/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
"use strict";

var $protobuf = require("protobufjs/minimal");

// Common aliases
var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

$root.proto = (function() {

    /**
     * Namespace proto.
     * @exports proto
     * @namespace
     */
    var proto = {};

    proto.ADVDeviceIdentity = (function() {

        /**
         * Properties of a ADVDeviceIdentity.
         * @memberof proto
         * @interface IADVDeviceIdentity
         * @property {number|null} [rawId] ADVDeviceIdentity rawId
         * @property {number|Long|null} [timestamp] ADVDeviceIdentity timestamp
         * @property {number|null} [keyIndex] ADVDeviceIdentity keyIndex
         */

        /**
         * Constructs a new ADVDeviceIdentity.
         * @memberof proto
         * @classdesc Represents a ADVDeviceIdentity.
         * @implements IADVDeviceIdentity
         * @constructor
         * @param {proto.IADVDeviceIdentity=} [properties] Properties to set
         */
        function ADVDeviceIdentity(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVDeviceIdentity rawId.
         * @member {number} rawId
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.rawId = 0;

        /**
         * ADVDeviceIdentity timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ADVDeviceIdentity keyIndex.
         * @member {number} keyIndex
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.keyIndex = 0;

        /**
         * Creates a new ADVDeviceIdentity instance using the specified properties.
         * @function create
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity=} [properties] Properties to set
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity instance
         */
        ADVDeviceIdentity.create = function create(properties) {
            return new ADVDeviceIdentity(properties);
        };

        /**
         * Encodes the specified ADVDeviceIdentity message. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity} message ADVDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVDeviceIdentity.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.rawId != null && Object.hasOwnProperty.call(message, "rawId"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.rawId);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.timestamp);
            if (message.keyIndex != null && Object.hasOwnProperty.call(message, "keyIndex"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.keyIndex);
            return writer;
        };

        /**
         * Encodes the specified ADVDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity} message ADVDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVDeviceIdentity.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVDeviceIdentity.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVDeviceIdentity();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.rawId = reader.uint32();
                    break;
                case 2:
                    message.timestamp = reader.uint64();
                    break;
                case 3:
                    message.keyIndex = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVDeviceIdentity.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVDeviceIdentity message.
         * @function verify
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVDeviceIdentity.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                if (!$util.isInteger(message.rawId))
                    return "rawId: integer expected";
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            if (message.keyIndex != null && message.hasOwnProperty("keyIndex"))
                if (!$util.isInteger(message.keyIndex))
                    return "keyIndex: integer expected";
            return null;
        };

        /**
         * Creates a ADVDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         */
        ADVDeviceIdentity.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVDeviceIdentity)
                return object;
            var message = new $root.proto.ADVDeviceIdentity();
            if (object.rawId != null)
                message.rawId = object.rawId >>> 0;
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = true;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber(true);
            if (object.keyIndex != null)
                message.keyIndex = object.keyIndex >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a ADVDeviceIdentity message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.ADVDeviceIdentity} message ADVDeviceIdentity
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVDeviceIdentity.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.rawId = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
                object.keyIndex = 0;
            }
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                object.rawId = message.rawId;
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber(true) : message.timestamp;
            if (message.keyIndex != null && message.hasOwnProperty("keyIndex"))
                object.keyIndex = message.keyIndex;
            return object;
        };

        /**
         * Converts this ADVDeviceIdentity to JSON.
         * @function toJSON
         * @memberof proto.ADVDeviceIdentity
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVDeviceIdentity;
    })();

    proto.ADVKeyIndexList = (function() {

        /**
         * Properties of a ADVKeyIndexList.
         * @memberof proto
         * @interface IADVKeyIndexList
         * @property {number|null} [rawId] ADVKeyIndexList rawId
         * @property {number|Long|null} [timestamp] ADVKeyIndexList timestamp
         * @property {number|null} [currentIndex] ADVKeyIndexList currentIndex
         * @property {Array.<number>|null} [validIndexes] ADVKeyIndexList validIndexes
         */

        /**
         * Constructs a new ADVKeyIndexList.
         * @memberof proto
         * @classdesc Represents a ADVKeyIndexList.
         * @implements IADVKeyIndexList
         * @constructor
         * @param {proto.IADVKeyIndexList=} [properties] Properties to set
         */
        function ADVKeyIndexList(properties) {
            this.validIndexes = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVKeyIndexList rawId.
         * @member {number} rawId
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.rawId = 0;

        /**
         * ADVKeyIndexList timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ADVKeyIndexList currentIndex.
         * @member {number} currentIndex
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.currentIndex = 0;

        /**
         * ADVKeyIndexList validIndexes.
         * @member {Array.<number>} validIndexes
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.validIndexes = $util.emptyArray;

        /**
         * Creates a new ADVKeyIndexList instance using the specified properties.
         * @function create
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList=} [properties] Properties to set
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList instance
         */
        ADVKeyIndexList.create = function create(properties) {
            return new ADVKeyIndexList(properties);
        };

        /**
         * Encodes the specified ADVKeyIndexList message. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList} message ADVKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVKeyIndexList.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.rawId != null && Object.hasOwnProperty.call(message, "rawId"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.rawId);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.timestamp);
            if (message.currentIndex != null && Object.hasOwnProperty.call(message, "currentIndex"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.currentIndex);
            if (message.validIndexes != null && message.validIndexes.length) {
                writer.uint32(/* id 4, wireType 2 =*/34).fork();
                for (var i = 0; i < message.validIndexes.length; ++i)
                    writer.uint32(message.validIndexes[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified ADVKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList} message ADVKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVKeyIndexList.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVKeyIndexList.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVKeyIndexList();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.rawId = reader.uint32();
                    break;
                case 2:
                    message.timestamp = reader.uint64();
                    break;
                case 3:
                    message.currentIndex = reader.uint32();
                    break;
                case 4:
                    if (!(message.validIndexes && message.validIndexes.length))
                        message.validIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.validIndexes.push(reader.uint32());
                    } else
                        message.validIndexes.push(reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVKeyIndexList.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVKeyIndexList message.
         * @function verify
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVKeyIndexList.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                if (!$util.isInteger(message.rawId))
                    return "rawId: integer expected";
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex"))
                if (!$util.isInteger(message.currentIndex))
                    return "currentIndex: integer expected";
            if (message.validIndexes != null && message.hasOwnProperty("validIndexes")) {
                if (!Array.isArray(message.validIndexes))
                    return "validIndexes: array expected";
                for (var i = 0; i < message.validIndexes.length; ++i)
                    if (!$util.isInteger(message.validIndexes[i]))
                        return "validIndexes: integer[] expected";
            }
            return null;
        };

        /**
         * Creates a ADVKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         */
        ADVKeyIndexList.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVKeyIndexList)
                return object;
            var message = new $root.proto.ADVKeyIndexList();
            if (object.rawId != null)
                message.rawId = object.rawId >>> 0;
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = true;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber(true);
            if (object.currentIndex != null)
                message.currentIndex = object.currentIndex >>> 0;
            if (object.validIndexes) {
                if (!Array.isArray(object.validIndexes))
                    throw TypeError(".proto.ADVKeyIndexList.validIndexes: array expected");
                message.validIndexes = [];
                for (var i = 0; i < object.validIndexes.length; ++i)
                    message.validIndexes[i] = object.validIndexes[i] >>> 0;
            }
            return message;
        };

        /**
         * Creates a plain object from a ADVKeyIndexList message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.ADVKeyIndexList} message ADVKeyIndexList
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVKeyIndexList.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.validIndexes = [];
            if (options.defaults) {
                object.rawId = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
                object.currentIndex = 0;
            }
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                object.rawId = message.rawId;
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber(true) : message.timestamp;
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex"))
                object.currentIndex = message.currentIndex;
            if (message.validIndexes && message.validIndexes.length) {
                object.validIndexes = [];
                for (var j = 0; j < message.validIndexes.length; ++j)
                    object.validIndexes[j] = message.validIndexes[j];
            }
            return object;
        };

        /**
         * Converts this ADVKeyIndexList to JSON.
         * @function toJSON
         * @memberof proto.ADVKeyIndexList
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVKeyIndexList;
    })();

    proto.ADVSignedDeviceIdentity = (function() {

        /**
         * Properties of a ADVSignedDeviceIdentity.
         * @memberof proto
         * @interface IADVSignedDeviceIdentity
         * @property {Uint8Array|null} [details] ADVSignedDeviceIdentity details
         * @property {Uint8Array|null} [accountSignatureKey] ADVSignedDeviceIdentity accountSignatureKey
         * @property {Uint8Array|null} [accountSignature] ADVSignedDeviceIdentity accountSignature
         * @property {Uint8Array|null} [deviceSignature] ADVSignedDeviceIdentity deviceSignature
         */

        /**
         * Constructs a new ADVSignedDeviceIdentity.
         * @memberof proto
         * @classdesc Represents a ADVSignedDeviceIdentity.
         * @implements IADVSignedDeviceIdentity
         * @constructor
         * @param {proto.IADVSignedDeviceIdentity=} [properties] Properties to set
         */
        function ADVSignedDeviceIdentity(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedDeviceIdentity details.
         * @member {Uint8Array} details
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.details = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentity accountSignatureKey.
         * @member {Uint8Array} accountSignatureKey
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.accountSignatureKey = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentity accountSignature.
         * @member {Uint8Array} accountSignature
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.accountSignature = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentity deviceSignature.
         * @member {Uint8Array} deviceSignature
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.deviceSignature = $util.newBuffer([]);

        /**
         * Creates a new ADVSignedDeviceIdentity instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity=} [properties] Properties to set
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity instance
         */
        ADVSignedDeviceIdentity.create = function create(properties) {
            return new ADVSignedDeviceIdentity(properties);
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentity message. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity} message ADVSignedDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentity.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.accountSignatureKey != null && Object.hasOwnProperty.call(message, "accountSignatureKey"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.accountSignatureKey);
            if (message.accountSignature != null && Object.hasOwnProperty.call(message, "accountSignature"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.accountSignature);
            if (message.deviceSignature != null && Object.hasOwnProperty.call(message, "deviceSignature"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.deviceSignature);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity} message ADVSignedDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentity.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentity.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedDeviceIdentity();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.accountSignatureKey = reader.bytes();
                    break;
                case 3:
                    message.accountSignature = reader.bytes();
                    break;
                case 4:
                    message.deviceSignature = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentity.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedDeviceIdentity message.
         * @function verify
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedDeviceIdentity.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.accountSignatureKey != null && message.hasOwnProperty("accountSignatureKey"))
                if (!(message.accountSignatureKey && typeof message.accountSignatureKey.length === "number" || $util.isString(message.accountSignatureKey)))
                    return "accountSignatureKey: buffer expected";
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                if (!(message.accountSignature && typeof message.accountSignature.length === "number" || $util.isString(message.accountSignature)))
                    return "accountSignature: buffer expected";
            if (message.deviceSignature != null && message.hasOwnProperty("deviceSignature"))
                if (!(message.deviceSignature && typeof message.deviceSignature.length === "number" || $util.isString(message.deviceSignature)))
                    return "deviceSignature: buffer expected";
            return null;
        };

        /**
         * Creates a ADVSignedDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         */
        ADVSignedDeviceIdentity.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedDeviceIdentity)
                return object;
            var message = new $root.proto.ADVSignedDeviceIdentity();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.accountSignatureKey != null)
                if (typeof object.accountSignatureKey === "string")
                    $util.base64.decode(object.accountSignatureKey, message.accountSignatureKey = $util.newBuffer($util.base64.length(object.accountSignatureKey)), 0);
                else if (object.accountSignatureKey.length)
                    message.accountSignatureKey = object.accountSignatureKey;
            if (object.accountSignature != null)
                if (typeof object.accountSignature === "string")
                    $util.base64.decode(object.accountSignature, message.accountSignature = $util.newBuffer($util.base64.length(object.accountSignature)), 0);
                else if (object.accountSignature.length)
                    message.accountSignature = object.accountSignature;
            if (object.deviceSignature != null)
                if (typeof object.deviceSignature === "string")
                    $util.base64.decode(object.deviceSignature, message.deviceSignature = $util.newBuffer($util.base64.length(object.deviceSignature)), 0);
                else if (object.deviceSignature.length)
                    message.deviceSignature = object.deviceSignature;
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedDeviceIdentity message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.ADVSignedDeviceIdentity} message ADVSignedDeviceIdentity
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedDeviceIdentity.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.accountSignatureKey = "";
                else {
                    object.accountSignatureKey = [];
                    if (options.bytes !== Array)
                        object.accountSignatureKey = $util.newBuffer(object.accountSignatureKey);
                }
                if (options.bytes === String)
                    object.accountSignature = "";
                else {
                    object.accountSignature = [];
                    if (options.bytes !== Array)
                        object.accountSignature = $util.newBuffer(object.accountSignature);
                }
                if (options.bytes === String)
                    object.deviceSignature = "";
                else {
                    object.deviceSignature = [];
                    if (options.bytes !== Array)
                        object.deviceSignature = $util.newBuffer(object.deviceSignature);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.accountSignatureKey != null && message.hasOwnProperty("accountSignatureKey"))
                object.accountSignatureKey = options.bytes === String ? $util.base64.encode(message.accountSignatureKey, 0, message.accountSignatureKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignatureKey) : message.accountSignatureKey;
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                object.accountSignature = options.bytes === String ? $util.base64.encode(message.accountSignature, 0, message.accountSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignature) : message.accountSignature;
            if (message.deviceSignature != null && message.hasOwnProperty("deviceSignature"))
                object.deviceSignature = options.bytes === String ? $util.base64.encode(message.deviceSignature, 0, message.deviceSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.deviceSignature) : message.deviceSignature;
            return object;
        };

        /**
         * Converts this ADVSignedDeviceIdentity to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVSignedDeviceIdentity;
    })();

    proto.ADVSignedDeviceIdentityHMAC = (function() {

        /**
         * Properties of a ADVSignedDeviceIdentityHMAC.
         * @memberof proto
         * @interface IADVSignedDeviceIdentityHMAC
         * @property {Uint8Array|null} [details] ADVSignedDeviceIdentityHMAC details
         * @property {Uint8Array|null} [hmac] ADVSignedDeviceIdentityHMAC hmac
         */

        /**
         * Constructs a new ADVSignedDeviceIdentityHMAC.
         * @memberof proto
         * @classdesc Represents a ADVSignedDeviceIdentityHMAC.
         * @implements IADVSignedDeviceIdentityHMAC
         * @constructor
         * @param {proto.IADVSignedDeviceIdentityHMAC=} [properties] Properties to set
         */
        function ADVSignedDeviceIdentityHMAC(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedDeviceIdentityHMAC details.
         * @member {Uint8Array} details
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         */
        ADVSignedDeviceIdentityHMAC.prototype.details = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentityHMAC hmac.
         * @member {Uint8Array} hmac
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         */
        ADVSignedDeviceIdentityHMAC.prototype.hmac = $util.newBuffer([]);

        /**
         * Creates a new ADVSignedDeviceIdentityHMAC instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC=} [properties] Properties to set
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC instance
         */
        ADVSignedDeviceIdentityHMAC.create = function create(properties) {
            return new ADVSignedDeviceIdentityHMAC(properties);
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentityHMAC.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.hmac != null && Object.hasOwnProperty.call(message, "hmac"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.hmac);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentityHMAC.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentityHMAC.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedDeviceIdentityHMAC();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.hmac = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentityHMAC.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedDeviceIdentityHMAC message.
         * @function verify
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedDeviceIdentityHMAC.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.hmac != null && message.hasOwnProperty("hmac"))
                if (!(message.hmac && typeof message.hmac.length === "number" || $util.isString(message.hmac)))
                    return "hmac: buffer expected";
            return null;
        };

        /**
         * Creates a ADVSignedDeviceIdentityHMAC message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         */
        ADVSignedDeviceIdentityHMAC.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedDeviceIdentityHMAC)
                return object;
            var message = new $root.proto.ADVSignedDeviceIdentityHMAC();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.hmac != null)
                if (typeof object.hmac === "string")
                    $util.base64.decode(object.hmac, message.hmac = $util.newBuffer($util.base64.length(object.hmac)), 0);
                else if (object.hmac.length)
                    message.hmac = object.hmac;
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedDeviceIdentityHMAC message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.ADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedDeviceIdentityHMAC.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.hmac = "";
                else {
                    object.hmac = [];
                    if (options.bytes !== Array)
                        object.hmac = $util.newBuffer(object.hmac);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.hmac != null && message.hasOwnProperty("hmac"))
                object.hmac = options.bytes === String ? $util.base64.encode(message.hmac, 0, message.hmac.length) : options.bytes === Array ? Array.prototype.slice.call(message.hmac) : message.hmac;
            return object;
        };

        /**
         * Converts this ADVSignedDeviceIdentityHMAC to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedDeviceIdentityHMAC.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVSignedDeviceIdentityHMAC;
    })();

    proto.ADVSignedKeyIndexList = (function() {

        /**
         * Properties of a ADVSignedKeyIndexList.
         * @memberof proto
         * @interface IADVSignedKeyIndexList
         * @property {Uint8Array|null} [details] ADVSignedKeyIndexList details
         * @property {Uint8Array|null} [accountSignature] ADVSignedKeyIndexList accountSignature
         */

        /**
         * Constructs a new ADVSignedKeyIndexList.
         * @memberof proto
         * @classdesc Represents a ADVSignedKeyIndexList.
         * @implements IADVSignedKeyIndexList
         * @constructor
         * @param {proto.IADVSignedKeyIndexList=} [properties] Properties to set
         */
        function ADVSignedKeyIndexList(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedKeyIndexList details.
         * @member {Uint8Array} details
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         */
        ADVSignedKeyIndexList.prototype.details = $util.newBuffer([]);

        /**
         * ADVSignedKeyIndexList accountSignature.
         * @member {Uint8Array} accountSignature
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         */
        ADVSignedKeyIndexList.prototype.accountSignature = $util.newBuffer([]);

        /**
         * Creates a new ADVSignedKeyIndexList instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList=} [properties] Properties to set
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList instance
         */
        ADVSignedKeyIndexList.create = function create(properties) {
            return new ADVSignedKeyIndexList(properties);
        };

        /**
         * Encodes the specified ADVSignedKeyIndexList message. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList} message ADVSignedKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedKeyIndexList.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.accountSignature != null && Object.hasOwnProperty.call(message, "accountSignature"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.accountSignature);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList} message ADVSignedKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedKeyIndexList.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedKeyIndexList.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedKeyIndexList();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.accountSignature = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedKeyIndexList.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedKeyIndexList message.
         * @function verify
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedKeyIndexList.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                if (!(message.accountSignature && typeof message.accountSignature.length === "number" || $util.isString(message.accountSignature)))
                    return "accountSignature: buffer expected";
            return null;
        };

        /**
         * Creates a ADVSignedKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         */
        ADVSignedKeyIndexList.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedKeyIndexList)
                return object;
            var message = new $root.proto.ADVSignedKeyIndexList();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.accountSignature != null)
                if (typeof object.accountSignature === "string")
                    $util.base64.decode(object.accountSignature, message.accountSignature = $util.newBuffer($util.base64.length(object.accountSignature)), 0);
                else if (object.accountSignature.length)
                    message.accountSignature = object.accountSignature;
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedKeyIndexList message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.ADVSignedKeyIndexList} message ADVSignedKeyIndexList
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedKeyIndexList.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.accountSignature = "";
                else {
                    object.accountSignature = [];
                    if (options.bytes !== Array)
                        object.accountSignature = $util.newBuffer(object.accountSignature);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                object.accountSignature = options.bytes === String ? $util.base64.encode(message.accountSignature, 0, message.accountSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignature) : message.accountSignature;
            return object;
        };

        /**
         * Converts this ADVSignedKeyIndexList to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVSignedKeyIndexList;
    })();

    proto.ActionLink = (function() {

        /**
         * Properties of an ActionLink.
         * @memberof proto
         * @interface IActionLink
         * @property {string|null} [url] ActionLink url
         * @property {string|null} [buttonTitle] ActionLink buttonTitle
         */

        /**
         * Constructs a new ActionLink.
         * @memberof proto
         * @classdesc Represents an ActionLink.
         * @implements IActionLink
         * @constructor
         * @param {proto.IActionLink=} [properties] Properties to set
         */
        function ActionLink(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ActionLink url.
         * @member {string} url
         * @memberof proto.ActionLink
         * @instance
         */
        ActionLink.prototype.url = "";

        /**
         * ActionLink buttonTitle.
         * @member {string} buttonTitle
         * @memberof proto.ActionLink
         * @instance
         */
        ActionLink.prototype.buttonTitle = "";

        /**
         * Creates a new ActionLink instance using the specified properties.
         * @function create
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink=} [properties] Properties to set
         * @returns {proto.ActionLink} ActionLink instance
         */
        ActionLink.create = function create(properties) {
            return new ActionLink(properties);
        };

        /**
         * Encodes the specified ActionLink message. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @function encode
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink} message ActionLink message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ActionLink.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.url);
            if (message.buttonTitle != null && Object.hasOwnProperty.call(message, "buttonTitle"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.buttonTitle);
            return writer;
        };

        /**
         * Encodes the specified ActionLink message, length delimited. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink} message ActionLink message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ActionLink.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ActionLink message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ActionLink
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ActionLink} ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ActionLink.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ActionLink();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.url = reader.string();
                    break;
                case 2:
                    message.buttonTitle = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ActionLink message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ActionLink
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ActionLink} ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ActionLink.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ActionLink message.
         * @function verify
         * @memberof proto.ActionLink
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ActionLink.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.url != null && message.hasOwnProperty("url"))
                if (!$util.isString(message.url))
                    return "url: string expected";
            if (message.buttonTitle != null && message.hasOwnProperty("buttonTitle"))
                if (!$util.isString(message.buttonTitle))
                    return "buttonTitle: string expected";
            return null;
        };

        /**
         * Creates an ActionLink message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ActionLink
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ActionLink} ActionLink
         */
        ActionLink.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ActionLink)
                return object;
            var message = new $root.proto.ActionLink();
            if (object.url != null)
                message.url = String(object.url);
            if (object.buttonTitle != null)
                message.buttonTitle = String(object.buttonTitle);
            return message;
        };

        /**
         * Creates a plain object from an ActionLink message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ActionLink
         * @static
         * @param {proto.ActionLink} message ActionLink
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ActionLink.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.url = "";
                object.buttonTitle = "";
            }
            if (message.url != null && message.hasOwnProperty("url"))
                object.url = message.url;
            if (message.buttonTitle != null && message.hasOwnProperty("buttonTitle"))
                object.buttonTitle = message.buttonTitle;
            return object;
        };

        /**
         * Converts this ActionLink to JSON.
         * @function toJSON
         * @memberof proto.ActionLink
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ActionLink.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ActionLink;
    })();

    proto.AdReplyInfo = (function() {

        /**
         * Properties of an AdReplyInfo.
         * @memberof proto
         * @interface IAdReplyInfo
         * @property {string|null} [advertiserName] AdReplyInfo advertiserName
         * @property {proto.AdReplyInfo.AdReplyInfoMediaType|null} [mediaType] AdReplyInfo mediaType
         * @property {Uint8Array|null} [jpegThumbnail] AdReplyInfo jpegThumbnail
         * @property {string|null} [caption] AdReplyInfo caption
         */

        /**
         * Constructs a new AdReplyInfo.
         * @memberof proto
         * @classdesc Represents an AdReplyInfo.
         * @implements IAdReplyInfo
         * @constructor
         * @param {proto.IAdReplyInfo=} [properties] Properties to set
         */
        function AdReplyInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AdReplyInfo advertiserName.
         * @member {string} advertiserName
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.advertiserName = "";

        /**
         * AdReplyInfo mediaType.
         * @member {proto.AdReplyInfo.AdReplyInfoMediaType} mediaType
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.mediaType = 0;

        /**
         * AdReplyInfo jpegThumbnail.
         * @member {Uint8Array} jpegThumbnail
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.jpegThumbnail = $util.newBuffer([]);

        /**
         * AdReplyInfo caption.
         * @member {string} caption
         * @memberof proto.AdReplyInfo
         * @instance
         */
        AdReplyInfo.prototype.caption = "";

        /**
         * Creates a new AdReplyInfo instance using the specified properties.
         * @function create
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.IAdReplyInfo=} [properties] Properties to set
         * @returns {proto.AdReplyInfo} AdReplyInfo instance
         */
        AdReplyInfo.create = function create(properties) {
            return new AdReplyInfo(properties);
        };

        /**
         * Encodes the specified AdReplyInfo message. Does not implicitly {@link proto.AdReplyInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.IAdReplyInfo} message AdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AdReplyInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.advertiserName != null && Object.hasOwnProperty.call(message, "advertiserName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.advertiserName);
            if (message.mediaType != null && Object.hasOwnProperty.call(message, "mediaType"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.mediaType);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 16, wireType 2 =*/130).bytes(message.jpegThumbnail);
            if (message.caption != null && Object.hasOwnProperty.call(message, "caption"))
                writer.uint32(/* id 17, wireType 2 =*/138).string(message.caption);
            return writer;
        };

        /**
         * Encodes the specified AdReplyInfo message, length delimited. Does not implicitly {@link proto.AdReplyInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.IAdReplyInfo} message AdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AdReplyInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AdReplyInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AdReplyInfo} AdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AdReplyInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AdReplyInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.advertiserName = reader.string();
                    break;
                case 2:
                    message.mediaType = reader.int32();
                    break;
                case 16:
                    message.jpegThumbnail = reader.bytes();
                    break;
                case 17:
                    message.caption = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AdReplyInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AdReplyInfo} AdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AdReplyInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AdReplyInfo message.
         * @function verify
         * @memberof proto.AdReplyInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AdReplyInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.advertiserName != null && message.hasOwnProperty("advertiserName"))
                if (!$util.isString(message.advertiserName))
                    return "advertiserName: string expected";
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                switch (message.mediaType) {
                default:
                    return "mediaType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                    return "jpegThumbnail: buffer expected";
            if (message.caption != null && message.hasOwnProperty("caption"))
                if (!$util.isString(message.caption))
                    return "caption: string expected";
            return null;
        };

        /**
         * Creates an AdReplyInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AdReplyInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AdReplyInfo} AdReplyInfo
         */
        AdReplyInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AdReplyInfo)
                return object;
            var message = new $root.proto.AdReplyInfo();
            if (object.advertiserName != null)
                message.advertiserName = String(object.advertiserName);
            switch (object.mediaType) {
            case "NONE":
            case 0:
                message.mediaType = 0;
                break;
            case "IMAGE":
            case 1:
                message.mediaType = 1;
                break;
            case "VIDEO":
            case 2:
                message.mediaType = 2;
                break;
            }
            if (object.jpegThumbnail != null)
                if (typeof object.jpegThumbnail === "string")
                    $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                else if (object.jpegThumbnail.length)
                    message.jpegThumbnail = object.jpegThumbnail;
            if (object.caption != null)
                message.caption = String(object.caption);
            return message;
        };

        /**
         * Creates a plain object from an AdReplyInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AdReplyInfo
         * @static
         * @param {proto.AdReplyInfo} message AdReplyInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AdReplyInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.advertiserName = "";
                object.mediaType = options.enums === String ? "NONE" : 0;
                if (options.bytes === String)
                    object.jpegThumbnail = "";
                else {
                    object.jpegThumbnail = [];
                    if (options.bytes !== Array)
                        object.jpegThumbnail = $util.newBuffer(object.jpegThumbnail);
                }
                object.caption = "";
            }
            if (message.advertiserName != null && message.hasOwnProperty("advertiserName"))
                object.advertiserName = message.advertiserName;
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                object.mediaType = options.enums === String ? $root.proto.AdReplyInfo.AdReplyInfoMediaType[message.mediaType] : message.mediaType;
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
            if (message.caption != null && message.hasOwnProperty("caption"))
                object.caption = message.caption;
            return object;
        };

        /**
         * Converts this AdReplyInfo to JSON.
         * @function toJSON
         * @memberof proto.AdReplyInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AdReplyInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * AdReplyInfoMediaType enum.
         * @name proto.AdReplyInfo.AdReplyInfoMediaType
         * @enum {number}
         * @property {number} NONE=0 NONE value
         * @property {number} IMAGE=1 IMAGE value
         * @property {number} VIDEO=2 VIDEO value
         */
        AdReplyInfo.AdReplyInfoMediaType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "IMAGE"] = 1;
            values[valuesById[2] = "VIDEO"] = 2;
            return values;
        })();

        return AdReplyInfo;
    })();

    proto.AgentAction = (function() {

        /**
         * Properties of an AgentAction.
         * @memberof proto
         * @interface IAgentAction
         * @property {string|null} [name] AgentAction name
         * @property {number|null} [deviceID] AgentAction deviceID
         * @property {boolean|null} [isDeleted] AgentAction isDeleted
         */

        /**
         * Constructs a new AgentAction.
         * @memberof proto
         * @classdesc Represents an AgentAction.
         * @implements IAgentAction
         * @constructor
         * @param {proto.IAgentAction=} [properties] Properties to set
         */
        function AgentAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AgentAction name.
         * @member {string} name
         * @memberof proto.AgentAction
         * @instance
         */
        AgentAction.prototype.name = "";

        /**
         * AgentAction deviceID.
         * @member {number} deviceID
         * @memberof proto.AgentAction
         * @instance
         */
        AgentAction.prototype.deviceID = 0;

        /**
         * AgentAction isDeleted.
         * @member {boolean} isDeleted
         * @memberof proto.AgentAction
         * @instance
         */
        AgentAction.prototype.isDeleted = false;

        /**
         * Creates a new AgentAction instance using the specified properties.
         * @function create
         * @memberof proto.AgentAction
         * @static
         * @param {proto.IAgentAction=} [properties] Properties to set
         * @returns {proto.AgentAction} AgentAction instance
         */
        AgentAction.create = function create(properties) {
            return new AgentAction(properties);
        };

        /**
         * Encodes the specified AgentAction message. Does not implicitly {@link proto.AgentAction.verify|verify} messages.
         * @function encode
         * @memberof proto.AgentAction
         * @static
         * @param {proto.IAgentAction} message AgentAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AgentAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
            if (message.deviceID != null && Object.hasOwnProperty.call(message, "deviceID"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.deviceID);
            if (message.isDeleted != null && Object.hasOwnProperty.call(message, "isDeleted"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.isDeleted);
            return writer;
        };

        /**
         * Encodes the specified AgentAction message, length delimited. Does not implicitly {@link proto.AgentAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AgentAction
         * @static
         * @param {proto.IAgentAction} message AgentAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AgentAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AgentAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AgentAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AgentAction} AgentAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AgentAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AgentAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.name = reader.string();
                    break;
                case 2:
                    message.deviceID = reader.int32();
                    break;
                case 3:
                    message.isDeleted = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AgentAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AgentAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AgentAction} AgentAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AgentAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AgentAction message.
         * @function verify
         * @memberof proto.AgentAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AgentAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            if (message.deviceID != null && message.hasOwnProperty("deviceID"))
                if (!$util.isInteger(message.deviceID))
                    return "deviceID: integer expected";
            if (message.isDeleted != null && message.hasOwnProperty("isDeleted"))
                if (typeof message.isDeleted !== "boolean")
                    return "isDeleted: boolean expected";
            return null;
        };

        /**
         * Creates an AgentAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AgentAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AgentAction} AgentAction
         */
        AgentAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AgentAction)
                return object;
            var message = new $root.proto.AgentAction();
            if (object.name != null)
                message.name = String(object.name);
            if (object.deviceID != null)
                message.deviceID = object.deviceID | 0;
            if (object.isDeleted != null)
                message.isDeleted = Boolean(object.isDeleted);
            return message;
        };

        /**
         * Creates a plain object from an AgentAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AgentAction
         * @static
         * @param {proto.AgentAction} message AgentAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AgentAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.name = "";
                object.deviceID = 0;
                object.isDeleted = false;
            }
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            if (message.deviceID != null && message.hasOwnProperty("deviceID"))
                object.deviceID = message.deviceID;
            if (message.isDeleted != null && message.hasOwnProperty("isDeleted"))
                object.isDeleted = message.isDeleted;
            return object;
        };

        /**
         * Converts this AgentAction to JSON.
         * @function toJSON
         * @memberof proto.AgentAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AgentAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AgentAction;
    })();

    proto.AndroidUnsupportedActions = (function() {

        /**
         * Properties of an AndroidUnsupportedActions.
         * @memberof proto
         * @interface IAndroidUnsupportedActions
         * @property {boolean|null} [allowed] AndroidUnsupportedActions allowed
         */

        /**
         * Constructs a new AndroidUnsupportedActions.
         * @memberof proto
         * @classdesc Represents an AndroidUnsupportedActions.
         * @implements IAndroidUnsupportedActions
         * @constructor
         * @param {proto.IAndroidUnsupportedActions=} [properties] Properties to set
         */
        function AndroidUnsupportedActions(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AndroidUnsupportedActions allowed.
         * @member {boolean} allowed
         * @memberof proto.AndroidUnsupportedActions
         * @instance
         */
        AndroidUnsupportedActions.prototype.allowed = false;

        /**
         * Creates a new AndroidUnsupportedActions instance using the specified properties.
         * @function create
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {proto.IAndroidUnsupportedActions=} [properties] Properties to set
         * @returns {proto.AndroidUnsupportedActions} AndroidUnsupportedActions instance
         */
        AndroidUnsupportedActions.create = function create(properties) {
            return new AndroidUnsupportedActions(properties);
        };

        /**
         * Encodes the specified AndroidUnsupportedActions message. Does not implicitly {@link proto.AndroidUnsupportedActions.verify|verify} messages.
         * @function encode
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {proto.IAndroidUnsupportedActions} message AndroidUnsupportedActions message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AndroidUnsupportedActions.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.allowed != null && Object.hasOwnProperty.call(message, "allowed"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.allowed);
            return writer;
        };

        /**
         * Encodes the specified AndroidUnsupportedActions message, length delimited. Does not implicitly {@link proto.AndroidUnsupportedActions.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {proto.IAndroidUnsupportedActions} message AndroidUnsupportedActions message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AndroidUnsupportedActions.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AndroidUnsupportedActions message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AndroidUnsupportedActions} AndroidUnsupportedActions
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AndroidUnsupportedActions.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AndroidUnsupportedActions();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.allowed = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AndroidUnsupportedActions message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AndroidUnsupportedActions} AndroidUnsupportedActions
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AndroidUnsupportedActions.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AndroidUnsupportedActions message.
         * @function verify
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AndroidUnsupportedActions.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.allowed != null && message.hasOwnProperty("allowed"))
                if (typeof message.allowed !== "boolean")
                    return "allowed: boolean expected";
            return null;
        };

        /**
         * Creates an AndroidUnsupportedActions message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AndroidUnsupportedActions} AndroidUnsupportedActions
         */
        AndroidUnsupportedActions.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AndroidUnsupportedActions)
                return object;
            var message = new $root.proto.AndroidUnsupportedActions();
            if (object.allowed != null)
                message.allowed = Boolean(object.allowed);
            return message;
        };

        /**
         * Creates a plain object from an AndroidUnsupportedActions message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AndroidUnsupportedActions
         * @static
         * @param {proto.AndroidUnsupportedActions} message AndroidUnsupportedActions
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AndroidUnsupportedActions.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.allowed = false;
            if (message.allowed != null && message.hasOwnProperty("allowed"))
                object.allowed = message.allowed;
            return object;
        };

        /**
         * Converts this AndroidUnsupportedActions to JSON.
         * @function toJSON
         * @memberof proto.AndroidUnsupportedActions
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AndroidUnsupportedActions.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AndroidUnsupportedActions;
    })();

    proto.AppStateFatalExceptionNotification = (function() {

        /**
         * Properties of an AppStateFatalExceptionNotification.
         * @memberof proto
         * @interface IAppStateFatalExceptionNotification
         * @property {Array.<string>|null} [collectionNames] AppStateFatalExceptionNotification collectionNames
         * @property {number|Long|null} [timestamp] AppStateFatalExceptionNotification timestamp
         */

        /**
         * Constructs a new AppStateFatalExceptionNotification.
         * @memberof proto
         * @classdesc Represents an AppStateFatalExceptionNotification.
         * @implements IAppStateFatalExceptionNotification
         * @constructor
         * @param {proto.IAppStateFatalExceptionNotification=} [properties] Properties to set
         */
        function AppStateFatalExceptionNotification(properties) {
            this.collectionNames = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateFatalExceptionNotification collectionNames.
         * @member {Array.<string>} collectionNames
         * @memberof proto.AppStateFatalExceptionNotification
         * @instance
         */
        AppStateFatalExceptionNotification.prototype.collectionNames = $util.emptyArray;

        /**
         * AppStateFatalExceptionNotification timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.AppStateFatalExceptionNotification
         * @instance
         */
        AppStateFatalExceptionNotification.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new AppStateFatalExceptionNotification instance using the specified properties.
         * @function create
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {proto.IAppStateFatalExceptionNotification=} [properties] Properties to set
         * @returns {proto.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification instance
         */
        AppStateFatalExceptionNotification.create = function create(properties) {
            return new AppStateFatalExceptionNotification(properties);
        };

        /**
         * Encodes the specified AppStateFatalExceptionNotification message. Does not implicitly {@link proto.AppStateFatalExceptionNotification.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {proto.IAppStateFatalExceptionNotification} message AppStateFatalExceptionNotification message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateFatalExceptionNotification.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.collectionNames != null && message.collectionNames.length)
                for (var i = 0; i < message.collectionNames.length; ++i)
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.collectionNames[i]);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.timestamp);
            return writer;
        };

        /**
         * Encodes the specified AppStateFatalExceptionNotification message, length delimited. Does not implicitly {@link proto.AppStateFatalExceptionNotification.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {proto.IAppStateFatalExceptionNotification} message AppStateFatalExceptionNotification message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateFatalExceptionNotification.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateFatalExceptionNotification message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateFatalExceptionNotification.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateFatalExceptionNotification();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.collectionNames && message.collectionNames.length))
                        message.collectionNames = [];
                    message.collectionNames.push(reader.string());
                    break;
                case 2:
                    message.timestamp = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateFatalExceptionNotification message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateFatalExceptionNotification.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateFatalExceptionNotification message.
         * @function verify
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateFatalExceptionNotification.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.collectionNames != null && message.hasOwnProperty("collectionNames")) {
                if (!Array.isArray(message.collectionNames))
                    return "collectionNames: array expected";
                for (var i = 0; i < message.collectionNames.length; ++i)
                    if (!$util.isString(message.collectionNames[i]))
                        return "collectionNames: string[] expected";
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates an AppStateFatalExceptionNotification message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification
         */
        AppStateFatalExceptionNotification.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateFatalExceptionNotification)
                return object;
            var message = new $root.proto.AppStateFatalExceptionNotification();
            if (object.collectionNames) {
                if (!Array.isArray(object.collectionNames))
                    throw TypeError(".proto.AppStateFatalExceptionNotification.collectionNames: array expected");
                message.collectionNames = [];
                for (var i = 0; i < object.collectionNames.length; ++i)
                    message.collectionNames[i] = String(object.collectionNames[i]);
            }
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from an AppStateFatalExceptionNotification message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateFatalExceptionNotification
         * @static
         * @param {proto.AppStateFatalExceptionNotification} message AppStateFatalExceptionNotification
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateFatalExceptionNotification.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.collectionNames = [];
            if (options.defaults)
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
            if (message.collectionNames && message.collectionNames.length) {
                object.collectionNames = [];
                for (var j = 0; j < message.collectionNames.length; ++j)
                    object.collectionNames[j] = message.collectionNames[j];
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber() : message.timestamp;
            return object;
        };

        /**
         * Converts this AppStateFatalExceptionNotification to JSON.
         * @function toJSON
         * @memberof proto.AppStateFatalExceptionNotification
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateFatalExceptionNotification.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateFatalExceptionNotification;
    })();

    proto.AppStateSyncKey = (function() {

        /**
         * Properties of an AppStateSyncKey.
         * @memberof proto
         * @interface IAppStateSyncKey
         * @property {proto.IAppStateSyncKeyId|null} [keyId] AppStateSyncKey keyId
         * @property {proto.IAppStateSyncKeyData|null} [keyData] AppStateSyncKey keyData
         */

        /**
         * Constructs a new AppStateSyncKey.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKey.
         * @implements IAppStateSyncKey
         * @constructor
         * @param {proto.IAppStateSyncKey=} [properties] Properties to set
         */
        function AppStateSyncKey(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKey keyId.
         * @member {proto.IAppStateSyncKeyId|null|undefined} keyId
         * @memberof proto.AppStateSyncKey
         * @instance
         */
        AppStateSyncKey.prototype.keyId = null;

        /**
         * AppStateSyncKey keyData.
         * @member {proto.IAppStateSyncKeyData|null|undefined} keyData
         * @memberof proto.AppStateSyncKey
         * @instance
         */
        AppStateSyncKey.prototype.keyData = null;

        /**
         * Creates a new AppStateSyncKey instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {proto.IAppStateSyncKey=} [properties] Properties to set
         * @returns {proto.AppStateSyncKey} AppStateSyncKey instance
         */
        AppStateSyncKey.create = function create(properties) {
            return new AppStateSyncKey(properties);
        };

        /**
         * Encodes the specified AppStateSyncKey message. Does not implicitly {@link proto.AppStateSyncKey.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {proto.IAppStateSyncKey} message AppStateSyncKey message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKey.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keyId != null && Object.hasOwnProperty.call(message, "keyId"))
                $root.proto.AppStateSyncKeyId.encode(message.keyId, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.keyData != null && Object.hasOwnProperty.call(message, "keyData"))
                $root.proto.AppStateSyncKeyData.encode(message.keyData, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKey message, length delimited. Does not implicitly {@link proto.AppStateSyncKey.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {proto.IAppStateSyncKey} message AppStateSyncKey message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKey.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKey message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKey} AppStateSyncKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKey.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKey();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.keyId = $root.proto.AppStateSyncKeyId.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.keyData = $root.proto.AppStateSyncKeyData.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKey message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKey} AppStateSyncKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKey.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKey message.
         * @function verify
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKey.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keyId != null && message.hasOwnProperty("keyId")) {
                var error = $root.proto.AppStateSyncKeyId.verify(message.keyId);
                if (error)
                    return "keyId." + error;
            }
            if (message.keyData != null && message.hasOwnProperty("keyData")) {
                var error = $root.proto.AppStateSyncKeyData.verify(message.keyData);
                if (error)
                    return "keyData." + error;
            }
            return null;
        };

        /**
         * Creates an AppStateSyncKey message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKey} AppStateSyncKey
         */
        AppStateSyncKey.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKey)
                return object;
            var message = new $root.proto.AppStateSyncKey();
            if (object.keyId != null) {
                if (typeof object.keyId !== "object")
                    throw TypeError(".proto.AppStateSyncKey.keyId: object expected");
                message.keyId = $root.proto.AppStateSyncKeyId.fromObject(object.keyId);
            }
            if (object.keyData != null) {
                if (typeof object.keyData !== "object")
                    throw TypeError(".proto.AppStateSyncKey.keyData: object expected");
                message.keyData = $root.proto.AppStateSyncKeyData.fromObject(object.keyData);
            }
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKey message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKey
         * @static
         * @param {proto.AppStateSyncKey} message AppStateSyncKey
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKey.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.keyId = null;
                object.keyData = null;
            }
            if (message.keyId != null && message.hasOwnProperty("keyId"))
                object.keyId = $root.proto.AppStateSyncKeyId.toObject(message.keyId, options);
            if (message.keyData != null && message.hasOwnProperty("keyData"))
                object.keyData = $root.proto.AppStateSyncKeyData.toObject(message.keyData, options);
            return object;
        };

        /**
         * Converts this AppStateSyncKey to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKey
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKey.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKey;
    })();

    proto.AppStateSyncKeyData = (function() {

        /**
         * Properties of an AppStateSyncKeyData.
         * @memberof proto
         * @interface IAppStateSyncKeyData
         * @property {Uint8Array|null} [keyData] AppStateSyncKeyData keyData
         * @property {proto.IAppStateSyncKeyFingerprint|null} [fingerprint] AppStateSyncKeyData fingerprint
         * @property {number|Long|null} [timestamp] AppStateSyncKeyData timestamp
         */

        /**
         * Constructs a new AppStateSyncKeyData.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKeyData.
         * @implements IAppStateSyncKeyData
         * @constructor
         * @param {proto.IAppStateSyncKeyData=} [properties] Properties to set
         */
        function AppStateSyncKeyData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKeyData keyData.
         * @member {Uint8Array} keyData
         * @memberof proto.AppStateSyncKeyData
         * @instance
         */
        AppStateSyncKeyData.prototype.keyData = $util.newBuffer([]);

        /**
         * AppStateSyncKeyData fingerprint.
         * @member {proto.IAppStateSyncKeyFingerprint|null|undefined} fingerprint
         * @memberof proto.AppStateSyncKeyData
         * @instance
         */
        AppStateSyncKeyData.prototype.fingerprint = null;

        /**
         * AppStateSyncKeyData timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.AppStateSyncKeyData
         * @instance
         */
        AppStateSyncKeyData.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new AppStateSyncKeyData instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {proto.IAppStateSyncKeyData=} [properties] Properties to set
         * @returns {proto.AppStateSyncKeyData} AppStateSyncKeyData instance
         */
        AppStateSyncKeyData.create = function create(properties) {
            return new AppStateSyncKeyData(properties);
        };

        /**
         * Encodes the specified AppStateSyncKeyData message. Does not implicitly {@link proto.AppStateSyncKeyData.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {proto.IAppStateSyncKeyData} message AppStateSyncKeyData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keyData != null && Object.hasOwnProperty.call(message, "keyData"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.keyData);
            if (message.fingerprint != null && Object.hasOwnProperty.call(message, "fingerprint"))
                $root.proto.AppStateSyncKeyFingerprint.encode(message.fingerprint, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 3, wireType 0 =*/24).int64(message.timestamp);
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKeyData message, length delimited. Does not implicitly {@link proto.AppStateSyncKeyData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {proto.IAppStateSyncKeyData} message AppStateSyncKeyData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKeyData message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKeyData} AppStateSyncKeyData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKeyData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.keyData = reader.bytes();
                    break;
                case 2:
                    message.fingerprint = $root.proto.AppStateSyncKeyFingerprint.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.timestamp = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKeyData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKeyData} AppStateSyncKeyData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKeyData message.
         * @function verify
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKeyData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keyData != null && message.hasOwnProperty("keyData"))
                if (!(message.keyData && typeof message.keyData.length === "number" || $util.isString(message.keyData)))
                    return "keyData: buffer expected";
            if (message.fingerprint != null && message.hasOwnProperty("fingerprint")) {
                var error = $root.proto.AppStateSyncKeyFingerprint.verify(message.fingerprint);
                if (error)
                    return "fingerprint." + error;
            }
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates an AppStateSyncKeyData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKeyData} AppStateSyncKeyData
         */
        AppStateSyncKeyData.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKeyData)
                return object;
            var message = new $root.proto.AppStateSyncKeyData();
            if (object.keyData != null)
                if (typeof object.keyData === "string")
                    $util.base64.decode(object.keyData, message.keyData = $util.newBuffer($util.base64.length(object.keyData)), 0);
                else if (object.keyData.length)
                    message.keyData = object.keyData;
            if (object.fingerprint != null) {
                if (typeof object.fingerprint !== "object")
                    throw TypeError(".proto.AppStateSyncKeyData.fingerprint: object expected");
                message.fingerprint = $root.proto.AppStateSyncKeyFingerprint.fromObject(object.fingerprint);
            }
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKeyData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKeyData
         * @static
         * @param {proto.AppStateSyncKeyData} message AppStateSyncKeyData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKeyData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.keyData = "";
                else {
                    object.keyData = [];
                    if (options.bytes !== Array)
                        object.keyData = $util.newBuffer(object.keyData);
                }
                object.fingerprint = null;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
            }
            if (message.keyData != null && message.hasOwnProperty("keyData"))
                object.keyData = options.bytes === String ? $util.base64.encode(message.keyData, 0, message.keyData.length) : options.bytes === Array ? Array.prototype.slice.call(message.keyData) : message.keyData;
            if (message.fingerprint != null && message.hasOwnProperty("fingerprint"))
                object.fingerprint = $root.proto.AppStateSyncKeyFingerprint.toObject(message.fingerprint, options);
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber() : message.timestamp;
            return object;
        };

        /**
         * Converts this AppStateSyncKeyData to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKeyData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKeyData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKeyData;
    })();

    proto.AppStateSyncKeyFingerprint = (function() {

        /**
         * Properties of an AppStateSyncKeyFingerprint.
         * @memberof proto
         * @interface IAppStateSyncKeyFingerprint
         * @property {number|null} [rawId] AppStateSyncKeyFingerprint rawId
         * @property {number|null} [currentIndex] AppStateSyncKeyFingerprint currentIndex
         * @property {Array.<number>|null} [deviceIndexes] AppStateSyncKeyFingerprint deviceIndexes
         */

        /**
         * Constructs a new AppStateSyncKeyFingerprint.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKeyFingerprint.
         * @implements IAppStateSyncKeyFingerprint
         * @constructor
         * @param {proto.IAppStateSyncKeyFingerprint=} [properties] Properties to set
         */
        function AppStateSyncKeyFingerprint(properties) {
            this.deviceIndexes = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKeyFingerprint rawId.
         * @member {number} rawId
         * @memberof proto.AppStateSyncKeyFingerprint
         * @instance
         */
        AppStateSyncKeyFingerprint.prototype.rawId = 0;

        /**
         * AppStateSyncKeyFingerprint currentIndex.
         * @member {number} currentIndex
         * @memberof proto.AppStateSyncKeyFingerprint
         * @instance
         */
        AppStateSyncKeyFingerprint.prototype.currentIndex = 0;

        /**
         * AppStateSyncKeyFingerprint deviceIndexes.
         * @member {Array.<number>} deviceIndexes
         * @memberof proto.AppStateSyncKeyFingerprint
         * @instance
         */
        AppStateSyncKeyFingerprint.prototype.deviceIndexes = $util.emptyArray;

        /**
         * Creates a new AppStateSyncKeyFingerprint instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {proto.IAppStateSyncKeyFingerprint=} [properties] Properties to set
         * @returns {proto.AppStateSyncKeyFingerprint} AppStateSyncKeyFingerprint instance
         */
        AppStateSyncKeyFingerprint.create = function create(properties) {
            return new AppStateSyncKeyFingerprint(properties);
        };

        /**
         * Encodes the specified AppStateSyncKeyFingerprint message. Does not implicitly {@link proto.AppStateSyncKeyFingerprint.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {proto.IAppStateSyncKeyFingerprint} message AppStateSyncKeyFingerprint message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyFingerprint.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.rawId != null && Object.hasOwnProperty.call(message, "rawId"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.rawId);
            if (message.currentIndex != null && Object.hasOwnProperty.call(message, "currentIndex"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.currentIndex);
            if (message.deviceIndexes != null && message.deviceIndexes.length) {
                writer.uint32(/* id 3, wireType 2 =*/26).fork();
                for (var i = 0; i < message.deviceIndexes.length; ++i)
                    writer.uint32(message.deviceIndexes[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKeyFingerprint message, length delimited. Does not implicitly {@link proto.AppStateSyncKeyFingerprint.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {proto.IAppStateSyncKeyFingerprint} message AppStateSyncKeyFingerprint message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyFingerprint.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKeyFingerprint message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKeyFingerprint} AppStateSyncKeyFingerprint
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyFingerprint.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKeyFingerprint();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.rawId = reader.uint32();
                    break;
                case 2:
                    message.currentIndex = reader.uint32();
                    break;
                case 3:
                    if (!(message.deviceIndexes && message.deviceIndexes.length))
                        message.deviceIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.deviceIndexes.push(reader.uint32());
                    } else
                        message.deviceIndexes.push(reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKeyFingerprint message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKeyFingerprint} AppStateSyncKeyFingerprint
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyFingerprint.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKeyFingerprint message.
         * @function verify
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKeyFingerprint.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                if (!$util.isInteger(message.rawId))
                    return "rawId: integer expected";
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex"))
                if (!$util.isInteger(message.currentIndex))
                    return "currentIndex: integer expected";
            if (message.deviceIndexes != null && message.hasOwnProperty("deviceIndexes")) {
                if (!Array.isArray(message.deviceIndexes))
                    return "deviceIndexes: array expected";
                for (var i = 0; i < message.deviceIndexes.length; ++i)
                    if (!$util.isInteger(message.deviceIndexes[i]))
                        return "deviceIndexes: integer[] expected";
            }
            return null;
        };

        /**
         * Creates an AppStateSyncKeyFingerprint message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKeyFingerprint} AppStateSyncKeyFingerprint
         */
        AppStateSyncKeyFingerprint.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKeyFingerprint)
                return object;
            var message = new $root.proto.AppStateSyncKeyFingerprint();
            if (object.rawId != null)
                message.rawId = object.rawId >>> 0;
            if (object.currentIndex != null)
                message.currentIndex = object.currentIndex >>> 0;
            if (object.deviceIndexes) {
                if (!Array.isArray(object.deviceIndexes))
                    throw TypeError(".proto.AppStateSyncKeyFingerprint.deviceIndexes: array expected");
                message.deviceIndexes = [];
                for (var i = 0; i < object.deviceIndexes.length; ++i)
                    message.deviceIndexes[i] = object.deviceIndexes[i] >>> 0;
            }
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKeyFingerprint message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKeyFingerprint
         * @static
         * @param {proto.AppStateSyncKeyFingerprint} message AppStateSyncKeyFingerprint
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKeyFingerprint.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.deviceIndexes = [];
            if (options.defaults) {
                object.rawId = 0;
                object.currentIndex = 0;
            }
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                object.rawId = message.rawId;
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex"))
                object.currentIndex = message.currentIndex;
            if (message.deviceIndexes && message.deviceIndexes.length) {
                object.deviceIndexes = [];
                for (var j = 0; j < message.deviceIndexes.length; ++j)
                    object.deviceIndexes[j] = message.deviceIndexes[j];
            }
            return object;
        };

        /**
         * Converts this AppStateSyncKeyFingerprint to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKeyFingerprint
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKeyFingerprint.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKeyFingerprint;
    })();

    proto.AppStateSyncKeyId = (function() {

        /**
         * Properties of an AppStateSyncKeyId.
         * @memberof proto
         * @interface IAppStateSyncKeyId
         * @property {Uint8Array|null} [keyId] AppStateSyncKeyId keyId
         */

        /**
         * Constructs a new AppStateSyncKeyId.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKeyId.
         * @implements IAppStateSyncKeyId
         * @constructor
         * @param {proto.IAppStateSyncKeyId=} [properties] Properties to set
         */
        function AppStateSyncKeyId(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKeyId keyId.
         * @member {Uint8Array} keyId
         * @memberof proto.AppStateSyncKeyId
         * @instance
         */
        AppStateSyncKeyId.prototype.keyId = $util.newBuffer([]);

        /**
         * Creates a new AppStateSyncKeyId instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {proto.IAppStateSyncKeyId=} [properties] Properties to set
         * @returns {proto.AppStateSyncKeyId} AppStateSyncKeyId instance
         */
        AppStateSyncKeyId.create = function create(properties) {
            return new AppStateSyncKeyId(properties);
        };

        /**
         * Encodes the specified AppStateSyncKeyId message. Does not implicitly {@link proto.AppStateSyncKeyId.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {proto.IAppStateSyncKeyId} message AppStateSyncKeyId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyId.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keyId != null && Object.hasOwnProperty.call(message, "keyId"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.keyId);
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKeyId message, length delimited. Does not implicitly {@link proto.AppStateSyncKeyId.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {proto.IAppStateSyncKeyId} message AppStateSyncKeyId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyId.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKeyId message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKeyId} AppStateSyncKeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyId.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKeyId();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.keyId = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKeyId message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKeyId} AppStateSyncKeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyId.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKeyId message.
         * @function verify
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKeyId.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keyId != null && message.hasOwnProperty("keyId"))
                if (!(message.keyId && typeof message.keyId.length === "number" || $util.isString(message.keyId)))
                    return "keyId: buffer expected";
            return null;
        };

        /**
         * Creates an AppStateSyncKeyId message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKeyId} AppStateSyncKeyId
         */
        AppStateSyncKeyId.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKeyId)
                return object;
            var message = new $root.proto.AppStateSyncKeyId();
            if (object.keyId != null)
                if (typeof object.keyId === "string")
                    $util.base64.decode(object.keyId, message.keyId = $util.newBuffer($util.base64.length(object.keyId)), 0);
                else if (object.keyId.length)
                    message.keyId = object.keyId;
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKeyId message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKeyId
         * @static
         * @param {proto.AppStateSyncKeyId} message AppStateSyncKeyId
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKeyId.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if (options.bytes === String)
                    object.keyId = "";
                else {
                    object.keyId = [];
                    if (options.bytes !== Array)
                        object.keyId = $util.newBuffer(object.keyId);
                }
            if (message.keyId != null && message.hasOwnProperty("keyId"))
                object.keyId = options.bytes === String ? $util.base64.encode(message.keyId, 0, message.keyId.length) : options.bytes === Array ? Array.prototype.slice.call(message.keyId) : message.keyId;
            return object;
        };

        /**
         * Converts this AppStateSyncKeyId to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKeyId
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKeyId.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKeyId;
    })();

    proto.AppStateSyncKeyRequest = (function() {

        /**
         * Properties of an AppStateSyncKeyRequest.
         * @memberof proto
         * @interface IAppStateSyncKeyRequest
         * @property {Array.<proto.IAppStateSyncKeyId>|null} [keyIds] AppStateSyncKeyRequest keyIds
         */

        /**
         * Constructs a new AppStateSyncKeyRequest.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKeyRequest.
         * @implements IAppStateSyncKeyRequest
         * @constructor
         * @param {proto.IAppStateSyncKeyRequest=} [properties] Properties to set
         */
        function AppStateSyncKeyRequest(properties) {
            this.keyIds = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKeyRequest keyIds.
         * @member {Array.<proto.IAppStateSyncKeyId>} keyIds
         * @memberof proto.AppStateSyncKeyRequest
         * @instance
         */
        AppStateSyncKeyRequest.prototype.keyIds = $util.emptyArray;

        /**
         * Creates a new AppStateSyncKeyRequest instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {proto.IAppStateSyncKeyRequest=} [properties] Properties to set
         * @returns {proto.AppStateSyncKeyRequest} AppStateSyncKeyRequest instance
         */
        AppStateSyncKeyRequest.create = function create(properties) {
            return new AppStateSyncKeyRequest(properties);
        };

        /**
         * Encodes the specified AppStateSyncKeyRequest message. Does not implicitly {@link proto.AppStateSyncKeyRequest.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {proto.IAppStateSyncKeyRequest} message AppStateSyncKeyRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyRequest.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keyIds != null && message.keyIds.length)
                for (var i = 0; i < message.keyIds.length; ++i)
                    $root.proto.AppStateSyncKeyId.encode(message.keyIds[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKeyRequest message, length delimited. Does not implicitly {@link proto.AppStateSyncKeyRequest.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {proto.IAppStateSyncKeyRequest} message AppStateSyncKeyRequest message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyRequest.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKeyRequest message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKeyRequest} AppStateSyncKeyRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyRequest.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKeyRequest();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.keyIds && message.keyIds.length))
                        message.keyIds = [];
                    message.keyIds.push($root.proto.AppStateSyncKeyId.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKeyRequest message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKeyRequest} AppStateSyncKeyRequest
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyRequest.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKeyRequest message.
         * @function verify
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKeyRequest.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keyIds != null && message.hasOwnProperty("keyIds")) {
                if (!Array.isArray(message.keyIds))
                    return "keyIds: array expected";
                for (var i = 0; i < message.keyIds.length; ++i) {
                    var error = $root.proto.AppStateSyncKeyId.verify(message.keyIds[i]);
                    if (error)
                        return "keyIds." + error;
                }
            }
            return null;
        };

        /**
         * Creates an AppStateSyncKeyRequest message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKeyRequest} AppStateSyncKeyRequest
         */
        AppStateSyncKeyRequest.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKeyRequest)
                return object;
            var message = new $root.proto.AppStateSyncKeyRequest();
            if (object.keyIds) {
                if (!Array.isArray(object.keyIds))
                    throw TypeError(".proto.AppStateSyncKeyRequest.keyIds: array expected");
                message.keyIds = [];
                for (var i = 0; i < object.keyIds.length; ++i) {
                    if (typeof object.keyIds[i] !== "object")
                        throw TypeError(".proto.AppStateSyncKeyRequest.keyIds: object expected");
                    message.keyIds[i] = $root.proto.AppStateSyncKeyId.fromObject(object.keyIds[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKeyRequest message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKeyRequest
         * @static
         * @param {proto.AppStateSyncKeyRequest} message AppStateSyncKeyRequest
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKeyRequest.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.keyIds = [];
            if (message.keyIds && message.keyIds.length) {
                object.keyIds = [];
                for (var j = 0; j < message.keyIds.length; ++j)
                    object.keyIds[j] = $root.proto.AppStateSyncKeyId.toObject(message.keyIds[j], options);
            }
            return object;
        };

        /**
         * Converts this AppStateSyncKeyRequest to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKeyRequest
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKeyRequest.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKeyRequest;
    })();

    proto.AppStateSyncKeyShare = (function() {

        /**
         * Properties of an AppStateSyncKeyShare.
         * @memberof proto
         * @interface IAppStateSyncKeyShare
         * @property {Array.<proto.IAppStateSyncKey>|null} [keys] AppStateSyncKeyShare keys
         */

        /**
         * Constructs a new AppStateSyncKeyShare.
         * @memberof proto
         * @classdesc Represents an AppStateSyncKeyShare.
         * @implements IAppStateSyncKeyShare
         * @constructor
         * @param {proto.IAppStateSyncKeyShare=} [properties] Properties to set
         */
        function AppStateSyncKeyShare(properties) {
            this.keys = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppStateSyncKeyShare keys.
         * @member {Array.<proto.IAppStateSyncKey>} keys
         * @memberof proto.AppStateSyncKeyShare
         * @instance
         */
        AppStateSyncKeyShare.prototype.keys = $util.emptyArray;

        /**
         * Creates a new AppStateSyncKeyShare instance using the specified properties.
         * @function create
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {proto.IAppStateSyncKeyShare=} [properties] Properties to set
         * @returns {proto.AppStateSyncKeyShare} AppStateSyncKeyShare instance
         */
        AppStateSyncKeyShare.create = function create(properties) {
            return new AppStateSyncKeyShare(properties);
        };

        /**
         * Encodes the specified AppStateSyncKeyShare message. Does not implicitly {@link proto.AppStateSyncKeyShare.verify|verify} messages.
         * @function encode
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {proto.IAppStateSyncKeyShare} message AppStateSyncKeyShare message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyShare.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keys != null && message.keys.length)
                for (var i = 0; i < message.keys.length; ++i)
                    $root.proto.AppStateSyncKey.encode(message.keys[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified AppStateSyncKeyShare message, length delimited. Does not implicitly {@link proto.AppStateSyncKeyShare.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {proto.IAppStateSyncKeyShare} message AppStateSyncKeyShare message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppStateSyncKeyShare.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppStateSyncKeyShare message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppStateSyncKeyShare} AppStateSyncKeyShare
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyShare.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppStateSyncKeyShare();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.keys && message.keys.length))
                        message.keys = [];
                    message.keys.push($root.proto.AppStateSyncKey.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppStateSyncKeyShare message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppStateSyncKeyShare} AppStateSyncKeyShare
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppStateSyncKeyShare.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppStateSyncKeyShare message.
         * @function verify
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppStateSyncKeyShare.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keys != null && message.hasOwnProperty("keys")) {
                if (!Array.isArray(message.keys))
                    return "keys: array expected";
                for (var i = 0; i < message.keys.length; ++i) {
                    var error = $root.proto.AppStateSyncKey.verify(message.keys[i]);
                    if (error)
                        return "keys." + error;
                }
            }
            return null;
        };

        /**
         * Creates an AppStateSyncKeyShare message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppStateSyncKeyShare} AppStateSyncKeyShare
         */
        AppStateSyncKeyShare.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppStateSyncKeyShare)
                return object;
            var message = new $root.proto.AppStateSyncKeyShare();
            if (object.keys) {
                if (!Array.isArray(object.keys))
                    throw TypeError(".proto.AppStateSyncKeyShare.keys: array expected");
                message.keys = [];
                for (var i = 0; i < object.keys.length; ++i) {
                    if (typeof object.keys[i] !== "object")
                        throw TypeError(".proto.AppStateSyncKeyShare.keys: object expected");
                    message.keys[i] = $root.proto.AppStateSyncKey.fromObject(object.keys[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from an AppStateSyncKeyShare message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppStateSyncKeyShare
         * @static
         * @param {proto.AppStateSyncKeyShare} message AppStateSyncKeyShare
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppStateSyncKeyShare.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.keys = [];
            if (message.keys && message.keys.length) {
                object.keys = [];
                for (var j = 0; j < message.keys.length; ++j)
                    object.keys[j] = $root.proto.AppStateSyncKey.toObject(message.keys[j], options);
            }
            return object;
        };

        /**
         * Converts this AppStateSyncKeyShare to JSON.
         * @function toJSON
         * @memberof proto.AppStateSyncKeyShare
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppStateSyncKeyShare.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppStateSyncKeyShare;
    })();

    proto.AppVersion = (function() {

        /**
         * Properties of an AppVersion.
         * @memberof proto
         * @interface IAppVersion
         * @property {number|null} [primary] AppVersion primary
         * @property {number|null} [secondary] AppVersion secondary
         * @property {number|null} [tertiary] AppVersion tertiary
         * @property {number|null} [quaternary] AppVersion quaternary
         * @property {number|null} [quinary] AppVersion quinary
         */

        /**
         * Constructs a new AppVersion.
         * @memberof proto
         * @classdesc Represents an AppVersion.
         * @implements IAppVersion
         * @constructor
         * @param {proto.IAppVersion=} [properties] Properties to set
         */
        function AppVersion(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AppVersion primary.
         * @member {number} primary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.primary = 0;

        /**
         * AppVersion secondary.
         * @member {number} secondary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.secondary = 0;

        /**
         * AppVersion tertiary.
         * @member {number} tertiary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.tertiary = 0;

        /**
         * AppVersion quaternary.
         * @member {number} quaternary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.quaternary = 0;

        /**
         * AppVersion quinary.
         * @member {number} quinary
         * @memberof proto.AppVersion
         * @instance
         */
        AppVersion.prototype.quinary = 0;

        /**
         * Creates a new AppVersion instance using the specified properties.
         * @function create
         * @memberof proto.AppVersion
         * @static
         * @param {proto.IAppVersion=} [properties] Properties to set
         * @returns {proto.AppVersion} AppVersion instance
         */
        AppVersion.create = function create(properties) {
            return new AppVersion(properties);
        };

        /**
         * Encodes the specified AppVersion message. Does not implicitly {@link proto.AppVersion.verify|verify} messages.
         * @function encode
         * @memberof proto.AppVersion
         * @static
         * @param {proto.IAppVersion} message AppVersion message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppVersion.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.primary != null && Object.hasOwnProperty.call(message, "primary"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.primary);
            if (message.secondary != null && Object.hasOwnProperty.call(message, "secondary"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.secondary);
            if (message.tertiary != null && Object.hasOwnProperty.call(message, "tertiary"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.tertiary);
            if (message.quaternary != null && Object.hasOwnProperty.call(message, "quaternary"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.quaternary);
            if (message.quinary != null && Object.hasOwnProperty.call(message, "quinary"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.quinary);
            return writer;
        };

        /**
         * Encodes the specified AppVersion message, length delimited. Does not implicitly {@link proto.AppVersion.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AppVersion
         * @static
         * @param {proto.IAppVersion} message AppVersion message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AppVersion.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AppVersion message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AppVersion
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AppVersion} AppVersion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppVersion.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AppVersion();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.primary = reader.uint32();
                    break;
                case 2:
                    message.secondary = reader.uint32();
                    break;
                case 3:
                    message.tertiary = reader.uint32();
                    break;
                case 4:
                    message.quaternary = reader.uint32();
                    break;
                case 5:
                    message.quinary = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AppVersion message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AppVersion
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AppVersion} AppVersion
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AppVersion.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AppVersion message.
         * @function verify
         * @memberof proto.AppVersion
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AppVersion.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.primary != null && message.hasOwnProperty("primary"))
                if (!$util.isInteger(message.primary))
                    return "primary: integer expected";
            if (message.secondary != null && message.hasOwnProperty("secondary"))
                if (!$util.isInteger(message.secondary))
                    return "secondary: integer expected";
            if (message.tertiary != null && message.hasOwnProperty("tertiary"))
                if (!$util.isInteger(message.tertiary))
                    return "tertiary: integer expected";
            if (message.quaternary != null && message.hasOwnProperty("quaternary"))
                if (!$util.isInteger(message.quaternary))
                    return "quaternary: integer expected";
            if (message.quinary != null && message.hasOwnProperty("quinary"))
                if (!$util.isInteger(message.quinary))
                    return "quinary: integer expected";
            return null;
        };

        /**
         * Creates an AppVersion message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AppVersion
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AppVersion} AppVersion
         */
        AppVersion.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AppVersion)
                return object;
            var message = new $root.proto.AppVersion();
            if (object.primary != null)
                message.primary = object.primary >>> 0;
            if (object.secondary != null)
                message.secondary = object.secondary >>> 0;
            if (object.tertiary != null)
                message.tertiary = object.tertiary >>> 0;
            if (object.quaternary != null)
                message.quaternary = object.quaternary >>> 0;
            if (object.quinary != null)
                message.quinary = object.quinary >>> 0;
            return message;
        };

        /**
         * Creates a plain object from an AppVersion message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AppVersion
         * @static
         * @param {proto.AppVersion} message AppVersion
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AppVersion.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.primary = 0;
                object.secondary = 0;
                object.tertiary = 0;
                object.quaternary = 0;
                object.quinary = 0;
            }
            if (message.primary != null && message.hasOwnProperty("primary"))
                object.primary = message.primary;
            if (message.secondary != null && message.hasOwnProperty("secondary"))
                object.secondary = message.secondary;
            if (message.tertiary != null && message.hasOwnProperty("tertiary"))
                object.tertiary = message.tertiary;
            if (message.quaternary != null && message.hasOwnProperty("quaternary"))
                object.quaternary = message.quaternary;
            if (message.quinary != null && message.hasOwnProperty("quinary"))
                object.quinary = message.quinary;
            return object;
        };

        /**
         * Converts this AppVersion to JSON.
         * @function toJSON
         * @memberof proto.AppVersion
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AppVersion.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AppVersion;
    })();

    proto.ArchiveChatAction = (function() {

        /**
         * Properties of an ArchiveChatAction.
         * @memberof proto
         * @interface IArchiveChatAction
         * @property {boolean|null} [archived] ArchiveChatAction archived
         * @property {proto.ISyncActionMessageRange|null} [messageRange] ArchiveChatAction messageRange
         */

        /**
         * Constructs a new ArchiveChatAction.
         * @memberof proto
         * @classdesc Represents an ArchiveChatAction.
         * @implements IArchiveChatAction
         * @constructor
         * @param {proto.IArchiveChatAction=} [properties] Properties to set
         */
        function ArchiveChatAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ArchiveChatAction archived.
         * @member {boolean} archived
         * @memberof proto.ArchiveChatAction
         * @instance
         */
        ArchiveChatAction.prototype.archived = false;

        /**
         * ArchiveChatAction messageRange.
         * @member {proto.ISyncActionMessageRange|null|undefined} messageRange
         * @memberof proto.ArchiveChatAction
         * @instance
         */
        ArchiveChatAction.prototype.messageRange = null;

        /**
         * Creates a new ArchiveChatAction instance using the specified properties.
         * @function create
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {proto.IArchiveChatAction=} [properties] Properties to set
         * @returns {proto.ArchiveChatAction} ArchiveChatAction instance
         */
        ArchiveChatAction.create = function create(properties) {
            return new ArchiveChatAction(properties);
        };

        /**
         * Encodes the specified ArchiveChatAction message. Does not implicitly {@link proto.ArchiveChatAction.verify|verify} messages.
         * @function encode
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {proto.IArchiveChatAction} message ArchiveChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ArchiveChatAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.archived != null && Object.hasOwnProperty.call(message, "archived"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.archived);
            if (message.messageRange != null && Object.hasOwnProperty.call(message, "messageRange"))
                $root.proto.SyncActionMessageRange.encode(message.messageRange, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified ArchiveChatAction message, length delimited. Does not implicitly {@link proto.ArchiveChatAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {proto.IArchiveChatAction} message ArchiveChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ArchiveChatAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ArchiveChatAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ArchiveChatAction} ArchiveChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ArchiveChatAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ArchiveChatAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.archived = reader.bool();
                    break;
                case 2:
                    message.messageRange = $root.proto.SyncActionMessageRange.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ArchiveChatAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ArchiveChatAction} ArchiveChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ArchiveChatAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ArchiveChatAction message.
         * @function verify
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ArchiveChatAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.archived != null && message.hasOwnProperty("archived"))
                if (typeof message.archived !== "boolean")
                    return "archived: boolean expected";
            if (message.messageRange != null && message.hasOwnProperty("messageRange")) {
                var error = $root.proto.SyncActionMessageRange.verify(message.messageRange);
                if (error)
                    return "messageRange." + error;
            }
            return null;
        };

        /**
         * Creates an ArchiveChatAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ArchiveChatAction} ArchiveChatAction
         */
        ArchiveChatAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ArchiveChatAction)
                return object;
            var message = new $root.proto.ArchiveChatAction();
            if (object.archived != null)
                message.archived = Boolean(object.archived);
            if (object.messageRange != null) {
                if (typeof object.messageRange !== "object")
                    throw TypeError(".proto.ArchiveChatAction.messageRange: object expected");
                message.messageRange = $root.proto.SyncActionMessageRange.fromObject(object.messageRange);
            }
            return message;
        };

        /**
         * Creates a plain object from an ArchiveChatAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ArchiveChatAction
         * @static
         * @param {proto.ArchiveChatAction} message ArchiveChatAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ArchiveChatAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.archived = false;
                object.messageRange = null;
            }
            if (message.archived != null && message.hasOwnProperty("archived"))
                object.archived = message.archived;
            if (message.messageRange != null && message.hasOwnProperty("messageRange"))
                object.messageRange = $root.proto.SyncActionMessageRange.toObject(message.messageRange, options);
            return object;
        };

        /**
         * Converts this ArchiveChatAction to JSON.
         * @function toJSON
         * @memberof proto.ArchiveChatAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ArchiveChatAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ArchiveChatAction;
    })();

    proto.AudioMessage = (function() {

        /**
         * Properties of an AudioMessage.
         * @memberof proto
         * @interface IAudioMessage
         * @property {string|null} [url] AudioMessage url
         * @property {string|null} [mimetype] AudioMessage mimetype
         * @property {Uint8Array|null} [fileSha256] AudioMessage fileSha256
         * @property {number|Long|null} [fileLength] AudioMessage fileLength
         * @property {number|null} [seconds] AudioMessage seconds
         * @property {boolean|null} [ptt] AudioMessage ptt
         * @property {Uint8Array|null} [mediaKey] AudioMessage mediaKey
         * @property {Uint8Array|null} [fileEncSha256] AudioMessage fileEncSha256
         * @property {string|null} [directPath] AudioMessage directPath
         * @property {number|Long|null} [mediaKeyTimestamp] AudioMessage mediaKeyTimestamp
         * @property {proto.IContextInfo|null} [contextInfo] AudioMessage contextInfo
         * @property {Uint8Array|null} [streamingSidecar] AudioMessage streamingSidecar
         * @property {Uint8Array|null} [waveform] AudioMessage waveform
         */

        /**
         * Constructs a new AudioMessage.
         * @memberof proto
         * @classdesc Represents an AudioMessage.
         * @implements IAudioMessage
         * @constructor
         * @param {proto.IAudioMessage=} [properties] Properties to set
         */
        function AudioMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AudioMessage url.
         * @member {string} url
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.url = "";

        /**
         * AudioMessage mimetype.
         * @member {string} mimetype
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.mimetype = "";

        /**
         * AudioMessage fileSha256.
         * @member {Uint8Array} fileSha256
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.fileSha256 = $util.newBuffer([]);

        /**
         * AudioMessage fileLength.
         * @member {number|Long} fileLength
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.fileLength = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * AudioMessage seconds.
         * @member {number} seconds
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.seconds = 0;

        /**
         * AudioMessage ptt.
         * @member {boolean} ptt
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.ptt = false;

        /**
         * AudioMessage mediaKey.
         * @member {Uint8Array} mediaKey
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.mediaKey = $util.newBuffer([]);

        /**
         * AudioMessage fileEncSha256.
         * @member {Uint8Array} fileEncSha256
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.fileEncSha256 = $util.newBuffer([]);

        /**
         * AudioMessage directPath.
         * @member {string} directPath
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.directPath = "";

        /**
         * AudioMessage mediaKeyTimestamp.
         * @member {number|Long} mediaKeyTimestamp
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * AudioMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.contextInfo = null;

        /**
         * AudioMessage streamingSidecar.
         * @member {Uint8Array} streamingSidecar
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.streamingSidecar = $util.newBuffer([]);

        /**
         * AudioMessage waveform.
         * @member {Uint8Array} waveform
         * @memberof proto.AudioMessage
         * @instance
         */
        AudioMessage.prototype.waveform = $util.newBuffer([]);

        /**
         * Creates a new AudioMessage instance using the specified properties.
         * @function create
         * @memberof proto.AudioMessage
         * @static
         * @param {proto.IAudioMessage=} [properties] Properties to set
         * @returns {proto.AudioMessage} AudioMessage instance
         */
        AudioMessage.create = function create(properties) {
            return new AudioMessage(properties);
        };

        /**
         * Encodes the specified AudioMessage message. Does not implicitly {@link proto.AudioMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.AudioMessage
         * @static
         * @param {proto.IAudioMessage} message AudioMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AudioMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.url);
            if (message.mimetype != null && Object.hasOwnProperty.call(message, "mimetype"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.mimetype);
            if (message.fileSha256 != null && Object.hasOwnProperty.call(message, "fileSha256"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.fileSha256);
            if (message.fileLength != null && Object.hasOwnProperty.call(message, "fileLength"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint64(message.fileLength);
            if (message.seconds != null && Object.hasOwnProperty.call(message, "seconds"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.seconds);
            if (message.ptt != null && Object.hasOwnProperty.call(message, "ptt"))
                writer.uint32(/* id 6, wireType 0 =*/48).bool(message.ptt);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 7, wireType 2 =*/58).bytes(message.mediaKey);
            if (message.fileEncSha256 != null && Object.hasOwnProperty.call(message, "fileEncSha256"))
                writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.fileEncSha256);
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.directPath);
            if (message.mediaKeyTimestamp != null && Object.hasOwnProperty.call(message, "mediaKeyTimestamp"))
                writer.uint32(/* id 10, wireType 0 =*/80).int64(message.mediaKeyTimestamp);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.streamingSidecar != null && Object.hasOwnProperty.call(message, "streamingSidecar"))
                writer.uint32(/* id 18, wireType 2 =*/146).bytes(message.streamingSidecar);
            if (message.waveform != null && Object.hasOwnProperty.call(message, "waveform"))
                writer.uint32(/* id 19, wireType 2 =*/154).bytes(message.waveform);
            return writer;
        };

        /**
         * Encodes the specified AudioMessage message, length delimited. Does not implicitly {@link proto.AudioMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AudioMessage
         * @static
         * @param {proto.IAudioMessage} message AudioMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AudioMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AudioMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AudioMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AudioMessage} AudioMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AudioMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AudioMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.url = reader.string();
                    break;
                case 2:
                    message.mimetype = reader.string();
                    break;
                case 3:
                    message.fileSha256 = reader.bytes();
                    break;
                case 4:
                    message.fileLength = reader.uint64();
                    break;
                case 5:
                    message.seconds = reader.uint32();
                    break;
                case 6:
                    message.ptt = reader.bool();
                    break;
                case 7:
                    message.mediaKey = reader.bytes();
                    break;
                case 8:
                    message.fileEncSha256 = reader.bytes();
                    break;
                case 9:
                    message.directPath = reader.string();
                    break;
                case 10:
                    message.mediaKeyTimestamp = reader.int64();
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.streamingSidecar = reader.bytes();
                    break;
                case 19:
                    message.waveform = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AudioMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AudioMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AudioMessage} AudioMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AudioMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AudioMessage message.
         * @function verify
         * @memberof proto.AudioMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AudioMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.url != null && message.hasOwnProperty("url"))
                if (!$util.isString(message.url))
                    return "url: string expected";
            if (message.mimetype != null && message.hasOwnProperty("mimetype"))
                if (!$util.isString(message.mimetype))
                    return "mimetype: string expected";
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                if (!(message.fileSha256 && typeof message.fileSha256.length === "number" || $util.isString(message.fileSha256)))
                    return "fileSha256: buffer expected";
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (!$util.isInteger(message.fileLength) && !(message.fileLength && $util.isInteger(message.fileLength.low) && $util.isInteger(message.fileLength.high)))
                    return "fileLength: integer|Long expected";
            if (message.seconds != null && message.hasOwnProperty("seconds"))
                if (!$util.isInteger(message.seconds))
                    return "seconds: integer expected";
            if (message.ptt != null && message.hasOwnProperty("ptt"))
                if (typeof message.ptt !== "boolean")
                    return "ptt: boolean expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!(message.mediaKey && typeof message.mediaKey.length === "number" || $util.isString(message.mediaKey)))
                    return "mediaKey: buffer expected";
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                if (!(message.fileEncSha256 && typeof message.fileEncSha256.length === "number" || $util.isString(message.fileEncSha256)))
                    return "fileEncSha256: buffer expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (!$util.isInteger(message.mediaKeyTimestamp) && !(message.mediaKeyTimestamp && $util.isInteger(message.mediaKeyTimestamp.low) && $util.isInteger(message.mediaKeyTimestamp.high)))
                    return "mediaKeyTimestamp: integer|Long expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.streamingSidecar != null && message.hasOwnProperty("streamingSidecar"))
                if (!(message.streamingSidecar && typeof message.streamingSidecar.length === "number" || $util.isString(message.streamingSidecar)))
                    return "streamingSidecar: buffer expected";
            if (message.waveform != null && message.hasOwnProperty("waveform"))
                if (!(message.waveform && typeof message.waveform.length === "number" || $util.isString(message.waveform)))
                    return "waveform: buffer expected";
            return null;
        };

        /**
         * Creates an AudioMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AudioMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AudioMessage} AudioMessage
         */
        AudioMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AudioMessage)
                return object;
            var message = new $root.proto.AudioMessage();
            if (object.url != null)
                message.url = String(object.url);
            if (object.mimetype != null)
                message.mimetype = String(object.mimetype);
            if (object.fileSha256 != null)
                if (typeof object.fileSha256 === "string")
                    $util.base64.decode(object.fileSha256, message.fileSha256 = $util.newBuffer($util.base64.length(object.fileSha256)), 0);
                else if (object.fileSha256.length)
                    message.fileSha256 = object.fileSha256;
            if (object.fileLength != null)
                if ($util.Long)
                    (message.fileLength = $util.Long.fromValue(object.fileLength)).unsigned = true;
                else if (typeof object.fileLength === "string")
                    message.fileLength = parseInt(object.fileLength, 10);
                else if (typeof object.fileLength === "number")
                    message.fileLength = object.fileLength;
                else if (typeof object.fileLength === "object")
                    message.fileLength = new $util.LongBits(object.fileLength.low >>> 0, object.fileLength.high >>> 0).toNumber(true);
            if (object.seconds != null)
                message.seconds = object.seconds >>> 0;
            if (object.ptt != null)
                message.ptt = Boolean(object.ptt);
            if (object.mediaKey != null)
                if (typeof object.mediaKey === "string")
                    $util.base64.decode(object.mediaKey, message.mediaKey = $util.newBuffer($util.base64.length(object.mediaKey)), 0);
                else if (object.mediaKey.length)
                    message.mediaKey = object.mediaKey;
            if (object.fileEncSha256 != null)
                if (typeof object.fileEncSha256 === "string")
                    $util.base64.decode(object.fileEncSha256, message.fileEncSha256 = $util.newBuffer($util.base64.length(object.fileEncSha256)), 0);
                else if (object.fileEncSha256.length)
                    message.fileEncSha256 = object.fileEncSha256;
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.mediaKeyTimestamp != null)
                if ($util.Long)
                    (message.mediaKeyTimestamp = $util.Long.fromValue(object.mediaKeyTimestamp)).unsigned = false;
                else if (typeof object.mediaKeyTimestamp === "string")
                    message.mediaKeyTimestamp = parseInt(object.mediaKeyTimestamp, 10);
                else if (typeof object.mediaKeyTimestamp === "number")
                    message.mediaKeyTimestamp = object.mediaKeyTimestamp;
                else if (typeof object.mediaKeyTimestamp === "object")
                    message.mediaKeyTimestamp = new $util.LongBits(object.mediaKeyTimestamp.low >>> 0, object.mediaKeyTimestamp.high >>> 0).toNumber();
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.AudioMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.streamingSidecar != null)
                if (typeof object.streamingSidecar === "string")
                    $util.base64.decode(object.streamingSidecar, message.streamingSidecar = $util.newBuffer($util.base64.length(object.streamingSidecar)), 0);
                else if (object.streamingSidecar.length)
                    message.streamingSidecar = object.streamingSidecar;
            if (object.waveform != null)
                if (typeof object.waveform === "string")
                    $util.base64.decode(object.waveform, message.waveform = $util.newBuffer($util.base64.length(object.waveform)), 0);
                else if (object.waveform.length)
                    message.waveform = object.waveform;
            return message;
        };

        /**
         * Creates a plain object from an AudioMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AudioMessage
         * @static
         * @param {proto.AudioMessage} message AudioMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AudioMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.url = "";
                object.mimetype = "";
                if (options.bytes === String)
                    object.fileSha256 = "";
                else {
                    object.fileSha256 = [];
                    if (options.bytes !== Array)
                        object.fileSha256 = $util.newBuffer(object.fileSha256);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fileLength = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fileLength = options.longs === String ? "0" : 0;
                object.seconds = 0;
                object.ptt = false;
                if (options.bytes === String)
                    object.mediaKey = "";
                else {
                    object.mediaKey = [];
                    if (options.bytes !== Array)
                        object.mediaKey = $util.newBuffer(object.mediaKey);
                }
                if (options.bytes === String)
                    object.fileEncSha256 = "";
                else {
                    object.fileEncSha256 = [];
                    if (options.bytes !== Array)
                        object.fileEncSha256 = $util.newBuffer(object.fileEncSha256);
                }
                object.directPath = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.mediaKeyTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.mediaKeyTimestamp = options.longs === String ? "0" : 0;
                object.contextInfo = null;
                if (options.bytes === String)
                    object.streamingSidecar = "";
                else {
                    object.streamingSidecar = [];
                    if (options.bytes !== Array)
                        object.streamingSidecar = $util.newBuffer(object.streamingSidecar);
                }
                if (options.bytes === String)
                    object.waveform = "";
                else {
                    object.waveform = [];
                    if (options.bytes !== Array)
                        object.waveform = $util.newBuffer(object.waveform);
                }
            }
            if (message.url != null && message.hasOwnProperty("url"))
                object.url = message.url;
            if (message.mimetype != null && message.hasOwnProperty("mimetype"))
                object.mimetype = message.mimetype;
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                object.fileSha256 = options.bytes === String ? $util.base64.encode(message.fileSha256, 0, message.fileSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileSha256) : message.fileSha256;
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (typeof message.fileLength === "number")
                    object.fileLength = options.longs === String ? String(message.fileLength) : message.fileLength;
                else
                    object.fileLength = options.longs === String ? $util.Long.prototype.toString.call(message.fileLength) : options.longs === Number ? new $util.LongBits(message.fileLength.low >>> 0, message.fileLength.high >>> 0).toNumber(true) : message.fileLength;
            if (message.seconds != null && message.hasOwnProperty("seconds"))
                object.seconds = message.seconds;
            if (message.ptt != null && message.hasOwnProperty("ptt"))
                object.ptt = message.ptt;
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = options.bytes === String ? $util.base64.encode(message.mediaKey, 0, message.mediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.mediaKey) : message.mediaKey;
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                object.fileEncSha256 = options.bytes === String ? $util.base64.encode(message.fileEncSha256, 0, message.fileEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileEncSha256) : message.fileEncSha256;
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (typeof message.mediaKeyTimestamp === "number")
                    object.mediaKeyTimestamp = options.longs === String ? String(message.mediaKeyTimestamp) : message.mediaKeyTimestamp;
                else
                    object.mediaKeyTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.mediaKeyTimestamp) : options.longs === Number ? new $util.LongBits(message.mediaKeyTimestamp.low >>> 0, message.mediaKeyTimestamp.high >>> 0).toNumber() : message.mediaKeyTimestamp;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.streamingSidecar != null && message.hasOwnProperty("streamingSidecar"))
                object.streamingSidecar = options.bytes === String ? $util.base64.encode(message.streamingSidecar, 0, message.streamingSidecar.length) : options.bytes === Array ? Array.prototype.slice.call(message.streamingSidecar) : message.streamingSidecar;
            if (message.waveform != null && message.hasOwnProperty("waveform"))
                object.waveform = options.bytes === String ? $util.base64.encode(message.waveform, 0, message.waveform.length) : options.bytes === Array ? Array.prototype.slice.call(message.waveform) : message.waveform;
            return object;
        };

        /**
         * Converts this AudioMessage to JSON.
         * @function toJSON
         * @memberof proto.AudioMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AudioMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AudioMessage;
    })();

    proto.AutoDownloadSettings = (function() {

        /**
         * Properties of an AutoDownloadSettings.
         * @memberof proto
         * @interface IAutoDownloadSettings
         * @property {boolean|null} [downloadImages] AutoDownloadSettings downloadImages
         * @property {boolean|null} [downloadAudio] AutoDownloadSettings downloadAudio
         * @property {boolean|null} [downloadVideo] AutoDownloadSettings downloadVideo
         * @property {boolean|null} [downloadDocuments] AutoDownloadSettings downloadDocuments
         */

        /**
         * Constructs a new AutoDownloadSettings.
         * @memberof proto
         * @classdesc Represents an AutoDownloadSettings.
         * @implements IAutoDownloadSettings
         * @constructor
         * @param {proto.IAutoDownloadSettings=} [properties] Properties to set
         */
        function AutoDownloadSettings(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AutoDownloadSettings downloadImages.
         * @member {boolean} downloadImages
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadImages = false;

        /**
         * AutoDownloadSettings downloadAudio.
         * @member {boolean} downloadAudio
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadAudio = false;

        /**
         * AutoDownloadSettings downloadVideo.
         * @member {boolean} downloadVideo
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadVideo = false;

        /**
         * AutoDownloadSettings downloadDocuments.
         * @member {boolean} downloadDocuments
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadDocuments = false;

        /**
         * Creates a new AutoDownloadSettings instance using the specified properties.
         * @function create
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.IAutoDownloadSettings=} [properties] Properties to set
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings instance
         */
        AutoDownloadSettings.create = function create(properties) {
            return new AutoDownloadSettings(properties);
        };

        /**
         * Encodes the specified AutoDownloadSettings message. Does not implicitly {@link proto.AutoDownloadSettings.verify|verify} messages.
         * @function encode
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.IAutoDownloadSettings} message AutoDownloadSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AutoDownloadSettings.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.downloadImages != null && Object.hasOwnProperty.call(message, "downloadImages"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.downloadImages);
            if (message.downloadAudio != null && Object.hasOwnProperty.call(message, "downloadAudio"))
                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.downloadAudio);
            if (message.downloadVideo != null && Object.hasOwnProperty.call(message, "downloadVideo"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.downloadVideo);
            if (message.downloadDocuments != null && Object.hasOwnProperty.call(message, "downloadDocuments"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.downloadDocuments);
            return writer;
        };

        /**
         * Encodes the specified AutoDownloadSettings message, length delimited. Does not implicitly {@link proto.AutoDownloadSettings.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.IAutoDownloadSettings} message AutoDownloadSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AutoDownloadSettings.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AutoDownloadSettings message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AutoDownloadSettings.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AutoDownloadSettings();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.downloadImages = reader.bool();
                    break;
                case 2:
                    message.downloadAudio = reader.bool();
                    break;
                case 3:
                    message.downloadVideo = reader.bool();
                    break;
                case 4:
                    message.downloadDocuments = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AutoDownloadSettings message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AutoDownloadSettings.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AutoDownloadSettings message.
         * @function verify
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AutoDownloadSettings.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.downloadImages != null && message.hasOwnProperty("downloadImages"))
                if (typeof message.downloadImages !== "boolean")
                    return "downloadImages: boolean expected";
            if (message.downloadAudio != null && message.hasOwnProperty("downloadAudio"))
                if (typeof message.downloadAudio !== "boolean")
                    return "downloadAudio: boolean expected";
            if (message.downloadVideo != null && message.hasOwnProperty("downloadVideo"))
                if (typeof message.downloadVideo !== "boolean")
                    return "downloadVideo: boolean expected";
            if (message.downloadDocuments != null && message.hasOwnProperty("downloadDocuments"))
                if (typeof message.downloadDocuments !== "boolean")
                    return "downloadDocuments: boolean expected";
            return null;
        };

        /**
         * Creates an AutoDownloadSettings message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings
         */
        AutoDownloadSettings.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AutoDownloadSettings)
                return object;
            var message = new $root.proto.AutoDownloadSettings();
            if (object.downloadImages != null)
                message.downloadImages = Boolean(object.downloadImages);
            if (object.downloadAudio != null)
                message.downloadAudio = Boolean(object.downloadAudio);
            if (object.downloadVideo != null)
                message.downloadVideo = Boolean(object.downloadVideo);
            if (object.downloadDocuments != null)
                message.downloadDocuments = Boolean(object.downloadDocuments);
            return message;
        };

        /**
         * Creates a plain object from an AutoDownloadSettings message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.AutoDownloadSettings} message AutoDownloadSettings
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AutoDownloadSettings.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.downloadImages = false;
                object.downloadAudio = false;
                object.downloadVideo = false;
                object.downloadDocuments = false;
            }
            if (message.downloadImages != null && message.hasOwnProperty("downloadImages"))
                object.downloadImages = message.downloadImages;
            if (message.downloadAudio != null && message.hasOwnProperty("downloadAudio"))
                object.downloadAudio = message.downloadAudio;
            if (message.downloadVideo != null && message.hasOwnProperty("downloadVideo"))
                object.downloadVideo = message.downloadVideo;
            if (message.downloadDocuments != null && message.hasOwnProperty("downloadDocuments"))
                object.downloadDocuments = message.downloadDocuments;
            return object;
        };

        /**
         * Converts this AutoDownloadSettings to JSON.
         * @function toJSON
         * @memberof proto.AutoDownloadSettings
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AutoDownloadSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AutoDownloadSettings;
    })();

    proto.BizAccountLinkInfo = (function() {

        /**
         * Properties of a BizAccountLinkInfo.
         * @memberof proto
         * @interface IBizAccountLinkInfo
         * @property {number|Long|null} [whatsappBizAcctFbid] BizAccountLinkInfo whatsappBizAcctFbid
         * @property {string|null} [whatsappAcctNumber] BizAccountLinkInfo whatsappAcctNumber
         * @property {number|Long|null} [issueTime] BizAccountLinkInfo issueTime
         * @property {proto.BizAccountLinkInfo.BizAccountLinkInfoHostStorageType|null} [hostStorage] BizAccountLinkInfo hostStorage
         * @property {proto.BizAccountLinkInfo.BizAccountLinkInfoAccountType|null} [accountType] BizAccountLinkInfo accountType
         */

        /**
         * Constructs a new BizAccountLinkInfo.
         * @memberof proto
         * @classdesc Represents a BizAccountLinkInfo.
         * @implements IBizAccountLinkInfo
         * @constructor
         * @param {proto.IBizAccountLinkInfo=} [properties] Properties to set
         */
        function BizAccountLinkInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizAccountLinkInfo whatsappBizAcctFbid.
         * @member {number|Long} whatsappBizAcctFbid
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.whatsappBizAcctFbid = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * BizAccountLinkInfo whatsappAcctNumber.
         * @member {string} whatsappAcctNumber
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.whatsappAcctNumber = "";

        /**
         * BizAccountLinkInfo issueTime.
         * @member {number|Long} issueTime
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.issueTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * BizAccountLinkInfo hostStorage.
         * @member {proto.BizAccountLinkInfo.BizAccountLinkInfoHostStorageType} hostStorage
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.hostStorage = 0;

        /**
         * BizAccountLinkInfo accountType.
         * @member {proto.BizAccountLinkInfo.BizAccountLinkInfoAccountType} accountType
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.accountType = 0;

        /**
         * Creates a new BizAccountLinkInfo instance using the specified properties.
         * @function create
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo=} [properties] Properties to set
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo instance
         */
        BizAccountLinkInfo.create = function create(properties) {
            return new BizAccountLinkInfo(properties);
        };

        /**
         * Encodes the specified BizAccountLinkInfo message. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo} message BizAccountLinkInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountLinkInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.whatsappBizAcctFbid != null && Object.hasOwnProperty.call(message, "whatsappBizAcctFbid"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.whatsappBizAcctFbid);
            if (message.whatsappAcctNumber != null && Object.hasOwnProperty.call(message, "whatsappAcctNumber"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.whatsappAcctNumber);
            if (message.issueTime != null && Object.hasOwnProperty.call(message, "issueTime"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint64(message.issueTime);
            if (message.hostStorage != null && Object.hasOwnProperty.call(message, "hostStorage"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.hostStorage);
            if (message.accountType != null && Object.hasOwnProperty.call(message, "accountType"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.accountType);
            return writer;
        };

        /**
         * Encodes the specified BizAccountLinkInfo message, length delimited. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo} message BizAccountLinkInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountLinkInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountLinkInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizAccountLinkInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.whatsappBizAcctFbid = reader.uint64();
                    break;
                case 2:
                    message.whatsappAcctNumber = reader.string();
                    break;
                case 3:
                    message.issueTime = reader.uint64();
                    break;
                case 4:
                    message.hostStorage = reader.int32();
                    break;
                case 5:
                    message.accountType = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountLinkInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizAccountLinkInfo message.
         * @function verify
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizAccountLinkInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.whatsappBizAcctFbid != null && message.hasOwnProperty("whatsappBizAcctFbid"))
                if (!$util.isInteger(message.whatsappBizAcctFbid) && !(message.whatsappBizAcctFbid && $util.isInteger(message.whatsappBizAcctFbid.low) && $util.isInteger(message.whatsappBizAcctFbid.high)))
                    return "whatsappBizAcctFbid: integer|Long expected";
            if (message.whatsappAcctNumber != null && message.hasOwnProperty("whatsappAcctNumber"))
                if (!$util.isString(message.whatsappAcctNumber))
                    return "whatsappAcctNumber: string expected";
            if (message.issueTime != null && message.hasOwnProperty("issueTime"))
                if (!$util.isInteger(message.issueTime) && !(message.issueTime && $util.isInteger(message.issueTime.low) && $util.isInteger(message.issueTime.high)))
                    return "issueTime: integer|Long expected";
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                switch (message.hostStorage) {
                default:
                    return "hostStorage: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.accountType != null && message.hasOwnProperty("accountType"))
                switch (message.accountType) {
                default:
                    return "accountType: enum value expected";
                case 0:
                    break;
                }
            return null;
        };

        /**
         * Creates a BizAccountLinkInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         */
        BizAccountLinkInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizAccountLinkInfo)
                return object;
            var message = new $root.proto.BizAccountLinkInfo();
            if (object.whatsappBizAcctFbid != null)
                if ($util.Long)
                    (message.whatsappBizAcctFbid = $util.Long.fromValue(object.whatsappBizAcctFbid)).unsigned = true;
                else if (typeof object.whatsappBizAcctFbid === "string")
                    message.whatsappBizAcctFbid = parseInt(object.whatsappBizAcctFbid, 10);
                else if (typeof object.whatsappBizAcctFbid === "number")
                    message.whatsappBizAcctFbid = object.whatsappBizAcctFbid;
                else if (typeof object.whatsappBizAcctFbid === "object")
                    message.whatsappBizAcctFbid = new $util.LongBits(object.whatsappBizAcctFbid.low >>> 0, object.whatsappBizAcctFbid.high >>> 0).toNumber(true);
            if (object.whatsappAcctNumber != null)
                message.whatsappAcctNumber = String(object.whatsappAcctNumber);
            if (object.issueTime != null)
                if ($util.Long)
                    (message.issueTime = $util.Long.fromValue(object.issueTime)).unsigned = true;
                else if (typeof object.issueTime === "string")
                    message.issueTime = parseInt(object.issueTime, 10);
                else if (typeof object.issueTime === "number")
                    message.issueTime = object.issueTime;
                else if (typeof object.issueTime === "object")
                    message.issueTime = new $util.LongBits(object.issueTime.low >>> 0, object.issueTime.high >>> 0).toNumber(true);
            switch (object.hostStorage) {
            case "ON_PREMISE":
            case 0:
                message.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                message.hostStorage = 1;
                break;
            }
            switch (object.accountType) {
            case "ENTERPRISE":
            case 0:
                message.accountType = 0;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a BizAccountLinkInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.BizAccountLinkInfo} message BizAccountLinkInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizAccountLinkInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.whatsappBizAcctFbid = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.whatsappBizAcctFbid = options.longs === String ? "0" : 0;
                object.whatsappAcctNumber = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.issueTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.issueTime = options.longs === String ? "0" : 0;
                object.hostStorage = options.enums === String ? "ON_PREMISE" : 0;
                object.accountType = options.enums === String ? "ENTERPRISE" : 0;
            }
            if (message.whatsappBizAcctFbid != null && message.hasOwnProperty("whatsappBizAcctFbid"))
                if (typeof message.whatsappBizAcctFbid === "number")
                    object.whatsappBizAcctFbid = options.longs === String ? String(message.whatsappBizAcctFbid) : message.whatsappBizAcctFbid;
                else
                    object.whatsappBizAcctFbid = options.longs === String ? $util.Long.prototype.toString.call(message.whatsappBizAcctFbid) : options.longs === Number ? new $util.LongBits(message.whatsappBizAcctFbid.low >>> 0, message.whatsappBizAcctFbid.high >>> 0).toNumber(true) : message.whatsappBizAcctFbid;
            if (message.whatsappAcctNumber != null && message.hasOwnProperty("whatsappAcctNumber"))
                object.whatsappAcctNumber = message.whatsappAcctNumber;
            if (message.issueTime != null && message.hasOwnProperty("issueTime"))
                if (typeof message.issueTime === "number")
                    object.issueTime = options.longs === String ? String(message.issueTime) : message.issueTime;
                else
                    object.issueTime = options.longs === String ? $util.Long.prototype.toString.call(message.issueTime) : options.longs === Number ? new $util.LongBits(message.issueTime.low >>> 0, message.issueTime.high >>> 0).toNumber(true) : message.issueTime;
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                object.hostStorage = options.enums === String ? $root.proto.BizAccountLinkInfo.BizAccountLinkInfoHostStorageType[message.hostStorage] : message.hostStorage;
            if (message.accountType != null && message.hasOwnProperty("accountType"))
                object.accountType = options.enums === String ? $root.proto.BizAccountLinkInfo.BizAccountLinkInfoAccountType[message.accountType] : message.accountType;
            return object;
        };

        /**
         * Converts this BizAccountLinkInfo to JSON.
         * @function toJSON
         * @memberof proto.BizAccountLinkInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizAccountLinkInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * BizAccountLinkInfoHostStorageType enum.
         * @name proto.BizAccountLinkInfo.BizAccountLinkInfoHostStorageType
         * @enum {number}
         * @property {number} ON_PREMISE=0 ON_PREMISE value
         * @property {number} FACEBOOK=1 FACEBOOK value
         */
        BizAccountLinkInfo.BizAccountLinkInfoHostStorageType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        /**
         * BizAccountLinkInfoAccountType enum.
         * @name proto.BizAccountLinkInfo.BizAccountLinkInfoAccountType
         * @enum {number}
         * @property {number} ENTERPRISE=0 ENTERPRISE value
         */
        BizAccountLinkInfo.BizAccountLinkInfoAccountType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ENTERPRISE"] = 0;
            return values;
        })();

        return BizAccountLinkInfo;
    })();

    proto.BizAccountPayload = (function() {

        /**
         * Properties of a BizAccountPayload.
         * @memberof proto
         * @interface IBizAccountPayload
         * @property {proto.IVerifiedNameCertificate|null} [vnameCert] BizAccountPayload vnameCert
         * @property {Uint8Array|null} [bizAcctLinkInfo] BizAccountPayload bizAcctLinkInfo
         */

        /**
         * Constructs a new BizAccountPayload.
         * @memberof proto
         * @classdesc Represents a BizAccountPayload.
         * @implements IBizAccountPayload
         * @constructor
         * @param {proto.IBizAccountPayload=} [properties] Properties to set
         */
        function BizAccountPayload(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizAccountPayload vnameCert.
         * @member {proto.IVerifiedNameCertificate|null|undefined} vnameCert
         * @memberof proto.BizAccountPayload
         * @instance
         */
        BizAccountPayload.prototype.vnameCert = null;

        /**
         * BizAccountPayload bizAcctLinkInfo.
         * @member {Uint8Array} bizAcctLinkInfo
         * @memberof proto.BizAccountPayload
         * @instance
         */
        BizAccountPayload.prototype.bizAcctLinkInfo = $util.newBuffer([]);

        /**
         * Creates a new BizAccountPayload instance using the specified properties.
         * @function create
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload=} [properties] Properties to set
         * @returns {proto.BizAccountPayload} BizAccountPayload instance
         */
        BizAccountPayload.create = function create(properties) {
            return new BizAccountPayload(properties);
        };

        /**
         * Encodes the specified BizAccountPayload message. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @function encode
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload} message BizAccountPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountPayload.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.vnameCert != null && Object.hasOwnProperty.call(message, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(message.vnameCert, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.bizAcctLinkInfo != null && Object.hasOwnProperty.call(message, "bizAcctLinkInfo"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.bizAcctLinkInfo);
            return writer;
        };

        /**
         * Encodes the specified BizAccountPayload message, length delimited. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload} message BizAccountPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountPayload.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizAccountPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizAccountPayload} BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountPayload.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizAccountPayload();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.vnameCert = $root.proto.VerifiedNameCertificate.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.bizAcctLinkInfo = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizAccountPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizAccountPayload} BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountPayload.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizAccountPayload message.
         * @function verify
         * @memberof proto.BizAccountPayload
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizAccountPayload.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert")) {
                var error = $root.proto.VerifiedNameCertificate.verify(message.vnameCert);
                if (error)
                    return "vnameCert." + error;
            }
            if (message.bizAcctLinkInfo != null && message.hasOwnProperty("bizAcctLinkInfo"))
                if (!(message.bizAcctLinkInfo && typeof message.bizAcctLinkInfo.length === "number" || $util.isString(message.bizAcctLinkInfo)))
                    return "bizAcctLinkInfo: buffer expected";
            return null;
        };

        /**
         * Creates a BizAccountPayload message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizAccountPayload
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizAccountPayload} BizAccountPayload
         */
        BizAccountPayload.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizAccountPayload)
                return object;
            var message = new $root.proto.BizAccountPayload();
            if (object.vnameCert != null) {
                if (typeof object.vnameCert !== "object")
                    throw TypeError(".proto.BizAccountPayload.vnameCert: object expected");
                message.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(object.vnameCert);
            }
            if (object.bizAcctLinkInfo != null)
                if (typeof object.bizAcctLinkInfo === "string")
                    $util.base64.decode(object.bizAcctLinkInfo, message.bizAcctLinkInfo = $util.newBuffer($util.base64.length(object.bizAcctLinkInfo)), 0);
                else if (object.bizAcctLinkInfo.length)
                    message.bizAcctLinkInfo = object.bizAcctLinkInfo;
            return message;
        };

        /**
         * Creates a plain object from a BizAccountPayload message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.BizAccountPayload} message BizAccountPayload
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizAccountPayload.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.vnameCert = null;
                if (options.bytes === String)
                    object.bizAcctLinkInfo = "";
                else {
                    object.bizAcctLinkInfo = [];
                    if (options.bytes !== Array)
                        object.bizAcctLinkInfo = $util.newBuffer(object.bizAcctLinkInfo);
                }
            }
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert"))
                object.vnameCert = $root.proto.VerifiedNameCertificate.toObject(message.vnameCert, options);
            if (message.bizAcctLinkInfo != null && message.hasOwnProperty("bizAcctLinkInfo"))
                object.bizAcctLinkInfo = options.bytes === String ? $util.base64.encode(message.bizAcctLinkInfo, 0, message.bizAcctLinkInfo.length) : options.bytes === Array ? Array.prototype.slice.call(message.bizAcctLinkInfo) : message.bizAcctLinkInfo;
            return object;
        };

        /**
         * Converts this BizAccountPayload to JSON.
         * @function toJSON
         * @memberof proto.BizAccountPayload
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizAccountPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return BizAccountPayload;
    })();

    proto.BizIdentityInfo = (function() {

        /**
         * Properties of a BizIdentityInfo.
         * @memberof proto
         * @interface IBizIdentityInfo
         * @property {proto.BizIdentityInfo.BizIdentityInfoVerifiedLevelValue|null} [vlevel] BizIdentityInfo vlevel
         * @property {proto.IVerifiedNameCertificate|null} [vnameCert] BizIdentityInfo vnameCert
         * @property {boolean|null} [signed] BizIdentityInfo signed
         * @property {boolean|null} [revoked] BizIdentityInfo revoked
         * @property {proto.BizIdentityInfo.BizIdentityInfoHostStorageType|null} [hostStorage] BizIdentityInfo hostStorage
         * @property {proto.BizIdentityInfo.BizIdentityInfoActualActorsType|null} [actualActors] BizIdentityInfo actualActors
         * @property {number|Long|null} [privacyModeTs] BizIdentityInfo privacyModeTs
         * @property {number|Long|null} [featureControls] BizIdentityInfo featureControls
         */

        /**
         * Constructs a new BizIdentityInfo.
         * @memberof proto
         * @classdesc Represents a BizIdentityInfo.
         * @implements IBizIdentityInfo
         * @constructor
         * @param {proto.IBizIdentityInfo=} [properties] Properties to set
         */
        function BizIdentityInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizIdentityInfo vlevel.
         * @member {proto.BizIdentityInfo.BizIdentityInfoVerifiedLevelValue} vlevel
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.vlevel = 0;

        /**
         * BizIdentityInfo vnameCert.
         * @member {proto.IVerifiedNameCertificate|null|undefined} vnameCert
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.vnameCert = null;

        /**
         * BizIdentityInfo signed.
         * @member {boolean} signed
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.signed = false;

        /**
         * BizIdentityInfo revoked.
         * @member {boolean} revoked
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.revoked = false;

        /**
         * BizIdentityInfo hostStorage.
         * @member {proto.BizIdentityInfo.BizIdentityInfoHostStorageType} hostStorage
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.hostStorage = 0;

        /**
         * BizIdentityInfo actualActors.
         * @member {proto.BizIdentityInfo.BizIdentityInfoActualActorsType} actualActors
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.actualActors = 0;

        /**
         * BizIdentityInfo privacyModeTs.
         * @member {number|Long} privacyModeTs
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.privacyModeTs = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * BizIdentityInfo featureControls.
         * @member {number|Long} featureControls
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.featureControls = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new BizIdentityInfo instance using the specified properties.
         * @function create
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo=} [properties] Properties to set
         * @returns {proto.BizIdentityInfo} BizIdentityInfo instance
         */
        BizIdentityInfo.create = function create(properties) {
            return new BizIdentityInfo(properties);
        };

        /**
         * Encodes the specified BizIdentityInfo message. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo} message BizIdentityInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizIdentityInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.vlevel != null && Object.hasOwnProperty.call(message, "vlevel"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.vlevel);
            if (message.vnameCert != null && Object.hasOwnProperty.call(message, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(message.vnameCert, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.signed != null && Object.hasOwnProperty.call(message, "signed"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.signed);
            if (message.revoked != null && Object.hasOwnProperty.call(message, "revoked"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.revoked);
            if (message.hostStorage != null && Object.hasOwnProperty.call(message, "hostStorage"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.hostStorage);
            if (message.actualActors != null && Object.hasOwnProperty.call(message, "actualActors"))
                writer.uint32(/* id 6, wireType 0 =*/48).int32(message.actualActors);
            if (message.privacyModeTs != null && Object.hasOwnProperty.call(message, "privacyModeTs"))
                writer.uint32(/* id 7, wireType 0 =*/56).uint64(message.privacyModeTs);
            if (message.featureControls != null && Object.hasOwnProperty.call(message, "featureControls"))
                writer.uint32(/* id 8, wireType 0 =*/64).uint64(message.featureControls);
            return writer;
        };

        /**
         * Encodes the specified BizIdentityInfo message, length delimited. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo} message BizIdentityInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizIdentityInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizIdentityInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizIdentityInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.vlevel = reader.int32();
                    break;
                case 2:
                    message.vnameCert = $root.proto.VerifiedNameCertificate.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.signed = reader.bool();
                    break;
                case 4:
                    message.revoked = reader.bool();
                    break;
                case 5:
                    message.hostStorage = reader.int32();
                    break;
                case 6:
                    message.actualActors = reader.int32();
                    break;
                case 7:
                    message.privacyModeTs = reader.uint64();
                    break;
                case 8:
                    message.featureControls = reader.uint64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizIdentityInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizIdentityInfo message.
         * @function verify
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizIdentityInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.vlevel != null && message.hasOwnProperty("vlevel"))
                switch (message.vlevel) {
                default:
                    return "vlevel: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert")) {
                var error = $root.proto.VerifiedNameCertificate.verify(message.vnameCert);
                if (error)
                    return "vnameCert." + error;
            }
            if (message.signed != null && message.hasOwnProperty("signed"))
                if (typeof message.signed !== "boolean")
                    return "signed: boolean expected";
            if (message.revoked != null && message.hasOwnProperty("revoked"))
                if (typeof message.revoked !== "boolean")
                    return "revoked: boolean expected";
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                switch (message.hostStorage) {
                default:
                    return "hostStorage: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.actualActors != null && message.hasOwnProperty("actualActors"))
                switch (message.actualActors) {
                default:
                    return "actualActors: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.privacyModeTs != null && message.hasOwnProperty("privacyModeTs"))
                if (!$util.isInteger(message.privacyModeTs) && !(message.privacyModeTs && $util.isInteger(message.privacyModeTs.low) && $util.isInteger(message.privacyModeTs.high)))
                    return "privacyModeTs: integer|Long expected";
            if (message.featureControls != null && message.hasOwnProperty("featureControls"))
                if (!$util.isInteger(message.featureControls) && !(message.featureControls && $util.isInteger(message.featureControls.low) && $util.isInteger(message.featureControls.high)))
                    return "featureControls: integer|Long expected";
            return null;
        };

        /**
         * Creates a BizIdentityInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         */
        BizIdentityInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizIdentityInfo)
                return object;
            var message = new $root.proto.BizIdentityInfo();
            switch (object.vlevel) {
            case "UNKNOWN":
            case 0:
                message.vlevel = 0;
                break;
            case "LOW":
            case 1:
                message.vlevel = 1;
                break;
            case "HIGH":
            case 2:
                message.vlevel = 2;
                break;
            }
            if (object.vnameCert != null) {
                if (typeof object.vnameCert !== "object")
                    throw TypeError(".proto.BizIdentityInfo.vnameCert: object expected");
                message.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(object.vnameCert);
            }
            if (object.signed != null)
                message.signed = Boolean(object.signed);
            if (object.revoked != null)
                message.revoked = Boolean(object.revoked);
            switch (object.hostStorage) {
            case "ON_PREMISE":
            case 0:
                message.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                message.hostStorage = 1;
                break;
            }
            switch (object.actualActors) {
            case "SELF":
            case 0:
                message.actualActors = 0;
                break;
            case "BSP":
            case 1:
                message.actualActors = 1;
                break;
            }
            if (object.privacyModeTs != null)
                if ($util.Long)
                    (message.privacyModeTs = $util.Long.fromValue(object.privacyModeTs)).unsigned = true;
                else if (typeof object.privacyModeTs === "string")
                    message.privacyModeTs = parseInt(object.privacyModeTs, 10);
                else if (typeof object.privacyModeTs === "number")
                    message.privacyModeTs = object.privacyModeTs;
                else if (typeof object.privacyModeTs === "object")
                    message.privacyModeTs = new $util.LongBits(object.privacyModeTs.low >>> 0, object.privacyModeTs.high >>> 0).toNumber(true);
            if (object.featureControls != null)
                if ($util.Long)
                    (message.featureControls = $util.Long.fromValue(object.featureControls)).unsigned = true;
                else if (typeof object.featureControls === "string")
                    message.featureControls = parseInt(object.featureControls, 10);
                else if (typeof object.featureControls === "number")
                    message.featureControls = object.featureControls;
                else if (typeof object.featureControls === "object")
                    message.featureControls = new $util.LongBits(object.featureControls.low >>> 0, object.featureControls.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a BizIdentityInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.BizIdentityInfo} message BizIdentityInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizIdentityInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.vlevel = options.enums === String ? "UNKNOWN" : 0;
                object.vnameCert = null;
                object.signed = false;
                object.revoked = false;
                object.hostStorage = options.enums === String ? "ON_PREMISE" : 0;
                object.actualActors = options.enums === String ? "SELF" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.privacyModeTs = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.privacyModeTs = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.featureControls = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.featureControls = options.longs === String ? "0" : 0;
            }
            if (message.vlevel != null && message.hasOwnProperty("vlevel"))
                object.vlevel = options.enums === String ? $root.proto.BizIdentityInfo.BizIdentityInfoVerifiedLevelValue[message.vlevel] : message.vlevel;
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert"))
                object.vnameCert = $root.proto.VerifiedNameCertificate.toObject(message.vnameCert, options);
            if (message.signed != null && message.hasOwnProperty("signed"))
                object.signed = message.signed;
            if (message.revoked != null && message.hasOwnProperty("revoked"))
                object.revoked = message.revoked;
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                object.hostStorage = options.enums === String ? $root.proto.BizIdentityInfo.BizIdentityInfoHostStorageType[message.hostStorage] : message.hostStorage;
            if (message.actualActors != null && message.hasOwnProperty("actualActors"))
                object.actualActors = options.enums === String ? $root.proto.BizIdentityInfo.BizIdentityInfoActualActorsType[message.actualActors] : message.actualActors;
            if (message.privacyModeTs != null && message.hasOwnProperty("privacyModeTs"))
                if (typeof message.privacyModeTs === "number")
                    object.privacyModeTs = options.longs === String ? String(message.privacyModeTs) : message.privacyModeTs;
                else
                    object.privacyModeTs = options.longs === String ? $util.Long.prototype.toString.call(message.privacyModeTs) : options.longs === Number ? new $util.LongBits(message.privacyModeTs.low >>> 0, message.privacyModeTs.high >>> 0).toNumber(true) : message.privacyModeTs;
            if (message.featureControls != null && message.hasOwnProperty("featureControls"))
                if (typeof message.featureControls === "number")
                    object.featureControls = options.longs === String ? String(message.featureControls) : message.featureControls;
                else
                    object.featureControls = options.longs === String ? $util.Long.prototype.toString.call(message.featureControls) : options.longs === Number ? new $util.LongBits(message.featureControls.low >>> 0, message.featureControls.high >>> 0).toNumber(true) : message.featureControls;
            return object;
        };

        /**
         * Converts this BizIdentityInfo to JSON.
         * @function toJSON
         * @memberof proto.BizIdentityInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizIdentityInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * BizIdentityInfoVerifiedLevelValue enum.
         * @name proto.BizIdentityInfo.BizIdentityInfoVerifiedLevelValue
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} LOW=1 LOW value
         * @property {number} HIGH=2 HIGH value
         */
        BizIdentityInfo.BizIdentityInfoVerifiedLevelValue = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "LOW"] = 1;
            values[valuesById[2] = "HIGH"] = 2;
            return values;
        })();

        /**
         * BizIdentityInfoHostStorageType enum.
         * @name proto.BizIdentityInfo.BizIdentityInfoHostStorageType
         * @enum {number}
         * @property {number} ON_PREMISE=0 ON_PREMISE value
         * @property {number} FACEBOOK=1 FACEBOOK value
         */
        BizIdentityInfo.BizIdentityInfoHostStorageType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        /**
         * BizIdentityInfoActualActorsType enum.
         * @name proto.BizIdentityInfo.BizIdentityInfoActualActorsType
         * @enum {number}
         * @property {number} SELF=0 SELF value
         * @property {number} BSP=1 BSP value
         */
        BizIdentityInfo.BizIdentityInfoActualActorsType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SELF"] = 0;
            values[valuesById[1] = "BSP"] = 1;
            return values;
        })();

        return BizIdentityInfo;
    })();

    proto.Button = (function() {

        /**
         * Properties of a Button.
         * @memberof proto
         * @interface IButton
         * @property {string|null} [buttonId] Button buttonId
         * @property {proto.IButtonText|null} [buttonText] Button buttonText
         * @property {proto.Button.ButtonType|null} [type] Button type
         * @property {proto.INativeFlowInfo|null} [nativeFlowInfo] Button nativeFlowInfo
         */

        /**
         * Constructs a new Button.
         * @memberof proto
         * @classdesc Represents a Button.
         * @implements IButton
         * @constructor
         * @param {proto.IButton=} [properties] Properties to set
         */
        function Button(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Button buttonId.
         * @member {string} buttonId
         * @memberof proto.Button
         * @instance
         */
        Button.prototype.buttonId = "";

        /**
         * Button buttonText.
         * @member {proto.IButtonText|null|undefined} buttonText
         * @memberof proto.Button
         * @instance
         */
        Button.prototype.buttonText = null;

        /**
         * Button type.
         * @member {proto.Button.ButtonType} type
         * @memberof proto.Button
         * @instance
         */
        Button.prototype.type = 0;

        /**
         * Button nativeFlowInfo.
         * @member {proto.INativeFlowInfo|null|undefined} nativeFlowInfo
         * @memberof proto.Button
         * @instance
         */
        Button.prototype.nativeFlowInfo = null;

        /**
         * Creates a new Button instance using the specified properties.
         * @function create
         * @memberof proto.Button
         * @static
         * @param {proto.IButton=} [properties] Properties to set
         * @returns {proto.Button} Button instance
         */
        Button.create = function create(properties) {
            return new Button(properties);
        };

        /**
         * Encodes the specified Button message. Does not implicitly {@link proto.Button.verify|verify} messages.
         * @function encode
         * @memberof proto.Button
         * @static
         * @param {proto.IButton} message Button message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Button.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.buttonId != null && Object.hasOwnProperty.call(message, "buttonId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.buttonId);
            if (message.buttonText != null && Object.hasOwnProperty.call(message, "buttonText"))
                $root.proto.ButtonText.encode(message.buttonText, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.type);
            if (message.nativeFlowInfo != null && Object.hasOwnProperty.call(message, "nativeFlowInfo"))
                $root.proto.NativeFlowInfo.encode(message.nativeFlowInfo, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified Button message, length delimited. Does not implicitly {@link proto.Button.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Button
         * @static
         * @param {proto.IButton} message Button message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Button.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Button message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Button
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Button} Button
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Button.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Button();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.buttonId = reader.string();
                    break;
                case 2:
                    message.buttonText = $root.proto.ButtonText.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.type = reader.int32();
                    break;
                case 4:
                    message.nativeFlowInfo = $root.proto.NativeFlowInfo.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Button message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Button
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Button} Button
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Button.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Button message.
         * @function verify
         * @memberof proto.Button
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Button.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.buttonId != null && message.hasOwnProperty("buttonId"))
                if (!$util.isString(message.buttonId))
                    return "buttonId: string expected";
            if (message.buttonText != null && message.hasOwnProperty("buttonText")) {
                var error = $root.proto.ButtonText.verify(message.buttonText);
                if (error)
                    return "buttonText." + error;
            }
            if (message.type != null && message.hasOwnProperty("type"))
                switch (message.type) {
                default:
                    return "type: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.nativeFlowInfo != null && message.hasOwnProperty("nativeFlowInfo")) {
                var error = $root.proto.NativeFlowInfo.verify(message.nativeFlowInfo);
                if (error)
                    return "nativeFlowInfo." + error;
            }
            return null;
        };

        /**
         * Creates a Button message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Button
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Button} Button
         */
        Button.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Button)
                return object;
            var message = new $root.proto.Button();
            if (object.buttonId != null)
                message.buttonId = String(object.buttonId);
            if (object.buttonText != null) {
                if (typeof object.buttonText !== "object")
                    throw TypeError(".proto.Button.buttonText: object expected");
                message.buttonText = $root.proto.ButtonText.fromObject(object.buttonText);
            }
            switch (object.type) {
            case "UNKNOWN":
            case 0:
                message.type = 0;
                break;
            case "RESPONSE":
            case 1:
                message.type = 1;
                break;
            case "NATIVE_FLOW":
            case 2:
                message.type = 2;
                break;
            }
            if (object.nativeFlowInfo != null) {
                if (typeof object.nativeFlowInfo !== "object")
                    throw TypeError(".proto.Button.nativeFlowInfo: object expected");
                message.nativeFlowInfo = $root.proto.NativeFlowInfo.fromObject(object.nativeFlowInfo);
            }
            return message;
        };

        /**
         * Creates a plain object from a Button message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Button
         * @static
         * @param {proto.Button} message Button
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Button.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.buttonId = "";
                object.buttonText = null;
                object.type = options.enums === String ? "UNKNOWN" : 0;
                object.nativeFlowInfo = null;
            }
            if (message.buttonId != null && message.hasOwnProperty("buttonId"))
                object.buttonId = message.buttonId;
            if (message.buttonText != null && message.hasOwnProperty("buttonText"))
                object.buttonText = $root.proto.ButtonText.toObject(message.buttonText, options);
            if (message.type != null && message.hasOwnProperty("type"))
                object.type = options.enums === String ? $root.proto.Button.ButtonType[message.type] : message.type;
            if (message.nativeFlowInfo != null && message.hasOwnProperty("nativeFlowInfo"))
                object.nativeFlowInfo = $root.proto.NativeFlowInfo.toObject(message.nativeFlowInfo, options);
            return object;
        };

        /**
         * Converts this Button to JSON.
         * @function toJSON
         * @memberof proto.Button
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Button.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ButtonType enum.
         * @name proto.Button.ButtonType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} RESPONSE=1 RESPONSE value
         * @property {number} NATIVE_FLOW=2 NATIVE_FLOW value
         */
        Button.ButtonType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "RESPONSE"] = 1;
            values[valuesById[2] = "NATIVE_FLOW"] = 2;
            return values;
        })();

        return Button;
    })();

    proto.ButtonText = (function() {

        /**
         * Properties of a ButtonText.
         * @memberof proto
         * @interface IButtonText
         * @property {string|null} [displayText] ButtonText displayText
         */

        /**
         * Constructs a new ButtonText.
         * @memberof proto
         * @classdesc Represents a ButtonText.
         * @implements IButtonText
         * @constructor
         * @param {proto.IButtonText=} [properties] Properties to set
         */
        function ButtonText(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ButtonText displayText.
         * @member {string} displayText
         * @memberof proto.ButtonText
         * @instance
         */
        ButtonText.prototype.displayText = "";

        /**
         * Creates a new ButtonText instance using the specified properties.
         * @function create
         * @memberof proto.ButtonText
         * @static
         * @param {proto.IButtonText=} [properties] Properties to set
         * @returns {proto.ButtonText} ButtonText instance
         */
        ButtonText.create = function create(properties) {
            return new ButtonText(properties);
        };

        /**
         * Encodes the specified ButtonText message. Does not implicitly {@link proto.ButtonText.verify|verify} messages.
         * @function encode
         * @memberof proto.ButtonText
         * @static
         * @param {proto.IButtonText} message ButtonText message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonText.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayText != null && Object.hasOwnProperty.call(message, "displayText"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayText);
            return writer;
        };

        /**
         * Encodes the specified ButtonText message, length delimited. Does not implicitly {@link proto.ButtonText.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ButtonText
         * @static
         * @param {proto.IButtonText} message ButtonText message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonText.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ButtonText message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ButtonText
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ButtonText} ButtonText
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonText.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ButtonText();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayText = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ButtonText message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ButtonText
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ButtonText} ButtonText
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonText.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ButtonText message.
         * @function verify
         * @memberof proto.ButtonText
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ButtonText.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                if (!$util.isString(message.displayText))
                    return "displayText: string expected";
            return null;
        };

        /**
         * Creates a ButtonText message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ButtonText
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ButtonText} ButtonText
         */
        ButtonText.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ButtonText)
                return object;
            var message = new $root.proto.ButtonText();
            if (object.displayText != null)
                message.displayText = String(object.displayText);
            return message;
        };

        /**
         * Creates a plain object from a ButtonText message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ButtonText
         * @static
         * @param {proto.ButtonText} message ButtonText
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ButtonText.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.displayText = "";
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                object.displayText = message.displayText;
            return object;
        };

        /**
         * Converts this ButtonText to JSON.
         * @function toJSON
         * @memberof proto.ButtonText
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ButtonText.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ButtonText;
    })();

    proto.ButtonsMessage = (function() {

        /**
         * Properties of a ButtonsMessage.
         * @memberof proto
         * @interface IButtonsMessage
         * @property {string|null} [contentText] ButtonsMessage contentText
         * @property {string|null} [footerText] ButtonsMessage footerText
         * @property {proto.IContextInfo|null} [contextInfo] ButtonsMessage contextInfo
         * @property {Array.<proto.IButton>|null} [buttons] ButtonsMessage buttons
         * @property {proto.ButtonsMessage.ButtonsMessageHeaderType|null} [headerType] ButtonsMessage headerType
         * @property {string|null} [text] ButtonsMessage text
         * @property {proto.IDocumentMessage|null} [documentMessage] ButtonsMessage documentMessage
         * @property {proto.IImageMessage|null} [imageMessage] ButtonsMessage imageMessage
         * @property {proto.IVideoMessage|null} [videoMessage] ButtonsMessage videoMessage
         * @property {proto.ILocationMessage|null} [locationMessage] ButtonsMessage locationMessage
         */

        /**
         * Constructs a new ButtonsMessage.
         * @memberof proto
         * @classdesc Represents a ButtonsMessage.
         * @implements IButtonsMessage
         * @constructor
         * @param {proto.IButtonsMessage=} [properties] Properties to set
         */
        function ButtonsMessage(properties) {
            this.buttons = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ButtonsMessage contentText.
         * @member {string} contentText
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.contentText = "";

        /**
         * ButtonsMessage footerText.
         * @member {string} footerText
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.footerText = "";

        /**
         * ButtonsMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.contextInfo = null;

        /**
         * ButtonsMessage buttons.
         * @member {Array.<proto.IButton>} buttons
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.buttons = $util.emptyArray;

        /**
         * ButtonsMessage headerType.
         * @member {proto.ButtonsMessage.ButtonsMessageHeaderType} headerType
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.headerType = 0;

        /**
         * ButtonsMessage text.
         * @member {string|null|undefined} text
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.text = null;

        /**
         * ButtonsMessage documentMessage.
         * @member {proto.IDocumentMessage|null|undefined} documentMessage
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.documentMessage = null;

        /**
         * ButtonsMessage imageMessage.
         * @member {proto.IImageMessage|null|undefined} imageMessage
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.imageMessage = null;

        /**
         * ButtonsMessage videoMessage.
         * @member {proto.IVideoMessage|null|undefined} videoMessage
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.videoMessage = null;

        /**
         * ButtonsMessage locationMessage.
         * @member {proto.ILocationMessage|null|undefined} locationMessage
         * @memberof proto.ButtonsMessage
         * @instance
         */
        ButtonsMessage.prototype.locationMessage = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * ButtonsMessage header.
         * @member {"text"|"documentMessage"|"imageMessage"|"videoMessage"|"locationMessage"|undefined} header
         * @memberof proto.ButtonsMessage
         * @instance
         */
        Object.defineProperty(ButtonsMessage.prototype, "header", {
            get: $util.oneOfGetter($oneOfFields = ["text", "documentMessage", "imageMessage", "videoMessage", "locationMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ButtonsMessage instance using the specified properties.
         * @function create
         * @memberof proto.ButtonsMessage
         * @static
         * @param {proto.IButtonsMessage=} [properties] Properties to set
         * @returns {proto.ButtonsMessage} ButtonsMessage instance
         */
        ButtonsMessage.create = function create(properties) {
            return new ButtonsMessage(properties);
        };

        /**
         * Encodes the specified ButtonsMessage message. Does not implicitly {@link proto.ButtonsMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ButtonsMessage
         * @static
         * @param {proto.IButtonsMessage} message ButtonsMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonsMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.text);
            if (message.documentMessage != null && Object.hasOwnProperty.call(message, "documentMessage"))
                $root.proto.DocumentMessage.encode(message.documentMessage, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.imageMessage != null && Object.hasOwnProperty.call(message, "imageMessage"))
                $root.proto.ImageMessage.encode(message.imageMessage, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.videoMessage != null && Object.hasOwnProperty.call(message, "videoMessage"))
                $root.proto.VideoMessage.encode(message.videoMessage, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.locationMessage != null && Object.hasOwnProperty.call(message, "locationMessage"))
                $root.proto.LocationMessage.encode(message.locationMessage, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.contentText != null && Object.hasOwnProperty.call(message, "contentText"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.contentText);
            if (message.footerText != null && Object.hasOwnProperty.call(message, "footerText"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.footerText);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            if (message.buttons != null && message.buttons.length)
                for (var i = 0; i < message.buttons.length; ++i)
                    $root.proto.Button.encode(message.buttons[i], writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
            if (message.headerType != null && Object.hasOwnProperty.call(message, "headerType"))
                writer.uint32(/* id 10, wireType 0 =*/80).int32(message.headerType);
            return writer;
        };

        /**
         * Encodes the specified ButtonsMessage message, length delimited. Does not implicitly {@link proto.ButtonsMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ButtonsMessage
         * @static
         * @param {proto.IButtonsMessage} message ButtonsMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonsMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ButtonsMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ButtonsMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ButtonsMessage} ButtonsMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonsMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ButtonsMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 6:
                    message.contentText = reader.string();
                    break;
                case 7:
                    message.footerText = reader.string();
                    break;
                case 8:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 9:
                    if (!(message.buttons && message.buttons.length))
                        message.buttons = [];
                    message.buttons.push($root.proto.Button.decode(reader, reader.uint32()));
                    break;
                case 10:
                    message.headerType = reader.int32();
                    break;
                case 1:
                    message.text = reader.string();
                    break;
                case 2:
                    message.documentMessage = $root.proto.DocumentMessage.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.imageMessage = $root.proto.ImageMessage.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.videoMessage = $root.proto.VideoMessage.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.locationMessage = $root.proto.LocationMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ButtonsMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ButtonsMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ButtonsMessage} ButtonsMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonsMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ButtonsMessage message.
         * @function verify
         * @memberof proto.ButtonsMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ButtonsMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.contentText != null && message.hasOwnProperty("contentText"))
                if (!$util.isString(message.contentText))
                    return "contentText: string expected";
            if (message.footerText != null && message.hasOwnProperty("footerText"))
                if (!$util.isString(message.footerText))
                    return "footerText: string expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.buttons != null && message.hasOwnProperty("buttons")) {
                if (!Array.isArray(message.buttons))
                    return "buttons: array expected";
                for (var i = 0; i < message.buttons.length; ++i) {
                    var error = $root.proto.Button.verify(message.buttons[i]);
                    if (error)
                        return "buttons." + error;
                }
            }
            if (message.headerType != null && message.hasOwnProperty("headerType"))
                switch (message.headerType) {
                default:
                    return "headerType: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                    break;
                }
            if (message.text != null && message.hasOwnProperty("text")) {
                properties.header = 1;
                if (!$util.isString(message.text))
                    return "text: string expected";
            }
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                if (properties.header === 1)
                    return "header: multiple values";
                properties.header = 1;
                {
                    var error = $root.proto.DocumentMessage.verify(message.documentMessage);
                    if (error)
                        return "documentMessage." + error;
                }
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                if (properties.header === 1)
                    return "header: multiple values";
                properties.header = 1;
                {
                    var error = $root.proto.ImageMessage.verify(message.imageMessage);
                    if (error)
                        return "imageMessage." + error;
                }
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                if (properties.header === 1)
                    return "header: multiple values";
                properties.header = 1;
                {
                    var error = $root.proto.VideoMessage.verify(message.videoMessage);
                    if (error)
                        return "videoMessage." + error;
                }
            }
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage")) {
                if (properties.header === 1)
                    return "header: multiple values";
                properties.header = 1;
                {
                    var error = $root.proto.LocationMessage.verify(message.locationMessage);
                    if (error)
                        return "locationMessage." + error;
                }
            }
            return null;
        };

        /**
         * Creates a ButtonsMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ButtonsMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ButtonsMessage} ButtonsMessage
         */
        ButtonsMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ButtonsMessage)
                return object;
            var message = new $root.proto.ButtonsMessage();
            if (object.contentText != null)
                message.contentText = String(object.contentText);
            if (object.footerText != null)
                message.footerText = String(object.footerText);
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ButtonsMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.buttons) {
                if (!Array.isArray(object.buttons))
                    throw TypeError(".proto.ButtonsMessage.buttons: array expected");
                message.buttons = [];
                for (var i = 0; i < object.buttons.length; ++i) {
                    if (typeof object.buttons[i] !== "object")
                        throw TypeError(".proto.ButtonsMessage.buttons: object expected");
                    message.buttons[i] = $root.proto.Button.fromObject(object.buttons[i]);
                }
            }
            switch (object.headerType) {
            case "UNKNOWN":
            case 0:
                message.headerType = 0;
                break;
            case "EMPTY":
            case 1:
                message.headerType = 1;
                break;
            case "TEXT":
            case 2:
                message.headerType = 2;
                break;
            case "DOCUMENT":
            case 3:
                message.headerType = 3;
                break;
            case "IMAGE":
            case 4:
                message.headerType = 4;
                break;
            case "VIDEO":
            case 5:
                message.headerType = 5;
                break;
            case "LOCATION":
            case 6:
                message.headerType = 6;
                break;
            }
            if (object.text != null)
                message.text = String(object.text);
            if (object.documentMessage != null) {
                if (typeof object.documentMessage !== "object")
                    throw TypeError(".proto.ButtonsMessage.documentMessage: object expected");
                message.documentMessage = $root.proto.DocumentMessage.fromObject(object.documentMessage);
            }
            if (object.imageMessage != null) {
                if (typeof object.imageMessage !== "object")
                    throw TypeError(".proto.ButtonsMessage.imageMessage: object expected");
                message.imageMessage = $root.proto.ImageMessage.fromObject(object.imageMessage);
            }
            if (object.videoMessage != null) {
                if (typeof object.videoMessage !== "object")
                    throw TypeError(".proto.ButtonsMessage.videoMessage: object expected");
                message.videoMessage = $root.proto.VideoMessage.fromObject(object.videoMessage);
            }
            if (object.locationMessage != null) {
                if (typeof object.locationMessage !== "object")
                    throw TypeError(".proto.ButtonsMessage.locationMessage: object expected");
                message.locationMessage = $root.proto.LocationMessage.fromObject(object.locationMessage);
            }
            return message;
        };

        /**
         * Creates a plain object from a ButtonsMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ButtonsMessage
         * @static
         * @param {proto.ButtonsMessage} message ButtonsMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ButtonsMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.buttons = [];
            if (options.defaults) {
                object.contentText = "";
                object.footerText = "";
                object.contextInfo = null;
                object.headerType = options.enums === String ? "UNKNOWN" : 0;
            }
            if (message.text != null && message.hasOwnProperty("text")) {
                object.text = message.text;
                if (options.oneofs)
                    object.header = "text";
            }
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                object.documentMessage = $root.proto.DocumentMessage.toObject(message.documentMessage, options);
                if (options.oneofs)
                    object.header = "documentMessage";
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                object.imageMessage = $root.proto.ImageMessage.toObject(message.imageMessage, options);
                if (options.oneofs)
                    object.header = "imageMessage";
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                object.videoMessage = $root.proto.VideoMessage.toObject(message.videoMessage, options);
                if (options.oneofs)
                    object.header = "videoMessage";
            }
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage")) {
                object.locationMessage = $root.proto.LocationMessage.toObject(message.locationMessage, options);
                if (options.oneofs)
                    object.header = "locationMessage";
            }
            if (message.contentText != null && message.hasOwnProperty("contentText"))
                object.contentText = message.contentText;
            if (message.footerText != null && message.hasOwnProperty("footerText"))
                object.footerText = message.footerText;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.buttons && message.buttons.length) {
                object.buttons = [];
                for (var j = 0; j < message.buttons.length; ++j)
                    object.buttons[j] = $root.proto.Button.toObject(message.buttons[j], options);
            }
            if (message.headerType != null && message.hasOwnProperty("headerType"))
                object.headerType = options.enums === String ? $root.proto.ButtonsMessage.ButtonsMessageHeaderType[message.headerType] : message.headerType;
            return object;
        };

        /**
         * Converts this ButtonsMessage to JSON.
         * @function toJSON
         * @memberof proto.ButtonsMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ButtonsMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ButtonsMessageHeaderType enum.
         * @name proto.ButtonsMessage.ButtonsMessageHeaderType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} EMPTY=1 EMPTY value
         * @property {number} TEXT=2 TEXT value
         * @property {number} DOCUMENT=3 DOCUMENT value
         * @property {number} IMAGE=4 IMAGE value
         * @property {number} VIDEO=5 VIDEO value
         * @property {number} LOCATION=6 LOCATION value
         */
        ButtonsMessage.ButtonsMessageHeaderType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "EMPTY"] = 1;
            values[valuesById[2] = "TEXT"] = 2;
            values[valuesById[3] = "DOCUMENT"] = 3;
            values[valuesById[4] = "IMAGE"] = 4;
            values[valuesById[5] = "VIDEO"] = 5;
            values[valuesById[6] = "LOCATION"] = 6;
            return values;
        })();

        return ButtonsMessage;
    })();

    proto.ButtonsResponseMessage = (function() {

        /**
         * Properties of a ButtonsResponseMessage.
         * @memberof proto
         * @interface IButtonsResponseMessage
         * @property {string|null} [selectedButtonId] ButtonsResponseMessage selectedButtonId
         * @property {proto.IContextInfo|null} [contextInfo] ButtonsResponseMessage contextInfo
         * @property {proto.ButtonsResponseMessage.ButtonsResponseMessageType|null} [type] ButtonsResponseMessage type
         * @property {string|null} [selectedDisplayText] ButtonsResponseMessage selectedDisplayText
         */

        /**
         * Constructs a new ButtonsResponseMessage.
         * @memberof proto
         * @classdesc Represents a ButtonsResponseMessage.
         * @implements IButtonsResponseMessage
         * @constructor
         * @param {proto.IButtonsResponseMessage=} [properties] Properties to set
         */
        function ButtonsResponseMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ButtonsResponseMessage selectedButtonId.
         * @member {string} selectedButtonId
         * @memberof proto.ButtonsResponseMessage
         * @instance
         */
        ButtonsResponseMessage.prototype.selectedButtonId = "";

        /**
         * ButtonsResponseMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ButtonsResponseMessage
         * @instance
         */
        ButtonsResponseMessage.prototype.contextInfo = null;

        /**
         * ButtonsResponseMessage type.
         * @member {proto.ButtonsResponseMessage.ButtonsResponseMessageType} type
         * @memberof proto.ButtonsResponseMessage
         * @instance
         */
        ButtonsResponseMessage.prototype.type = 0;

        /**
         * ButtonsResponseMessage selectedDisplayText.
         * @member {string|null|undefined} selectedDisplayText
         * @memberof proto.ButtonsResponseMessage
         * @instance
         */
        ButtonsResponseMessage.prototype.selectedDisplayText = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * ButtonsResponseMessage response.
         * @member {"selectedDisplayText"|undefined} response
         * @memberof proto.ButtonsResponseMessage
         * @instance
         */
        Object.defineProperty(ButtonsResponseMessage.prototype, "response", {
            get: $util.oneOfGetter($oneOfFields = ["selectedDisplayText"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new ButtonsResponseMessage instance using the specified properties.
         * @function create
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {proto.IButtonsResponseMessage=} [properties] Properties to set
         * @returns {proto.ButtonsResponseMessage} ButtonsResponseMessage instance
         */
        ButtonsResponseMessage.create = function create(properties) {
            return new ButtonsResponseMessage(properties);
        };

        /**
         * Encodes the specified ButtonsResponseMessage message. Does not implicitly {@link proto.ButtonsResponseMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {proto.IButtonsResponseMessage} message ButtonsResponseMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonsResponseMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.selectedButtonId != null && Object.hasOwnProperty.call(message, "selectedButtonId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.selectedButtonId);
            if (message.selectedDisplayText != null && Object.hasOwnProperty.call(message, "selectedDisplayText"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.selectedDisplayText);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.type);
            return writer;
        };

        /**
         * Encodes the specified ButtonsResponseMessage message, length delimited. Does not implicitly {@link proto.ButtonsResponseMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {proto.IButtonsResponseMessage} message ButtonsResponseMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ButtonsResponseMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ButtonsResponseMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ButtonsResponseMessage} ButtonsResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonsResponseMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ButtonsResponseMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.selectedButtonId = reader.string();
                    break;
                case 3:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.type = reader.int32();
                    break;
                case 2:
                    message.selectedDisplayText = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ButtonsResponseMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ButtonsResponseMessage} ButtonsResponseMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ButtonsResponseMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ButtonsResponseMessage message.
         * @function verify
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ButtonsResponseMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.selectedButtonId != null && message.hasOwnProperty("selectedButtonId"))
                if (!$util.isString(message.selectedButtonId))
                    return "selectedButtonId: string expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.type != null && message.hasOwnProperty("type"))
                switch (message.type) {
                default:
                    return "type: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.selectedDisplayText != null && message.hasOwnProperty("selectedDisplayText")) {
                properties.response = 1;
                if (!$util.isString(message.selectedDisplayText))
                    return "selectedDisplayText: string expected";
            }
            return null;
        };

        /**
         * Creates a ButtonsResponseMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ButtonsResponseMessage} ButtonsResponseMessage
         */
        ButtonsResponseMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ButtonsResponseMessage)
                return object;
            var message = new $root.proto.ButtonsResponseMessage();
            if (object.selectedButtonId != null)
                message.selectedButtonId = String(object.selectedButtonId);
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ButtonsResponseMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            switch (object.type) {
            case "UNKNOWN":
            case 0:
                message.type = 0;
                break;
            case "DISPLAY_TEXT":
            case 1:
                message.type = 1;
                break;
            }
            if (object.selectedDisplayText != null)
                message.selectedDisplayText = String(object.selectedDisplayText);
            return message;
        };

        /**
         * Creates a plain object from a ButtonsResponseMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ButtonsResponseMessage
         * @static
         * @param {proto.ButtonsResponseMessage} message ButtonsResponseMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ButtonsResponseMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.selectedButtonId = "";
                object.contextInfo = null;
                object.type = options.enums === String ? "UNKNOWN" : 0;
            }
            if (message.selectedButtonId != null && message.hasOwnProperty("selectedButtonId"))
                object.selectedButtonId = message.selectedButtonId;
            if (message.selectedDisplayText != null && message.hasOwnProperty("selectedDisplayText")) {
                object.selectedDisplayText = message.selectedDisplayText;
                if (options.oneofs)
                    object.response = "selectedDisplayText";
            }
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.type != null && message.hasOwnProperty("type"))
                object.type = options.enums === String ? $root.proto.ButtonsResponseMessage.ButtonsResponseMessageType[message.type] : message.type;
            return object;
        };

        /**
         * Converts this ButtonsResponseMessage to JSON.
         * @function toJSON
         * @memberof proto.ButtonsResponseMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ButtonsResponseMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ButtonsResponseMessageType enum.
         * @name proto.ButtonsResponseMessage.ButtonsResponseMessageType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} DISPLAY_TEXT=1 DISPLAY_TEXT value
         */
        ButtonsResponseMessage.ButtonsResponseMessageType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "DISPLAY_TEXT"] = 1;
            return values;
        })();

        return ButtonsResponseMessage;
    })();

    proto.Call = (function() {

        /**
         * Properties of a Call.
         * @memberof proto
         * @interface ICall
         * @property {Uint8Array|null} [callKey] Call callKey
         * @property {string|null} [conversionSource] Call conversionSource
         * @property {Uint8Array|null} [conversionData] Call conversionData
         * @property {number|null} [conversionDelaySeconds] Call conversionDelaySeconds
         */

        /**
         * Constructs a new Call.
         * @memberof proto
         * @classdesc Represents a Call.
         * @implements ICall
         * @constructor
         * @param {proto.ICall=} [properties] Properties to set
         */
        function Call(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Call callKey.
         * @member {Uint8Array} callKey
         * @memberof proto.Call
         * @instance
         */
        Call.prototype.callKey = $util.newBuffer([]);

        /**
         * Call conversionSource.
         * @member {string} conversionSource
         * @memberof proto.Call
         * @instance
         */
        Call.prototype.conversionSource = "";

        /**
         * Call conversionData.
         * @member {Uint8Array} conversionData
         * @memberof proto.Call
         * @instance
         */
        Call.prototype.conversionData = $util.newBuffer([]);

        /**
         * Call conversionDelaySeconds.
         * @member {number} conversionDelaySeconds
         * @memberof proto.Call
         * @instance
         */
        Call.prototype.conversionDelaySeconds = 0;

        /**
         * Creates a new Call instance using the specified properties.
         * @function create
         * @memberof proto.Call
         * @static
         * @param {proto.ICall=} [properties] Properties to set
         * @returns {proto.Call} Call instance
         */
        Call.create = function create(properties) {
            return new Call(properties);
        };

        /**
         * Encodes the specified Call message. Does not implicitly {@link proto.Call.verify|verify} messages.
         * @function encode
         * @memberof proto.Call
         * @static
         * @param {proto.ICall} message Call message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Call.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.callKey != null && Object.hasOwnProperty.call(message, "callKey"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.callKey);
            if (message.conversionSource != null && Object.hasOwnProperty.call(message, "conversionSource"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.conversionSource);
            if (message.conversionData != null && Object.hasOwnProperty.call(message, "conversionData"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.conversionData);
            if (message.conversionDelaySeconds != null && Object.hasOwnProperty.call(message, "conversionDelaySeconds"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.conversionDelaySeconds);
            return writer;
        };

        /**
         * Encodes the specified Call message, length delimited. Does not implicitly {@link proto.Call.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Call
         * @static
         * @param {proto.ICall} message Call message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Call.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Call message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Call
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Call} Call
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Call.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Call();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.callKey = reader.bytes();
                    break;
                case 2:
                    message.conversionSource = reader.string();
                    break;
                case 3:
                    message.conversionData = reader.bytes();
                    break;
                case 4:
                    message.conversionDelaySeconds = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Call message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Call
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Call} Call
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Call.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Call message.
         * @function verify
         * @memberof proto.Call
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Call.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.callKey != null && message.hasOwnProperty("callKey"))
                if (!(message.callKey && typeof message.callKey.length === "number" || $util.isString(message.callKey)))
                    return "callKey: buffer expected";
            if (message.conversionSource != null && message.hasOwnProperty("conversionSource"))
                if (!$util.isString(message.conversionSource))
                    return "conversionSource: string expected";
            if (message.conversionData != null && message.hasOwnProperty("conversionData"))
                if (!(message.conversionData && typeof message.conversionData.length === "number" || $util.isString(message.conversionData)))
                    return "conversionData: buffer expected";
            if (message.conversionDelaySeconds != null && message.hasOwnProperty("conversionDelaySeconds"))
                if (!$util.isInteger(message.conversionDelaySeconds))
                    return "conversionDelaySeconds: integer expected";
            return null;
        };

        /**
         * Creates a Call message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Call
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Call} Call
         */
        Call.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Call)
                return object;
            var message = new $root.proto.Call();
            if (object.callKey != null)
                if (typeof object.callKey === "string")
                    $util.base64.decode(object.callKey, message.callKey = $util.newBuffer($util.base64.length(object.callKey)), 0);
                else if (object.callKey.length)
                    message.callKey = object.callKey;
            if (object.conversionSource != null)
                message.conversionSource = String(object.conversionSource);
            if (object.conversionData != null)
                if (typeof object.conversionData === "string")
                    $util.base64.decode(object.conversionData, message.conversionData = $util.newBuffer($util.base64.length(object.conversionData)), 0);
                else if (object.conversionData.length)
                    message.conversionData = object.conversionData;
            if (object.conversionDelaySeconds != null)
                message.conversionDelaySeconds = object.conversionDelaySeconds >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a Call message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Call
         * @static
         * @param {proto.Call} message Call
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Call.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.callKey = "";
                else {
                    object.callKey = [];
                    if (options.bytes !== Array)
                        object.callKey = $util.newBuffer(object.callKey);
                }
                object.conversionSource = "";
                if (options.bytes === String)
                    object.conversionData = "";
                else {
                    object.conversionData = [];
                    if (options.bytes !== Array)
                        object.conversionData = $util.newBuffer(object.conversionData);
                }
                object.conversionDelaySeconds = 0;
            }
            if (message.callKey != null && message.hasOwnProperty("callKey"))
                object.callKey = options.bytes === String ? $util.base64.encode(message.callKey, 0, message.callKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.callKey) : message.callKey;
            if (message.conversionSource != null && message.hasOwnProperty("conversionSource"))
                object.conversionSource = message.conversionSource;
            if (message.conversionData != null && message.hasOwnProperty("conversionData"))
                object.conversionData = options.bytes === String ? $util.base64.encode(message.conversionData, 0, message.conversionData.length) : options.bytes === Array ? Array.prototype.slice.call(message.conversionData) : message.conversionData;
            if (message.conversionDelaySeconds != null && message.hasOwnProperty("conversionDelaySeconds"))
                object.conversionDelaySeconds = message.conversionDelaySeconds;
            return object;
        };

        /**
         * Converts this Call to JSON.
         * @function toJSON
         * @memberof proto.Call
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Call.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Call;
    })();

    proto.CallButton = (function() {

        /**
         * Properties of a CallButton.
         * @memberof proto
         * @interface ICallButton
         * @property {proto.IHighlyStructuredMessage|null} [displayText] CallButton displayText
         * @property {proto.IHighlyStructuredMessage|null} [phoneNumber] CallButton phoneNumber
         */

        /**
         * Constructs a new CallButton.
         * @memberof proto
         * @classdesc Represents a CallButton.
         * @implements ICallButton
         * @constructor
         * @param {proto.ICallButton=} [properties] Properties to set
         */
        function CallButton(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CallButton displayText.
         * @member {proto.IHighlyStructuredMessage|null|undefined} displayText
         * @memberof proto.CallButton
         * @instance
         */
        CallButton.prototype.displayText = null;

        /**
         * CallButton phoneNumber.
         * @member {proto.IHighlyStructuredMessage|null|undefined} phoneNumber
         * @memberof proto.CallButton
         * @instance
         */
        CallButton.prototype.phoneNumber = null;

        /**
         * Creates a new CallButton instance using the specified properties.
         * @function create
         * @memberof proto.CallButton
         * @static
         * @param {proto.ICallButton=} [properties] Properties to set
         * @returns {proto.CallButton} CallButton instance
         */
        CallButton.create = function create(properties) {
            return new CallButton(properties);
        };

        /**
         * Encodes the specified CallButton message. Does not implicitly {@link proto.CallButton.verify|verify} messages.
         * @function encode
         * @memberof proto.CallButton
         * @static
         * @param {proto.ICallButton} message CallButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CallButton.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayText != null && Object.hasOwnProperty.call(message, "displayText"))
                $root.proto.HighlyStructuredMessage.encode(message.displayText, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.phoneNumber != null && Object.hasOwnProperty.call(message, "phoneNumber"))
                $root.proto.HighlyStructuredMessage.encode(message.phoneNumber, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified CallButton message, length delimited. Does not implicitly {@link proto.CallButton.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CallButton
         * @static
         * @param {proto.ICallButton} message CallButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CallButton.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CallButton message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CallButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CallButton} CallButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CallButton.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CallButton();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayText = $root.proto.HighlyStructuredMessage.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.phoneNumber = $root.proto.HighlyStructuredMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CallButton message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CallButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CallButton} CallButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CallButton.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CallButton message.
         * @function verify
         * @memberof proto.CallButton
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CallButton.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayText != null && message.hasOwnProperty("displayText")) {
                var error = $root.proto.HighlyStructuredMessage.verify(message.displayText);
                if (error)
                    return "displayText." + error;
            }
            if (message.phoneNumber != null && message.hasOwnProperty("phoneNumber")) {
                var error = $root.proto.HighlyStructuredMessage.verify(message.phoneNumber);
                if (error)
                    return "phoneNumber." + error;
            }
            return null;
        };

        /**
         * Creates a CallButton message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CallButton
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CallButton} CallButton
         */
        CallButton.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CallButton)
                return object;
            var message = new $root.proto.CallButton();
            if (object.displayText != null) {
                if (typeof object.displayText !== "object")
                    throw TypeError(".proto.CallButton.displayText: object expected");
                message.displayText = $root.proto.HighlyStructuredMessage.fromObject(object.displayText);
            }
            if (object.phoneNumber != null) {
                if (typeof object.phoneNumber !== "object")
                    throw TypeError(".proto.CallButton.phoneNumber: object expected");
                message.phoneNumber = $root.proto.HighlyStructuredMessage.fromObject(object.phoneNumber);
            }
            return message;
        };

        /**
         * Creates a plain object from a CallButton message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CallButton
         * @static
         * @param {proto.CallButton} message CallButton
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CallButton.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.displayText = null;
                object.phoneNumber = null;
            }
            if (message.displayText != null && message.hasOwnProperty("displayText"))
                object.displayText = $root.proto.HighlyStructuredMessage.toObject(message.displayText, options);
            if (message.phoneNumber != null && message.hasOwnProperty("phoneNumber"))
                object.phoneNumber = $root.proto.HighlyStructuredMessage.toObject(message.phoneNumber, options);
            return object;
        };

        /**
         * Converts this CallButton to JSON.
         * @function toJSON
         * @memberof proto.CallButton
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CallButton.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CallButton;
    })();

    proto.CancelPaymentRequestMessage = (function() {

        /**
         * Properties of a CancelPaymentRequestMessage.
         * @memberof proto
         * @interface ICancelPaymentRequestMessage
         * @property {proto.IMessageKey|null} [key] CancelPaymentRequestMessage key
         */

        /**
         * Constructs a new CancelPaymentRequestMessage.
         * @memberof proto
         * @classdesc Represents a CancelPaymentRequestMessage.
         * @implements ICancelPaymentRequestMessage
         * @constructor
         * @param {proto.ICancelPaymentRequestMessage=} [properties] Properties to set
         */
        function CancelPaymentRequestMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CancelPaymentRequestMessage key.
         * @member {proto.IMessageKey|null|undefined} key
         * @memberof proto.CancelPaymentRequestMessage
         * @instance
         */
        CancelPaymentRequestMessage.prototype.key = null;

        /**
         * Creates a new CancelPaymentRequestMessage instance using the specified properties.
         * @function create
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {proto.ICancelPaymentRequestMessage=} [properties] Properties to set
         * @returns {proto.CancelPaymentRequestMessage} CancelPaymentRequestMessage instance
         */
        CancelPaymentRequestMessage.create = function create(properties) {
            return new CancelPaymentRequestMessage(properties);
        };

        /**
         * Encodes the specified CancelPaymentRequestMessage message. Does not implicitly {@link proto.CancelPaymentRequestMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {proto.ICancelPaymentRequestMessage} message CancelPaymentRequestMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CancelPaymentRequestMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                $root.proto.MessageKey.encode(message.key, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified CancelPaymentRequestMessage message, length delimited. Does not implicitly {@link proto.CancelPaymentRequestMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {proto.ICancelPaymentRequestMessage} message CancelPaymentRequestMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CancelPaymentRequestMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CancelPaymentRequestMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CancelPaymentRequestMessage} CancelPaymentRequestMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CancelPaymentRequestMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CancelPaymentRequestMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.key = $root.proto.MessageKey.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CancelPaymentRequestMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CancelPaymentRequestMessage} CancelPaymentRequestMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CancelPaymentRequestMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CancelPaymentRequestMessage message.
         * @function verify
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CancelPaymentRequestMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.key != null && message.hasOwnProperty("key")) {
                var error = $root.proto.MessageKey.verify(message.key);
                if (error)
                    return "key." + error;
            }
            return null;
        };

        /**
         * Creates a CancelPaymentRequestMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CancelPaymentRequestMessage} CancelPaymentRequestMessage
         */
        CancelPaymentRequestMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CancelPaymentRequestMessage)
                return object;
            var message = new $root.proto.CancelPaymentRequestMessage();
            if (object.key != null) {
                if (typeof object.key !== "object")
                    throw TypeError(".proto.CancelPaymentRequestMessage.key: object expected");
                message.key = $root.proto.MessageKey.fromObject(object.key);
            }
            return message;
        };

        /**
         * Creates a plain object from a CancelPaymentRequestMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CancelPaymentRequestMessage
         * @static
         * @param {proto.CancelPaymentRequestMessage} message CancelPaymentRequestMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CancelPaymentRequestMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.key = null;
            if (message.key != null && message.hasOwnProperty("key"))
                object.key = $root.proto.MessageKey.toObject(message.key, options);
            return object;
        };

        /**
         * Converts this CancelPaymentRequestMessage to JSON.
         * @function toJSON
         * @memberof proto.CancelPaymentRequestMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CancelPaymentRequestMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CancelPaymentRequestMessage;
    })();

    proto.CatalogSnapshot = (function() {

        /**
         * Properties of a CatalogSnapshot.
         * @memberof proto
         * @interface ICatalogSnapshot
         * @property {proto.IImageMessage|null} [catalogImage] CatalogSnapshot catalogImage
         * @property {string|null} [title] CatalogSnapshot title
         * @property {string|null} [description] CatalogSnapshot description
         */

        /**
         * Constructs a new CatalogSnapshot.
         * @memberof proto
         * @classdesc Represents a CatalogSnapshot.
         * @implements ICatalogSnapshot
         * @constructor
         * @param {proto.ICatalogSnapshot=} [properties] Properties to set
         */
        function CatalogSnapshot(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CatalogSnapshot catalogImage.
         * @member {proto.IImageMessage|null|undefined} catalogImage
         * @memberof proto.CatalogSnapshot
         * @instance
         */
        CatalogSnapshot.prototype.catalogImage = null;

        /**
         * CatalogSnapshot title.
         * @member {string} title
         * @memberof proto.CatalogSnapshot
         * @instance
         */
        CatalogSnapshot.prototype.title = "";

        /**
         * CatalogSnapshot description.
         * @member {string} description
         * @memberof proto.CatalogSnapshot
         * @instance
         */
        CatalogSnapshot.prototype.description = "";

        /**
         * Creates a new CatalogSnapshot instance using the specified properties.
         * @function create
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {proto.ICatalogSnapshot=} [properties] Properties to set
         * @returns {proto.CatalogSnapshot} CatalogSnapshot instance
         */
        CatalogSnapshot.create = function create(properties) {
            return new CatalogSnapshot(properties);
        };

        /**
         * Encodes the specified CatalogSnapshot message. Does not implicitly {@link proto.CatalogSnapshot.verify|verify} messages.
         * @function encode
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {proto.ICatalogSnapshot} message CatalogSnapshot message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CatalogSnapshot.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.catalogImage != null && Object.hasOwnProperty.call(message, "catalogImage"))
                $root.proto.ImageMessage.encode(message.catalogImage, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.title);
            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.description);
            return writer;
        };

        /**
         * Encodes the specified CatalogSnapshot message, length delimited. Does not implicitly {@link proto.CatalogSnapshot.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {proto.ICatalogSnapshot} message CatalogSnapshot message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CatalogSnapshot.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CatalogSnapshot message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CatalogSnapshot} CatalogSnapshot
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CatalogSnapshot.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CatalogSnapshot();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.catalogImage = $root.proto.ImageMessage.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.title = reader.string();
                    break;
                case 3:
                    message.description = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CatalogSnapshot message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CatalogSnapshot} CatalogSnapshot
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CatalogSnapshot.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CatalogSnapshot message.
         * @function verify
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CatalogSnapshot.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.catalogImage != null && message.hasOwnProperty("catalogImage")) {
                var error = $root.proto.ImageMessage.verify(message.catalogImage);
                if (error)
                    return "catalogImage." + error;
            }
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.description != null && message.hasOwnProperty("description"))
                if (!$util.isString(message.description))
                    return "description: string expected";
            return null;
        };

        /**
         * Creates a CatalogSnapshot message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CatalogSnapshot} CatalogSnapshot
         */
        CatalogSnapshot.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CatalogSnapshot)
                return object;
            var message = new $root.proto.CatalogSnapshot();
            if (object.catalogImage != null) {
                if (typeof object.catalogImage !== "object")
                    throw TypeError(".proto.CatalogSnapshot.catalogImage: object expected");
                message.catalogImage = $root.proto.ImageMessage.fromObject(object.catalogImage);
            }
            if (object.title != null)
                message.title = String(object.title);
            if (object.description != null)
                message.description = String(object.description);
            return message;
        };

        /**
         * Creates a plain object from a CatalogSnapshot message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CatalogSnapshot
         * @static
         * @param {proto.CatalogSnapshot} message CatalogSnapshot
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CatalogSnapshot.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.catalogImage = null;
                object.title = "";
                object.description = "";
            }
            if (message.catalogImage != null && message.hasOwnProperty("catalogImage"))
                object.catalogImage = $root.proto.ImageMessage.toObject(message.catalogImage, options);
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.description != null && message.hasOwnProperty("description"))
                object.description = message.description;
            return object;
        };

        /**
         * Converts this CatalogSnapshot to JSON.
         * @function toJSON
         * @memberof proto.CatalogSnapshot
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CatalogSnapshot.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CatalogSnapshot;
    })();

    proto.CertChain = (function() {

        /**
         * Properties of a CertChain.
         * @memberof proto
         * @interface ICertChain
         * @property {proto.ICertChainNoiseCertificate|null} [leaf] CertChain leaf
         * @property {proto.ICertChainNoiseCertificate|null} [intermediate] CertChain intermediate
         */

        /**
         * Constructs a new CertChain.
         * @memberof proto
         * @classdesc Represents a CertChain.
         * @implements ICertChain
         * @constructor
         * @param {proto.ICertChain=} [properties] Properties to set
         */
        function CertChain(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CertChain leaf.
         * @member {proto.ICertChainNoiseCertificate|null|undefined} leaf
         * @memberof proto.CertChain
         * @instance
         */
        CertChain.prototype.leaf = null;

        /**
         * CertChain intermediate.
         * @member {proto.ICertChainNoiseCertificate|null|undefined} intermediate
         * @memberof proto.CertChain
         * @instance
         */
        CertChain.prototype.intermediate = null;

        /**
         * Creates a new CertChain instance using the specified properties.
         * @function create
         * @memberof proto.CertChain
         * @static
         * @param {proto.ICertChain=} [properties] Properties to set
         * @returns {proto.CertChain} CertChain instance
         */
        CertChain.create = function create(properties) {
            return new CertChain(properties);
        };

        /**
         * Encodes the specified CertChain message. Does not implicitly {@link proto.CertChain.verify|verify} messages.
         * @function encode
         * @memberof proto.CertChain
         * @static
         * @param {proto.ICertChain} message CertChain message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CertChain.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.leaf != null && Object.hasOwnProperty.call(message, "leaf"))
                $root.proto.CertChainNoiseCertificate.encode(message.leaf, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.intermediate != null && Object.hasOwnProperty.call(message, "intermediate"))
                $root.proto.CertChainNoiseCertificate.encode(message.intermediate, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified CertChain message, length delimited. Does not implicitly {@link proto.CertChain.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CertChain
         * @static
         * @param {proto.ICertChain} message CertChain message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CertChain.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CertChain message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CertChain
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CertChain} CertChain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CertChain.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CertChain();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.leaf = $root.proto.CertChainNoiseCertificate.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.intermediate = $root.proto.CertChainNoiseCertificate.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CertChain message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CertChain
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CertChain} CertChain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CertChain.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CertChain message.
         * @function verify
         * @memberof proto.CertChain
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CertChain.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.leaf != null && message.hasOwnProperty("leaf")) {
                var error = $root.proto.CertChainNoiseCertificate.verify(message.leaf);
                if (error)
                    return "leaf." + error;
            }
            if (message.intermediate != null && message.hasOwnProperty("intermediate")) {
                var error = $root.proto.CertChainNoiseCertificate.verify(message.intermediate);
                if (error)
                    return "intermediate." + error;
            }
            return null;
        };

        /**
         * Creates a CertChain message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CertChain
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CertChain} CertChain
         */
        CertChain.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CertChain)
                return object;
            var message = new $root.proto.CertChain();
            if (object.leaf != null) {
                if (typeof object.leaf !== "object")
                    throw TypeError(".proto.CertChain.leaf: object expected");
                message.leaf = $root.proto.CertChainNoiseCertificate.fromObject(object.leaf);
            }
            if (object.intermediate != null) {
                if (typeof object.intermediate !== "object")
                    throw TypeError(".proto.CertChain.intermediate: object expected");
                message.intermediate = $root.proto.CertChainNoiseCertificate.fromObject(object.intermediate);
            }
            return message;
        };

        /**
         * Creates a plain object from a CertChain message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CertChain
         * @static
         * @param {proto.CertChain} message CertChain
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CertChain.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.leaf = null;
                object.intermediate = null;
            }
            if (message.leaf != null && message.hasOwnProperty("leaf"))
                object.leaf = $root.proto.CertChainNoiseCertificate.toObject(message.leaf, options);
            if (message.intermediate != null && message.hasOwnProperty("intermediate"))
                object.intermediate = $root.proto.CertChainNoiseCertificate.toObject(message.intermediate, options);
            return object;
        };

        /**
         * Converts this CertChain to JSON.
         * @function toJSON
         * @memberof proto.CertChain
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CertChain.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CertChain;
    })();

    proto.CertChainNoiseCertificate = (function() {

        /**
         * Properties of a CertChainNoiseCertificate.
         * @memberof proto
         * @interface ICertChainNoiseCertificate
         * @property {Uint8Array|null} [details] CertChainNoiseCertificate details
         * @property {Uint8Array|null} [signature] CertChainNoiseCertificate signature
         */

        /**
         * Constructs a new CertChainNoiseCertificate.
         * @memberof proto
         * @classdesc Represents a CertChainNoiseCertificate.
         * @implements ICertChainNoiseCertificate
         * @constructor
         * @param {proto.ICertChainNoiseCertificate=} [properties] Properties to set
         */
        function CertChainNoiseCertificate(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CertChainNoiseCertificate details.
         * @member {Uint8Array} details
         * @memberof proto.CertChainNoiseCertificate
         * @instance
         */
        CertChainNoiseCertificate.prototype.details = $util.newBuffer([]);

        /**
         * CertChainNoiseCertificate signature.
         * @member {Uint8Array} signature
         * @memberof proto.CertChainNoiseCertificate
         * @instance
         */
        CertChainNoiseCertificate.prototype.signature = $util.newBuffer([]);

        /**
         * Creates a new CertChainNoiseCertificate instance using the specified properties.
         * @function create
         * @memberof proto.CertChainNoiseCertificate
         * @static
         * @param {proto.ICertChainNoiseCertificate=} [properties] Properties to set
         * @returns {proto.CertChainNoiseCertificate} CertChainNoiseCertificate instance
         */
        CertChainNoiseCertificate.create = function create(properties) {
            return new CertChainNoiseCertificate(properties);
        };

        /**
         * Encodes the specified CertChainNoiseCertificate message. Does not implicitly {@link proto.CertChainNoiseCertificate.verify|verify} messages.
         * @function encode
         * @memberof proto.CertChainNoiseCertificate
         * @static
         * @param {proto.ICertChainNoiseCertificate} message CertChainNoiseCertificate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CertChainNoiseCertificate.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.signature != null && Object.hasOwnProperty.call(message, "signature"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.signature);
            return writer;
        };

        /**
         * Encodes the specified CertChainNoiseCertificate message, length delimited. Does not implicitly {@link proto.CertChainNoiseCertificate.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CertChainNoiseCertificate
         * @static
         * @param {proto.ICertChainNoiseCertificate} message CertChainNoiseCertificate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CertChainNoiseCertificate.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CertChainNoiseCertificate message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CertChainNoiseCertificate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CertChainNoiseCertificate} CertChainNoiseCertificate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CertChainNoiseCertificate.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CertChainNoiseCertificate();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.signature = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CertChainNoiseCertificate message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CertChainNoiseCertificate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CertChainNoiseCertificate} CertChainNoiseCertificate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CertChainNoiseCertificate.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CertChainNoiseCertificate message.
         * @function verify
         * @memberof proto.CertChainNoiseCertificate
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CertChainNoiseCertificate.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.signature != null && message.hasOwnProperty("signature"))
                if (!(message.signature && typeof message.signature.length === "number" || $util.isString(message.signature)))
                    return "signature: buffer expected";
            return null;
        };

        /**
         * Creates a CertChainNoiseCertificate message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CertChainNoiseCertificate
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CertChainNoiseCertificate} CertChainNoiseCertificate
         */
        CertChainNoiseCertificate.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CertChainNoiseCertificate)
                return object;
            var message = new $root.proto.CertChainNoiseCertificate();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.signature != null)
                if (typeof object.signature === "string")
                    $util.base64.decode(object.signature, message.signature = $util.newBuffer($util.base64.length(object.signature)), 0);
                else if (object.signature.length)
                    message.signature = object.signature;
            return message;
        };

        /**
         * Creates a plain object from a CertChainNoiseCertificate message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CertChainNoiseCertificate
         * @static
         * @param {proto.CertChainNoiseCertificate} message CertChainNoiseCertificate
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CertChainNoiseCertificate.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.signature = "";
                else {
                    object.signature = [];
                    if (options.bytes !== Array)
                        object.signature = $util.newBuffer(object.signature);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.signature != null && message.hasOwnProperty("signature"))
                object.signature = options.bytes === String ? $util.base64.encode(message.signature, 0, message.signature.length) : options.bytes === Array ? Array.prototype.slice.call(message.signature) : message.signature;
            return object;
        };

        /**
         * Converts this CertChainNoiseCertificate to JSON.
         * @function toJSON
         * @memberof proto.CertChainNoiseCertificate
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CertChainNoiseCertificate.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CertChainNoiseCertificate;
    })();

    proto.CertChainNoiseCertificateDetails = (function() {

        /**
         * Properties of a CertChainNoiseCertificateDetails.
         * @memberof proto
         * @interface ICertChainNoiseCertificateDetails
         * @property {number|null} [serial] CertChainNoiseCertificateDetails serial
         * @property {number|null} [issuerSerial] CertChainNoiseCertificateDetails issuerSerial
         * @property {Uint8Array|null} [key] CertChainNoiseCertificateDetails key
         * @property {number|Long|null} [notBefore] CertChainNoiseCertificateDetails notBefore
         * @property {number|Long|null} [notAfter] CertChainNoiseCertificateDetails notAfter
         */

        /**
         * Constructs a new CertChainNoiseCertificateDetails.
         * @memberof proto
         * @classdesc Represents a CertChainNoiseCertificateDetails.
         * @implements ICertChainNoiseCertificateDetails
         * @constructor
         * @param {proto.ICertChainNoiseCertificateDetails=} [properties] Properties to set
         */
        function CertChainNoiseCertificateDetails(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CertChainNoiseCertificateDetails serial.
         * @member {number} serial
         * @memberof proto.CertChainNoiseCertificateDetails
         * @instance
         */
        CertChainNoiseCertificateDetails.prototype.serial = 0;

        /**
         * CertChainNoiseCertificateDetails issuerSerial.
         * @member {number} issuerSerial
         * @memberof proto.CertChainNoiseCertificateDetails
         * @instance
         */
        CertChainNoiseCertificateDetails.prototype.issuerSerial = 0;

        /**
         * CertChainNoiseCertificateDetails key.
         * @member {Uint8Array} key
         * @memberof proto.CertChainNoiseCertificateDetails
         * @instance
         */
        CertChainNoiseCertificateDetails.prototype.key = $util.newBuffer([]);

        /**
         * CertChainNoiseCertificateDetails notBefore.
         * @member {number|Long} notBefore
         * @memberof proto.CertChainNoiseCertificateDetails
         * @instance
         */
        CertChainNoiseCertificateDetails.prototype.notBefore = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * CertChainNoiseCertificateDetails notAfter.
         * @member {number|Long} notAfter
         * @memberof proto.CertChainNoiseCertificateDetails
         * @instance
         */
        CertChainNoiseCertificateDetails.prototype.notAfter = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new CertChainNoiseCertificateDetails instance using the specified properties.
         * @function create
         * @memberof proto.CertChainNoiseCertificateDetails
         * @static
         * @param {proto.ICertChainNoiseCertificateDetails=} [properties] Properties to set
         * @returns {proto.CertChainNoiseCertificateDetails} CertChainNoiseCertificateDetails instance
         */
        CertChainNoiseCertificateDetails.create = function create(properties) {
            return new CertChainNoiseCertificateDetails(properties);
        };

        /**
         * Encodes the specified CertChainNoiseCertificateDetails message. Does not implicitly {@link proto.CertChainNoiseCertificateDetails.verify|verify} messages.
         * @function encode
         * @memberof proto.CertChainNoiseCertificateDetails
         * @static
         * @param {proto.ICertChainNoiseCertificateDetails} message CertChainNoiseCertificateDetails message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CertChainNoiseCertificateDetails.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.serial != null && Object.hasOwnProperty.call(message, "serial"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.serial);
            if (message.issuerSerial != null && Object.hasOwnProperty.call(message, "issuerSerial"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.issuerSerial);
            if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.key);
            if (message.notBefore != null && Object.hasOwnProperty.call(message, "notBefore"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint64(message.notBefore);
            if (message.notAfter != null && Object.hasOwnProperty.call(message, "notAfter"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint64(message.notAfter);
            return writer;
        };

        /**
         * Encodes the specified CertChainNoiseCertificateDetails message, length delimited. Does not implicitly {@link proto.CertChainNoiseCertificateDetails.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CertChainNoiseCertificateDetails
         * @static
         * @param {proto.ICertChainNoiseCertificateDetails} message CertChainNoiseCertificateDetails message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CertChainNoiseCertificateDetails.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CertChainNoiseCertificateDetails message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CertChainNoiseCertificateDetails
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CertChainNoiseCertificateDetails} CertChainNoiseCertificateDetails
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CertChainNoiseCertificateDetails.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CertChainNoiseCertificateDetails();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.serial = reader.uint32();
                    break;
                case 2:
                    message.issuerSerial = reader.uint32();
                    break;
                case 3:
                    message.key = reader.bytes();
                    break;
                case 4:
                    message.notBefore = reader.uint64();
                    break;
                case 5:
                    message.notAfter = reader.uint64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CertChainNoiseCertificateDetails message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CertChainNoiseCertificateDetails
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CertChainNoiseCertificateDetails} CertChainNoiseCertificateDetails
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CertChainNoiseCertificateDetails.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CertChainNoiseCertificateDetails message.
         * @function verify
         * @memberof proto.CertChainNoiseCertificateDetails
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CertChainNoiseCertificateDetails.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.serial != null && message.hasOwnProperty("serial"))
                if (!$util.isInteger(message.serial))
                    return "serial: integer expected";
            if (message.issuerSerial != null && message.hasOwnProperty("issuerSerial"))
                if (!$util.isInteger(message.issuerSerial))
                    return "issuerSerial: integer expected";
            if (message.key != null && message.hasOwnProperty("key"))
                if (!(message.key && typeof message.key.length === "number" || $util.isString(message.key)))
                    return "key: buffer expected";
            if (message.notBefore != null && message.hasOwnProperty("notBefore"))
                if (!$util.isInteger(message.notBefore) && !(message.notBefore && $util.isInteger(message.notBefore.low) && $util.isInteger(message.notBefore.high)))
                    return "notBefore: integer|Long expected";
            if (message.notAfter != null && message.hasOwnProperty("notAfter"))
                if (!$util.isInteger(message.notAfter) && !(message.notAfter && $util.isInteger(message.notAfter.low) && $util.isInteger(message.notAfter.high)))
                    return "notAfter: integer|Long expected";
            return null;
        };

        /**
         * Creates a CertChainNoiseCertificateDetails message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CertChainNoiseCertificateDetails
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CertChainNoiseCertificateDetails} CertChainNoiseCertificateDetails
         */
        CertChainNoiseCertificateDetails.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CertChainNoiseCertificateDetails)
                return object;
            var message = new $root.proto.CertChainNoiseCertificateDetails();
            if (object.serial != null)
                message.serial = object.serial >>> 0;
            if (object.issuerSerial != null)
                message.issuerSerial = object.issuerSerial >>> 0;
            if (object.key != null)
                if (typeof object.key === "string")
                    $util.base64.decode(object.key, message.key = $util.newBuffer($util.base64.length(object.key)), 0);
                else if (object.key.length)
                    message.key = object.key;
            if (object.notBefore != null)
                if ($util.Long)
                    (message.notBefore = $util.Long.fromValue(object.notBefore)).unsigned = true;
                else if (typeof object.notBefore === "string")
                    message.notBefore = parseInt(object.notBefore, 10);
                else if (typeof object.notBefore === "number")
                    message.notBefore = object.notBefore;
                else if (typeof object.notBefore === "object")
                    message.notBefore = new $util.LongBits(object.notBefore.low >>> 0, object.notBefore.high >>> 0).toNumber(true);
            if (object.notAfter != null)
                if ($util.Long)
                    (message.notAfter = $util.Long.fromValue(object.notAfter)).unsigned = true;
                else if (typeof object.notAfter === "string")
                    message.notAfter = parseInt(object.notAfter, 10);
                else if (typeof object.notAfter === "number")
                    message.notAfter = object.notAfter;
                else if (typeof object.notAfter === "object")
                    message.notAfter = new $util.LongBits(object.notAfter.low >>> 0, object.notAfter.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a CertChainNoiseCertificateDetails message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CertChainNoiseCertificateDetails
         * @static
         * @param {proto.CertChainNoiseCertificateDetails} message CertChainNoiseCertificateDetails
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CertChainNoiseCertificateDetails.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.serial = 0;
                object.issuerSerial = 0;
                if (options.bytes === String)
                    object.key = "";
                else {
                    object.key = [];
                    if (options.bytes !== Array)
                        object.key = $util.newBuffer(object.key);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.notBefore = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.notBefore = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.notAfter = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.notAfter = options.longs === String ? "0" : 0;
            }
            if (message.serial != null && message.hasOwnProperty("serial"))
                object.serial = message.serial;
            if (message.issuerSerial != null && message.hasOwnProperty("issuerSerial"))
                object.issuerSerial = message.issuerSerial;
            if (message.key != null && message.hasOwnProperty("key"))
                object.key = options.bytes === String ? $util.base64.encode(message.key, 0, message.key.length) : options.bytes === Array ? Array.prototype.slice.call(message.key) : message.key;
            if (message.notBefore != null && message.hasOwnProperty("notBefore"))
                if (typeof message.notBefore === "number")
                    object.notBefore = options.longs === String ? String(message.notBefore) : message.notBefore;
                else
                    object.notBefore = options.longs === String ? $util.Long.prototype.toString.call(message.notBefore) : options.longs === Number ? new $util.LongBits(message.notBefore.low >>> 0, message.notBefore.high >>> 0).toNumber(true) : message.notBefore;
            if (message.notAfter != null && message.hasOwnProperty("notAfter"))
                if (typeof message.notAfter === "number")
                    object.notAfter = options.longs === String ? String(message.notAfter) : message.notAfter;
                else
                    object.notAfter = options.longs === String ? $util.Long.prototype.toString.call(message.notAfter) : options.longs === Number ? new $util.LongBits(message.notAfter.low >>> 0, message.notAfter.high >>> 0).toNumber(true) : message.notAfter;
            return object;
        };

        /**
         * Converts this CertChainNoiseCertificateDetails to JSON.
         * @function toJSON
         * @memberof proto.CertChainNoiseCertificateDetails
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CertChainNoiseCertificateDetails.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CertChainNoiseCertificateDetails;
    })();

    proto.Chain = (function() {

        /**
         * Properties of a Chain.
         * @memberof proto
         * @interface IChain
         * @property {Uint8Array|null} [senderRatchetKey] Chain senderRatchetKey
         * @property {Uint8Array|null} [senderRatchetKeyPrivate] Chain senderRatchetKeyPrivate
         * @property {proto.IChainKey|null} [chainKey] Chain chainKey
         * @property {Array.<proto.IMessageKey>|null} [messageKeys] Chain messageKeys
         */

        /**
         * Constructs a new Chain.
         * @memberof proto
         * @classdesc Represents a Chain.
         * @implements IChain
         * @constructor
         * @param {proto.IChain=} [properties] Properties to set
         */
        function Chain(properties) {
            this.messageKeys = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Chain senderRatchetKey.
         * @member {Uint8Array} senderRatchetKey
         * @memberof proto.Chain
         * @instance
         */
        Chain.prototype.senderRatchetKey = $util.newBuffer([]);

        /**
         * Chain senderRatchetKeyPrivate.
         * @member {Uint8Array} senderRatchetKeyPrivate
         * @memberof proto.Chain
         * @instance
         */
        Chain.prototype.senderRatchetKeyPrivate = $util.newBuffer([]);

        /**
         * Chain chainKey.
         * @member {proto.IChainKey|null|undefined} chainKey
         * @memberof proto.Chain
         * @instance
         */
        Chain.prototype.chainKey = null;

        /**
         * Chain messageKeys.
         * @member {Array.<proto.IMessageKey>} messageKeys
         * @memberof proto.Chain
         * @instance
         */
        Chain.prototype.messageKeys = $util.emptyArray;

        /**
         * Creates a new Chain instance using the specified properties.
         * @function create
         * @memberof proto.Chain
         * @static
         * @param {proto.IChain=} [properties] Properties to set
         * @returns {proto.Chain} Chain instance
         */
        Chain.create = function create(properties) {
            return new Chain(properties);
        };

        /**
         * Encodes the specified Chain message. Does not implicitly {@link proto.Chain.verify|verify} messages.
         * @function encode
         * @memberof proto.Chain
         * @static
         * @param {proto.IChain} message Chain message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Chain.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.senderRatchetKey != null && Object.hasOwnProperty.call(message, "senderRatchetKey"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.senderRatchetKey);
            if (message.senderRatchetKeyPrivate != null && Object.hasOwnProperty.call(message, "senderRatchetKeyPrivate"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.senderRatchetKeyPrivate);
            if (message.chainKey != null && Object.hasOwnProperty.call(message, "chainKey"))
                $root.proto.ChainKey.encode(message.chainKey, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.messageKeys != null && message.messageKeys.length)
                for (var i = 0; i < message.messageKeys.length; ++i)
                    $root.proto.MessageKey.encode(message.messageKeys[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified Chain message, length delimited. Does not implicitly {@link proto.Chain.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Chain
         * @static
         * @param {proto.IChain} message Chain message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Chain.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Chain message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Chain
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Chain} Chain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Chain.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Chain();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.senderRatchetKey = reader.bytes();
                    break;
                case 2:
                    message.senderRatchetKeyPrivate = reader.bytes();
                    break;
                case 3:
                    message.chainKey = $root.proto.ChainKey.decode(reader, reader.uint32());
                    break;
                case 4:
                    if (!(message.messageKeys && message.messageKeys.length))
                        message.messageKeys = [];
                    message.messageKeys.push($root.proto.MessageKey.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Chain message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Chain
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Chain} Chain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Chain.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Chain message.
         * @function verify
         * @memberof proto.Chain
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Chain.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.senderRatchetKey != null && message.hasOwnProperty("senderRatchetKey"))
                if (!(message.senderRatchetKey && typeof message.senderRatchetKey.length === "number" || $util.isString(message.senderRatchetKey)))
                    return "senderRatchetKey: buffer expected";
            if (message.senderRatchetKeyPrivate != null && message.hasOwnProperty("senderRatchetKeyPrivate"))
                if (!(message.senderRatchetKeyPrivate && typeof message.senderRatchetKeyPrivate.length === "number" || $util.isString(message.senderRatchetKeyPrivate)))
                    return "senderRatchetKeyPrivate: buffer expected";
            if (message.chainKey != null && message.hasOwnProperty("chainKey")) {
                var error = $root.proto.ChainKey.verify(message.chainKey);
                if (error)
                    return "chainKey." + error;
            }
            if (message.messageKeys != null && message.hasOwnProperty("messageKeys")) {
                if (!Array.isArray(message.messageKeys))
                    return "messageKeys: array expected";
                for (var i = 0; i < message.messageKeys.length; ++i) {
                    var error = $root.proto.MessageKey.verify(message.messageKeys[i]);
                    if (error)
                        return "messageKeys." + error;
                }
            }
            return null;
        };

        /**
         * Creates a Chain message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Chain
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Chain} Chain
         */
        Chain.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Chain)
                return object;
            var message = new $root.proto.Chain();
            if (object.senderRatchetKey != null)
                if (typeof object.senderRatchetKey === "string")
                    $util.base64.decode(object.senderRatchetKey, message.senderRatchetKey = $util.newBuffer($util.base64.length(object.senderRatchetKey)), 0);
                else if (object.senderRatchetKey.length)
                    message.senderRatchetKey = object.senderRatchetKey;
            if (object.senderRatchetKeyPrivate != null)
                if (typeof object.senderRatchetKeyPrivate === "string")
                    $util.base64.decode(object.senderRatchetKeyPrivate, message.senderRatchetKeyPrivate = $util.newBuffer($util.base64.length(object.senderRatchetKeyPrivate)), 0);
                else if (object.senderRatchetKeyPrivate.length)
                    message.senderRatchetKeyPrivate = object.senderRatchetKeyPrivate;
            if (object.chainKey != null) {
                if (typeof object.chainKey !== "object")
                    throw TypeError(".proto.Chain.chainKey: object expected");
                message.chainKey = $root.proto.ChainKey.fromObject(object.chainKey);
            }
            if (object.messageKeys) {
                if (!Array.isArray(object.messageKeys))
                    throw TypeError(".proto.Chain.messageKeys: array expected");
                message.messageKeys = [];
                for (var i = 0; i < object.messageKeys.length; ++i) {
                    if (typeof object.messageKeys[i] !== "object")
                        throw TypeError(".proto.Chain.messageKeys: object expected");
                    message.messageKeys[i] = $root.proto.MessageKey.fromObject(object.messageKeys[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a Chain message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Chain
         * @static
         * @param {proto.Chain} message Chain
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Chain.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.messageKeys = [];
            if (options.defaults) {
                if (options.bytes === String)
                    object.senderRatchetKey = "";
                else {
                    object.senderRatchetKey = [];
                    if (options.bytes !== Array)
                        object.senderRatchetKey = $util.newBuffer(object.senderRatchetKey);
                }
                if (options.bytes === String)
                    object.senderRatchetKeyPrivate = "";
                else {
                    object.senderRatchetKeyPrivate = [];
                    if (options.bytes !== Array)
                        object.senderRatchetKeyPrivate = $util.newBuffer(object.senderRatchetKeyPrivate);
                }
                object.chainKey = null;
            }
            if (message.senderRatchetKey != null && message.hasOwnProperty("senderRatchetKey"))
                object.senderRatchetKey = options.bytes === String ? $util.base64.encode(message.senderRatchetKey, 0, message.senderRatchetKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.senderRatchetKey) : message.senderRatchetKey;
            if (message.senderRatchetKeyPrivate != null && message.hasOwnProperty("senderRatchetKeyPrivate"))
                object.senderRatchetKeyPrivate = options.bytes === String ? $util.base64.encode(message.senderRatchetKeyPrivate, 0, message.senderRatchetKeyPrivate.length) : options.bytes === Array ? Array.prototype.slice.call(message.senderRatchetKeyPrivate) : message.senderRatchetKeyPrivate;
            if (message.chainKey != null && message.hasOwnProperty("chainKey"))
                object.chainKey = $root.proto.ChainKey.toObject(message.chainKey, options);
            if (message.messageKeys && message.messageKeys.length) {
                object.messageKeys = [];
                for (var j = 0; j < message.messageKeys.length; ++j)
                    object.messageKeys[j] = $root.proto.MessageKey.toObject(message.messageKeys[j], options);
            }
            return object;
        };

        /**
         * Converts this Chain to JSON.
         * @function toJSON
         * @memberof proto.Chain
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Chain.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Chain;
    })();

    proto.ChainKey = (function() {

        /**
         * Properties of a ChainKey.
         * @memberof proto
         * @interface IChainKey
         * @property {number|null} [index] ChainKey index
         * @property {Uint8Array|null} [key] ChainKey key
         */

        /**
         * Constructs a new ChainKey.
         * @memberof proto
         * @classdesc Represents a ChainKey.
         * @implements IChainKey
         * @constructor
         * @param {proto.IChainKey=} [properties] Properties to set
         */
        function ChainKey(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ChainKey index.
         * @member {number} index
         * @memberof proto.ChainKey
         * @instance
         */
        ChainKey.prototype.index = 0;

        /**
         * ChainKey key.
         * @member {Uint8Array} key
         * @memberof proto.ChainKey
         * @instance
         */
        ChainKey.prototype.key = $util.newBuffer([]);

        /**
         * Creates a new ChainKey instance using the specified properties.
         * @function create
         * @memberof proto.ChainKey
         * @static
         * @param {proto.IChainKey=} [properties] Properties to set
         * @returns {proto.ChainKey} ChainKey instance
         */
        ChainKey.create = function create(properties) {
            return new ChainKey(properties);
        };

        /**
         * Encodes the specified ChainKey message. Does not implicitly {@link proto.ChainKey.verify|verify} messages.
         * @function encode
         * @memberof proto.ChainKey
         * @static
         * @param {proto.IChainKey} message ChainKey message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ChainKey.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && Object.hasOwnProperty.call(message, "index"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.index);
            if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.key);
            return writer;
        };

        /**
         * Encodes the specified ChainKey message, length delimited. Does not implicitly {@link proto.ChainKey.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ChainKey
         * @static
         * @param {proto.IChainKey} message ChainKey message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ChainKey.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ChainKey message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ChainKey
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ChainKey} ChainKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ChainKey.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ChainKey();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.uint32();
                    break;
                case 2:
                    message.key = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ChainKey message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ChainKey
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ChainKey} ChainKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ChainKey.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ChainKey message.
         * @function verify
         * @memberof proto.ChainKey
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ChainKey.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            if (message.key != null && message.hasOwnProperty("key"))
                if (!(message.key && typeof message.key.length === "number" || $util.isString(message.key)))
                    return "key: buffer expected";
            return null;
        };

        /**
         * Creates a ChainKey message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ChainKey
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ChainKey} ChainKey
         */
        ChainKey.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ChainKey)
                return object;
            var message = new $root.proto.ChainKey();
            if (object.index != null)
                message.index = object.index >>> 0;
            if (object.key != null)
                if (typeof object.key === "string")
                    $util.base64.decode(object.key, message.key = $util.newBuffer($util.base64.length(object.key)), 0);
                else if (object.key.length)
                    message.key = object.key;
            return message;
        };

        /**
         * Creates a plain object from a ChainKey message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ChainKey
         * @static
         * @param {proto.ChainKey} message ChainKey
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ChainKey.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.index = 0;
                if (options.bytes === String)
                    object.key = "";
                else {
                    object.key = [];
                    if (options.bytes !== Array)
                        object.key = $util.newBuffer(object.key);
                }
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.key != null && message.hasOwnProperty("key"))
                object.key = options.bytes === String ? $util.base64.encode(message.key, 0, message.key.length) : options.bytes === Array ? Array.prototype.slice.call(message.key) : message.key;
            return object;
        };

        /**
         * Converts this ChainKey to JSON.
         * @function toJSON
         * @memberof proto.ChainKey
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ChainKey.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ChainKey;
    })();

    proto.Chat = (function() {

        /**
         * Properties of a Chat.
         * @memberof proto
         * @interface IChat
         * @property {string|null} [displayName] Chat displayName
         * @property {string|null} [id] Chat id
         */

        /**
         * Constructs a new Chat.
         * @memberof proto
         * @classdesc Represents a Chat.
         * @implements IChat
         * @constructor
         * @param {proto.IChat=} [properties] Properties to set
         */
        function Chat(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Chat displayName.
         * @member {string} displayName
         * @memberof proto.Chat
         * @instance
         */
        Chat.prototype.displayName = "";

        /**
         * Chat id.
         * @member {string} id
         * @memberof proto.Chat
         * @instance
         */
        Chat.prototype.id = "";

        /**
         * Creates a new Chat instance using the specified properties.
         * @function create
         * @memberof proto.Chat
         * @static
         * @param {proto.IChat=} [properties] Properties to set
         * @returns {proto.Chat} Chat instance
         */
        Chat.create = function create(properties) {
            return new Chat(properties);
        };

        /**
         * Encodes the specified Chat message. Does not implicitly {@link proto.Chat.verify|verify} messages.
         * @function encode
         * @memberof proto.Chat
         * @static
         * @param {proto.IChat} message Chat message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Chat.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayName);
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.id);
            return writer;
        };

        /**
         * Encodes the specified Chat message, length delimited. Does not implicitly {@link proto.Chat.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Chat
         * @static
         * @param {proto.IChat} message Chat message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Chat.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Chat message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Chat
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Chat} Chat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Chat.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Chat();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayName = reader.string();
                    break;
                case 2:
                    message.id = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Chat message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Chat
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Chat} Chat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Chat.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Chat message.
         * @function verify
         * @memberof proto.Chat
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Chat.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                if (!$util.isString(message.displayName))
                    return "displayName: string expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            return null;
        };

        /**
         * Creates a Chat message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Chat
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Chat} Chat
         */
        Chat.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Chat)
                return object;
            var message = new $root.proto.Chat();
            if (object.displayName != null)
                message.displayName = String(object.displayName);
            if (object.id != null)
                message.id = String(object.id);
            return message;
        };

        /**
         * Creates a plain object from a Chat message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Chat
         * @static
         * @param {proto.Chat} message Chat
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Chat.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.displayName = "";
                object.id = "";
            }
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                object.displayName = message.displayName;
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            return object;
        };

        /**
         * Converts this Chat to JSON.
         * @function toJSON
         * @memberof proto.Chat
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Chat.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Chat;
    })();

    proto.ClearChatAction = (function() {

        /**
         * Properties of a ClearChatAction.
         * @memberof proto
         * @interface IClearChatAction
         * @property {proto.ISyncActionMessageRange|null} [messageRange] ClearChatAction messageRange
         */

        /**
         * Constructs a new ClearChatAction.
         * @memberof proto
         * @classdesc Represents a ClearChatAction.
         * @implements IClearChatAction
         * @constructor
         * @param {proto.IClearChatAction=} [properties] Properties to set
         */
        function ClearChatAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ClearChatAction messageRange.
         * @member {proto.ISyncActionMessageRange|null|undefined} messageRange
         * @memberof proto.ClearChatAction
         * @instance
         */
        ClearChatAction.prototype.messageRange = null;

        /**
         * Creates a new ClearChatAction instance using the specified properties.
         * @function create
         * @memberof proto.ClearChatAction
         * @static
         * @param {proto.IClearChatAction=} [properties] Properties to set
         * @returns {proto.ClearChatAction} ClearChatAction instance
         */
        ClearChatAction.create = function create(properties) {
            return new ClearChatAction(properties);
        };

        /**
         * Encodes the specified ClearChatAction message. Does not implicitly {@link proto.ClearChatAction.verify|verify} messages.
         * @function encode
         * @memberof proto.ClearChatAction
         * @static
         * @param {proto.IClearChatAction} message ClearChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClearChatAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.messageRange != null && Object.hasOwnProperty.call(message, "messageRange"))
                $root.proto.SyncActionMessageRange.encode(message.messageRange, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified ClearChatAction message, length delimited. Does not implicitly {@link proto.ClearChatAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ClearChatAction
         * @static
         * @param {proto.IClearChatAction} message ClearChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClearChatAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClearChatAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ClearChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ClearChatAction} ClearChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClearChatAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClearChatAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.messageRange = $root.proto.SyncActionMessageRange.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ClearChatAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ClearChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ClearChatAction} ClearChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClearChatAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClearChatAction message.
         * @function verify
         * @memberof proto.ClearChatAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClearChatAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.messageRange != null && message.hasOwnProperty("messageRange")) {
                var error = $root.proto.SyncActionMessageRange.verify(message.messageRange);
                if (error)
                    return "messageRange." + error;
            }
            return null;
        };

        /**
         * Creates a ClearChatAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ClearChatAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ClearChatAction} ClearChatAction
         */
        ClearChatAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ClearChatAction)
                return object;
            var message = new $root.proto.ClearChatAction();
            if (object.messageRange != null) {
                if (typeof object.messageRange !== "object")
                    throw TypeError(".proto.ClearChatAction.messageRange: object expected");
                message.messageRange = $root.proto.SyncActionMessageRange.fromObject(object.messageRange);
            }
            return message;
        };

        /**
         * Creates a plain object from a ClearChatAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ClearChatAction
         * @static
         * @param {proto.ClearChatAction} message ClearChatAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClearChatAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.messageRange = null;
            if (message.messageRange != null && message.hasOwnProperty("messageRange"))
                object.messageRange = $root.proto.SyncActionMessageRange.toObject(message.messageRange, options);
            return object;
        };

        /**
         * Converts this ClearChatAction to JSON.
         * @function toJSON
         * @memberof proto.ClearChatAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClearChatAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ClearChatAction;
    })();

    proto.ClientFinish = (function() {

        /**
         * Properties of a ClientFinish.
         * @memberof proto
         * @interface IClientFinish
         * @property {Uint8Array|null} ["static"] ClientFinish static
         * @property {Uint8Array|null} [payload] ClientFinish payload
         */

        /**
         * Constructs a new ClientFinish.
         * @memberof proto
         * @classdesc Represents a ClientFinish.
         * @implements IClientFinish
         * @constructor
         * @param {proto.IClientFinish=} [properties] Properties to set
         */
        function ClientFinish(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ClientFinish static.
         * @member {Uint8Array} static
         * @memberof proto.ClientFinish
         * @instance
         */
        ClientFinish.prototype["static"] = $util.newBuffer([]);

        /**
         * ClientFinish payload.
         * @member {Uint8Array} payload
         * @memberof proto.ClientFinish
         * @instance
         */
        ClientFinish.prototype.payload = $util.newBuffer([]);

        /**
         * Creates a new ClientFinish instance using the specified properties.
         * @function create
         * @memberof proto.ClientFinish
         * @static
         * @param {proto.IClientFinish=} [properties] Properties to set
         * @returns {proto.ClientFinish} ClientFinish instance
         */
        ClientFinish.create = function create(properties) {
            return new ClientFinish(properties);
        };

        /**
         * Encodes the specified ClientFinish message. Does not implicitly {@link proto.ClientFinish.verify|verify} messages.
         * @function encode
         * @memberof proto.ClientFinish
         * @static
         * @param {proto.IClientFinish} message ClientFinish message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientFinish.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message["static"] != null && Object.hasOwnProperty.call(message, "static"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message["static"]);
            if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.payload);
            return writer;
        };

        /**
         * Encodes the specified ClientFinish message, length delimited. Does not implicitly {@link proto.ClientFinish.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ClientFinish
         * @static
         * @param {proto.IClientFinish} message ClientFinish message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientFinish.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClientFinish message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ClientFinish
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ClientFinish} ClientFinish
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientFinish.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientFinish();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message["static"] = reader.bytes();
                    break;
                case 2:
                    message.payload = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ClientFinish message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ClientFinish
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ClientFinish} ClientFinish
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientFinish.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClientFinish message.
         * @function verify
         * @memberof proto.ClientFinish
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClientFinish.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message["static"] != null && message.hasOwnProperty("static"))
                if (!(message["static"] && typeof message["static"].length === "number" || $util.isString(message["static"])))
                    return "static: buffer expected";
            if (message.payload != null && message.hasOwnProperty("payload"))
                if (!(message.payload && typeof message.payload.length === "number" || $util.isString(message.payload)))
                    return "payload: buffer expected";
            return null;
        };

        /**
         * Creates a ClientFinish message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ClientFinish
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ClientFinish} ClientFinish
         */
        ClientFinish.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ClientFinish)
                return object;
            var message = new $root.proto.ClientFinish();
            if (object["static"] != null)
                if (typeof object["static"] === "string")
                    $util.base64.decode(object["static"], message["static"] = $util.newBuffer($util.base64.length(object["static"])), 0);
                else if (object["static"].length)
                    message["static"] = object["static"];
            if (object.payload != null)
                if (typeof object.payload === "string")
                    $util.base64.decode(object.payload, message.payload = $util.newBuffer($util.base64.length(object.payload)), 0);
                else if (object.payload.length)
                    message.payload = object.payload;
            return message;
        };

        /**
         * Creates a plain object from a ClientFinish message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ClientFinish
         * @static
         * @param {proto.ClientFinish} message ClientFinish
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClientFinish.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object["static"] = "";
                else {
                    object["static"] = [];
                    if (options.bytes !== Array)
                        object["static"] = $util.newBuffer(object["static"]);
                }
                if (options.bytes === String)
                    object.payload = "";
                else {
                    object.payload = [];
                    if (options.bytes !== Array)
                        object.payload = $util.newBuffer(object.payload);
                }
            }
            if (message["static"] != null && message.hasOwnProperty("static"))
                object["static"] = options.bytes === String ? $util.base64.encode(message["static"], 0, message["static"].length) : options.bytes === Array ? Array.prototype.slice.call(message["static"]) : message["static"];
            if (message.payload != null && message.hasOwnProperty("payload"))
                object.payload = options.bytes === String ? $util.base64.encode(message.payload, 0, message.payload.length) : options.bytes === Array ? Array.prototype.slice.call(message.payload) : message.payload;
            return object;
        };

        /**
         * Converts this ClientFinish to JSON.
         * @function toJSON
         * @memberof proto.ClientFinish
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClientFinish.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ClientFinish;
    })();

    proto.ClientHello = (function() {

        /**
         * Properties of a ClientHello.
         * @memberof proto
         * @interface IClientHello
         * @property {Uint8Array|null} [ephemeral] ClientHello ephemeral
         * @property {Uint8Array|null} ["static"] ClientHello static
         * @property {Uint8Array|null} [payload] ClientHello payload
         */

        /**
         * Constructs a new ClientHello.
         * @memberof proto
         * @classdesc Represents a ClientHello.
         * @implements IClientHello
         * @constructor
         * @param {proto.IClientHello=} [properties] Properties to set
         */
        function ClientHello(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ClientHello ephemeral.
         * @member {Uint8Array} ephemeral
         * @memberof proto.ClientHello
         * @instance
         */
        ClientHello.prototype.ephemeral = $util.newBuffer([]);

        /**
         * ClientHello static.
         * @member {Uint8Array} static
         * @memberof proto.ClientHello
         * @instance
         */
        ClientHello.prototype["static"] = $util.newBuffer([]);

        /**
         * ClientHello payload.
         * @member {Uint8Array} payload
         * @memberof proto.ClientHello
         * @instance
         */
        ClientHello.prototype.payload = $util.newBuffer([]);

        /**
         * Creates a new ClientHello instance using the specified properties.
         * @function create
         * @memberof proto.ClientHello
         * @static
         * @param {proto.IClientHello=} [properties] Properties to set
         * @returns {proto.ClientHello} ClientHello instance
         */
        ClientHello.create = function create(properties) {
            return new ClientHello(properties);
        };

        /**
         * Encodes the specified ClientHello message. Does not implicitly {@link proto.ClientHello.verify|verify} messages.
         * @function encode
         * @memberof proto.ClientHello
         * @static
         * @param {proto.IClientHello} message ClientHello message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientHello.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.ephemeral != null && Object.hasOwnProperty.call(message, "ephemeral"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.ephemeral);
            if (message["static"] != null && Object.hasOwnProperty.call(message, "static"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message["static"]);
            if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.payload);
            return writer;
        };

        /**
         * Encodes the specified ClientHello message, length delimited. Does not implicitly {@link proto.ClientHello.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ClientHello
         * @static
         * @param {proto.IClientHello} message ClientHello message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientHello.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClientHello message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ClientHello
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ClientHello} ClientHello
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientHello.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientHello();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.ephemeral = reader.bytes();
                    break;
                case 2:
                    message["static"] = reader.bytes();
                    break;
                case 3:
                    message.payload = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ClientHello message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ClientHello
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ClientHello} ClientHello
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientHello.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClientHello message.
         * @function verify
         * @memberof proto.ClientHello
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClientHello.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.ephemeral != null && message.hasOwnProperty("ephemeral"))
                if (!(message.ephemeral && typeof message.ephemeral.length === "number" || $util.isString(message.ephemeral)))
                    return "ephemeral: buffer expected";
            if (message["static"] != null && message.hasOwnProperty("static"))
                if (!(message["static"] && typeof message["static"].length === "number" || $util.isString(message["static"])))
                    return "static: buffer expected";
            if (message.payload != null && message.hasOwnProperty("payload"))
                if (!(message.payload && typeof message.payload.length === "number" || $util.isString(message.payload)))
                    return "payload: buffer expected";
            return null;
        };

        /**
         * Creates a ClientHello message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ClientHello
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ClientHello} ClientHello
         */
        ClientHello.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ClientHello)
                return object;
            var message = new $root.proto.ClientHello();
            if (object.ephemeral != null)
                if (typeof object.ephemeral === "string")
                    $util.base64.decode(object.ephemeral, message.ephemeral = $util.newBuffer($util.base64.length(object.ephemeral)), 0);
                else if (object.ephemeral.length)
                    message.ephemeral = object.ephemeral;
            if (object["static"] != null)
                if (typeof object["static"] === "string")
                    $util.base64.decode(object["static"], message["static"] = $util.newBuffer($util.base64.length(object["static"])), 0);
                else if (object["static"].length)
                    message["static"] = object["static"];
            if (object.payload != null)
                if (typeof object.payload === "string")
                    $util.base64.decode(object.payload, message.payload = $util.newBuffer($util.base64.length(object.payload)), 0);
                else if (object.payload.length)
                    message.payload = object.payload;
            return message;
        };

        /**
         * Creates a plain object from a ClientHello message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ClientHello
         * @static
         * @param {proto.ClientHello} message ClientHello
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClientHello.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.ephemeral = "";
                else {
                    object.ephemeral = [];
                    if (options.bytes !== Array)
                        object.ephemeral = $util.newBuffer(object.ephemeral);
                }
                if (options.bytes === String)
                    object["static"] = "";
                else {
                    object["static"] = [];
                    if (options.bytes !== Array)
                        object["static"] = $util.newBuffer(object["static"]);
                }
                if (options.bytes === String)
                    object.payload = "";
                else {
                    object.payload = [];
                    if (options.bytes !== Array)
                        object.payload = $util.newBuffer(object.payload);
                }
            }
            if (message.ephemeral != null && message.hasOwnProperty("ephemeral"))
                object.ephemeral = options.bytes === String ? $util.base64.encode(message.ephemeral, 0, message.ephemeral.length) : options.bytes === Array ? Array.prototype.slice.call(message.ephemeral) : message.ephemeral;
            if (message["static"] != null && message.hasOwnProperty("static"))
                object["static"] = options.bytes === String ? $util.base64.encode(message["static"], 0, message["static"].length) : options.bytes === Array ? Array.prototype.slice.call(message["static"]) : message["static"];
            if (message.payload != null && message.hasOwnProperty("payload"))
                object.payload = options.bytes === String ? $util.base64.encode(message.payload, 0, message.payload.length) : options.bytes === Array ? Array.prototype.slice.call(message.payload) : message.payload;
            return object;
        };

        /**
         * Converts this ClientHello to JSON.
         * @function toJSON
         * @memberof proto.ClientHello
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClientHello.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ClientHello;
    })();

    proto.ClientPayload = (function() {

        /**
         * Properties of a ClientPayload.
         * @memberof proto
         * @interface IClientPayload
         * @property {number|Long|null} [username] ClientPayload username
         * @property {boolean|null} [passive] ClientPayload passive
         * @property {proto.IUserAgent|null} [userAgent] ClientPayload userAgent
         * @property {proto.IWebInfo|null} [webInfo] ClientPayload webInfo
         * @property {string|null} [pushName] ClientPayload pushName
         * @property {number|null} [sessionId] ClientPayload sessionId
         * @property {boolean|null} [shortConnect] ClientPayload shortConnect
         * @property {proto.ClientPayload.ClientPayloadConnectType|null} [connectType] ClientPayload connectType
         * @property {proto.ClientPayload.ClientPayloadConnectReason|null} [connectReason] ClientPayload connectReason
         * @property {Array.<number>|null} [shards] ClientPayload shards
         * @property {proto.IDNSSource|null} [dnsSource] ClientPayload dnsSource
         * @property {number|null} [connectAttemptCount] ClientPayload connectAttemptCount
         * @property {number|null} [device] ClientPayload device
         * @property {proto.IDevicePairingRegistrationData|null} [devicePairingData] ClientPayload devicePairingData
         * @property {proto.ClientPayload.ClientPayloadProduct|null} [product] ClientPayload product
         * @property {Uint8Array|null} [fbCat] ClientPayload fbCat
         * @property {Uint8Array|null} [fbUserAgent] ClientPayload fbUserAgent
         * @property {boolean|null} [oc] ClientPayload oc
         * @property {number|null} [lc] ClientPayload lc
         * @property {proto.ClientPayload.ClientPayloadIOSAppExtension|null} [iosAppExtension] ClientPayload iosAppExtension
         * @property {number|Long|null} [fbAppId] ClientPayload fbAppId
         * @property {Uint8Array|null} [fbDeviceId] ClientPayload fbDeviceId
         * @property {boolean|null} [pull] ClientPayload pull
         * @property {Uint8Array|null} [paddingBytes] ClientPayload paddingBytes
         */

        /**
         * Constructs a new ClientPayload.
         * @memberof proto
         * @classdesc Represents a ClientPayload.
         * @implements IClientPayload
         * @constructor
         * @param {proto.IClientPayload=} [properties] Properties to set
         */
        function ClientPayload(properties) {
            this.shards = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ClientPayload username.
         * @member {number|Long} username
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.username = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ClientPayload passive.
         * @member {boolean} passive
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.passive = false;

        /**
         * ClientPayload userAgent.
         * @member {proto.IUserAgent|null|undefined} userAgent
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.userAgent = null;

        /**
         * ClientPayload webInfo.
         * @member {proto.IWebInfo|null|undefined} webInfo
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.webInfo = null;

        /**
         * ClientPayload pushName.
         * @member {string} pushName
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.pushName = "";

        /**
         * ClientPayload sessionId.
         * @member {number} sessionId
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.sessionId = 0;

        /**
         * ClientPayload shortConnect.
         * @member {boolean} shortConnect
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.shortConnect = false;

        /**
         * ClientPayload connectType.
         * @member {proto.ClientPayload.ClientPayloadConnectType} connectType
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.connectType = 0;

        /**
         * ClientPayload connectReason.
         * @member {proto.ClientPayload.ClientPayloadConnectReason} connectReason
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.connectReason = 0;

        /**
         * ClientPayload shards.
         * @member {Array.<number>} shards
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.shards = $util.emptyArray;

        /**
         * ClientPayload dnsSource.
         * @member {proto.IDNSSource|null|undefined} dnsSource
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.dnsSource = null;

        /**
         * ClientPayload connectAttemptCount.
         * @member {number} connectAttemptCount
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.connectAttemptCount = 0;

        /**
         * ClientPayload device.
         * @member {number} device
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.device = 0;

        /**
         * ClientPayload devicePairingData.
         * @member {proto.IDevicePairingRegistrationData|null|undefined} devicePairingData
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.devicePairingData = null;

        /**
         * ClientPayload product.
         * @member {proto.ClientPayload.ClientPayloadProduct} product
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.product = 0;

        /**
         * ClientPayload fbCat.
         * @member {Uint8Array} fbCat
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbCat = $util.newBuffer([]);

        /**
         * ClientPayload fbUserAgent.
         * @member {Uint8Array} fbUserAgent
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbUserAgent = $util.newBuffer([]);

        /**
         * ClientPayload oc.
         * @member {boolean} oc
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.oc = false;

        /**
         * ClientPayload lc.
         * @member {number} lc
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.lc = 0;

        /**
         * ClientPayload iosAppExtension.
         * @member {proto.ClientPayload.ClientPayloadIOSAppExtension} iosAppExtension
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.iosAppExtension = 0;

        /**
         * ClientPayload fbAppId.
         * @member {number|Long} fbAppId
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbAppId = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ClientPayload fbDeviceId.
         * @member {Uint8Array} fbDeviceId
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbDeviceId = $util.newBuffer([]);

        /**
         * ClientPayload pull.
         * @member {boolean} pull
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.pull = false;

        /**
         * ClientPayload paddingBytes.
         * @member {Uint8Array} paddingBytes
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.paddingBytes = $util.newBuffer([]);

        /**
         * Creates a new ClientPayload instance using the specified properties.
         * @function create
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.IClientPayload=} [properties] Properties to set
         * @returns {proto.ClientPayload} ClientPayload instance
         */
        ClientPayload.create = function create(properties) {
            return new ClientPayload(properties);
        };

        /**
         * Encodes the specified ClientPayload message. Does not implicitly {@link proto.ClientPayload.verify|verify} messages.
         * @function encode
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.IClientPayload} message ClientPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientPayload.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.username != null && Object.hasOwnProperty.call(message, "username"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.username);
            if (message.passive != null && Object.hasOwnProperty.call(message, "passive"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.passive);
            if (message.userAgent != null && Object.hasOwnProperty.call(message, "userAgent"))
                $root.proto.UserAgent.encode(message.userAgent, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.webInfo != null && Object.hasOwnProperty.call(message, "webInfo"))
                $root.proto.WebInfo.encode(message.webInfo, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.pushName != null && Object.hasOwnProperty.call(message, "pushName"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.pushName);
            if (message.sessionId != null && Object.hasOwnProperty.call(message, "sessionId"))
                writer.uint32(/* id 9, wireType 5 =*/77).sfixed32(message.sessionId);
            if (message.shortConnect != null && Object.hasOwnProperty.call(message, "shortConnect"))
                writer.uint32(/* id 10, wireType 0 =*/80).bool(message.shortConnect);
            if (message.connectType != null && Object.hasOwnProperty.call(message, "connectType"))
                writer.uint32(/* id 12, wireType 0 =*/96).int32(message.connectType);
            if (message.connectReason != null && Object.hasOwnProperty.call(message, "connectReason"))
                writer.uint32(/* id 13, wireType 0 =*/104).int32(message.connectReason);
            if (message.shards != null && message.shards.length)
                for (var i = 0; i < message.shards.length; ++i)
                    writer.uint32(/* id 14, wireType 0 =*/112).int32(message.shards[i]);
            if (message.dnsSource != null && Object.hasOwnProperty.call(message, "dnsSource"))
                $root.proto.DNSSource.encode(message.dnsSource, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
            if (message.connectAttemptCount != null && Object.hasOwnProperty.call(message, "connectAttemptCount"))
                writer.uint32(/* id 16, wireType 0 =*/128).uint32(message.connectAttemptCount);
            if (message.device != null && Object.hasOwnProperty.call(message, "device"))
                writer.uint32(/* id 18, wireType 0 =*/144).uint32(message.device);
            if (message.devicePairingData != null && Object.hasOwnProperty.call(message, "devicePairingData"))
                $root.proto.DevicePairingRegistrationData.encode(message.devicePairingData, writer.uint32(/* id 19, wireType 2 =*/154).fork()).ldelim();
            if (message.product != null && Object.hasOwnProperty.call(message, "product"))
                writer.uint32(/* id 20, wireType 0 =*/160).int32(message.product);
            if (message.fbCat != null && Object.hasOwnProperty.call(message, "fbCat"))
                writer.uint32(/* id 21, wireType 2 =*/170).bytes(message.fbCat);
            if (message.fbUserAgent != null && Object.hasOwnProperty.call(message, "fbUserAgent"))
                writer.uint32(/* id 22, wireType 2 =*/178).bytes(message.fbUserAgent);
            if (message.oc != null && Object.hasOwnProperty.call(message, "oc"))
                writer.uint32(/* id 23, wireType 0 =*/184).bool(message.oc);
            if (message.lc != null && Object.hasOwnProperty.call(message, "lc"))
                writer.uint32(/* id 24, wireType 0 =*/192).int32(message.lc);
            if (message.iosAppExtension != null && Object.hasOwnProperty.call(message, "iosAppExtension"))
                writer.uint32(/* id 30, wireType 0 =*/240).int32(message.iosAppExtension);
            if (message.fbAppId != null && Object.hasOwnProperty.call(message, "fbAppId"))
                writer.uint32(/* id 31, wireType 0 =*/248).uint64(message.fbAppId);
            if (message.fbDeviceId != null && Object.hasOwnProperty.call(message, "fbDeviceId"))
                writer.uint32(/* id 32, wireType 2 =*/258).bytes(message.fbDeviceId);
            if (message.pull != null && Object.hasOwnProperty.call(message, "pull"))
                writer.uint32(/* id 33, wireType 0 =*/264).bool(message.pull);
            if (message.paddingBytes != null && Object.hasOwnProperty.call(message, "paddingBytes"))
                writer.uint32(/* id 34, wireType 2 =*/274).bytes(message.paddingBytes);
            return writer;
        };

        /**
         * Encodes the specified ClientPayload message, length delimited. Does not implicitly {@link proto.ClientPayload.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.IClientPayload} message ClientPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientPayload.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClientPayload message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ClientPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ClientPayload} ClientPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientPayload.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientPayload();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.username = reader.uint64();
                    break;
                case 3:
                    message.passive = reader.bool();
                    break;
                case 5:
                    message.userAgent = $root.proto.UserAgent.decode(reader, reader.uint32());
                    break;
                case 6:
                    message.webInfo = $root.proto.WebInfo.decode(reader, reader.uint32());
                    break;
                case 7:
                    message.pushName = reader.string();
                    break;
                case 9:
                    message.sessionId = reader.sfixed32();
                    break;
                case 10:
                    message.shortConnect = reader.bool();
                    break;
                case 12:
                    message.connectType = reader.int32();
                    break;
                case 13:
                    message.connectReason = reader.int32();
                    break;
                case 14:
                    if (!(message.shards && message.shards.length))
                        message.shards = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.shards.push(reader.int32());
                    } else
                        message.shards.push(reader.int32());
                    break;
                case 15:
                    message.dnsSource = $root.proto.DNSSource.decode(reader, reader.uint32());
                    break;
                case 16:
                    message.connectAttemptCount = reader.uint32();
                    break;
                case 18:
                    message.device = reader.uint32();
                    break;
                case 19:
                    message.devicePairingData = $root.proto.DevicePairingRegistrationData.decode(reader, reader.uint32());
                    break;
                case 20:
                    message.product = reader.int32();
                    break;
                case 21:
                    message.fbCat = reader.bytes();
                    break;
                case 22:
                    message.fbUserAgent = reader.bytes();
                    break;
                case 23:
                    message.oc = reader.bool();
                    break;
                case 24:
                    message.lc = reader.int32();
                    break;
                case 30:
                    message.iosAppExtension = reader.int32();
                    break;
                case 31:
                    message.fbAppId = reader.uint64();
                    break;
                case 32:
                    message.fbDeviceId = reader.bytes();
                    break;
                case 33:
                    message.pull = reader.bool();
                    break;
                case 34:
                    message.paddingBytes = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ClientPayload message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ClientPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ClientPayload} ClientPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientPayload.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClientPayload message.
         * @function verify
         * @memberof proto.ClientPayload
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClientPayload.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.username != null && message.hasOwnProperty("username"))
                if (!$util.isInteger(message.username) && !(message.username && $util.isInteger(message.username.low) && $util.isInteger(message.username.high)))
                    return "username: integer|Long expected";
            if (message.passive != null && message.hasOwnProperty("passive"))
                if (typeof message.passive !== "boolean")
                    return "passive: boolean expected";
            if (message.userAgent != null && message.hasOwnProperty("userAgent")) {
                var error = $root.proto.UserAgent.verify(message.userAgent);
                if (error)
                    return "userAgent." + error;
            }
            if (message.webInfo != null && message.hasOwnProperty("webInfo")) {
                var error = $root.proto.WebInfo.verify(message.webInfo);
                if (error)
                    return "webInfo." + error;
            }
            if (message.pushName != null && message.hasOwnProperty("pushName"))
                if (!$util.isString(message.pushName))
                    return "pushName: string expected";
            if (message.sessionId != null && message.hasOwnProperty("sessionId"))
                if (!$util.isInteger(message.sessionId))
                    return "sessionId: integer expected";
            if (message.shortConnect != null && message.hasOwnProperty("shortConnect"))
                if (typeof message.shortConnect !== "boolean")
                    return "shortConnect: boolean expected";
            if (message.connectType != null && message.hasOwnProperty("connectType"))
                switch (message.connectType) {
                default:
                    return "connectType: enum value expected";
                case 0:
                case 1:
                case 100:
                case 101:
                case 102:
                case 103:
                case 104:
                case 105:
                case 106:
                case 107:
                case 108:
                case 109:
                case 110:
                case 111:
                case 112:
                    break;
                }
            if (message.connectReason != null && message.hasOwnProperty("connectReason"))
                switch (message.connectReason) {
                default:
                    return "connectReason: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                    break;
                }
            if (message.shards != null && message.hasOwnProperty("shards")) {
                if (!Array.isArray(message.shards))
                    return "shards: array expected";
                for (var i = 0; i < message.shards.length; ++i)
                    if (!$util.isInteger(message.shards[i]))
                        return "shards: integer[] expected";
            }
            if (message.dnsSource != null && message.hasOwnProperty("dnsSource")) {
                var error = $root.proto.DNSSource.verify(message.dnsSource);
                if (error)
                    return "dnsSource." + error;
            }
            if (message.connectAttemptCount != null && message.hasOwnProperty("connectAttemptCount"))
                if (!$util.isInteger(message.connectAttemptCount))
                    return "connectAttemptCount: integer expected";
            if (message.device != null && message.hasOwnProperty("device"))
                if (!$util.isInteger(message.device))
                    return "device: integer expected";
            if (message.devicePairingData != null && message.hasOwnProperty("devicePairingData")) {
                var error = $root.proto.DevicePairingRegistrationData.verify(message.devicePairingData);
                if (error)
                    return "devicePairingData." + error;
            }
            if (message.product != null && message.hasOwnProperty("product"))
                switch (message.product) {
                default:
                    return "product: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.fbCat != null && message.hasOwnProperty("fbCat"))
                if (!(message.fbCat && typeof message.fbCat.length === "number" || $util.isString(message.fbCat)))
                    return "fbCat: buffer expected";
            if (message.fbUserAgent != null && message.hasOwnProperty("fbUserAgent"))
                if (!(message.fbUserAgent && typeof message.fbUserAgent.length === "number" || $util.isString(message.fbUserAgent)))
                    return "fbUserAgent: buffer expected";
            if (message.oc != null && message.hasOwnProperty("oc"))
                if (typeof message.oc !== "boolean")
                    return "oc: boolean expected";
            if (message.lc != null && message.hasOwnProperty("lc"))
                if (!$util.isInteger(message.lc))
                    return "lc: integer expected";
            if (message.iosAppExtension != null && message.hasOwnProperty("iosAppExtension"))
                switch (message.iosAppExtension) {
                default:
                    return "iosAppExtension: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.fbAppId != null && message.hasOwnProperty("fbAppId"))
                if (!$util.isInteger(message.fbAppId) && !(message.fbAppId && $util.isInteger(message.fbAppId.low) && $util.isInteger(message.fbAppId.high)))
                    return "fbAppId: integer|Long expected";
            if (message.fbDeviceId != null && message.hasOwnProperty("fbDeviceId"))
                if (!(message.fbDeviceId && typeof message.fbDeviceId.length === "number" || $util.isString(message.fbDeviceId)))
                    return "fbDeviceId: buffer expected";
            if (message.pull != null && message.hasOwnProperty("pull"))
                if (typeof message.pull !== "boolean")
                    return "pull: boolean expected";
            if (message.paddingBytes != null && message.hasOwnProperty("paddingBytes"))
                if (!(message.paddingBytes && typeof message.paddingBytes.length === "number" || $util.isString(message.paddingBytes)))
                    return "paddingBytes: buffer expected";
            return null;
        };

        /**
         * Creates a ClientPayload message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ClientPayload
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ClientPayload} ClientPayload
         */
        ClientPayload.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ClientPayload)
                return object;
            var message = new $root.proto.ClientPayload();
            if (object.username != null)
                if ($util.Long)
                    (message.username = $util.Long.fromValue(object.username)).unsigned = true;
                else if (typeof object.username === "string")
                    message.username = parseInt(object.username, 10);
                else if (typeof object.username === "number")
                    message.username = object.username;
                else if (typeof object.username === "object")
                    message.username = new $util.LongBits(object.username.low >>> 0, object.username.high >>> 0).toNumber(true);
            if (object.passive != null)
                message.passive = Boolean(object.passive);
            if (object.userAgent != null) {
                if (typeof object.userAgent !== "object")
                    throw TypeError(".proto.ClientPayload.userAgent: object expected");
                message.userAgent = $root.proto.UserAgent.fromObject(object.userAgent);
            }
            if (object.webInfo != null) {
                if (typeof object.webInfo !== "object")
                    throw TypeError(".proto.ClientPayload.webInfo: object expected");
                message.webInfo = $root.proto.WebInfo.fromObject(object.webInfo);
            }
            if (object.pushName != null)
                message.pushName = String(object.pushName);
            if (object.sessionId != null)
                message.sessionId = object.sessionId | 0;
            if (object.shortConnect != null)
                message.shortConnect = Boolean(object.shortConnect);
            switch (object.connectType) {
            case "CELLULAR_UNKNOWN":
            case 0:
                message.connectType = 0;
                break;
            case "WIFI_UNKNOWN":
            case 1:
                message.connectType = 1;
                break;
            case "CELLULAR_EDGE":
            case 100:
                message.connectType = 100;
                break;
            case "CELLULAR_IDEN":
            case 101:
                message.connectType = 101;
                break;
            case "CELLULAR_UMTS":
            case 102:
                message.connectType = 102;
                break;
            case "CELLULAR_EVDO":
            case 103:
                message.connectType = 103;
                break;
            case "CELLULAR_GPRS":
            case 104:
                message.connectType = 104;
                break;
            case "CELLULAR_HSDPA":
            case 105:
                message.connectType = 105;
                break;
            case "CELLULAR_HSUPA":
            case 106:
                message.connectType = 106;
                break;
            case "CELLULAR_HSPA":
            case 107:
                message.connectType = 107;
                break;
            case "CELLULAR_CDMA":
            case 108:
                message.connectType = 108;
                break;
            case "CELLULAR_1XRTT":
            case 109:
                message.connectType = 109;
                break;
            case "CELLULAR_EHRPD":
            case 110:
                message.connectType = 110;
                break;
            case "CELLULAR_LTE":
            case 111:
                message.connectType = 111;
                break;
            case "CELLULAR_HSPAP":
            case 112:
                message.connectType = 112;
                break;
            }
            switch (object.connectReason) {
            case "PUSH":
            case 0:
                message.connectReason = 0;
                break;
            case "USER_ACTIVATED":
            case 1:
                message.connectReason = 1;
                break;
            case "SCHEDULED":
            case 2:
                message.connectReason = 2;
                break;
            case "ERROR_RECONNECT":
            case 3:
                message.connectReason = 3;
                break;
            case "NETWORK_SWITCH":
            case 4:
                message.connectReason = 4;
                break;
            case "PING_RECONNECT":
            case 5:
                message.connectReason = 5;
                break;
            }
            if (object.shards) {
                if (!Array.isArray(object.shards))
                    throw TypeError(".proto.ClientPayload.shards: array expected");
                message.shards = [];
                for (var i = 0; i < object.shards.length; ++i)
                    message.shards[i] = object.shards[i] | 0;
            }
            if (object.dnsSource != null) {
                if (typeof object.dnsSource !== "object")
                    throw TypeError(".proto.ClientPayload.dnsSource: object expected");
                message.dnsSource = $root.proto.DNSSource.fromObject(object.dnsSource);
            }
            if (object.connectAttemptCount != null)
                message.connectAttemptCount = object.connectAttemptCount >>> 0;
            if (object.device != null)
                message.device = object.device >>> 0;
            if (object.devicePairingData != null) {
                if (typeof object.devicePairingData !== "object")
                    throw TypeError(".proto.ClientPayload.devicePairingData: object expected");
                message.devicePairingData = $root.proto.DevicePairingRegistrationData.fromObject(object.devicePairingData);
            }
            switch (object.product) {
            case "WHATSAPP":
            case 0:
                message.product = 0;
                break;
            case "MESSENGER":
            case 1:
                message.product = 1;
                break;
            }
            if (object.fbCat != null)
                if (typeof object.fbCat === "string")
                    $util.base64.decode(object.fbCat, message.fbCat = $util.newBuffer($util.base64.length(object.fbCat)), 0);
                else if (object.fbCat.length)
                    message.fbCat = object.fbCat;
            if (object.fbUserAgent != null)
                if (typeof object.fbUserAgent === "string")
                    $util.base64.decode(object.fbUserAgent, message.fbUserAgent = $util.newBuffer($util.base64.length(object.fbUserAgent)), 0);
                else if (object.fbUserAgent.length)
                    message.fbUserAgent = object.fbUserAgent;
            if (object.oc != null)
                message.oc = Boolean(object.oc);
            if (object.lc != null)
                message.lc = object.lc | 0;
            switch (object.iosAppExtension) {
            case "SHARE_EXTENSION":
            case 0:
                message.iosAppExtension = 0;
                break;
            case "SERVICE_EXTENSION":
            case 1:
                message.iosAppExtension = 1;
                break;
            case "INTENTS_EXTENSION":
            case 2:
                message.iosAppExtension = 2;
                break;
            }
            if (object.fbAppId != null)
                if ($util.Long)
                    (message.fbAppId = $util.Long.fromValue(object.fbAppId)).unsigned = true;
                else if (typeof object.fbAppId === "string")
                    message.fbAppId = parseInt(object.fbAppId, 10);
                else if (typeof object.fbAppId === "number")
                    message.fbAppId = object.fbAppId;
                else if (typeof object.fbAppId === "object")
                    message.fbAppId = new $util.LongBits(object.fbAppId.low >>> 0, object.fbAppId.high >>> 0).toNumber(true);
            if (object.fbDeviceId != null)
                if (typeof object.fbDeviceId === "string")
                    $util.base64.decode(object.fbDeviceId, message.fbDeviceId = $util.newBuffer($util.base64.length(object.fbDeviceId)), 0);
                else if (object.fbDeviceId.length)
                    message.fbDeviceId = object.fbDeviceId;
            if (object.pull != null)
                message.pull = Boolean(object.pull);
            if (object.paddingBytes != null)
                if (typeof object.paddingBytes === "string")
                    $util.base64.decode(object.paddingBytes, message.paddingBytes = $util.newBuffer($util.base64.length(object.paddingBytes)), 0);
                else if (object.paddingBytes.length)
                    message.paddingBytes = object.paddingBytes;
            return message;
        };

        /**
         * Creates a plain object from a ClientPayload message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.ClientPayload} message ClientPayload
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClientPayload.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.shards = [];
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.username = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.username = options.longs === String ? "0" : 0;
                object.passive = false;
                object.userAgent = null;
                object.webInfo = null;
                object.pushName = "";
                object.sessionId = 0;
                object.shortConnect = false;
                object.connectType = options.enums === String ? "CELLULAR_UNKNOWN" : 0;
                object.connectReason = options.enums === String ? "PUSH" : 0;
                object.dnsSource = null;
                object.connectAttemptCount = 0;
                object.device = 0;
                object.devicePairingData = null;
                object.product = options.enums === String ? "WHATSAPP" : 0;
                if (options.bytes === String)
                    object.fbCat = "";
                else {
                    object.fbCat = [];
                    if (options.bytes !== Array)
                        object.fbCat = $util.newBuffer(object.fbCat);
                }
                if (options.bytes === String)
                    object.fbUserAgent = "";
                else {
                    object.fbUserAgent = [];
                    if (options.bytes !== Array)
                        object.fbUserAgent = $util.newBuffer(object.fbUserAgent);
                }
                object.oc = false;
                object.lc = 0;
                object.iosAppExtension = options.enums === String ? "SHARE_EXTENSION" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fbAppId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fbAppId = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.fbDeviceId = "";
                else {
                    object.fbDeviceId = [];
                    if (options.bytes !== Array)
                        object.fbDeviceId = $util.newBuffer(object.fbDeviceId);
                }
                object.pull = false;
                if (options.bytes === String)
                    object.paddingBytes = "";
                else {
                    object.paddingBytes = [];
                    if (options.bytes !== Array)
                        object.paddingBytes = $util.newBuffer(object.paddingBytes);
                }
            }
            if (message.username != null && message.hasOwnProperty("username"))
                if (typeof message.username === "number")
                    object.username = options.longs === String ? String(message.username) : message.username;
                else
                    object.username = options.longs === String ? $util.Long.prototype.toString.call(message.username) : options.longs === Number ? new $util.LongBits(message.username.low >>> 0, message.username.high >>> 0).toNumber(true) : message.username;
            if (message.passive != null && message.hasOwnProperty("passive"))
                object.passive = message.passive;
            if (message.userAgent != null && message.hasOwnProperty("userAgent"))
                object.userAgent = $root.proto.UserAgent.toObject(message.userAgent, options);
            if (message.webInfo != null && message.hasOwnProperty("webInfo"))
                object.webInfo = $root.proto.WebInfo.toObject(message.webInfo, options);
            if (message.pushName != null && message.hasOwnProperty("pushName"))
                object.pushName = message.pushName;
            if (message.sessionId != null && message.hasOwnProperty("sessionId"))
                object.sessionId = message.sessionId;
            if (message.shortConnect != null && message.hasOwnProperty("shortConnect"))
                object.shortConnect = message.shortConnect;
            if (message.connectType != null && message.hasOwnProperty("connectType"))
                object.connectType = options.enums === String ? $root.proto.ClientPayload.ClientPayloadConnectType[message.connectType] : message.connectType;
            if (message.connectReason != null && message.hasOwnProperty("connectReason"))
                object.connectReason = options.enums === String ? $root.proto.ClientPayload.ClientPayloadConnectReason[message.connectReason] : message.connectReason;
            if (message.shards && message.shards.length) {
                object.shards = [];
                for (var j = 0; j < message.shards.length; ++j)
                    object.shards[j] = message.shards[j];
            }
            if (message.dnsSource != null && message.hasOwnProperty("dnsSource"))
                object.dnsSource = $root.proto.DNSSource.toObject(message.dnsSource, options);
            if (message.connectAttemptCount != null && message.hasOwnProperty("connectAttemptCount"))
                object.connectAttemptCount = message.connectAttemptCount;
            if (message.device != null && message.hasOwnProperty("device"))
                object.device = message.device;
            if (message.devicePairingData != null && message.hasOwnProperty("devicePairingData"))
                object.devicePairingData = $root.proto.DevicePairingRegistrationData.toObject(message.devicePairingData, options);
            if (message.product != null && message.hasOwnProperty("product"))
                object.product = options.enums === String ? $root.proto.ClientPayload.ClientPayloadProduct[message.product] : message.product;
            if (message.fbCat != null && message.hasOwnProperty("fbCat"))
                object.fbCat = options.bytes === String ? $util.base64.encode(message.fbCat, 0, message.fbCat.length) : options.bytes === Array ? Array.prototype.slice.call(message.fbCat) : message.fbCat;
            if (message.fbUserAgent != null && message.hasOwnProperty("fbUserAgent"))
                object.fbUserAgent = options.bytes === String ? $util.base64.encode(message.fbUserAgent, 0, message.fbUserAgent.length) : options.bytes === Array ? Array.prototype.slice.call(message.fbUserAgent) : message.fbUserAgent;
            if (message.oc != null && message.hasOwnProperty("oc"))
                object.oc = message.oc;
            if (message.lc != null && message.hasOwnProperty("lc"))
                object.lc = message.lc;
            if (message.iosAppExtension != null && message.hasOwnProperty("iosAppExtension"))
                object.iosAppExtension = options.enums === String ? $root.proto.ClientPayload.ClientPayloadIOSAppExtension[message.iosAppExtension] : message.iosAppExtension;
            if (message.fbAppId != null && message.hasOwnProperty("fbAppId"))
                if (typeof message.fbAppId === "number")
                    object.fbAppId = options.longs === String ? String(message.fbAppId) : message.fbAppId;
                else
                    object.fbAppId = options.longs === String ? $util.Long.prototype.toString.call(message.fbAppId) : options.longs === Number ? new $util.LongBits(message.fbAppId.low >>> 0, message.fbAppId.high >>> 0).toNumber(true) : message.fbAppId;
            if (message.fbDeviceId != null && message.hasOwnProperty("fbDeviceId"))
                object.fbDeviceId = options.bytes === String ? $util.base64.encode(message.fbDeviceId, 0, message.fbDeviceId.length) : options.bytes === Array ? Array.prototype.slice.call(message.fbDeviceId) : message.fbDeviceId;
            if (message.pull != null && message.hasOwnProperty("pull"))
                object.pull = message.pull;
            if (message.paddingBytes != null && message.hasOwnProperty("paddingBytes"))
                object.paddingBytes = options.bytes === String ? $util.base64.encode(message.paddingBytes, 0, message.paddingBytes.length) : options.bytes === Array ? Array.prototype.slice.call(message.paddingBytes) : message.paddingBytes;
            return object;
        };

        /**
         * Converts this ClientPayload to JSON.
         * @function toJSON
         * @memberof proto.ClientPayload
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClientPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ClientPayloadConnectType enum.
         * @name proto.ClientPayload.ClientPayloadConnectType
         * @enum {number}
         * @property {number} CELLULAR_UNKNOWN=0 CELLULAR_UNKNOWN value
         * @property {number} WIFI_UNKNOWN=1 WIFI_UNKNOWN value
         * @property {number} CELLULAR_EDGE=100 CELLULAR_EDGE value
         * @property {number} CELLULAR_IDEN=101 CELLULAR_IDEN value
         * @property {number} CELLULAR_UMTS=102 CELLULAR_UMTS value
         * @property {number} CELLULAR_EVDO=103 CELLULAR_EVDO value
         * @property {number} CELLULAR_GPRS=104 CELLULAR_GPRS value
         * @property {number} CELLULAR_HSDPA=105 CELLULAR_HSDPA value
         * @property {number} CELLULAR_HSUPA=106 CELLULAR_HSUPA value
         * @property {number} CELLULAR_HSPA=107 CELLULAR_HSPA value
         * @property {number} CELLULAR_CDMA=108 CELLULAR_CDMA value
         * @property {number} CELLULAR_1XRTT=109 CELLULAR_1XRTT value
         * @property {number} CELLULAR_EHRPD=110 CELLULAR_EHRPD value
         * @property {number} CELLULAR_LTE=111 CELLULAR_LTE value
         * @property {number} CELLULAR_HSPAP=112 CELLULAR_HSPAP value
         */
        ClientPayload.ClientPayloadConnectType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CELLULAR_UNKNOWN"] = 0;
            values[valuesById[1] = "WIFI_UNKNOWN"] = 1;
            values[valuesById[100] = "CELLULAR_EDGE"] = 100;
            values[valuesById[101] = "CELLULAR_IDEN"] = 101;
            values[valuesById[102] = "CELLULAR_UMTS"] = 102;
            values[valuesById[103] = "CELLULAR_EVDO"] = 103;
            values[valuesById[104] = "CELLULAR_GPRS"] = 104;
            values[valuesById[105] = "CELLULAR_HSDPA"] = 105;
            values[valuesById[106] = "CELLULAR_HSUPA"] = 106;
            values[valuesById[107] = "CELLULAR_HSPA"] = 107;
            values[valuesById[108] = "CELLULAR_CDMA"] = 108;
            values[valuesById[109] = "CELLULAR_1XRTT"] = 109;
            values[valuesById[110] = "CELLULAR_EHRPD"] = 110;
            values[valuesById[111] = "CELLULAR_LTE"] = 111;
            values[valuesById[112] = "CELLULAR_HSPAP"] = 112;
            return values;
        })();

        /**
         * ClientPayloadConnectReason enum.
         * @name proto.ClientPayload.ClientPayloadConnectReason
         * @enum {number}
         * @property {number} PUSH=0 PUSH value
         * @property {number} USER_ACTIVATED=1 USER_ACTIVATED value
         * @property {number} SCHEDULED=2 SCHEDULED value
         * @property {number} ERROR_RECONNECT=3 ERROR_RECONNECT value
         * @property {number} NETWORK_SWITCH=4 NETWORK_SWITCH value
         * @property {number} PING_RECONNECT=5 PING_RECONNECT value
         */
        ClientPayload.ClientPayloadConnectReason = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "PUSH"] = 0;
            values[valuesById[1] = "USER_ACTIVATED"] = 1;
            values[valuesById[2] = "SCHEDULED"] = 2;
            values[valuesById[3] = "ERROR_RECONNECT"] = 3;
            values[valuesById[4] = "NETWORK_SWITCH"] = 4;
            values[valuesById[5] = "PING_RECONNECT"] = 5;
            return values;
        })();

        /**
         * ClientPayloadProduct enum.
         * @name proto.ClientPayload.ClientPayloadProduct
         * @enum {number}
         * @property {number} WHATSAPP=0 WHATSAPP value
         * @property {number} MESSENGER=1 MESSENGER value
         */
        ClientPayload.ClientPayloadProduct = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "WHATSAPP"] = 0;
            values[valuesById[1] = "MESSENGER"] = 1;
            return values;
        })();

        /**
         * ClientPayloadIOSAppExtension enum.
         * @name proto.ClientPayload.ClientPayloadIOSAppExtension
         * @enum {number}
         * @property {number} SHARE_EXTENSION=0 SHARE_EXTENSION value
         * @property {number} SERVICE_EXTENSION=1 SERVICE_EXTENSION value
         * @property {number} INTENTS_EXTENSION=2 INTENTS_EXTENSION value
         */
        ClientPayload.ClientPayloadIOSAppExtension = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SHARE_EXTENSION"] = 0;
            values[valuesById[1] = "SERVICE_EXTENSION"] = 1;
            values[valuesById[2] = "INTENTS_EXTENSION"] = 2;
            return values;
        })();

        return ClientPayload;
    })();

    proto.CollectionMessage = (function() {

        /**
         * Properties of a CollectionMessage.
         * @memberof proto
         * @interface ICollectionMessage
         * @property {string|null} [bizJid] CollectionMessage bizJid
         * @property {string|null} [id] CollectionMessage id
         * @property {number|null} [messageVersion] CollectionMessage messageVersion
         */

        /**
         * Constructs a new CollectionMessage.
         * @memberof proto
         * @classdesc Represents a CollectionMessage.
         * @implements ICollectionMessage
         * @constructor
         * @param {proto.ICollectionMessage=} [properties] Properties to set
         */
        function CollectionMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CollectionMessage bizJid.
         * @member {string} bizJid
         * @memberof proto.CollectionMessage
         * @instance
         */
        CollectionMessage.prototype.bizJid = "";

        /**
         * CollectionMessage id.
         * @member {string} id
         * @memberof proto.CollectionMessage
         * @instance
         */
        CollectionMessage.prototype.id = "";

        /**
         * CollectionMessage messageVersion.
         * @member {number} messageVersion
         * @memberof proto.CollectionMessage
         * @instance
         */
        CollectionMessage.prototype.messageVersion = 0;

        /**
         * Creates a new CollectionMessage instance using the specified properties.
         * @function create
         * @memberof proto.CollectionMessage
         * @static
         * @param {proto.ICollectionMessage=} [properties] Properties to set
         * @returns {proto.CollectionMessage} CollectionMessage instance
         */
        CollectionMessage.create = function create(properties) {
            return new CollectionMessage(properties);
        };

        /**
         * Encodes the specified CollectionMessage message. Does not implicitly {@link proto.CollectionMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.CollectionMessage
         * @static
         * @param {proto.ICollectionMessage} message CollectionMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CollectionMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.bizJid != null && Object.hasOwnProperty.call(message, "bizJid"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.bizJid);
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.id);
            if (message.messageVersion != null && Object.hasOwnProperty.call(message, "messageVersion"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.messageVersion);
            return writer;
        };

        /**
         * Encodes the specified CollectionMessage message, length delimited. Does not implicitly {@link proto.CollectionMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CollectionMessage
         * @static
         * @param {proto.ICollectionMessage} message CollectionMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CollectionMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CollectionMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CollectionMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CollectionMessage} CollectionMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CollectionMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CollectionMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.bizJid = reader.string();
                    break;
                case 2:
                    message.id = reader.string();
                    break;
                case 3:
                    message.messageVersion = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CollectionMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CollectionMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CollectionMessage} CollectionMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CollectionMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CollectionMessage message.
         * @function verify
         * @memberof proto.CollectionMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CollectionMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.bizJid != null && message.hasOwnProperty("bizJid"))
                if (!$util.isString(message.bizJid))
                    return "bizJid: string expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!$util.isString(message.id))
                    return "id: string expected";
            if (message.messageVersion != null && message.hasOwnProperty("messageVersion"))
                if (!$util.isInteger(message.messageVersion))
                    return "messageVersion: integer expected";
            return null;
        };

        /**
         * Creates a CollectionMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CollectionMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CollectionMessage} CollectionMessage
         */
        CollectionMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CollectionMessage)
                return object;
            var message = new $root.proto.CollectionMessage();
            if (object.bizJid != null)
                message.bizJid = String(object.bizJid);
            if (object.id != null)
                message.id = String(object.id);
            if (object.messageVersion != null)
                message.messageVersion = object.messageVersion | 0;
            return message;
        };

        /**
         * Creates a plain object from a CollectionMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CollectionMessage
         * @static
         * @param {proto.CollectionMessage} message CollectionMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CollectionMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.bizJid = "";
                object.id = "";
                object.messageVersion = 0;
            }
            if (message.bizJid != null && message.hasOwnProperty("bizJid"))
                object.bizJid = message.bizJid;
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.messageVersion != null && message.hasOwnProperty("messageVersion"))
                object.messageVersion = message.messageVersion;
            return object;
        };

        /**
         * Converts this CollectionMessage to JSON.
         * @function toJSON
         * @memberof proto.CollectionMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CollectionMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return CollectionMessage;
    })();

    proto.ContactAction = (function() {

        /**
         * Properties of a ContactAction.
         * @memberof proto
         * @interface IContactAction
         * @property {string|null} [fullName] ContactAction fullName
         * @property {string|null} [firstName] ContactAction firstName
         */

        /**
         * Constructs a new ContactAction.
         * @memberof proto
         * @classdesc Represents a ContactAction.
         * @implements IContactAction
         * @constructor
         * @param {proto.IContactAction=} [properties] Properties to set
         */
        function ContactAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ContactAction fullName.
         * @member {string} fullName
         * @memberof proto.ContactAction
         * @instance
         */
        ContactAction.prototype.fullName = "";

        /**
         * ContactAction firstName.
         * @member {string} firstName
         * @memberof proto.ContactAction
         * @instance
         */
        ContactAction.prototype.firstName = "";

        /**
         * Creates a new ContactAction instance using the specified properties.
         * @function create
         * @memberof proto.ContactAction
         * @static
         * @param {proto.IContactAction=} [properties] Properties to set
         * @returns {proto.ContactAction} ContactAction instance
         */
        ContactAction.create = function create(properties) {
            return new ContactAction(properties);
        };

        /**
         * Encodes the specified ContactAction message. Does not implicitly {@link proto.ContactAction.verify|verify} messages.
         * @function encode
         * @memberof proto.ContactAction
         * @static
         * @param {proto.IContactAction} message ContactAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.fullName != null && Object.hasOwnProperty.call(message, "fullName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.fullName);
            if (message.firstName != null && Object.hasOwnProperty.call(message, "firstName"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.firstName);
            return writer;
        };

        /**
         * Encodes the specified ContactAction message, length delimited. Does not implicitly {@link proto.ContactAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ContactAction
         * @static
         * @param {proto.IContactAction} message ContactAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ContactAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ContactAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ContactAction} ContactAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ContactAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.fullName = reader.string();
                    break;
                case 2:
                    message.firstName = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ContactAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ContactAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ContactAction} ContactAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ContactAction message.
         * @function verify
         * @memberof proto.ContactAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ContactAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.fullName != null && message.hasOwnProperty("fullName"))
                if (!$util.isString(message.fullName))
                    return "fullName: string expected";
            if (message.firstName != null && message.hasOwnProperty("firstName"))
                if (!$util.isString(message.firstName))
                    return "firstName: string expected";
            return null;
        };

        /**
         * Creates a ContactAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ContactAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ContactAction} ContactAction
         */
        ContactAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ContactAction)
                return object;
            var message = new $root.proto.ContactAction();
            if (object.fullName != null)
                message.fullName = String(object.fullName);
            if (object.firstName != null)
                message.firstName = String(object.firstName);
            return message;
        };

        /**
         * Creates a plain object from a ContactAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ContactAction
         * @static
         * @param {proto.ContactAction} message ContactAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ContactAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.fullName = "";
                object.firstName = "";
            }
            if (message.fullName != null && message.hasOwnProperty("fullName"))
                object.fullName = message.fullName;
            if (message.firstName != null && message.hasOwnProperty("firstName"))
                object.firstName = message.firstName;
            return object;
        };

        /**
         * Converts this ContactAction to JSON.
         * @function toJSON
         * @memberof proto.ContactAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ContactAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ContactAction;
    })();

    proto.ContactMessage = (function() {

        /**
         * Properties of a ContactMessage.
         * @memberof proto
         * @interface IContactMessage
         * @property {string|null} [displayName] ContactMessage displayName
         * @property {string|null} [vcard] ContactMessage vcard
         * @property {proto.IContextInfo|null} [contextInfo] ContactMessage contextInfo
         */

        /**
         * Constructs a new ContactMessage.
         * @memberof proto
         * @classdesc Represents a ContactMessage.
         * @implements IContactMessage
         * @constructor
         * @param {proto.IContactMessage=} [properties] Properties to set
         */
        function ContactMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ContactMessage displayName.
         * @member {string} displayName
         * @memberof proto.ContactMessage
         * @instance
         */
        ContactMessage.prototype.displayName = "";

        /**
         * ContactMessage vcard.
         * @member {string} vcard
         * @memberof proto.ContactMessage
         * @instance
         */
        ContactMessage.prototype.vcard = "";

        /**
         * ContactMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ContactMessage
         * @instance
         */
        ContactMessage.prototype.contextInfo = null;

        /**
         * Creates a new ContactMessage instance using the specified properties.
         * @function create
         * @memberof proto.ContactMessage
         * @static
         * @param {proto.IContactMessage=} [properties] Properties to set
         * @returns {proto.ContactMessage} ContactMessage instance
         */
        ContactMessage.create = function create(properties) {
            return new ContactMessage(properties);
        };

        /**
         * Encodes the specified ContactMessage message. Does not implicitly {@link proto.ContactMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ContactMessage
         * @static
         * @param {proto.IContactMessage} message ContactMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayName);
            if (message.vcard != null && Object.hasOwnProperty.call(message, "vcard"))
                writer.uint32(/* id 16, wireType 2 =*/130).string(message.vcard);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified ContactMessage message, length delimited. Does not implicitly {@link proto.ContactMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ContactMessage
         * @static
         * @param {proto.IContactMessage} message ContactMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ContactMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ContactMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ContactMessage} ContactMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ContactMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayName = reader.string();
                    break;
                case 16:
                    message.vcard = reader.string();
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ContactMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ContactMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ContactMessage} ContactMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ContactMessage message.
         * @function verify
         * @memberof proto.ContactMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ContactMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                if (!$util.isString(message.displayName))
                    return "displayName: string expected";
            if (message.vcard != null && message.hasOwnProperty("vcard"))
                if (!$util.isString(message.vcard))
                    return "vcard: string expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            return null;
        };

        /**
         * Creates a ContactMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ContactMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ContactMessage} ContactMessage
         */
        ContactMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ContactMessage)
                return object;
            var message = new $root.proto.ContactMessage();
            if (object.displayName != null)
                message.displayName = String(object.displayName);
            if (object.vcard != null)
                message.vcard = String(object.vcard);
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ContactMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            return message;
        };

        /**
         * Creates a plain object from a ContactMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ContactMessage
         * @static
         * @param {proto.ContactMessage} message ContactMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ContactMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.displayName = "";
                object.vcard = "";
                object.contextInfo = null;
            }
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                object.displayName = message.displayName;
            if (message.vcard != null && message.hasOwnProperty("vcard"))
                object.vcard = message.vcard;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            return object;
        };

        /**
         * Converts this ContactMessage to JSON.
         * @function toJSON
         * @memberof proto.ContactMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ContactMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ContactMessage;
    })();

    proto.ContactsArrayMessage = (function() {

        /**
         * Properties of a ContactsArrayMessage.
         * @memberof proto
         * @interface IContactsArrayMessage
         * @property {string|null} [displayName] ContactsArrayMessage displayName
         * @property {Array.<proto.IContactMessage>|null} [contacts] ContactsArrayMessage contacts
         * @property {proto.IContextInfo|null} [contextInfo] ContactsArrayMessage contextInfo
         */

        /**
         * Constructs a new ContactsArrayMessage.
         * @memberof proto
         * @classdesc Represents a ContactsArrayMessage.
         * @implements IContactsArrayMessage
         * @constructor
         * @param {proto.IContactsArrayMessage=} [properties] Properties to set
         */
        function ContactsArrayMessage(properties) {
            this.contacts = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ContactsArrayMessage displayName.
         * @member {string} displayName
         * @memberof proto.ContactsArrayMessage
         * @instance
         */
        ContactsArrayMessage.prototype.displayName = "";

        /**
         * ContactsArrayMessage contacts.
         * @member {Array.<proto.IContactMessage>} contacts
         * @memberof proto.ContactsArrayMessage
         * @instance
         */
        ContactsArrayMessage.prototype.contacts = $util.emptyArray;

        /**
         * ContactsArrayMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ContactsArrayMessage
         * @instance
         */
        ContactsArrayMessage.prototype.contextInfo = null;

        /**
         * Creates a new ContactsArrayMessage instance using the specified properties.
         * @function create
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {proto.IContactsArrayMessage=} [properties] Properties to set
         * @returns {proto.ContactsArrayMessage} ContactsArrayMessage instance
         */
        ContactsArrayMessage.create = function create(properties) {
            return new ContactsArrayMessage(properties);
        };

        /**
         * Encodes the specified ContactsArrayMessage message. Does not implicitly {@link proto.ContactsArrayMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {proto.IContactsArrayMessage} message ContactsArrayMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactsArrayMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayName);
            if (message.contacts != null && message.contacts.length)
                for (var i = 0; i < message.contacts.length; ++i)
                    $root.proto.ContactMessage.encode(message.contacts[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified ContactsArrayMessage message, length delimited. Does not implicitly {@link proto.ContactsArrayMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {proto.IContactsArrayMessage} message ContactsArrayMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContactsArrayMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ContactsArrayMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ContactsArrayMessage} ContactsArrayMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactsArrayMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ContactsArrayMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.displayName = reader.string();
                    break;
                case 2:
                    if (!(message.contacts && message.contacts.length))
                        message.contacts = [];
                    message.contacts.push($root.proto.ContactMessage.decode(reader, reader.uint32()));
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ContactsArrayMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ContactsArrayMessage} ContactsArrayMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContactsArrayMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ContactsArrayMessage message.
         * @function verify
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ContactsArrayMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                if (!$util.isString(message.displayName))
                    return "displayName: string expected";
            if (message.contacts != null && message.hasOwnProperty("contacts")) {
                if (!Array.isArray(message.contacts))
                    return "contacts: array expected";
                for (var i = 0; i < message.contacts.length; ++i) {
                    var error = $root.proto.ContactMessage.verify(message.contacts[i]);
                    if (error)
                        return "contacts." + error;
                }
            }
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            return null;
        };

        /**
         * Creates a ContactsArrayMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ContactsArrayMessage} ContactsArrayMessage
         */
        ContactsArrayMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ContactsArrayMessage)
                return object;
            var message = new $root.proto.ContactsArrayMessage();
            if (object.displayName != null)
                message.displayName = String(object.displayName);
            if (object.contacts) {
                if (!Array.isArray(object.contacts))
                    throw TypeError(".proto.ContactsArrayMessage.contacts: array expected");
                message.contacts = [];
                for (var i = 0; i < object.contacts.length; ++i) {
                    if (typeof object.contacts[i] !== "object")
                        throw TypeError(".proto.ContactsArrayMessage.contacts: object expected");
                    message.contacts[i] = $root.proto.ContactMessage.fromObject(object.contacts[i]);
                }
            }
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ContactsArrayMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            return message;
        };

        /**
         * Creates a plain object from a ContactsArrayMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ContactsArrayMessage
         * @static
         * @param {proto.ContactsArrayMessage} message ContactsArrayMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ContactsArrayMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.contacts = [];
            if (options.defaults) {
                object.displayName = "";
                object.contextInfo = null;
            }
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                object.displayName = message.displayName;
            if (message.contacts && message.contacts.length) {
                object.contacts = [];
                for (var j = 0; j < message.contacts.length; ++j)
                    object.contacts[j] = $root.proto.ContactMessage.toObject(message.contacts[j], options);
            }
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            return object;
        };

        /**
         * Converts this ContactsArrayMessage to JSON.
         * @function toJSON
         * @memberof proto.ContactsArrayMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ContactsArrayMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ContactsArrayMessage;
    })();

    proto.ContextInfo = (function() {

        /**
         * Properties of a ContextInfo.
         * @memberof proto
         * @interface IContextInfo
         * @property {string|null} [stanzaId] ContextInfo stanzaId
         * @property {string|null} [participant] ContextInfo participant
         * @property {proto.IMessage|null} [quotedMessage] ContextInfo quotedMessage
         * @property {string|null} [remoteJid] ContextInfo remoteJid
         * @property {Array.<string>|null} [mentionedJid] ContextInfo mentionedJid
         * @property {string|null} [conversionSource] ContextInfo conversionSource
         * @property {Uint8Array|null} [conversionData] ContextInfo conversionData
         * @property {number|null} [conversionDelaySeconds] ContextInfo conversionDelaySeconds
         * @property {number|null} [forwardingScore] ContextInfo forwardingScore
         * @property {boolean|null} [isForwarded] ContextInfo isForwarded
         * @property {proto.IAdReplyInfo|null} [quotedAd] ContextInfo quotedAd
         * @property {proto.IMessageKey|null} [placeholderKey] ContextInfo placeholderKey
         * @property {number|null} [expiration] ContextInfo expiration
         * @property {number|Long|null} [ephemeralSettingTimestamp] ContextInfo ephemeralSettingTimestamp
         * @property {Uint8Array|null} [ephemeralSharedSecret] ContextInfo ephemeralSharedSecret
         * @property {proto.IExternalAdReplyInfo|null} [externalAdReply] ContextInfo externalAdReply
         * @property {string|null} [entryPointConversionSource] ContextInfo entryPointConversionSource
         * @property {string|null} [entryPointConversionApp] ContextInfo entryPointConversionApp
         * @property {number|null} [entryPointConversionDelaySeconds] ContextInfo entryPointConversionDelaySeconds
         * @property {proto.IDisappearingMode|null} [disappearingMode] ContextInfo disappearingMode
         * @property {proto.IActionLink|null} [actionLink] ContextInfo actionLink
         * @property {string|null} [groupSubject] ContextInfo groupSubject
         * @property {string|null} [parentGroupJid] ContextInfo parentGroupJid
         */

        /**
         * Constructs a new ContextInfo.
         * @memberof proto
         * @classdesc Represents a ContextInfo.
         * @implements IContextInfo
         * @constructor
         * @param {proto.IContextInfo=} [properties] Properties to set
         */
        function ContextInfo(properties) {
            this.mentionedJid = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ContextInfo stanzaId.
         * @member {string} stanzaId
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.stanzaId = "";

        /**
         * ContextInfo participant.
         * @member {string} participant
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.participant = "";

        /**
         * ContextInfo quotedMessage.
         * @member {proto.IMessage|null|undefined} quotedMessage
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.quotedMessage = null;

        /**
         * ContextInfo remoteJid.
         * @member {string} remoteJid
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.remoteJid = "";

        /**
         * ContextInfo mentionedJid.
         * @member {Array.<string>} mentionedJid
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.mentionedJid = $util.emptyArray;

        /**
         * ContextInfo conversionSource.
         * @member {string} conversionSource
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.conversionSource = "";

        /**
         * ContextInfo conversionData.
         * @member {Uint8Array} conversionData
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.conversionData = $util.newBuffer([]);

        /**
         * ContextInfo conversionDelaySeconds.
         * @member {number} conversionDelaySeconds
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.conversionDelaySeconds = 0;

        /**
         * ContextInfo forwardingScore.
         * @member {number} forwardingScore
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.forwardingScore = 0;

        /**
         * ContextInfo isForwarded.
         * @member {boolean} isForwarded
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.isForwarded = false;

        /**
         * ContextInfo quotedAd.
         * @member {proto.IAdReplyInfo|null|undefined} quotedAd
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.quotedAd = null;

        /**
         * ContextInfo placeholderKey.
         * @member {proto.IMessageKey|null|undefined} placeholderKey
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.placeholderKey = null;

        /**
         * ContextInfo expiration.
         * @member {number} expiration
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.expiration = 0;

        /**
         * ContextInfo ephemeralSettingTimestamp.
         * @member {number|Long} ephemeralSettingTimestamp
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.ephemeralSettingTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * ContextInfo ephemeralSharedSecret.
         * @member {Uint8Array} ephemeralSharedSecret
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.ephemeralSharedSecret = $util.newBuffer([]);

        /**
         * ContextInfo externalAdReply.
         * @member {proto.IExternalAdReplyInfo|null|undefined} externalAdReply
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.externalAdReply = null;

        /**
         * ContextInfo entryPointConversionSource.
         * @member {string} entryPointConversionSource
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.entryPointConversionSource = "";

        /**
         * ContextInfo entryPointConversionApp.
         * @member {string} entryPointConversionApp
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.entryPointConversionApp = "";

        /**
         * ContextInfo entryPointConversionDelaySeconds.
         * @member {number} entryPointConversionDelaySeconds
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.entryPointConversionDelaySeconds = 0;

        /**
         * ContextInfo disappearingMode.
         * @member {proto.IDisappearingMode|null|undefined} disappearingMode
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.disappearingMode = null;

        /**
         * ContextInfo actionLink.
         * @member {proto.IActionLink|null|undefined} actionLink
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.actionLink = null;

        /**
         * ContextInfo groupSubject.
         * @member {string} groupSubject
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.groupSubject = "";

        /**
         * ContextInfo parentGroupJid.
         * @member {string} parentGroupJid
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.parentGroupJid = "";

        /**
         * Creates a new ContextInfo instance using the specified properties.
         * @function create
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.IContextInfo=} [properties] Properties to set
         * @returns {proto.ContextInfo} ContextInfo instance
         */
        ContextInfo.create = function create(properties) {
            return new ContextInfo(properties);
        };

        /**
         * Encodes the specified ContextInfo message. Does not implicitly {@link proto.ContextInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.IContextInfo} message ContextInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContextInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.stanzaId != null && Object.hasOwnProperty.call(message, "stanzaId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.stanzaId);
            if (message.participant != null && Object.hasOwnProperty.call(message, "participant"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.participant);
            if (message.quotedMessage != null && Object.hasOwnProperty.call(message, "quotedMessage"))
                $root.proto.Message.encode(message.quotedMessage, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.remoteJid != null && Object.hasOwnProperty.call(message, "remoteJid"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.remoteJid);
            if (message.mentionedJid != null && message.mentionedJid.length)
                for (var i = 0; i < message.mentionedJid.length; ++i)
                    writer.uint32(/* id 15, wireType 2 =*/122).string(message.mentionedJid[i]);
            if (message.conversionSource != null && Object.hasOwnProperty.call(message, "conversionSource"))
                writer.uint32(/* id 18, wireType 2 =*/146).string(message.conversionSource);
            if (message.conversionData != null && Object.hasOwnProperty.call(message, "conversionData"))
                writer.uint32(/* id 19, wireType 2 =*/154).bytes(message.conversionData);
            if (message.conversionDelaySeconds != null && Object.hasOwnProperty.call(message, "conversionDelaySeconds"))
                writer.uint32(/* id 20, wireType 0 =*/160).uint32(message.conversionDelaySeconds);
            if (message.forwardingScore != null && Object.hasOwnProperty.call(message, "forwardingScore"))
                writer.uint32(/* id 21, wireType 0 =*/168).uint32(message.forwardingScore);
            if (message.isForwarded != null && Object.hasOwnProperty.call(message, "isForwarded"))
                writer.uint32(/* id 22, wireType 0 =*/176).bool(message.isForwarded);
            if (message.quotedAd != null && Object.hasOwnProperty.call(message, "quotedAd"))
                $root.proto.AdReplyInfo.encode(message.quotedAd, writer.uint32(/* id 23, wireType 2 =*/186).fork()).ldelim();
            if (message.placeholderKey != null && Object.hasOwnProperty.call(message, "placeholderKey"))
                $root.proto.MessageKey.encode(message.placeholderKey, writer.uint32(/* id 24, wireType 2 =*/194).fork()).ldelim();
            if (message.expiration != null && Object.hasOwnProperty.call(message, "expiration"))
                writer.uint32(/* id 25, wireType 0 =*/200).uint32(message.expiration);
            if (message.ephemeralSettingTimestamp != null && Object.hasOwnProperty.call(message, "ephemeralSettingTimestamp"))
                writer.uint32(/* id 26, wireType 0 =*/208).int64(message.ephemeralSettingTimestamp);
            if (message.ephemeralSharedSecret != null && Object.hasOwnProperty.call(message, "ephemeralSharedSecret"))
                writer.uint32(/* id 27, wireType 2 =*/218).bytes(message.ephemeralSharedSecret);
            if (message.externalAdReply != null && Object.hasOwnProperty.call(message, "externalAdReply"))
                $root.proto.ExternalAdReplyInfo.encode(message.externalAdReply, writer.uint32(/* id 28, wireType 2 =*/226).fork()).ldelim();
            if (message.entryPointConversionSource != null && Object.hasOwnProperty.call(message, "entryPointConversionSource"))
                writer.uint32(/* id 29, wireType 2 =*/234).string(message.entryPointConversionSource);
            if (message.entryPointConversionApp != null && Object.hasOwnProperty.call(message, "entryPointConversionApp"))
                writer.uint32(/* id 30, wireType 2 =*/242).string(message.entryPointConversionApp);
            if (message.entryPointConversionDelaySeconds != null && Object.hasOwnProperty.call(message, "entryPointConversionDelaySeconds"))
                writer.uint32(/* id 31, wireType 0 =*/248).uint32(message.entryPointConversionDelaySeconds);
            if (message.disappearingMode != null && Object.hasOwnProperty.call(message, "disappearingMode"))
                $root.proto.DisappearingMode.encode(message.disappearingMode, writer.uint32(/* id 32, wireType 2 =*/258).fork()).ldelim();
            if (message.actionLink != null && Object.hasOwnProperty.call(message, "actionLink"))
                $root.proto.ActionLink.encode(message.actionLink, writer.uint32(/* id 33, wireType 2 =*/266).fork()).ldelim();
            if (message.groupSubject != null && Object.hasOwnProperty.call(message, "groupSubject"))
                writer.uint32(/* id 34, wireType 2 =*/274).string(message.groupSubject);
            if (message.parentGroupJid != null && Object.hasOwnProperty.call(message, "parentGroupJid"))
                writer.uint32(/* id 35, wireType 2 =*/282).string(message.parentGroupJid);
            return writer;
        };

        /**
         * Encodes the specified ContextInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.IContextInfo} message ContextInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContextInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ContextInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ContextInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ContextInfo} ContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContextInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ContextInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.stanzaId = reader.string();
                    break;
                case 2:
                    message.participant = reader.string();
                    break;
                case 3:
                    message.quotedMessage = $root.proto.Message.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.remoteJid = reader.string();
                    break;
                case 15:
                    if (!(message.mentionedJid && message.mentionedJid.length))
                        message.mentionedJid = [];
                    message.mentionedJid.push(reader.string());
                    break;
                case 18:
                    message.conversionSource = reader.string();
                    break;
                case 19:
                    message.conversionData = reader.bytes();
                    break;
                case 20:
                    message.conversionDelaySeconds = reader.uint32();
                    break;
                case 21:
                    message.forwardingScore = reader.uint32();
                    break;
                case 22:
                    message.isForwarded = reader.bool();
                    break;
                case 23:
                    message.quotedAd = $root.proto.AdReplyInfo.decode(reader, reader.uint32());
                    break;
                case 24:
                    message.placeholderKey = $root.proto.MessageKey.decode(reader, reader.uint32());
                    break;
                case 25:
                    message.expiration = reader.uint32();
                    break;
                case 26:
                    message.ephemeralSettingTimestamp = reader.int64();
                    break;
                case 27:
                    message.ephemeralSharedSecret = reader.bytes();
                    break;
                case 28:
                    message.externalAdReply = $root.proto.ExternalAdReplyInfo.decode(reader, reader.uint32());
                    break;
                case 29:
                    message.entryPointConversionSource = reader.string();
                    break;
                case 30:
                    message.entryPointConversionApp = reader.string();
                    break;
                case 31:
                    message.entryPointConversionDelaySeconds = reader.uint32();
                    break;
                case 32:
                    message.disappearingMode = $root.proto.DisappearingMode.decode(reader, reader.uint32());
                    break;
                case 33:
                    message.actionLink = $root.proto.ActionLink.decode(reader, reader.uint32());
                    break;
                case 34:
                    message.groupSubject = reader.string();
                    break;
                case 35:
                    message.parentGroupJid = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ContextInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ContextInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ContextInfo} ContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContextInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ContextInfo message.
         * @function verify
         * @memberof proto.ContextInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ContextInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                if (!$util.isString(message.stanzaId))
                    return "stanzaId: string expected";
            if (message.participant != null && message.hasOwnProperty("participant"))
                if (!$util.isString(message.participant))
                    return "participant: string expected";
            if (message.quotedMessage != null && message.hasOwnProperty("quotedMessage")) {
                var error = $root.proto.Message.verify(message.quotedMessage);
                if (error)
                    return "quotedMessage." + error;
            }
            if (message.remoteJid != null && message.hasOwnProperty("remoteJid"))
                if (!$util.isString(message.remoteJid))
                    return "remoteJid: string expected";
            if (message.mentionedJid != null && message.hasOwnProperty("mentionedJid")) {
                if (!Array.isArray(message.mentionedJid))
                    return "mentionedJid: array expected";
                for (var i = 0; i < message.mentionedJid.length; ++i)
                    if (!$util.isString(message.mentionedJid[i]))
                        return "mentionedJid: string[] expected";
            }
            if (message.conversionSource != null && message.hasOwnProperty("conversionSource"))
                if (!$util.isString(message.conversionSource))
                    return "conversionSource: string expected";
            if (message.conversionData != null && message.hasOwnProperty("conversionData"))
                if (!(message.conversionData && typeof message.conversionData.length === "number" || $util.isString(message.conversionData)))
                    return "conversionData: buffer expected";
            if (message.conversionDelaySeconds != null && message.hasOwnProperty("conversionDelaySeconds"))
                if (!$util.isInteger(message.conversionDelaySeconds))
                    return "conversionDelaySeconds: integer expected";
            if (message.forwardingScore != null && message.hasOwnProperty("forwardingScore"))
                if (!$util.isInteger(message.forwardingScore))
                    return "forwardingScore: integer expected";
            if (message.isForwarded != null && message.hasOwnProperty("isForwarded"))
                if (typeof message.isForwarded !== "boolean")
                    return "isForwarded: boolean expected";
            if (message.quotedAd != null && message.hasOwnProperty("quotedAd")) {
                var error = $root.proto.AdReplyInfo.verify(message.quotedAd);
                if (error)
                    return "quotedAd." + error;
            }
            if (message.placeholderKey != null && message.hasOwnProperty("placeholderKey")) {
                var error = $root.proto.MessageKey.verify(message.placeholderKey);
                if (error)
                    return "placeholderKey." + error;
            }
            if (message.expiration != null && message.hasOwnProperty("expiration"))
                if (!$util.isInteger(message.expiration))
                    return "expiration: integer expected";
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (!$util.isInteger(message.ephemeralSettingTimestamp) && !(message.ephemeralSettingTimestamp && $util.isInteger(message.ephemeralSettingTimestamp.low) && $util.isInteger(message.ephemeralSettingTimestamp.high)))
                    return "ephemeralSettingTimestamp: integer|Long expected";
            if (message.ephemeralSharedSecret != null && message.hasOwnProperty("ephemeralSharedSecret"))
                if (!(message.ephemeralSharedSecret && typeof message.ephemeralSharedSecret.length === "number" || $util.isString(message.ephemeralSharedSecret)))
                    return "ephemeralSharedSecret: buffer expected";
            if (message.externalAdReply != null && message.hasOwnProperty("externalAdReply")) {
                var error = $root.proto.ExternalAdReplyInfo.verify(message.externalAdReply);
                if (error)
                    return "externalAdReply." + error;
            }
            if (message.entryPointConversionSource != null && message.hasOwnProperty("entryPointConversionSource"))
                if (!$util.isString(message.entryPointConversionSource))
                    return "entryPointConversionSource: string expected";
            if (message.entryPointConversionApp != null && message.hasOwnProperty("entryPointConversionApp"))
                if (!$util.isString(message.entryPointConversionApp))
                    return "entryPointConversionApp: string expected";
            if (message.entryPointConversionDelaySeconds != null && message.hasOwnProperty("entryPointConversionDelaySeconds"))
                if (!$util.isInteger(message.entryPointConversionDelaySeconds))
                    return "entryPointConversionDelaySeconds: integer expected";
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode")) {
                var error = $root.proto.DisappearingMode.verify(message.disappearingMode);
                if (error)
                    return "disappearingMode." + error;
            }
            if (message.actionLink != null && message.hasOwnProperty("actionLink")) {
                var error = $root.proto.ActionLink.verify(message.actionLink);
                if (error)
                    return "actionLink." + error;
            }
            if (message.groupSubject != null && message.hasOwnProperty("groupSubject"))
                if (!$util.isString(message.groupSubject))
                    return "groupSubject: string expected";
            if (message.parentGroupJid != null && message.hasOwnProperty("parentGroupJid"))
                if (!$util.isString(message.parentGroupJid))
                    return "parentGroupJid: string expected";
            return null;
        };

        /**
         * Creates a ContextInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ContextInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ContextInfo} ContextInfo
         */
        ContextInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ContextInfo)
                return object;
            var message = new $root.proto.ContextInfo();
            if (object.stanzaId != null)
                message.stanzaId = String(object.stanzaId);
            if (object.participant != null)
                message.participant = String(object.participant);
            if (object.quotedMessage != null) {
                if (typeof object.quotedMessage !== "object")
                    throw TypeError(".proto.ContextInfo.quotedMessage: object expected");
                message.quotedMessage = $root.proto.Message.fromObject(object.quotedMessage);
            }
            if (object.remoteJid != null)
                message.remoteJid = String(object.remoteJid);
            if (object.mentionedJid) {
                if (!Array.isArray(object.mentionedJid))
                    throw TypeError(".proto.ContextInfo.mentionedJid: array expected");
                message.mentionedJid = [];
                for (var i = 0; i < object.mentionedJid.length; ++i)
                    message.mentionedJid[i] = String(object.mentionedJid[i]);
            }
            if (object.conversionSource != null)
                message.conversionSource = String(object.conversionSource);
            if (object.conversionData != null)
                if (typeof object.conversionData === "string")
                    $util.base64.decode(object.conversionData, message.conversionData = $util.newBuffer($util.base64.length(object.conversionData)), 0);
                else if (object.conversionData.length)
                    message.conversionData = object.conversionData;
            if (object.conversionDelaySeconds != null)
                message.conversionDelaySeconds = object.conversionDelaySeconds >>> 0;
            if (object.forwardingScore != null)
                message.forwardingScore = object.forwardingScore >>> 0;
            if (object.isForwarded != null)
                message.isForwarded = Boolean(object.isForwarded);
            if (object.quotedAd != null) {
                if (typeof object.quotedAd !== "object")
                    throw TypeError(".proto.ContextInfo.quotedAd: object expected");
                message.quotedAd = $root.proto.AdReplyInfo.fromObject(object.quotedAd);
            }
            if (object.placeholderKey != null) {
                if (typeof object.placeholderKey !== "object")
                    throw TypeError(".proto.ContextInfo.placeholderKey: object expected");
                message.placeholderKey = $root.proto.MessageKey.fromObject(object.placeholderKey);
            }
            if (object.expiration != null)
                message.expiration = object.expiration >>> 0;
            if (object.ephemeralSettingTimestamp != null)
                if ($util.Long)
                    (message.ephemeralSettingTimestamp = $util.Long.fromValue(object.ephemeralSettingTimestamp)).unsigned = false;
                else if (typeof object.ephemeralSettingTimestamp === "string")
                    message.ephemeralSettingTimestamp = parseInt(object.ephemeralSettingTimestamp, 10);
                else if (typeof object.ephemeralSettingTimestamp === "number")
                    message.ephemeralSettingTimestamp = object.ephemeralSettingTimestamp;
                else if (typeof object.ephemeralSettingTimestamp === "object")
                    message.ephemeralSettingTimestamp = new $util.LongBits(object.ephemeralSettingTimestamp.low >>> 0, object.ephemeralSettingTimestamp.high >>> 0).toNumber();
            if (object.ephemeralSharedSecret != null)
                if (typeof object.ephemeralSharedSecret === "string")
                    $util.base64.decode(object.ephemeralSharedSecret, message.ephemeralSharedSecret = $util.newBuffer($util.base64.length(object.ephemeralSharedSecret)), 0);
                else if (object.ephemeralSharedSecret.length)
                    message.ephemeralSharedSecret = object.ephemeralSharedSecret;
            if (object.externalAdReply != null) {
                if (typeof object.externalAdReply !== "object")
                    throw TypeError(".proto.ContextInfo.externalAdReply: object expected");
                message.externalAdReply = $root.proto.ExternalAdReplyInfo.fromObject(object.externalAdReply);
            }
            if (object.entryPointConversionSource != null)
                message.entryPointConversionSource = String(object.entryPointConversionSource);
            if (object.entryPointConversionApp != null)
                message.entryPointConversionApp = String(object.entryPointConversionApp);
            if (object.entryPointConversionDelaySeconds != null)
                message.entryPointConversionDelaySeconds = object.entryPointConversionDelaySeconds >>> 0;
            if (object.disappearingMode != null) {
                if (typeof object.disappearingMode !== "object")
                    throw TypeError(".proto.ContextInfo.disappearingMode: object expected");
                message.disappearingMode = $root.proto.DisappearingMode.fromObject(object.disappearingMode);
            }
            if (object.actionLink != null) {
                if (typeof object.actionLink !== "object")
                    throw TypeError(".proto.ContextInfo.actionLink: object expected");
                message.actionLink = $root.proto.ActionLink.fromObject(object.actionLink);
            }
            if (object.groupSubject != null)
                message.groupSubject = String(object.groupSubject);
            if (object.parentGroupJid != null)
                message.parentGroupJid = String(object.parentGroupJid);
            return message;
        };

        /**
         * Creates a plain object from a ContextInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.ContextInfo} message ContextInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ContextInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.mentionedJid = [];
            if (options.defaults) {
                object.stanzaId = "";
                object.participant = "";
                object.quotedMessage = null;
                object.remoteJid = "";
                object.conversionSource = "";
                if (options.bytes === String)
                    object.conversionData = "";
                else {
                    object.conversionData = [];
                    if (options.bytes !== Array)
                        object.conversionData = $util.newBuffer(object.conversionData);
                }
                object.conversionDelaySeconds = 0;
                object.forwardingScore = 0;
                object.isForwarded = false;
                object.quotedAd = null;
                object.placeholderKey = null;
                object.expiration = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.ephemeralSettingTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.ephemeralSettingTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.ephemeralSharedSecret = "";
                else {
                    object.ephemeralSharedSecret = [];
                    if (options.bytes !== Array)
                        object.ephemeralSharedSecret = $util.newBuffer(object.ephemeralSharedSecret);
                }
                object.externalAdReply = null;
                object.entryPointConversionSource = "";
                object.entryPointConversionApp = "";
                object.entryPointConversionDelaySeconds = 0;
                object.disappearingMode = null;
                object.actionLink = null;
                object.groupSubject = "";
                object.parentGroupJid = "";
            }
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                object.stanzaId = message.stanzaId;
            if (message.participant != null && message.hasOwnProperty("participant"))
                object.participant = message.participant;
            if (message.quotedMessage != null && message.hasOwnProperty("quotedMessage"))
                object.quotedMessage = $root.proto.Message.toObject(message.quotedMessage, options);
            if (message.remoteJid != null && message.hasOwnProperty("remoteJid"))
                object.remoteJid = message.remoteJid;
            if (message.mentionedJid && message.mentionedJid.length) {
                object.mentionedJid = [];
                for (var j = 0; j < message.mentionedJid.length; ++j)
                    object.mentionedJid[j] = message.mentionedJid[j];
            }
            if (message.conversionSource != null && message.hasOwnProperty("conversionSource"))
                object.conversionSource = message.conversionSource;
            if (message.conversionData != null && message.hasOwnProperty("conversionData"))
                object.conversionData = options.bytes === String ? $util.base64.encode(message.conversionData, 0, message.conversionData.length) : options.bytes === Array ? Array.prototype.slice.call(message.conversionData) : message.conversionData;
            if (message.conversionDelaySeconds != null && message.hasOwnProperty("conversionDelaySeconds"))
                object.conversionDelaySeconds = message.conversionDelaySeconds;
            if (message.forwardingScore != null && message.hasOwnProperty("forwardingScore"))
                object.forwardingScore = message.forwardingScore;
            if (message.isForwarded != null && message.hasOwnProperty("isForwarded"))
                object.isForwarded = message.isForwarded;
            if (message.quotedAd != null && message.hasOwnProperty("quotedAd"))
                object.quotedAd = $root.proto.AdReplyInfo.toObject(message.quotedAd, options);
            if (message.placeholderKey != null && message.hasOwnProperty("placeholderKey"))
                object.placeholderKey = $root.proto.MessageKey.toObject(message.placeholderKey, options);
            if (message.expiration != null && message.hasOwnProperty("expiration"))
                object.expiration = message.expiration;
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (typeof message.ephemeralSettingTimestamp === "number")
                    object.ephemeralSettingTimestamp = options.longs === String ? String(message.ephemeralSettingTimestamp) : message.ephemeralSettingTimestamp;
                else
                    object.ephemeralSettingTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.ephemeralSettingTimestamp) : options.longs === Number ? new $util.LongBits(message.ephemeralSettingTimestamp.low >>> 0, message.ephemeralSettingTimestamp.high >>> 0).toNumber() : message.ephemeralSettingTimestamp;
            if (message.ephemeralSharedSecret != null && message.hasOwnProperty("ephemeralSharedSecret"))
                object.ephemeralSharedSecret = options.bytes === String ? $util.base64.encode(message.ephemeralSharedSecret, 0, message.ephemeralSharedSecret.length) : options.bytes === Array ? Array.prototype.slice.call(message.ephemeralSharedSecret) : message.ephemeralSharedSecret;
            if (message.externalAdReply != null && message.hasOwnProperty("externalAdReply"))
                object.externalAdReply = $root.proto.ExternalAdReplyInfo.toObject(message.externalAdReply, options);
            if (message.entryPointConversionSource != null && message.hasOwnProperty("entryPointConversionSource"))
                object.entryPointConversionSource = message.entryPointConversionSource;
            if (message.entryPointConversionApp != null && message.hasOwnProperty("entryPointConversionApp"))
                object.entryPointConversionApp = message.entryPointConversionApp;
            if (message.entryPointConversionDelaySeconds != null && message.hasOwnProperty("entryPointConversionDelaySeconds"))
                object.entryPointConversionDelaySeconds = message.entryPointConversionDelaySeconds;
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode"))
                object.disappearingMode = $root.proto.DisappearingMode.toObject(message.disappearingMode, options);
            if (message.actionLink != null && message.hasOwnProperty("actionLink"))
                object.actionLink = $root.proto.ActionLink.toObject(message.actionLink, options);
            if (message.groupSubject != null && message.hasOwnProperty("groupSubject"))
                object.groupSubject = message.groupSubject;
            if (message.parentGroupJid != null && message.hasOwnProperty("parentGroupJid"))
                object.parentGroupJid = message.parentGroupJid;
            return object;
        };

        /**
         * Converts this ContextInfo to JSON.
         * @function toJSON
         * @memberof proto.ContextInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ContextInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ContextInfo;
    })();

    proto.Conversation = (function() {

        /**
         * Properties of a Conversation.
         * @memberof proto
         * @interface IConversation
         * @property {string} id Conversation id
         * @property {Array.<proto.IHistorySyncMsg>|null} [messages] Conversation messages
         * @property {string|null} [newJid] Conversation newJid
         * @property {string|null} [oldJid] Conversation oldJid
         * @property {number|Long|null} [lastMsgTimestamp] Conversation lastMsgTimestamp
         * @property {number|null} [unreadCount] Conversation unreadCount
         * @property {boolean|null} [readOnly] Conversation readOnly
         * @property {boolean|null} [endOfHistoryTransfer] Conversation endOfHistoryTransfer
         * @property {number|null} [ephemeralExpiration] Conversation ephemeralExpiration
         * @property {number|Long|null} [ephemeralSettingTimestamp] Conversation ephemeralSettingTimestamp
         * @property {proto.Conversation.ConversationEndOfHistoryTransferType|null} [endOfHistoryTransferType] Conversation endOfHistoryTransferType
         * @property {number|Long|null} [conversationTimestamp] Conversation conversationTimestamp
         * @property {string|null} [name] Conversation name
         * @property {string|null} [pHash] Conversation pHash
         * @property {boolean|null} [notSpam] Conversation notSpam
         * @property {boolean|null} [archived] Conversation archived
         * @property {proto.IDisappearingMode|null} [disappearingMode] Conversation disappearingMode
         * @property {number|null} [unreadMentionCount] Conversation unreadMentionCount
         * @property {boolean|null} [markedAsUnread] Conversation markedAsUnread
         * @property {Array.<proto.IGroupParticipant>|null} [participant] Conversation participant
         * @property {Uint8Array|null} [tcToken] Conversation tcToken
         * @property {number|Long|null} [tcTokenTimestamp] Conversation tcTokenTimestamp
         * @property {Uint8Array|null} [contactPrimaryIdentityKey] Conversation contactPrimaryIdentityKey
         * @property {number|null} [pinned] Conversation pinned
         * @property {number|Long|null} [muteEndTime] Conversation muteEndTime
         * @property {proto.IWallpaperSettings|null} [wallpaper] Conversation wallpaper
         * @property {proto.MediaVisibility|null} [mediaVisibility] Conversation mediaVisibility
         * @property {number|Long|null} [tcTokenSenderTimestamp] Conversation tcTokenSenderTimestamp
         * @property {boolean|null} [suspended] Conversation suspended
         * @property {boolean|null} [terminated] Conversation terminated
         * @property {number|Long|null} [createdAt] Conversation createdAt
         * @property {string|null} [createdBy] Conversation createdBy
         * @property {string|null} [description] Conversation description
         * @property {boolean|null} [support] Conversation support
         * @property {boolean|null} [isParentGroup] Conversation isParentGroup
         * @property {boolean|null} [isDefaultSubgroup] Conversation isDefaultSubgroup
         * @property {string|null} [parentGroupId] Conversation parentGroupId
         * @property {string|null} [displayName] Conversation displayName
         * @property {string|null} [pnJid] Conversation pnJid
         * @property {boolean|null} [selfMasked] Conversation selfMasked
         */

        /**
         * Constructs a new Conversation.
         * @memberof proto
         * @classdesc Represents a Conversation.
         * @implements IConversation
         * @constructor
         * @param {proto.IConversation=} [properties] Properties to set
         */
        function Conversation(properties) {
            this.messages = [];
            this.participant = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Conversation id.
         * @member {string} id
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.id = "";

        /**
         * Conversation messages.
         * @member {Array.<proto.IHistorySyncMsg>} messages
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.messages = $util.emptyArray;

        /**
         * Conversation newJid.
         * @member {string} newJid
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.newJid = "";

        /**
         * Conversation oldJid.
         * @member {string} oldJid
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.oldJid = "";

        /**
         * Conversation lastMsgTimestamp.
         * @member {number|Long} lastMsgTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.lastMsgTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation unreadCount.
         * @member {number} unreadCount
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.unreadCount = 0;

        /**
         * Conversation readOnly.
         * @member {boolean} readOnly
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.readOnly = false;

        /**
         * Conversation endOfHistoryTransfer.
         * @member {boolean} endOfHistoryTransfer
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.endOfHistoryTransfer = false;

        /**
         * Conversation ephemeralExpiration.
         * @member {number} ephemeralExpiration
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.ephemeralExpiration = 0;

        /**
         * Conversation ephemeralSettingTimestamp.
         * @member {number|Long} ephemeralSettingTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.ephemeralSettingTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Conversation endOfHistoryTransferType.
         * @member {proto.Conversation.ConversationEndOfHistoryTransferType} endOfHistoryTransferType
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.endOfHistoryTransferType = 0;

        /**
         * Conversation conversationTimestamp.
         * @member {number|Long} conversationTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.conversationTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation name.
         * @member {string} name
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.name = "";

        /**
         * Conversation pHash.
         * @member {string} pHash
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.pHash = "";

        /**
         * Conversation notSpam.
         * @member {boolean} notSpam
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.notSpam = false;

        /**
         * Conversation archived.
         * @member {boolean} archived
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.archived = false;

        /**
         * Conversation disappearingMode.
         * @member {proto.IDisappearingMode|null|undefined} disappearingMode
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.disappearingMode = null;

        /**
         * Conversation unreadMentionCount.
         * @member {number} unreadMentionCount
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.unreadMentionCount = 0;

        /**
         * Conversation markedAsUnread.
         * @member {boolean} markedAsUnread
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.markedAsUnread = false;

        /**
         * Conversation participant.
         * @member {Array.<proto.IGroupParticipant>} participant
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.participant = $util.emptyArray;

        /**
         * Conversation tcToken.
         * @member {Uint8Array} tcToken
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.tcToken = $util.newBuffer([]);

        /**
         * Conversation tcTokenTimestamp.
         * @member {number|Long} tcTokenTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.tcTokenTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation contactPrimaryIdentityKey.
         * @member {Uint8Array} contactPrimaryIdentityKey
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.contactPrimaryIdentityKey = $util.newBuffer([]);

        /**
         * Conversation pinned.
         * @member {number} pinned
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.pinned = 0;

        /**
         * Conversation muteEndTime.
         * @member {number|Long} muteEndTime
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.muteEndTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation wallpaper.
         * @member {proto.IWallpaperSettings|null|undefined} wallpaper
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.wallpaper = null;

        /**
         * Conversation mediaVisibility.
         * @member {proto.MediaVisibility} mediaVisibility
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.mediaVisibility = 0;

        /**
         * Conversation tcTokenSenderTimestamp.
         * @member {number|Long} tcTokenSenderTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.tcTokenSenderTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation suspended.
         * @member {boolean} suspended
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.suspended = false;

        /**
         * Conversation terminated.
         * @member {boolean} terminated
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.terminated = false;

        /**
         * Conversation createdAt.
         * @member {number|Long} createdAt
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.createdAt = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation createdBy.
         * @member {string} createdBy
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.createdBy = "";

        /**
         * Conversation description.
         * @member {string} description
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.description = "";

        /**
         * Conversation support.
         * @member {boolean} support
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.support = false;

        /**
         * Conversation isParentGroup.
         * @member {boolean} isParentGroup
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.isParentGroup = false;

        /**
         * Conversation isDefaultSubgroup.
         * @member {boolean} isDefaultSubgroup
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.isDefaultSubgroup = false;

        /**
         * Conversation parentGroupId.
         * @member {string} parentGroupId
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.parentGroupId = "";

        /**
         * Conversation displayName.
         * @member {string} displayName
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.displayName = "";

        /**
         * Conversation pnJid.
         * @member {string} pnJid
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.pnJid = "";

        /**
         * Conversation selfMasked.
         * @member {boolean} selfMasked
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.selfMasked = false;

        /**
         * Creates a new Conversation instance using the specified properties.
         * @function create
         * @memberof proto.Conversation
         * @static
         * @param {proto.IConversation=} [properties] Properties to set
         * @returns {proto.Conversation} Conversation instance
         */
        Conversation.create = function create(properties) {
            return new Conversation(properties);
        };

        /**
         * Encodes the specified Conversation message. Does not implicitly {@link proto.Conversation.verify|verify} messages.
         * @function encode
         * @memberof proto.Conversation
         * @static
         * @param {proto.IConversation} message Conversation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Conversation.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            if (message.messages != null && message.messages.length)
                for (var i = 0; i < message.messages.length; ++i)
                    $root.proto.HistorySyncMsg.encode(message.messages[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.newJid != null && Object.hasOwnProperty.call(message, "newJid"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.newJid);
            if (message.oldJid != null && Object.hasOwnProperty.call(message, "oldJid"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.oldJid);
            if (message.lastMsgTimestamp != null && Object.hasOwnProperty.call(message, "lastMsgTimestamp"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint64(message.lastMsgTimestamp);
            if (message.unreadCount != null && Object.hasOwnProperty.call(message, "unreadCount"))
                writer.uint32(/* id 6, wireType 0 =*/48).uint32(message.unreadCount);
            if (message.readOnly != null && Object.hasOwnProperty.call(message, "readOnly"))
                writer.uint32(/* id 7, wireType 0 =*/56).bool(message.readOnly);
            if (message.endOfHistoryTransfer != null && Object.hasOwnProperty.call(message, "endOfHistoryTransfer"))
                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.endOfHistoryTransfer);
            if (message.ephemeralExpiration != null && Object.hasOwnProperty.call(message, "ephemeralExpiration"))
                writer.uint32(/* id 9, wireType 0 =*/72).uint32(message.ephemeralExpiration);
            if (message.ephemeralSettingTimestamp != null && Object.hasOwnProperty.call(message, "ephemeralSettingTimestamp"))
                writer.uint32(/* id 10, wireType 0 =*/80).int64(message.ephemeralSettingTimestamp);
            if (message.endOfHistoryTransferType != null && Object.hasOwnProperty.call(message, "endOfHistoryTransferType"))
                writer.uint32(/* id 11, wireType 0 =*/88).int32(message.endOfHistoryTransferType);
            if (message.conversationTimestamp != null && Object.hasOwnProperty.call(message, "conversationTimestamp"))
                writer.uint32(/* id 12, wireType 0 =*/96).uint64(message.conversationTimestamp);
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 13, wireType 2 =*/106).string(message.name);
            if (message.pHash != null && Object.hasOwnProperty.call(message, "pHash"))
                writer.uint32(/* id 14, wireType 2 =*/114).string(message.pHash);
            if (message.notSpam != null && Object.hasOwnProperty.call(message, "notSpam"))
                writer.uint32(/* id 15, wireType 0 =*/120).bool(message.notSpam);
            if (message.archived != null && Object.hasOwnProperty.call(message, "archived"))
                writer.uint32(/* id 16, wireType 0 =*/128).bool(message.archived);
            if (message.disappearingMode != null && Object.hasOwnProperty.call(message, "disappearingMode"))
                $root.proto.DisappearingMode.encode(message.disappearingMode, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.unreadMentionCount != null && Object.hasOwnProperty.call(message, "unreadMentionCount"))
                writer.uint32(/* id 18, wireType 0 =*/144).uint32(message.unreadMentionCount);
            if (message.markedAsUnread != null && Object.hasOwnProperty.call(message, "markedAsUnread"))
                writer.uint32(/* id 19, wireType 0 =*/152).bool(message.markedAsUnread);
            if (message.participant != null && message.participant.length)
                for (var i = 0; i < message.participant.length; ++i)
                    $root.proto.GroupParticipant.encode(message.participant[i], writer.uint32(/* id 20, wireType 2 =*/162).fork()).ldelim();
            if (message.tcToken != null && Object.hasOwnProperty.call(message, "tcToken"))
                writer.uint32(/* id 21, wireType 2 =*/170).bytes(message.tcToken);
            if (message.tcTokenTimestamp != null && Object.hasOwnProperty.call(message, "tcTokenTimestamp"))
                writer.uint32(/* id 22, wireType 0 =*/176).uint64(message.tcTokenTimestamp);
            if (message.contactPrimaryIdentityKey != null && Object.hasOwnProperty.call(message, "contactPrimaryIdentityKey"))
                writer.uint32(/* id 23, wireType 2 =*/186).bytes(message.contactPrimaryIdentityKey);
            if (message.pinned != null && Object.hasOwnProperty.call(message, "pinned"))
                writer.uint32(/* id 24, wireType 0 =*/192).uint32(message.pinned);
            if (message.muteEndTime != null && Object.hasOwnProperty.call(message, "muteEndTime"))
                writer.uint32(/* id 25, wireType 0 =*/200).uint64(message.muteEndTime);
            if (message.wallpaper != null && Object.hasOwnProperty.call(message, "wallpaper"))
                $root.proto.WallpaperSettings.encode(message.wallpaper, writer.uint32(/* id 26, wireType 2 =*/210).fork()).ldelim();
            if (message.mediaVisibility != null && Object.hasOwnProperty.call(message, "mediaVisibility"))
                writer.uint32(/* id 27, wireType 0 =*/216).int32(message.mediaVisibility);
            if (message.tcTokenSenderTimestamp != null && Object.hasOwnProperty.call(message, "tcTokenSenderTimestamp"))
                writer.uint32(/* id 28, wireType 0 =*/224).uint64(message.tcTokenSenderTimestamp);
            if (message.suspended != null && Object.hasOwnProperty.call(message, "suspended"))
                writer.uint32(/* id 29, wireType 0 =*/232).bool(message.suspended);
            if (message.terminated != null && Object.hasOwnProperty.call(message, "terminated"))
                writer.uint32(/* id 30, wireType 0 =*/240).bool(message.terminated);
            if (message.createdAt != null && Object.hasOwnProperty.call(message, "createdAt"))
                writer.uint32(/* id 31, wireType 0 =*/248).uint64(message.createdAt);
            if (message.createdBy != null && Object.hasOwnProperty.call(message, "createdBy"))
                writer.uint32(/* id 32, wireType 2 =*/258).string(message.createdBy);
            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                writer.uint32(/* id 33, wireType 2 =*/266).string(message.description);
            if (message.support != null && Object.hasOwnProperty.call(message, "support"))
                writer.uint32(/* id 34, wireType 0 =*/272).bool(message.support);
            if (message.isParentGroup != null && Object.hasOwnProperty.call(message, "isParentGroup"))
                writer.uint32(/* id 35, wireType 0 =*/280).bool(message.isParentGroup);
            if (message.isDefaultSubgroup != null && Object.hasOwnProperty.call(message, "isDefaultSubgroup"))
                writer.uint32(/* id 36, wireType 0 =*/288).bool(message.isDefaultSubgroup);
            if (message.parentGroupId != null && Object.hasOwnProperty.call(message, "parentGroupId"))
                writer.uint32(/* id 37, wireType 2 =*/298).string(message.parentGroupId);
            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                writer.uint32(/* id 38, wireType 2 =*/306).string(message.displayName);
            if (message.pnJid != null && Object.hasOwnProperty.call(message, "pnJid"))
                writer.uint32(/* id 39, wireType 2 =*/314).string(message.pnJid);
            if (message.selfMasked != null && Object.hasOwnProperty.call(message, "selfMasked"))
                writer.uint32(/* id 40, wireType 0 =*/320).bool(message.selfMasked);
            return writer;
        };

        /**
         * Encodes the specified Conversation message, length delimited. Does not implicitly {@link proto.Conversation.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Conversation
         * @static
         * @param {proto.IConversation} message Conversation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Conversation.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Conversation message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Conversation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Conversation} Conversation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Conversation.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Conversation();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.string();
                    break;
                case 2:
                    if (!(message.messages && message.messages.length))
                        message.messages = [];
                    message.messages.push($root.proto.HistorySyncMsg.decode(reader, reader.uint32()));
                    break;
                case 3:
                    message.newJid = reader.string();
                    break;
                case 4:
                    message.oldJid = reader.string();
                    break;
                case 5:
                    message.lastMsgTimestamp = reader.uint64();
                    break;
                case 6:
                    message.unreadCount = reader.uint32();
                    break;
                case 7:
                    message.readOnly = reader.bool();
                    break;
                case 8:
                    message.endOfHistoryTransfer = reader.bool();
                    break;
                case 9:
                    message.ephemeralExpiration = reader.uint32();
                    break;
                case 10:
                    message.ephemeralSettingTimestamp = reader.int64();
                    break;
                case 11:
                    message.endOfHistoryTransferType = reader.int32();
                    break;
                case 12:
                    message.conversationTimestamp = reader.uint64();
                    break;
                case 13:
                    message.name = reader.string();
                    break;
                case 14:
                    message.pHash = reader.string();
                    break;
                case 15:
                    message.notSpam = reader.bool();
                    break;
                case 16:
                    message.archived = reader.bool();
                    break;
                case 17:
                    message.disappearingMode = $root.proto.DisappearingMode.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.unreadMentionCount = reader.uint32();
                    break;
                case 19:
                    message.markedAsUnread = reader.bool();
                    break;
                case 20:
                    if (!(message.participant && message.participant.length))
                        message.participant = [];
                    message.participant.push($root.proto.GroupParticipant.decode(reader, reader.uint32()));
                    break;
                case 21:
                    message.tcToken = reader.bytes();
                    break;
                case 22:
                    message.tcTokenTimestamp = reader.uint64();
                    break;
                case 23:
                    message.contactPrimaryIdentityKey = reader.bytes();
                    break;
                case 24:
                    message.pinned = reader.uint32();
                    break;
                case 25:
                    message.muteEndTime = reader.uint64();
                    break;
                case 26:
                    message.wallpaper = $root.proto.WallpaperSettings.decode(reader, reader.uint32());
                    break;
                case 27:
                    message.mediaVisibility = reader.int32();
                    break;
                case 28:
                    message.tcTokenSenderTimestamp = reader.uint64();
                    break;
                case 29:
                    message.suspended = reader.bool();
                    break;
                case 30:
                    message.terminated = reader.bool();
                    break;
                case 31:
                    message.createdAt = reader.uint64();
                    break;
                case 32:
                    message.createdBy = reader.string();
                    break;
                case 33:
                    message.description = reader.string();
                    break;
                case 34:
                    message.support = reader.bool();
                    break;
                case 35:
                    message.isParentGroup = reader.bool();
                    break;
                case 36:
                    message.isDefaultSubgroup = reader.bool();
                    break;
                case 37:
                    message.parentGroupId = reader.string();
                    break;
                case 38:
                    message.displayName = reader.string();
                    break;
                case 39:
                    message.pnJid = reader.string();
                    break;
                case 40:
                    message.selfMasked = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("id"))
                throw $util.ProtocolError("missing required 'id'", { instance: message });
            return message;
        };

        /**
         * Decodes a Conversation message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Conversation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Conversation} Conversation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Conversation.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Conversation message.
         * @function verify
         * @memberof proto.Conversation
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Conversation.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (!$util.isString(message.id))
                return "id: string expected";
            if (message.messages != null && message.hasOwnProperty("messages")) {
                if (!Array.isArray(message.messages))
                    return "messages: array expected";
                for (var i = 0; i < message.messages.length; ++i) {
                    var error = $root.proto.HistorySyncMsg.verify(message.messages[i]);
                    if (error)
                        return "messages." + error;
                }
            }
            if (message.newJid != null && message.hasOwnProperty("newJid"))
                if (!$util.isString(message.newJid))
                    return "newJid: string expected";
            if (message.oldJid != null && message.hasOwnProperty("oldJid"))
                if (!$util.isString(message.oldJid))
                    return "oldJid: string expected";
            if (message.lastMsgTimestamp != null && message.hasOwnProperty("lastMsgTimestamp"))
                if (!$util.isInteger(message.lastMsgTimestamp) && !(message.lastMsgTimestamp && $util.isInteger(message.lastMsgTimestamp.low) && $util.isInteger(message.lastMsgTimestamp.high)))
                    return "lastMsgTimestamp: integer|Long expected";
            if (message.unreadCount != null && message.hasOwnProperty("unreadCount"))
                if (!$util.isInteger(message.unreadCount))
                    return "unreadCount: integer expected";
            if (message.readOnly != null && message.hasOwnProperty("readOnly"))
                if (typeof message.readOnly !== "boolean")
                    return "readOnly: boolean expected";
            if (message.endOfHistoryTransfer != null && message.hasOwnProperty("endOfHistoryTransfer"))
                if (typeof message.endOfHistoryTransfer !== "boolean")
                    return "endOfHistoryTransfer: boolean expected";
            if (message.ephemeralExpiration != null && message.hasOwnProperty("ephemeralExpiration"))
                if (!$util.isInteger(message.ephemeralExpiration))
                    return "ephemeralExpiration: integer expected";
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (!$util.isInteger(message.ephemeralSettingTimestamp) && !(message.ephemeralSettingTimestamp && $util.isInteger(message.ephemeralSettingTimestamp.low) && $util.isInteger(message.ephemeralSettingTimestamp.high)))
                    return "ephemeralSettingTimestamp: integer|Long expected";
            if (message.endOfHistoryTransferType != null && message.hasOwnProperty("endOfHistoryTransferType"))
                switch (message.endOfHistoryTransferType) {
                default:
                    return "endOfHistoryTransferType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.conversationTimestamp != null && message.hasOwnProperty("conversationTimestamp"))
                if (!$util.isInteger(message.conversationTimestamp) && !(message.conversationTimestamp && $util.isInteger(message.conversationTimestamp.low) && $util.isInteger(message.conversationTimestamp.high)))
                    return "conversationTimestamp: integer|Long expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            if (message.pHash != null && message.hasOwnProperty("pHash"))
                if (!$util.isString(message.pHash))
                    return "pHash: string expected";
            if (message.notSpam != null && message.hasOwnProperty("notSpam"))
                if (typeof message.notSpam !== "boolean")
                    return "notSpam: boolean expected";
            if (message.archived != null && message.hasOwnProperty("archived"))
                if (typeof message.archived !== "boolean")
                    return "archived: boolean expected";
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode")) {
                var error = $root.proto.DisappearingMode.verify(message.disappearingMode);
                if (error)
                    return "disappearingMode." + error;
            }
            if (message.unreadMentionCount != null && message.hasOwnProperty("unreadMentionCount"))
                if (!$util.isInteger(message.unreadMentionCount))
                    return "unreadMentionCount: integer expected";
            if (message.markedAsUnread != null && message.hasOwnProperty("markedAsUnread"))
                if (typeof message.markedAsUnread !== "boolean")
                    return "markedAsUnread: boolean expected";
            if (message.participant != null && message.hasOwnProperty("participant")) {
                if (!Array.isArray(message.participant))
                    return "participant: array expected";
                for (var i = 0; i < message.participant.length; ++i) {
                    var error = $root.proto.GroupParticipant.verify(message.participant[i]);
                    if (error)
                        return "participant." + error;
                }
            }
            if (message.tcToken != null && message.hasOwnProperty("tcToken"))
                if (!(message.tcToken && typeof message.tcToken.length === "number" || $util.isString(message.tcToken)))
                    return "tcToken: buffer expected";
            if (message.tcTokenTimestamp != null && message.hasOwnProperty("tcTokenTimestamp"))
                if (!$util.isInteger(message.tcTokenTimestamp) && !(message.tcTokenTimestamp && $util.isInteger(message.tcTokenTimestamp.low) && $util.isInteger(message.tcTokenTimestamp.high)))
                    return "tcTokenTimestamp: integer|Long expected";
            if (message.contactPrimaryIdentityKey != null && message.hasOwnProperty("contactPrimaryIdentityKey"))
                if (!(message.contactPrimaryIdentityKey && typeof message.contactPrimaryIdentityKey.length === "number" || $util.isString(message.contactPrimaryIdentityKey)))
                    return "contactPrimaryIdentityKey: buffer expected";
            if (message.pinned != null && message.hasOwnProperty("pinned"))
                if (!$util.isInteger(message.pinned))
                    return "pinned: integer expected";
            if (message.muteEndTime != null && message.hasOwnProperty("muteEndTime"))
                if (!$util.isInteger(message.muteEndTime) && !(message.muteEndTime && $util.isInteger(message.muteEndTime.low) && $util.isInteger(message.muteEndTime.high)))
                    return "muteEndTime: integer|Long expected";
            if (message.wallpaper != null && message.hasOwnProperty("wallpaper")) {
                var error = $root.proto.WallpaperSettings.verify(message.wallpaper);
                if (error)
                    return "wallpaper." + error;
            }
            if (message.mediaVisibility != null && message.hasOwnProperty("mediaVisibility"))
                switch (message.mediaVisibility) {
                default:
                    return "mediaVisibility: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.tcTokenSenderTimestamp != null && message.hasOwnProperty("tcTokenSenderTimestamp"))
                if (!$util.isInteger(message.tcTokenSenderTimestamp) && !(message.tcTokenSenderTimestamp && $util.isInteger(message.tcTokenSenderTimestamp.low) && $util.isInteger(message.tcTokenSenderTimestamp.high)))
                    return "tcTokenSenderTimestamp: integer|Long expected";
            if (message.suspended != null && message.hasOwnProperty("suspended"))
                if (typeof message.suspended !== "boolean")
                    return "suspended: boolean expected";
            if (message.terminated != null && message.hasOwnProperty("terminated"))
                if (typeof message.terminated !== "boolean")
                    return "terminated: boolean expected";
            if (message.createdAt != null && message.hasOwnProperty("createdAt"))
                if (!$util.isInteger(message.createdAt) && !(message.createdAt && $util.isInteger(message.createdAt.low) && $util.isInteger(message.createdAt.high)))
                    return "createdAt: integer|Long expected";
            if (message.createdBy != null && message.hasOwnProperty("createdBy"))
                if (!$util.isString(message.createdBy))
                    return "createdBy: string expected";
            if (message.description != null && message.hasOwnProperty("description"))
                if (!$util.isString(message.description))
                    return "description: string expected";
            if (message.support != null && message.hasOwnProperty("support"))
                if (typeof message.support !== "boolean")
                    return "support: boolean expected";
            if (message.isParentGroup != null && message.hasOwnProperty("isParentGroup"))
                if (typeof message.isParentGroup !== "boolean")
                    return "isParentGroup: boolean expected";
            if (message.isDefaultSubgroup != null && message.hasOwnProperty("isDefaultSubgroup"))
                if (typeof message.isDefaultSubgroup !== "boolean")
                    return "isDefaultSubgroup: boolean expected";
            if (message.parentGroupId != null && message.hasOwnProperty("parentGroupId"))
                if (!$util.isString(message.parentGroupId))
                    return "parentGroupId: string expected";
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                if (!$util.isString(message.displayName))
                    return "displayName: string expected";
            if (message.pnJid != null && message.hasOwnProperty("pnJid"))
                if (!$util.isString(message.pnJid))
                    return "pnJid: string expected";
            if (message.selfMasked != null && message.hasOwnProperty("selfMasked"))
                if (typeof message.selfMasked !== "boolean")
                    return "selfMasked: boolean expected";
            return null;
        };

        /**
         * Creates a Conversation message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Conversation
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Conversation} Conversation
         */
        Conversation.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Conversation)
                return object;
            var message = new $root.proto.Conversation();
            if (object.id != null)
                message.id = String(object.id);
            if (object.messages) {
                if (!Array.isArray(object.messages))
                    throw TypeError(".proto.Conversation.messages: array expected");
                message.messages = [];
                for (var i = 0; i < object.messages.length; ++i) {
                    if (typeof object.messages[i] !== "object")
                        throw TypeError(".proto.Conversation.messages: object expected");
                    message.messages[i] = $root.proto.HistorySyncMsg.fromObject(object.messages[i]);
                }
            }
            if (object.newJid != null)
                message.newJid = String(object.newJid);
            if (object.oldJid != null)
                message.oldJid = String(object.oldJid);
            if (object.lastMsgTimestamp != null)
                if ($util.Long)
                    (message.lastMsgTimestamp = $util.Long.fromValue(object.lastMsgTimestamp)).unsigned = true;
                else if (typeof object.lastMsgTimestamp === "string")
                    message.lastMsgTimestamp = parseInt(object.lastMsgTimestamp, 10);
                else if (typeof object.lastMsgTimestamp === "number")
                    message.lastMsgTimestamp = object.lastMsgTimestamp;
                else if (typeof object.lastMsgTimestamp === "object")
                    message.lastMsgTimestamp = new $util.LongBits(object.lastMsgTimestamp.low >>> 0, object.lastMsgTimestamp.high >>> 0).toNumber(true);
            if (object.unreadCount != null)
                message.unreadCount = object.unreadCount >>> 0;
            if (object.readOnly != null)
                message.readOnly = Boolean(object.readOnly);
            if (object.endOfHistoryTransfer != null)
                message.endOfHistoryTransfer = Boolean(object.endOfHistoryTransfer);
            if (object.ephemeralExpiration != null)
                message.ephemeralExpiration = object.ephemeralExpiration >>> 0;
            if (object.ephemeralSettingTimestamp != null)
                if ($util.Long)
                    (message.ephemeralSettingTimestamp = $util.Long.fromValue(object.ephemeralSettingTimestamp)).unsigned = false;
                else if (typeof object.ephemeralSettingTimestamp === "string")
                    message.ephemeralSettingTimestamp = parseInt(object.ephemeralSettingTimestamp, 10);
                else if (typeof object.ephemeralSettingTimestamp === "number")
                    message.ephemeralSettingTimestamp = object.ephemeralSettingTimestamp;
                else if (typeof object.ephemeralSettingTimestamp === "object")
                    message.ephemeralSettingTimestamp = new $util.LongBits(object.ephemeralSettingTimestamp.low >>> 0, object.ephemeralSettingTimestamp.high >>> 0).toNumber();
            switch (object.endOfHistoryTransferType) {
            case "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY":
            case 0:
                message.endOfHistoryTransferType = 0;
                break;
            case "COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY":
            case 1:
                message.endOfHistoryTransferType = 1;
                break;
            }
            if (object.conversationTimestamp != null)
                if ($util.Long)
                    (message.conversationTimestamp = $util.Long.fromValue(object.conversationTimestamp)).unsigned = true;
                else if (typeof object.conversationTimestamp === "string")
                    message.conversationTimestamp = parseInt(object.conversationTimestamp, 10);
                else if (typeof object.conversationTimestamp === "number")
                    message.conversationTimestamp = object.conversationTimestamp;
                else if (typeof object.conversationTimestamp === "object")
                    message.conversationTimestamp = new $util.LongBits(object.conversationTimestamp.low >>> 0, object.conversationTimestamp.high >>> 0).toNumber(true);
            if (object.name != null)
                message.name = String(object.name);
            if (object.pHash != null)
                message.pHash = String(object.pHash);
            if (object.notSpam != null)
                message.notSpam = Boolean(object.notSpam);
            if (object.archived != null)
                message.archived = Boolean(object.archived);
            if (object.disappearingMode != null) {
                if (typeof object.disappearingMode !== "object")
                    throw TypeError(".proto.Conversation.disappearingMode: object expected");
                message.disappearingMode = $root.proto.DisappearingMode.fromObject(object.disappearingMode);
            }
            if (object.unreadMentionCount != null)
                message.unreadMentionCount = object.unreadMentionCount >>> 0;
            if (object.markedAsUnread != null)
                message.markedAsUnread = Boolean(object.markedAsUnread);
            if (object.participant) {
                if (!Array.isArray(object.participant))
                    throw TypeError(".proto.Conversation.participant: array expected");
                message.participant = [];
                for (var i = 0; i < object.participant.length; ++i) {
                    if (typeof object.participant[i] !== "object")
                        throw TypeError(".proto.Conversation.participant: object expected");
                    message.participant[i] = $root.proto.GroupParticipant.fromObject(object.participant[i]);
                }
            }
            if (object.tcToken != null)
                if (typeof object.tcToken === "string")
                    $util.base64.decode(object.tcToken, message.tcToken = $util.newBuffer($util.base64.length(object.tcToken)), 0);
                else if (object.tcToken.length)
                    message.tcToken = object.tcToken;
            if (object.tcTokenTimestamp != null)
                if ($util.Long)
                    (message.tcTokenTimestamp = $util.Long.fromValue(object.tcTokenTimestamp)).unsigned = true;
                else if (typeof object.tcTokenTimestamp === "string")
                    message.tcTokenTimestamp = parseInt(object.tcTokenTimestamp, 10);
                else if (typeof object.tcTokenTimestamp === "number")
                    message.tcTokenTimestamp = object.tcTokenTimestamp;
                else if (typeof object.tcTokenTimestamp === "object")
                    message.tcTokenTimestamp = new $util.LongBits(object.tcTokenTimestamp.low >>> 0, object.tcTokenTimestamp.high >>> 0).toNumber(true);
            if (object.contactPrimaryIdentityKey != null)
                if (typeof object.contactPrimaryIdentityKey === "string")
                    $util.base64.decode(object.contactPrimaryIdentityKey, message.contactPrimaryIdentityKey = $util.newBuffer($util.base64.length(object.contactPrimaryIdentityKey)), 0);
                else if (object.contactPrimaryIdentityKey.length)
                    message.contactPrimaryIdentityKey = object.contactPrimaryIdentityKey;
            if (object.pinned != null)
                message.pinned = object.pinned >>> 0;
            if (object.muteEndTime != null)
                if ($util.Long)
                    (message.muteEndTime = $util.Long.fromValue(object.muteEndTime)).unsigned = true;
                else if (typeof object.muteEndTime === "string")
                    message.muteEndTime = parseInt(object.muteEndTime, 10);
                else if (typeof object.muteEndTime === "number")
                    message.muteEndTime = object.muteEndTime;
                else if (typeof object.muteEndTime === "object")
                    message.muteEndTime = new $util.LongBits(object.muteEndTime.low >>> 0, object.muteEndTime.high >>> 0).toNumber(true);
            if (object.wallpaper != null) {
                if (typeof object.wallpaper !== "object")
                    throw TypeError(".proto.Conversation.wallpaper: object expected");
                message.wallpaper = $root.proto.WallpaperSettings.fromObject(object.wallpaper);
            }
            switch (object.mediaVisibility) {
            case "DEFAULT":
            case 0:
                message.mediaVisibility = 0;
                break;
            case "OFF":
            case 1:
                message.mediaVisibility = 1;
                break;
            case "ON":
            case 2:
                message.mediaVisibility = 2;
                break;
            }
            if (object.tcTokenSenderTimestamp != null)
                if ($util.Long)
                    (message.tcTokenSenderTimestamp = $util.Long.fromValue(object.tcTokenSenderTimestamp)).unsigned = true;
                else if (typeof object.tcTokenSenderTimestamp === "string")
                    message.tcTokenSenderTimestamp = parseInt(object.tcTokenSenderTimestamp, 10);
                else if (typeof object.tcTokenSenderTimestamp === "number")
                    message.tcTokenSenderTimestamp = object.tcTokenSenderTimestamp;
                else if (typeof object.tcTokenSenderTimestamp === "object")
                    message.tcTokenSenderTimestamp = new $util.LongBits(object.tcTokenSenderTimestamp.low >>> 0, object.tcTokenSenderTimestamp.high >>> 0).toNumber(true);
            if (object.suspended != null)
                message.suspended = Boolean(object.suspended);
            if (object.terminated != null)
                message.terminated = Boolean(object.terminated);
            if (object.createdAt != null)
                if ($util.Long)
                    (message.createdAt = $util.Long.fromValue(object.createdAt)).unsigned = true;
                else if (typeof object.createdAt === "string")
                    message.createdAt = parseInt(object.createdAt, 10);
                else if (typeof object.createdAt === "number")
                    message.createdAt = object.createdAt;
                else if (typeof object.createdAt === "object")
                    message.createdAt = new $util.LongBits(object.createdAt.low >>> 0, object.createdAt.high >>> 0).toNumber(true);
            if (object.createdBy != null)
                message.createdBy = String(object.createdBy);
            if (object.description != null)
                message.description = String(object.description);
            if (object.support != null)
                message.support = Boolean(object.support);
            if (object.isParentGroup != null)
                message.isParentGroup = Boolean(object.isParentGroup);
            if (object.isDefaultSubgroup != null)
                message.isDefaultSubgroup = Boolean(object.isDefaultSubgroup);
            if (object.parentGroupId != null)
                message.parentGroupId = String(object.parentGroupId);
            if (object.displayName != null)
                message.displayName = String(object.displayName);
            if (object.pnJid != null)
                message.pnJid = String(object.pnJid);
            if (object.selfMasked != null)
                message.selfMasked = Boolean(object.selfMasked);
            return message;
        };

        /**
         * Creates a plain object from a Conversation message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Conversation
         * @static
         * @param {proto.Conversation} message Conversation
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Conversation.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.messages = [];
                object.participant = [];
            }
            if (options.defaults) {
                object.id = "";
                object.newJid = "";
                object.oldJid = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.lastMsgTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.lastMsgTimestamp = options.longs === String ? "0" : 0;
                object.unreadCount = 0;
                object.readOnly = false;
                object.endOfHistoryTransfer = false;
                object.ephemeralExpiration = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.ephemeralSettingTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.ephemeralSettingTimestamp = options.longs === String ? "0" : 0;
                object.endOfHistoryTransferType = options.enums === String ? "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.conversationTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.conversationTimestamp = options.longs === String ? "0" : 0;
                object.name = "";
                object.pHash = "";
                object.notSpam = false;
                object.archived = false;
                object.disappearingMode = null;
                object.unreadMentionCount = 0;
                object.markedAsUnread = false;
                if (options.bytes === String)
                    object.tcToken = "";
                else {
                    object.tcToken = [];
                    if (options.bytes !== Array)
                        object.tcToken = $util.newBuffer(object.tcToken);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.tcTokenTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.tcTokenTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.contactPrimaryIdentityKey = "";
                else {
                    object.contactPrimaryIdentityKey = [];
                    if (options.bytes !== Array)
                        object.contactPrimaryIdentityKey = $util.newBuffer(object.contactPrimaryIdentityKey);
                }
                object.pinned = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.muteEndTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.muteEndTime = options.longs === String ? "0" : 0;
                object.wallpaper = null;
                object.mediaVisibility = options.enums === String ? "DEFAULT" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.tcTokenSenderTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.tcTokenSenderTimestamp = options.longs === String ? "0" : 0;
                object.suspended = false;
                object.terminated = false;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.createdAt = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.createdAt = options.longs === String ? "0" : 0;
                object.createdBy = "";
                object.description = "";
                object.support = false;
                object.isParentGroup = false;
                object.isDefaultSubgroup = false;
                object.parentGroupId = "";
                object.displayName = "";
                object.pnJid = "";
                object.selfMasked = false;
            }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.messages && message.messages.length) {
                object.messages = [];
                for (var j = 0; j < message.messages.length; ++j)
                    object.messages[j] = $root.proto.HistorySyncMsg.toObject(message.messages[j], options);
            }
            if (message.newJid != null && message.hasOwnProperty("newJid"))
                object.newJid = message.newJid;
            if (message.oldJid != null && message.hasOwnProperty("oldJid"))
                object.oldJid = message.oldJid;
            if (message.lastMsgTimestamp != null && message.hasOwnProperty("lastMsgTimestamp"))
                if (typeof message.lastMsgTimestamp === "number")
                    object.lastMsgTimestamp = options.longs === String ? String(message.lastMsgTimestamp) : message.lastMsgTimestamp;
                else
                    object.lastMsgTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.lastMsgTimestamp) : options.longs === Number ? new $util.LongBits(message.lastMsgTimestamp.low >>> 0, message.lastMsgTimestamp.high >>> 0).toNumber(true) : message.lastMsgTimestamp;
            if (message.unreadCount != null && message.hasOwnProperty("unreadCount"))
                object.unreadCount = message.unreadCount;
            if (message.readOnly != null && message.hasOwnProperty("readOnly"))
                object.readOnly = message.readOnly;
            if (message.endOfHistoryTransfer != null && message.hasOwnProperty("endOfHistoryTransfer"))
                object.endOfHistoryTransfer = message.endOfHistoryTransfer;
            if (message.ephemeralExpiration != null && message.hasOwnProperty("ephemeralExpiration"))
                object.ephemeralExpiration = message.ephemeralExpiration;
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (typeof message.ephemeralSettingTimestamp === "number")
                    object.ephemeralSettingTimestamp = options.longs === String ? String(message.ephemeralSettingTimestamp) : message.ephemeralSettingTimestamp;
                else
                    object.ephemeralSettingTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.ephemeralSettingTimestamp) : options.longs === Number ? new $util.LongBits(message.ephemeralSettingTimestamp.low >>> 0, message.ephemeralSettingTimestamp.high >>> 0).toNumber() : message.ephemeralSettingTimestamp;
            if (message.endOfHistoryTransferType != null && message.hasOwnProperty("endOfHistoryTransferType"))
                object.endOfHistoryTransferType = options.enums === String ? $root.proto.Conversation.ConversationEndOfHistoryTransferType[message.endOfHistoryTransferType] : message.endOfHistoryTransferType;
            if (message.conversationTimestamp != null && message.hasOwnProperty("conversationTimestamp"))
                if (typeof message.conversationTimestamp === "number")
                    object.conversationTimestamp = options.longs === String ? String(message.conversationTimestamp) : message.conversationTimestamp;
                else
                    object.conversationTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.conversationTimestamp) : options.longs === Number ? new $util.LongBits(message.conversationTimestamp.low >>> 0, message.conversationTimestamp.high >>> 0).toNumber(true) : message.conversationTimestamp;
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            if (message.pHash != null && message.hasOwnProperty("pHash"))
                object.pHash = message.pHash;
            if (message.notSpam != null && message.hasOwnProperty("notSpam"))
                object.notSpam = message.notSpam;
            if (message.archived != null && message.hasOwnProperty("archived"))
                object.archived = message.archived;
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode"))
                object.disappearingMode = $root.proto.DisappearingMode.toObject(message.disappearingMode, options);
            if (message.unreadMentionCount != null && message.hasOwnProperty("unreadMentionCount"))
                object.unreadMentionCount = message.unreadMentionCount;
            if (message.markedAsUnread != null && message.hasOwnProperty("markedAsUnread"))
                object.markedAsUnread = message.markedAsUnread;
            if (message.participant && message.participant.length) {
                object.participant = [];
                for (var j = 0; j < message.participant.length; ++j)
                    object.participant[j] = $root.proto.GroupParticipant.toObject(message.participant[j], options);
            }
            if (message.tcToken != null && message.hasOwnProperty("tcToken"))
                object.tcToken = options.bytes === String ? $util.base64.encode(message.tcToken, 0, message.tcToken.length) : options.bytes === Array ? Array.prototype.slice.call(message.tcToken) : message.tcToken;
            if (message.tcTokenTimestamp != null && message.hasOwnProperty("tcTokenTimestamp"))
                if (typeof message.tcTokenTimestamp === "number")
                    object.tcTokenTimestamp = options.longs === String ? String(message.tcTokenTimestamp) : message.tcTokenTimestamp;
                else
                    object.tcTokenTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.tcTokenTimestamp) : options.longs === Number ? new $util.LongBits(message.tcTokenTimestamp.low >>> 0, message.tcTokenTimestamp.high >>> 0).toNumber(true) : message.tcTokenTimestamp;
            if (message.contactPrimaryIdentityKey != null && message.hasOwnProperty("contactPrimaryIdentityKey"))
                object.contactPrimaryIdentityKey = options.bytes === String ? $util.base64.encode(message.contactPrimaryIdentityKey, 0, message.contactPrimaryIdentityKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.contactPrimaryIdentityKey) : message.contactPrimaryIdentityKey;
            if (message.pinned != null && message.hasOwnProperty("pinned"))
                object.pinned = message.pinned;
            if (message.muteEndTime != null && message.hasOwnProperty("muteEndTime"))
                if (typeof message.muteEndTime === "number")
                    object.muteEndTime = options.longs === String ? String(message.muteEndTime) : message.muteEndTime;
                else
                    object.muteEndTime = options.longs === String ? $util.Long.prototype.toString.call(message.muteEndTime) : options.longs === Number ? new $util.LongBits(message.muteEndTime.low >>> 0, message.muteEndTime.high >>> 0).toNumber(true) : message.muteEndTime;
            if (message.wallpaper != null && message.hasOwnProperty("wallpaper"))
                object.wallpaper = $root.proto.WallpaperSettings.toObject(message.wallpaper, options);
            if (message.mediaVisibility != null && message.hasOwnProperty("mediaVisibility"))
                object.mediaVisibility = options.enums === String ? $root.proto.MediaVisibility[message.mediaVisibility] : message.mediaVisibility;
            if (message.tcTokenSenderTimestamp != null && message.hasOwnProperty("tcTokenSenderTimestamp"))
                if (typeof message.tcTokenSenderTimestamp === "number")
                    object.tcTokenSenderTimestamp = options.longs === String ? String(message.tcTokenSenderTimestamp) : message.tcTokenSenderTimestamp;
                else
                    object.tcTokenSenderTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.tcTokenSenderTimestamp) : options.longs === Number ? new $util.LongBits(message.tcTokenSenderTimestamp.low >>> 0, message.tcTokenSenderTimestamp.high >>> 0).toNumber(true) : message.tcTokenSenderTimestamp;
            if (message.suspended != null && message.hasOwnProperty("suspended"))
                object.suspended = message.suspended;
            if (message.terminated != null && message.hasOwnProperty("terminated"))
                object.terminated = message.terminated;
            if (message.createdAt != null && message.hasOwnProperty("createdAt"))
                if (typeof message.createdAt === "number")
                    object.createdAt = options.longs === String ? String(message.createdAt) : message.createdAt;
                else
                    object.createdAt = options.longs === String ? $util.Long.prototype.toString.call(message.createdAt) : options.longs === Number ? new $util.LongBits(message.createdAt.low >>> 0, message.createdAt.high >>> 0).toNumber(true) : message.createdAt;
            if (message.createdBy != null && message.hasOwnProperty("createdBy"))
                object.createdBy = message.createdBy;
            if (message.description != null && message.hasOwnProperty("description"))
                object.description = message.description;
            if (message.support != null && message.hasOwnProperty("support"))
                object.support = message.support;
            if (message.isParentGroup != null && message.hasOwnProperty("isParentGroup"))
                object.isParentGroup = message.isParentGroup;
            if (message.isDefaultSubgroup != null && message.hasOwnProperty("isDefaultSubgroup"))
                object.isDefaultSubgroup = message.isDefaultSubgroup;
            if (message.parentGroupId != null && message.hasOwnProperty("parentGroupId"))
                object.parentGroupId = message.parentGroupId;
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                object.displayName = message.displayName;
            if (message.pnJid != null && message.hasOwnProperty("pnJid"))
                object.pnJid = message.pnJid;
            if (message.selfMasked != null && message.hasOwnProperty("selfMasked"))
                object.selfMasked = message.selfMasked;
            return object;
        };

        /**
         * Converts this Conversation to JSON.
         * @function toJSON
         * @memberof proto.Conversation
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Conversation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ConversationEndOfHistoryTransferType enum.
         * @name proto.Conversation.ConversationEndOfHistoryTransferType
         * @enum {number}
         * @property {number} COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY=0 COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY value
         * @property {number} COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY=1 COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY value
         */
        Conversation.ConversationEndOfHistoryTransferType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY"] = 0;
            values[valuesById[1] = "COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY"] = 1;
            return values;
        })();

        return Conversation;
    })();

    proto.DNSSource = (function() {

        /**
         * Properties of a DNSSource.
         * @memberof proto
         * @interface IDNSSource
         * @property {proto.DNSSource.DNSSourceDNSResolutionMethod|null} [dnsMethod] DNSSource dnsMethod
         * @property {boolean|null} [appCached] DNSSource appCached
         */

        /**
         * Constructs a new DNSSource.
         * @memberof proto
         * @classdesc Represents a DNSSource.
         * @implements IDNSSource
         * @constructor
         * @param {proto.IDNSSource=} [properties] Properties to set
         */
        function DNSSource(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DNSSource dnsMethod.
         * @member {proto.DNSSource.DNSSourceDNSResolutionMethod} dnsMethod
         * @memberof proto.DNSSource
         * @instance
         */
        DNSSource.prototype.dnsMethod = 0;

        /**
         * DNSSource appCached.
         * @member {boolean} appCached
         * @memberof proto.DNSSource
         * @instance
         */
        DNSSource.prototype.appCached = false;

        /**
         * Creates a new DNSSource instance using the specified properties.
         * @function create
         * @memberof proto.DNSSource
         * @static
         * @param {proto.IDNSSource=} [properties] Properties to set
         * @returns {proto.DNSSource} DNSSource instance
         */
        DNSSource.create = function create(properties) {
            return new DNSSource(properties);
        };

        /**
         * Encodes the specified DNSSource message. Does not implicitly {@link proto.DNSSource.verify|verify} messages.
         * @function encode
         * @memberof proto.DNSSource
         * @static
         * @param {proto.IDNSSource} message DNSSource message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DNSSource.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.dnsMethod != null && Object.hasOwnProperty.call(message, "dnsMethod"))
                writer.uint32(/* id 15, wireType 0 =*/120).int32(message.dnsMethod);
            if (message.appCached != null && Object.hasOwnProperty.call(message, "appCached"))
                writer.uint32(/* id 16, wireType 0 =*/128).bool(message.appCached);
            return writer;
        };

        /**
         * Encodes the specified DNSSource message, length delimited. Does not implicitly {@link proto.DNSSource.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DNSSource
         * @static
         * @param {proto.IDNSSource} message DNSSource message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DNSSource.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DNSSource message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DNSSource
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DNSSource} DNSSource
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DNSSource.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DNSSource();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 15:
                    message.dnsMethod = reader.int32();
                    break;
                case 16:
                    message.appCached = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DNSSource message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DNSSource
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DNSSource} DNSSource
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DNSSource.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DNSSource message.
         * @function verify
         * @memberof proto.DNSSource
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DNSSource.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.dnsMethod != null && message.hasOwnProperty("dnsMethod"))
                switch (message.dnsMethod) {
                default:
                    return "dnsMethod: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                    break;
                }
            if (message.appCached != null && message.hasOwnProperty("appCached"))
                if (typeof message.appCached !== "boolean")
                    return "appCached: boolean expected";
            return null;
        };

        /**
         * Creates a DNSSource message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DNSSource
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DNSSource} DNSSource
         */
        DNSSource.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DNSSource)
                return object;
            var message = new $root.proto.DNSSource();
            switch (object.dnsMethod) {
            case "SYSTEM":
            case 0:
                message.dnsMethod = 0;
                break;
            case "GOOGLE":
            case 1:
                message.dnsMethod = 1;
                break;
            case "HARDCODED":
            case 2:
                message.dnsMethod = 2;
                break;
            case "OVERRIDE":
            case 3:
                message.dnsMethod = 3;
                break;
            case "FALLBACK":
            case 4:
                message.dnsMethod = 4;
                break;
            }
            if (object.appCached != null)
                message.appCached = Boolean(object.appCached);
            return message;
        };

        /**
         * Creates a plain object from a DNSSource message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DNSSource
         * @static
         * @param {proto.DNSSource} message DNSSource
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DNSSource.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.dnsMethod = options.enums === String ? "SYSTEM" : 0;
                object.appCached = false;
            }
            if (message.dnsMethod != null && message.hasOwnProperty("dnsMethod"))
                object.dnsMethod = options.enums === String ? $root.proto.DNSSource.DNSSourceDNSResolutionMethod[message.dnsMethod] : message.dnsMethod;
            if (message.appCached != null && message.hasOwnProperty("appCached"))
                object.appCached = message.appCached;
            return object;
        };

        /**
         * Converts this DNSSource to JSON.
         * @function toJSON
         * @memberof proto.DNSSource
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DNSSource.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * DNSSourceDNSResolutionMethod enum.
         * @name proto.DNSSource.DNSSourceDNSResolutionMethod
         * @enum {number}
         * @property {number} SYSTEM=0 SYSTEM value
         * @property {number} GOOGLE=1 GOOGLE value
         * @property {number} HARDCODED=2 HARDCODED value
         * @property {number} OVERRIDE=3 OVERRIDE value
         * @property {number} FALLBACK=4 FALLBACK value
         */
        DNSSource.DNSSourceDNSResolutionMethod = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SYSTEM"] = 0;
            values[valuesById[1] = "GOOGLE"] = 1;
            values[valuesById[2] = "HARDCODED"] = 2;
            values[valuesById[3] = "OVERRIDE"] = 3;
            values[valuesById[4] = "FALLBACK"] = 4;
            return values;
        })();

        return DNSSource;
    })();

    proto.DeclinePaymentRequestMessage = (function() {

        /**
         * Properties of a DeclinePaymentRequestMessage.
         * @memberof proto
         * @interface IDeclinePaymentRequestMessage
         * @property {proto.IMessageKey|null} [key] DeclinePaymentRequestMessage key
         */

        /**
         * Constructs a new DeclinePaymentRequestMessage.
         * @memberof proto
         * @classdesc Represents a DeclinePaymentRequestMessage.
         * @implements IDeclinePaymentRequestMessage
         * @constructor
         * @param {proto.IDeclinePaymentRequestMessage=} [properties] Properties to set
         */
        function DeclinePaymentRequestMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeclinePaymentRequestMessage key.
         * @member {proto.IMessageKey|null|undefined} key
         * @memberof proto.DeclinePaymentRequestMessage
         * @instance
         */
        DeclinePaymentRequestMessage.prototype.key = null;

        /**
         * Creates a new DeclinePaymentRequestMessage instance using the specified properties.
         * @function create
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {proto.IDeclinePaymentRequestMessage=} [properties] Properties to set
         * @returns {proto.DeclinePaymentRequestMessage} DeclinePaymentRequestMessage instance
         */
        DeclinePaymentRequestMessage.create = function create(properties) {
            return new DeclinePaymentRequestMessage(properties);
        };

        /**
         * Encodes the specified DeclinePaymentRequestMessage message. Does not implicitly {@link proto.DeclinePaymentRequestMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {proto.IDeclinePaymentRequestMessage} message DeclinePaymentRequestMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeclinePaymentRequestMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                $root.proto.MessageKey.encode(message.key, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified DeclinePaymentRequestMessage message, length delimited. Does not implicitly {@link proto.DeclinePaymentRequestMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {proto.IDeclinePaymentRequestMessage} message DeclinePaymentRequestMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeclinePaymentRequestMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeclinePaymentRequestMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeclinePaymentRequestMessage} DeclinePaymentRequestMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeclinePaymentRequestMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeclinePaymentRequestMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.key = $root.proto.MessageKey.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeclinePaymentRequestMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeclinePaymentRequestMessage} DeclinePaymentRequestMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeclinePaymentRequestMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeclinePaymentRequestMessage message.
         * @function verify
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeclinePaymentRequestMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.key != null && message.hasOwnProperty("key")) {
                var error = $root.proto.MessageKey.verify(message.key);
                if (error)
                    return "key." + error;
            }
            return null;
        };

        /**
         * Creates a DeclinePaymentRequestMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeclinePaymentRequestMessage} DeclinePaymentRequestMessage
         */
        DeclinePaymentRequestMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeclinePaymentRequestMessage)
                return object;
            var message = new $root.proto.DeclinePaymentRequestMessage();
            if (object.key != null) {
                if (typeof object.key !== "object")
                    throw TypeError(".proto.DeclinePaymentRequestMessage.key: object expected");
                message.key = $root.proto.MessageKey.fromObject(object.key);
            }
            return message;
        };

        /**
         * Creates a plain object from a DeclinePaymentRequestMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeclinePaymentRequestMessage
         * @static
         * @param {proto.DeclinePaymentRequestMessage} message DeclinePaymentRequestMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeclinePaymentRequestMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.key = null;
            if (message.key != null && message.hasOwnProperty("key"))
                object.key = $root.proto.MessageKey.toObject(message.key, options);
            return object;
        };

        /**
         * Converts this DeclinePaymentRequestMessage to JSON.
         * @function toJSON
         * @memberof proto.DeclinePaymentRequestMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeclinePaymentRequestMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeclinePaymentRequestMessage;
    })();

    proto.DeleteChatAction = (function() {

        /**
         * Properties of a DeleteChatAction.
         * @memberof proto
         * @interface IDeleteChatAction
         * @property {proto.ISyncActionMessageRange|null} [messageRange] DeleteChatAction messageRange
         */

        /**
         * Constructs a new DeleteChatAction.
         * @memberof proto
         * @classdesc Represents a DeleteChatAction.
         * @implements IDeleteChatAction
         * @constructor
         * @param {proto.IDeleteChatAction=} [properties] Properties to set
         */
        function DeleteChatAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeleteChatAction messageRange.
         * @member {proto.ISyncActionMessageRange|null|undefined} messageRange
         * @memberof proto.DeleteChatAction
         * @instance
         */
        DeleteChatAction.prototype.messageRange = null;

        /**
         * Creates a new DeleteChatAction instance using the specified properties.
         * @function create
         * @memberof proto.DeleteChatAction
         * @static
         * @param {proto.IDeleteChatAction=} [properties] Properties to set
         * @returns {proto.DeleteChatAction} DeleteChatAction instance
         */
        DeleteChatAction.create = function create(properties) {
            return new DeleteChatAction(properties);
        };

        /**
         * Encodes the specified DeleteChatAction message. Does not implicitly {@link proto.DeleteChatAction.verify|verify} messages.
         * @function encode
         * @memberof proto.DeleteChatAction
         * @static
         * @param {proto.IDeleteChatAction} message DeleteChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeleteChatAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.messageRange != null && Object.hasOwnProperty.call(message, "messageRange"))
                $root.proto.SyncActionMessageRange.encode(message.messageRange, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified DeleteChatAction message, length delimited. Does not implicitly {@link proto.DeleteChatAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeleteChatAction
         * @static
         * @param {proto.IDeleteChatAction} message DeleteChatAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeleteChatAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeleteChatAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeleteChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeleteChatAction} DeleteChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeleteChatAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeleteChatAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.messageRange = $root.proto.SyncActionMessageRange.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeleteChatAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeleteChatAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeleteChatAction} DeleteChatAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeleteChatAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeleteChatAction message.
         * @function verify
         * @memberof proto.DeleteChatAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeleteChatAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.messageRange != null && message.hasOwnProperty("messageRange")) {
                var error = $root.proto.SyncActionMessageRange.verify(message.messageRange);
                if (error)
                    return "messageRange." + error;
            }
            return null;
        };

        /**
         * Creates a DeleteChatAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeleteChatAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeleteChatAction} DeleteChatAction
         */
        DeleteChatAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeleteChatAction)
                return object;
            var message = new $root.proto.DeleteChatAction();
            if (object.messageRange != null) {
                if (typeof object.messageRange !== "object")
                    throw TypeError(".proto.DeleteChatAction.messageRange: object expected");
                message.messageRange = $root.proto.SyncActionMessageRange.fromObject(object.messageRange);
            }
            return message;
        };

        /**
         * Creates a plain object from a DeleteChatAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeleteChatAction
         * @static
         * @param {proto.DeleteChatAction} message DeleteChatAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeleteChatAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.messageRange = null;
            if (message.messageRange != null && message.hasOwnProperty("messageRange"))
                object.messageRange = $root.proto.SyncActionMessageRange.toObject(message.messageRange, options);
            return object;
        };

        /**
         * Converts this DeleteChatAction to JSON.
         * @function toJSON
         * @memberof proto.DeleteChatAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeleteChatAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeleteChatAction;
    })();

    proto.DeleteMessageForMeAction = (function() {

        /**
         * Properties of a DeleteMessageForMeAction.
         * @memberof proto
         * @interface IDeleteMessageForMeAction
         * @property {boolean|null} [deleteMedia] DeleteMessageForMeAction deleteMedia
         * @property {number|Long|null} [messageTimestamp] DeleteMessageForMeAction messageTimestamp
         */

        /**
         * Constructs a new DeleteMessageForMeAction.
         * @memberof proto
         * @classdesc Represents a DeleteMessageForMeAction.
         * @implements IDeleteMessageForMeAction
         * @constructor
         * @param {proto.IDeleteMessageForMeAction=} [properties] Properties to set
         */
        function DeleteMessageForMeAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeleteMessageForMeAction deleteMedia.
         * @member {boolean} deleteMedia
         * @memberof proto.DeleteMessageForMeAction
         * @instance
         */
        DeleteMessageForMeAction.prototype.deleteMedia = false;

        /**
         * DeleteMessageForMeAction messageTimestamp.
         * @member {number|Long} messageTimestamp
         * @memberof proto.DeleteMessageForMeAction
         * @instance
         */
        DeleteMessageForMeAction.prototype.messageTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new DeleteMessageForMeAction instance using the specified properties.
         * @function create
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {proto.IDeleteMessageForMeAction=} [properties] Properties to set
         * @returns {proto.DeleteMessageForMeAction} DeleteMessageForMeAction instance
         */
        DeleteMessageForMeAction.create = function create(properties) {
            return new DeleteMessageForMeAction(properties);
        };

        /**
         * Encodes the specified DeleteMessageForMeAction message. Does not implicitly {@link proto.DeleteMessageForMeAction.verify|verify} messages.
         * @function encode
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {proto.IDeleteMessageForMeAction} message DeleteMessageForMeAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeleteMessageForMeAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.deleteMedia != null && Object.hasOwnProperty.call(message, "deleteMedia"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.deleteMedia);
            if (message.messageTimestamp != null && Object.hasOwnProperty.call(message, "messageTimestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.messageTimestamp);
            return writer;
        };

        /**
         * Encodes the specified DeleteMessageForMeAction message, length delimited. Does not implicitly {@link proto.DeleteMessageForMeAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {proto.IDeleteMessageForMeAction} message DeleteMessageForMeAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeleteMessageForMeAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeleteMessageForMeAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeleteMessageForMeAction} DeleteMessageForMeAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeleteMessageForMeAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeleteMessageForMeAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.deleteMedia = reader.bool();
                    break;
                case 2:
                    message.messageTimestamp = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeleteMessageForMeAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeleteMessageForMeAction} DeleteMessageForMeAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeleteMessageForMeAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeleteMessageForMeAction message.
         * @function verify
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeleteMessageForMeAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.deleteMedia != null && message.hasOwnProperty("deleteMedia"))
                if (typeof message.deleteMedia !== "boolean")
                    return "deleteMedia: boolean expected";
            if (message.messageTimestamp != null && message.hasOwnProperty("messageTimestamp"))
                if (!$util.isInteger(message.messageTimestamp) && !(message.messageTimestamp && $util.isInteger(message.messageTimestamp.low) && $util.isInteger(message.messageTimestamp.high)))
                    return "messageTimestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates a DeleteMessageForMeAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeleteMessageForMeAction} DeleteMessageForMeAction
         */
        DeleteMessageForMeAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeleteMessageForMeAction)
                return object;
            var message = new $root.proto.DeleteMessageForMeAction();
            if (object.deleteMedia != null)
                message.deleteMedia = Boolean(object.deleteMedia);
            if (object.messageTimestamp != null)
                if ($util.Long)
                    (message.messageTimestamp = $util.Long.fromValue(object.messageTimestamp)).unsigned = false;
                else if (typeof object.messageTimestamp === "string")
                    message.messageTimestamp = parseInt(object.messageTimestamp, 10);
                else if (typeof object.messageTimestamp === "number")
                    message.messageTimestamp = object.messageTimestamp;
                else if (typeof object.messageTimestamp === "object")
                    message.messageTimestamp = new $util.LongBits(object.messageTimestamp.low >>> 0, object.messageTimestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from a DeleteMessageForMeAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeleteMessageForMeAction
         * @static
         * @param {proto.DeleteMessageForMeAction} message DeleteMessageForMeAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeleteMessageForMeAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.deleteMedia = false;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.messageTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.messageTimestamp = options.longs === String ? "0" : 0;
            }
            if (message.deleteMedia != null && message.hasOwnProperty("deleteMedia"))
                object.deleteMedia = message.deleteMedia;
            if (message.messageTimestamp != null && message.hasOwnProperty("messageTimestamp"))
                if (typeof message.messageTimestamp === "number")
                    object.messageTimestamp = options.longs === String ? String(message.messageTimestamp) : message.messageTimestamp;
                else
                    object.messageTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.messageTimestamp) : options.longs === Number ? new $util.LongBits(message.messageTimestamp.low >>> 0, message.messageTimestamp.high >>> 0).toNumber() : message.messageTimestamp;
            return object;
        };

        /**
         * Converts this DeleteMessageForMeAction to JSON.
         * @function toJSON
         * @memberof proto.DeleteMessageForMeAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeleteMessageForMeAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeleteMessageForMeAction;
    })();

    proto.DeviceListMetadata = (function() {

        /**
         * Properties of a DeviceListMetadata.
         * @memberof proto
         * @interface IDeviceListMetadata
         * @property {Uint8Array|null} [senderKeyHash] DeviceListMetadata senderKeyHash
         * @property {number|Long|null} [senderTimestamp] DeviceListMetadata senderTimestamp
         * @property {Array.<number>|null} [senderKeyIndexes] DeviceListMetadata senderKeyIndexes
         * @property {Uint8Array|null} [recipientKeyHash] DeviceListMetadata recipientKeyHash
         * @property {number|Long|null} [recipientTimestamp] DeviceListMetadata recipientTimestamp
         * @property {Array.<number>|null} [recipientKeyIndexes] DeviceListMetadata recipientKeyIndexes
         */

        /**
         * Constructs a new DeviceListMetadata.
         * @memberof proto
         * @classdesc Represents a DeviceListMetadata.
         * @implements IDeviceListMetadata
         * @constructor
         * @param {proto.IDeviceListMetadata=} [properties] Properties to set
         */
        function DeviceListMetadata(properties) {
            this.senderKeyIndexes = [];
            this.recipientKeyIndexes = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeviceListMetadata senderKeyHash.
         * @member {Uint8Array} senderKeyHash
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderKeyHash = $util.newBuffer([]);

        /**
         * DeviceListMetadata senderTimestamp.
         * @member {number|Long} senderTimestamp
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * DeviceListMetadata senderKeyIndexes.
         * @member {Array.<number>} senderKeyIndexes
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderKeyIndexes = $util.emptyArray;

        /**
         * DeviceListMetadata recipientKeyHash.
         * @member {Uint8Array} recipientKeyHash
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientKeyHash = $util.newBuffer([]);

        /**
         * DeviceListMetadata recipientTimestamp.
         * @member {number|Long} recipientTimestamp
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * DeviceListMetadata recipientKeyIndexes.
         * @member {Array.<number>} recipientKeyIndexes
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientKeyIndexes = $util.emptyArray;

        /**
         * Creates a new DeviceListMetadata instance using the specified properties.
         * @function create
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata=} [properties] Properties to set
         * @returns {proto.DeviceListMetadata} DeviceListMetadata instance
         */
        DeviceListMetadata.create = function create(properties) {
            return new DeviceListMetadata(properties);
        };

        /**
         * Encodes the specified DeviceListMetadata message. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata} message DeviceListMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceListMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.senderKeyHash != null && Object.hasOwnProperty.call(message, "senderKeyHash"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.senderKeyHash);
            if (message.senderTimestamp != null && Object.hasOwnProperty.call(message, "senderTimestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.senderTimestamp);
            if (message.senderKeyIndexes != null && message.senderKeyIndexes.length) {
                writer.uint32(/* id 3, wireType 2 =*/26).fork();
                for (var i = 0; i < message.senderKeyIndexes.length; ++i)
                    writer.uint32(message.senderKeyIndexes[i]);
                writer.ldelim();
            }
            if (message.recipientKeyHash != null && Object.hasOwnProperty.call(message, "recipientKeyHash"))
                writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.recipientKeyHash);
            if (message.recipientTimestamp != null && Object.hasOwnProperty.call(message, "recipientTimestamp"))
                writer.uint32(/* id 9, wireType 0 =*/72).uint64(message.recipientTimestamp);
            if (message.recipientKeyIndexes != null && message.recipientKeyIndexes.length) {
                writer.uint32(/* id 10, wireType 2 =*/82).fork();
                for (var i = 0; i < message.recipientKeyIndexes.length; ++i)
                    writer.uint32(message.recipientKeyIndexes[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified DeviceListMetadata message, length delimited. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata} message DeviceListMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceListMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceListMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeviceListMetadata();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.senderKeyHash = reader.bytes();
                    break;
                case 2:
                    message.senderTimestamp = reader.uint64();
                    break;
                case 3:
                    if (!(message.senderKeyIndexes && message.senderKeyIndexes.length))
                        message.senderKeyIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.senderKeyIndexes.push(reader.uint32());
                    } else
                        message.senderKeyIndexes.push(reader.uint32());
                    break;
                case 8:
                    message.recipientKeyHash = reader.bytes();
                    break;
                case 9:
                    message.recipientTimestamp = reader.uint64();
                    break;
                case 10:
                    if (!(message.recipientKeyIndexes && message.recipientKeyIndexes.length))
                        message.recipientKeyIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.recipientKeyIndexes.push(reader.uint32());
                    } else
                        message.recipientKeyIndexes.push(reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceListMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeviceListMetadata message.
         * @function verify
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeviceListMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.senderKeyHash != null && message.hasOwnProperty("senderKeyHash"))
                if (!(message.senderKeyHash && typeof message.senderKeyHash.length === "number" || $util.isString(message.senderKeyHash)))
                    return "senderKeyHash: buffer expected";
            if (message.senderTimestamp != null && message.hasOwnProperty("senderTimestamp"))
                if (!$util.isInteger(message.senderTimestamp) && !(message.senderTimestamp && $util.isInteger(message.senderTimestamp.low) && $util.isInteger(message.senderTimestamp.high)))
                    return "senderTimestamp: integer|Long expected";
            if (message.senderKeyIndexes != null && message.hasOwnProperty("senderKeyIndexes")) {
                if (!Array.isArray(message.senderKeyIndexes))
                    return "senderKeyIndexes: array expected";
                for (var i = 0; i < message.senderKeyIndexes.length; ++i)
                    if (!$util.isInteger(message.senderKeyIndexes[i]))
                        return "senderKeyIndexes: integer[] expected";
            }
            if (message.recipientKeyHash != null && message.hasOwnProperty("recipientKeyHash"))
                if (!(message.recipientKeyHash && typeof message.recipientKeyHash.length === "number" || $util.isString(message.recipientKeyHash)))
                    return "recipientKeyHash: buffer expected";
            if (message.recipientTimestamp != null && message.hasOwnProperty("recipientTimestamp"))
                if (!$util.isInteger(message.recipientTimestamp) && !(message.recipientTimestamp && $util.isInteger(message.recipientTimestamp.low) && $util.isInteger(message.recipientTimestamp.high)))
                    return "recipientTimestamp: integer|Long expected";
            if (message.recipientKeyIndexes != null && message.hasOwnProperty("recipientKeyIndexes")) {
                if (!Array.isArray(message.recipientKeyIndexes))
                    return "recipientKeyIndexes: array expected";
                for (var i = 0; i < message.recipientKeyIndexes.length; ++i)
                    if (!$util.isInteger(message.recipientKeyIndexes[i]))
                        return "recipientKeyIndexes: integer[] expected";
            }
            return null;
        };

        /**
         * Creates a DeviceListMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         */
        DeviceListMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeviceListMetadata)
                return object;
            var message = new $root.proto.DeviceListMetadata();
            if (object.senderKeyHash != null)
                if (typeof object.senderKeyHash === "string")
                    $util.base64.decode(object.senderKeyHash, message.senderKeyHash = $util.newBuffer($util.base64.length(object.senderKeyHash)), 0);
                else if (object.senderKeyHash.length)
                    message.senderKeyHash = object.senderKeyHash;
            if (object.senderTimestamp != null)
                if ($util.Long)
                    (message.senderTimestamp = $util.Long.fromValue(object.senderTimestamp)).unsigned = true;
                else if (typeof object.senderTimestamp === "string")
                    message.senderTimestamp = parseInt(object.senderTimestamp, 10);
                else if (typeof object.senderTimestamp === "number")
                    message.senderTimestamp = object.senderTimestamp;
                else if (typeof object.senderTimestamp === "object")
                    message.senderTimestamp = new $util.LongBits(object.senderTimestamp.low >>> 0, object.senderTimestamp.high >>> 0).toNumber(true);
            if (object.senderKeyIndexes) {
                if (!Array.isArray(object.senderKeyIndexes))
                    throw TypeError(".proto.DeviceListMetadata.senderKeyIndexes: array expected");
                message.senderKeyIndexes = [];
                for (var i = 0; i < object.senderKeyIndexes.length; ++i)
                    message.senderKeyIndexes[i] = object.senderKeyIndexes[i] >>> 0;
            }
            if (object.recipientKeyHash != null)
                if (typeof object.recipientKeyHash === "string")
                    $util.base64.decode(object.recipientKeyHash, message.recipientKeyHash = $util.newBuffer($util.base64.length(object.recipientKeyHash)), 0);
                else if (object.recipientKeyHash.length)
                    message.recipientKeyHash = object.recipientKeyHash;
            if (object.recipientTimestamp != null)
                if ($util.Long)
                    (message.recipientTimestamp = $util.Long.fromValue(object.recipientTimestamp)).unsigned = true;
                else if (typeof object.recipientTimestamp === "string")
                    message.recipientTimestamp = parseInt(object.recipientTimestamp, 10);
                else if (typeof object.recipientTimestamp === "number")
                    message.recipientTimestamp = object.recipientTimestamp;
                else if (typeof object.recipientTimestamp === "object")
                    message.recipientTimestamp = new $util.LongBits(object.recipientTimestamp.low >>> 0, object.recipientTimestamp.high >>> 0).toNumber(true);
            if (object.recipientKeyIndexes) {
                if (!Array.isArray(object.recipientKeyIndexes))
                    throw TypeError(".proto.DeviceListMetadata.recipientKeyIndexes: array expected");
                message.recipientKeyIndexes = [];
                for (var i = 0; i < object.recipientKeyIndexes.length; ++i)
                    message.recipientKeyIndexes[i] = object.recipientKeyIndexes[i] >>> 0;
            }
            return message;
        };

        /**
         * Creates a plain object from a DeviceListMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.DeviceListMetadata} message DeviceListMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeviceListMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.senderKeyIndexes = [];
                object.recipientKeyIndexes = [];
            }
            if (options.defaults) {
                if (options.bytes === String)
                    object.senderKeyHash = "";
                else {
                    object.senderKeyHash = [];
                    if (options.bytes !== Array)
                        object.senderKeyHash = $util.newBuffer(object.senderKeyHash);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.senderTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.senderTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.recipientKeyHash = "";
                else {
                    object.recipientKeyHash = [];
                    if (options.bytes !== Array)
                        object.recipientKeyHash = $util.newBuffer(object.recipientKeyHash);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.recipientTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.recipientTimestamp = options.longs === String ? "0" : 0;
            }
            if (message.senderKeyHash != null && message.hasOwnProperty("senderKeyHash"))
                object.senderKeyHash = options.bytes === String ? $util.base64.encode(message.senderKeyHash, 0, message.senderKeyHash.length) : options.bytes === Array ? Array.prototype.slice.call(message.senderKeyHash) : message.senderKeyHash;
            if (message.senderTimestamp != null && message.hasOwnProperty("senderTimestamp"))
                if (typeof message.senderTimestamp === "number")
                    object.senderTimestamp = options.longs === String ? String(message.senderTimestamp) : message.senderTimestamp;
                else
                    object.senderTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.senderTimestamp) : options.longs === Number ? new $util.LongBits(message.senderTimestamp.low >>> 0, message.senderTimestamp.high >>> 0).toNumber(true) : message.senderTimestamp;
            if (message.senderKeyIndexes && message.senderKeyIndexes.length) {
                object.senderKeyIndexes = [];
                for (var j = 0; j < message.senderKeyIndexes.length; ++j)
                    object.senderKeyIndexes[j] = message.senderKeyIndexes[j];
            }
            if (message.recipientKeyHash != null && message.hasOwnProperty("recipientKeyHash"))
                object.recipientKeyHash = options.bytes === String ? $util.base64.encode(message.recipientKeyHash, 0, message.recipientKeyHash.length) : options.bytes === Array ? Array.prototype.slice.call(message.recipientKeyHash) : message.recipientKeyHash;
            if (message.recipientTimestamp != null && message.hasOwnProperty("recipientTimestamp"))
                if (typeof message.recipientTimestamp === "number")
                    object.recipientTimestamp = options.longs === String ? String(message.recipientTimestamp) : message.recipientTimestamp;
                else
                    object.recipientTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.recipientTimestamp) : options.longs === Number ? new $util.LongBits(message.recipientTimestamp.low >>> 0, message.recipientTimestamp.high >>> 0).toNumber(true) : message.recipientTimestamp;
            if (message.recipientKeyIndexes && message.recipientKeyIndexes.length) {
                object.recipientKeyIndexes = [];
                for (var j = 0; j < message.recipientKeyIndexes.length; ++j)
                    object.recipientKeyIndexes[j] = message.recipientKeyIndexes[j];
            }
            return object;
        };

        /**
         * Converts this DeviceListMetadata to JSON.
         * @function toJSON
         * @memberof proto.DeviceListMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeviceListMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeviceListMetadata;
    })();

    proto.DevicePairingRegistrationData = (function() {

        /**
         * Properties of a DevicePairingRegistrationData.
         * @memberof proto
         * @interface IDevicePairingRegistrationData
         * @property {Uint8Array|null} [eRegid] DevicePairingRegistrationData eRegid
         * @property {Uint8Array|null} [eKeytype] DevicePairingRegistrationData eKeytype
         * @property {Uint8Array|null} [eIdent] DevicePairingRegistrationData eIdent
         * @property {Uint8Array|null} [eSkeyId] DevicePairingRegistrationData eSkeyId
         * @property {Uint8Array|null} [eSkeyVal] DevicePairingRegistrationData eSkeyVal
         * @property {Uint8Array|null} [eSkeySig] DevicePairingRegistrationData eSkeySig
         * @property {Uint8Array|null} [buildHash] DevicePairingRegistrationData buildHash
         * @property {Uint8Array|null} [deviceProps] DevicePairingRegistrationData deviceProps
         */

        /**
         * Constructs a new DevicePairingRegistrationData.
         * @memberof proto
         * @classdesc Represents a DevicePairingRegistrationData.
         * @implements IDevicePairingRegistrationData
         * @constructor
         * @param {proto.IDevicePairingRegistrationData=} [properties] Properties to set
         */
        function DevicePairingRegistrationData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DevicePairingRegistrationData eRegid.
         * @member {Uint8Array} eRegid
         * @memberof proto.DevicePairingRegistrationData
         * @instance
         */
        DevicePairingRegistrationData.prototype.eRegid = $util.newBuffer([]);

        /**
         * DevicePairingRegistrationData eKeytype.
         * @member {Uint8Array} eKeytype
         * @memberof proto.DevicePairingRegistrationData
         * @instance
         */
        DevicePairingRegistrationData.prototype.eKeytype = $util.newBuffer([]);

        /**
         * DevicePairingRegistrationData eIdent.
         * @member {Uint8Array} eIdent
         * @memberof proto.DevicePairingRegistrationData
         * @instance
         */
        DevicePairingRegistrationData.prototype.eIdent = $util.newBuffer([]);

        /**
         * DevicePairingRegistrationData eSkeyId.
         * @member {Uint8Array} eSkeyId
         * @memberof proto.DevicePairingRegistrationData
         * @instance
         */
        DevicePairingRegistrationData.prototype.eSkeyId = $util.newBuffer([]);

        /**
         * DevicePairingRegistrationData eSkeyVal.
         * @member {Uint8Array} eSkeyVal
         * @memberof proto.DevicePairingRegistrationData
         * @instance
         */
        DevicePairingRegistrationData.prototype.eSkeyVal = $util.newBuffer([]);

        /**
         * DevicePairingRegistrationData eSkeySig.
         * @member {Uint8Array} eSkeySig
         * @memberof proto.DevicePairingRegistrationData
         * @instance
         */
        DevicePairingRegistrationData.prototype.eSkeySig = $util.newBuffer([]);

        /**
         * DevicePairingRegistrationData buildHash.
         * @member {Uint8Array} buildHash
         * @memberof proto.DevicePairingRegistrationData
         * @instance
         */
        DevicePairingRegistrationData.prototype.buildHash = $util.newBuffer([]);

        /**
         * DevicePairingRegistrationData deviceProps.
         * @member {Uint8Array} deviceProps
         * @memberof proto.DevicePairingRegistrationData
         * @instance
         */
        DevicePairingRegistrationData.prototype.deviceProps = $util.newBuffer([]);

        /**
         * Creates a new DevicePairingRegistrationData instance using the specified properties.
         * @function create
         * @memberof proto.DevicePairingRegistrationData
         * @static
         * @param {proto.IDevicePairingRegistrationData=} [properties] Properties to set
         * @returns {proto.DevicePairingRegistrationData} DevicePairingRegistrationData instance
         */
        DevicePairingRegistrationData.create = function create(properties) {
            return new DevicePairingRegistrationData(properties);
        };

        /**
         * Encodes the specified DevicePairingRegistrationData message. Does not implicitly {@link proto.DevicePairingRegistrationData.verify|verify} messages.
         * @function encode
         * @memberof proto.DevicePairingRegistrationData
         * @static
         * @param {proto.IDevicePairingRegistrationData} message DevicePairingRegistrationData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DevicePairingRegistrationData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.eRegid != null && Object.hasOwnProperty.call(message, "eRegid"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.eRegid);
            if (message.eKeytype != null && Object.hasOwnProperty.call(message, "eKeytype"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.eKeytype);
            if (message.eIdent != null && Object.hasOwnProperty.call(message, "eIdent"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.eIdent);
            if (message.eSkeyId != null && Object.hasOwnProperty.call(message, "eSkeyId"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.eSkeyId);
            if (message.eSkeyVal != null && Object.hasOwnProperty.call(message, "eSkeyVal"))
                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.eSkeyVal);
            if (message.eSkeySig != null && Object.hasOwnProperty.call(message, "eSkeySig"))
                writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.eSkeySig);
            if (message.buildHash != null && Object.hasOwnProperty.call(message, "buildHash"))
                writer.uint32(/* id 7, wireType 2 =*/58).bytes(message.buildHash);
            if (message.deviceProps != null && Object.hasOwnProperty.call(message, "deviceProps"))
                writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.deviceProps);
            return writer;
        };

        /**
         * Encodes the specified DevicePairingRegistrationData message, length delimited. Does not implicitly {@link proto.DevicePairingRegistrationData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DevicePairingRegistrationData
         * @static
         * @param {proto.IDevicePairingRegistrationData} message DevicePairingRegistrationData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DevicePairingRegistrationData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DevicePairingRegistrationData message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DevicePairingRegistrationData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DevicePairingRegistrationData} DevicePairingRegistrationData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DevicePairingRegistrationData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DevicePairingRegistrationData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.eRegid = reader.bytes();
                    break;
                case 2:
                    message.eKeytype = reader.bytes();
                    break;
                case 3:
                    message.eIdent = reader.bytes();
                    break;
                case 4:
                    message.eSkeyId = reader.bytes();
                    break;
                case 5:
                    message.eSkeyVal = reader.bytes();
                    break;
                case 6:
                    message.eSkeySig = reader.bytes();
                    break;
                case 7:
                    message.buildHash = reader.bytes();
                    break;
                case 8:
                    message.deviceProps = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DevicePairingRegistrationData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DevicePairingRegistrationData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DevicePairingRegistrationData} DevicePairingRegistrationData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DevicePairingRegistrationData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DevicePairingRegistrationData message.
         * @function verify
         * @memberof proto.DevicePairingRegistrationData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DevicePairingRegistrationData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.eRegid != null && message.hasOwnProperty("eRegid"))
                if (!(message.eRegid && typeof message.eRegid.length === "number" || $util.isString(message.eRegid)))
                    return "eRegid: buffer expected";
            if (message.eKeytype != null && message.hasOwnProperty("eKeytype"))
                if (!(message.eKeytype && typeof message.eKeytype.length === "number" || $util.isString(message.eKeytype)))
                    return "eKeytype: buffer expected";
            if (message.eIdent != null && message.hasOwnProperty("eIdent"))
                if (!(message.eIdent && typeof message.eIdent.length === "number" || $util.isString(message.eIdent)))
                    return "eIdent: buffer expected";
            if (message.eSkeyId != null && message.hasOwnProperty("eSkeyId"))
                if (!(message.eSkeyId && typeof message.eSkeyId.length === "number" || $util.isString(message.eSkeyId)))
                    return "eSkeyId: buffer expected";
            if (message.eSkeyVal != null && message.hasOwnProperty("eSkeyVal"))
                if (!(message.eSkeyVal && typeof message.eSkeyVal.length === "number" || $util.isString(message.eSkeyVal)))
                    return "eSkeyVal: buffer expected";
            if (message.eSkeySig != null && message.hasOwnProperty("eSkeySig"))
                if (!(message.eSkeySig && typeof message.eSkeySig.length === "number" || $util.isString(message.eSkeySig)))
                    return "eSkeySig: buffer expected";
            if (message.buildHash != null && message.hasOwnProperty("buildHash"))
                if (!(message.buildHash && typeof message.buildHash.length === "number" || $util.isString(message.buildHash)))
                    return "buildHash: buffer expected";
            if (message.deviceProps != null && message.hasOwnProperty("deviceProps"))
                if (!(message.deviceProps && typeof message.deviceProps.length === "number" || $util.isString(message.deviceProps)))
                    return "deviceProps: buffer expected";
            return null;
        };

        /**
         * Creates a DevicePairingRegistrationData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DevicePairingRegistrationData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DevicePairingRegistrationData} DevicePairingRegistrationData
         */
        DevicePairingRegistrationData.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DevicePairingRegistrationData)
                return object;
            var message = new $root.proto.DevicePairingRegistrationData();
            if (object.eRegid != null)
                if (typeof object.eRegid === "string")
                    $util.base64.decode(object.eRegid, message.eRegid = $util.newBuffer($util.base64.length(object.eRegid)), 0);
                else if (object.eRegid.length)
                    message.eRegid = object.eRegid;
            if (object.eKeytype != null)
                if (typeof object.eKeytype === "string")
                    $util.base64.decode(object.eKeytype, message.eKeytype = $util.newBuffer($util.base64.length(object.eKeytype)), 0);
                else if (object.eKeytype.length)
                    message.eKeytype = object.eKeytype;
            if (object.eIdent != null)
                if (typeof object.eIdent === "string")
                    $util.base64.decode(object.eIdent, message.eIdent = $util.newBuffer($util.base64.length(object.eIdent)), 0);
                else if (object.eIdent.length)
                    message.eIdent = object.eIdent;
            if (object.eSkeyId != null)
                if (typeof object.eSkeyId === "string")
                    $util.base64.decode(object.eSkeyId, message.eSkeyId = $util.newBuffer($util.base64.length(object.eSkeyId)), 0);
                else if (object.eSkeyId.length)
                    message.eSkeyId = object.eSkeyId;
            if (object.eSkeyVal != null)
                if (typeof object.eSkeyVal === "string")
                    $util.base64.decode(object.eSkeyVal, message.eSkeyVal = $util.newBuffer($util.base64.length(object.eSkeyVal)), 0);
                else if (object.eSkeyVal.length)
                    message.eSkeyVal = object.eSkeyVal;
            if (object.eSkeySig != null)
                if (typeof object.eSkeySig === "string")
                    $util.base64.decode(object.eSkeySig, message.eSkeySig = $util.newBuffer($util.base64.length(object.eSkeySig)), 0);
                else if (object.eSkeySig.length)
                    message.eSkeySig = object.eSkeySig;
            if (object.buildHash != null)
                if (typeof object.buildHash === "string")
                    $util.base64.decode(object.buildHash, message.buildHash = $util.newBuffer($util.base64.length(object.buildHash)), 0);
                else if (object.buildHash.length)
                    message.buildHash = object.buildHash;
            if (object.deviceProps != null)
                if (typeof object.deviceProps === "string")
                    $util.base64.decode(object.deviceProps, message.deviceProps = $util.newBuffer($util.base64.length(object.deviceProps)), 0);
                else if (object.deviceProps.length)
                    message.deviceProps = object.deviceProps;
            return message;
        };

        /**
         * Creates a plain object from a DevicePairingRegistrationData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DevicePairingRegistrationData
         * @static
         * @param {proto.DevicePairingRegistrationData} message DevicePairingRegistrationData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DevicePairingRegistrationData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.eRegid = "";
                else {
                    object.eRegid = [];
                    if (options.bytes !== Array)
                        object.eRegid = $util.newBuffer(object.eRegid);
                }
                if (options.bytes === String)
                    object.eKeytype = "";
                else {
                    object.eKeytype = [];
                    if (options.bytes !== Array)
                        object.eKeytype = $util.newBuffer(object.eKeytype);
                }
                if (options.bytes === String)
                    object.eIdent = "";
                else {
                    object.eIdent = [];
                    if (options.bytes !== Array)
                        object.eIdent = $util.newBuffer(object.eIdent);
                }
                if (options.bytes === String)
                    object.eSkeyId = "";
                else {
                    object.eSkeyId = [];
                    if (options.bytes !== Array)
                        object.eSkeyId = $util.newBuffer(object.eSkeyId);
                }
                if (options.bytes === String)
                    object.eSkeyVal = "";
                else {
                    object.eSkeyVal = [];
                    if (options.bytes !== Array)
                        object.eSkeyVal = $util.newBuffer(object.eSkeyVal);
                }
                if (options.bytes === String)
                    object.eSkeySig = "";
                else {
                    object.eSkeySig = [];
                    if (options.bytes !== Array)
                        object.eSkeySig = $util.newBuffer(object.eSkeySig);
                }
                if (options.bytes === String)
                    object.buildHash = "";
                else {
                    object.buildHash = [];
                    if (options.bytes !== Array)
                        object.buildHash = $util.newBuffer(object.buildHash);
                }
                if (options.bytes === String)
                    object.deviceProps = "";
                else {
                    object.deviceProps = [];
                    if (options.bytes !== Array)
                        object.deviceProps = $util.newBuffer(object.deviceProps);
                }
            }
            if (message.eRegid != null && message.hasOwnProperty("eRegid"))
                object.eRegid = options.bytes === String ? $util.base64.encode(message.eRegid, 0, message.eRegid.length) : options.bytes === Array ? Array.prototype.slice.call(message.eRegid) : message.eRegid;
            if (message.eKeytype != null && message.hasOwnProperty("eKeytype"))
                object.eKeytype = options.bytes === String ? $util.base64.encode(message.eKeytype, 0, message.eKeytype.length) : options.bytes === Array ? Array.prototype.slice.call(message.eKeytype) : message.eKeytype;
            if (message.eIdent != null && message.hasOwnProperty("eIdent"))
                object.eIdent = options.bytes === String ? $util.base64.encode(message.eIdent, 0, message.eIdent.length) : options.bytes === Array ? Array.prototype.slice.call(message.eIdent) : message.eIdent;
            if (message.eSkeyId != null && message.hasOwnProperty("eSkeyId"))
                object.eSkeyId = options.bytes === String ? $util.base64.encode(message.eSkeyId, 0, message.eSkeyId.length) : options.bytes === Array ? Array.prototype.slice.call(message.eSkeyId) : message.eSkeyId;
            if (message.eSkeyVal != null && message.hasOwnProperty("eSkeyVal"))
                object.eSkeyVal = options.bytes === String ? $util.base64.encode(message.eSkeyVal, 0, message.eSkeyVal.length) : options.bytes === Array ? Array.prototype.slice.call(message.eSkeyVal) : message.eSkeyVal;
            if (message.eSkeySig != null && message.hasOwnProperty("eSkeySig"))
                object.eSkeySig = options.bytes === String ? $util.base64.encode(message.eSkeySig, 0, message.eSkeySig.length) : options.bytes === Array ? Array.prototype.slice.call(message.eSkeySig) : message.eSkeySig;
            if (message.buildHash != null && message.hasOwnProperty("buildHash"))
                object.buildHash = options.bytes === String ? $util.base64.encode(message.buildHash, 0, message.buildHash.length) : options.bytes === Array ? Array.prototype.slice.call(message.buildHash) : message.buildHash;
            if (message.deviceProps != null && message.hasOwnProperty("deviceProps"))
                object.deviceProps = options.bytes === String ? $util.base64.encode(message.deviceProps, 0, message.deviceProps.length) : options.bytes === Array ? Array.prototype.slice.call(message.deviceProps) : message.deviceProps;
            return object;
        };

        /**
         * Converts this DevicePairingRegistrationData to JSON.
         * @function toJSON
         * @memberof proto.DevicePairingRegistrationData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DevicePairingRegistrationData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DevicePairingRegistrationData;
    })();

    proto.DeviceProps = (function() {

        /**
         * Properties of a DeviceProps.
         * @memberof proto
         * @interface IDeviceProps
         * @property {string|null} [os] DeviceProps os
         * @property {proto.IAppVersion|null} [version] DeviceProps version
         * @property {proto.DeviceProps.DevicePropsPlatformType|null} [platformType] DeviceProps platformType
         * @property {boolean|null} [requireFullSync] DeviceProps requireFullSync
         */

        /**
         * Constructs a new DeviceProps.
         * @memberof proto
         * @classdesc Represents a DeviceProps.
         * @implements IDeviceProps
         * @constructor
         * @param {proto.IDeviceProps=} [properties] Properties to set
         */
        function DeviceProps(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeviceProps os.
         * @member {string} os
         * @memberof proto.DeviceProps
         * @instance
         */
        DeviceProps.prototype.os = "";

        /**
         * DeviceProps version.
         * @member {proto.IAppVersion|null|undefined} version
         * @memberof proto.DeviceProps
         * @instance
         */
        DeviceProps.prototype.version = null;

        /**
         * DeviceProps platformType.
         * @member {proto.DeviceProps.DevicePropsPlatformType} platformType
         * @memberof proto.DeviceProps
         * @instance
         */
        DeviceProps.prototype.platformType = 0;

        /**
         * DeviceProps requireFullSync.
         * @member {boolean} requireFullSync
         * @memberof proto.DeviceProps
         * @instance
         */
        DeviceProps.prototype.requireFullSync = false;

        /**
         * Creates a new DeviceProps instance using the specified properties.
         * @function create
         * @memberof proto.DeviceProps
         * @static
         * @param {proto.IDeviceProps=} [properties] Properties to set
         * @returns {proto.DeviceProps} DeviceProps instance
         */
        DeviceProps.create = function create(properties) {
            return new DeviceProps(properties);
        };

        /**
         * Encodes the specified DeviceProps message. Does not implicitly {@link proto.DeviceProps.verify|verify} messages.
         * @function encode
         * @memberof proto.DeviceProps
         * @static
         * @param {proto.IDeviceProps} message DeviceProps message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceProps.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.os != null && Object.hasOwnProperty.call(message, "os"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.os);
            if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                $root.proto.AppVersion.encode(message.version, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.platformType != null && Object.hasOwnProperty.call(message, "platformType"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.platformType);
            if (message.requireFullSync != null && Object.hasOwnProperty.call(message, "requireFullSync"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.requireFullSync);
            return writer;
        };

        /**
         * Encodes the specified DeviceProps message, length delimited. Does not implicitly {@link proto.DeviceProps.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeviceProps
         * @static
         * @param {proto.IDeviceProps} message DeviceProps message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceProps.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeviceProps message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeviceProps
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeviceProps} DeviceProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceProps.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeviceProps();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.os = reader.string();
                    break;
                case 2:
                    message.version = $root.proto.AppVersion.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.platformType = reader.int32();
                    break;
                case 4:
                    message.requireFullSync = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeviceProps message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeviceProps
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeviceProps} DeviceProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceProps.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeviceProps message.
         * @function verify
         * @memberof proto.DeviceProps
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeviceProps.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.os != null && message.hasOwnProperty("os"))
                if (!$util.isString(message.os))
                    return "os: string expected";
            if (message.version != null && message.hasOwnProperty("version")) {
                var error = $root.proto.AppVersion.verify(message.version);
                if (error)
                    return "version." + error;
            }
            if (message.platformType != null && message.hasOwnProperty("platformType"))
                switch (message.platformType) {
                default:
                    return "platformType: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                case 8:
                case 9:
                case 10:
                case 11:
                case 12:
                case 13:
                    break;
                }
            if (message.requireFullSync != null && message.hasOwnProperty("requireFullSync"))
                if (typeof message.requireFullSync !== "boolean")
                    return "requireFullSync: boolean expected";
            return null;
        };

        /**
         * Creates a DeviceProps message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeviceProps
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeviceProps} DeviceProps
         */
        DeviceProps.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeviceProps)
                return object;
            var message = new $root.proto.DeviceProps();
            if (object.os != null)
                message.os = String(object.os);
            if (object.version != null) {
                if (typeof object.version !== "object")
                    throw TypeError(".proto.DeviceProps.version: object expected");
                message.version = $root.proto.AppVersion.fromObject(object.version);
            }
            switch (object.platformType) {
            case "UNKNOWN":
            case 0:
                message.platformType = 0;
                break;
            case "CHROME":
            case 1:
                message.platformType = 1;
                break;
            case "FIREFOX":
            case 2:
                message.platformType = 2;
                break;
            case "IE":
            case 3:
                message.platformType = 3;
                break;
            case "OPERA":
            case 4:
                message.platformType = 4;
                break;
            case "SAFARI":
            case 5:
                message.platformType = 5;
                break;
            case "EDGE":
            case 6:
                message.platformType = 6;
                break;
            case "DESKTOP":
            case 7:
                message.platformType = 7;
                break;
            case "IPAD":
            case 8:
                message.platformType = 8;
                break;
            case "ANDROID_TABLET":
            case 9:
                message.platformType = 9;
                break;
            case "OHANA":
            case 10:
                message.platformType = 10;
                break;
            case "ALOHA":
            case 11:
                message.platformType = 11;
                break;
            case "CATALINA":
            case 12:
                message.platformType = 12;
                break;
            case "TCL_TV":
            case 13:
                message.platformType = 13;
                break;
            }
            if (object.requireFullSync != null)
                message.requireFullSync = Boolean(object.requireFullSync);
            return message;
        };

        /**
         * Creates a plain object from a DeviceProps message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeviceProps
         * @static
         * @param {proto.DeviceProps} message DeviceProps
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeviceProps.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.os = "";
                object.version = null;
                object.platformType = options.enums === String ? "UNKNOWN" : 0;
                object.requireFullSync = false;
            }
            if (message.os != null && message.hasOwnProperty("os"))
                object.os = message.os;
            if (message.version != null && message.hasOwnProperty("version"))
                object.version = $root.proto.AppVersion.toObject(message.version, options);
            if (message.platformType != null && message.hasOwnProperty("platformType"))
                object.platformType = options.enums === String ? $root.proto.DeviceProps.DevicePropsPlatformType[message.platformType] : message.platformType;
            if (message.requireFullSync != null && message.hasOwnProperty("requireFullSync"))
                object.requireFullSync = message.requireFullSync;
            return object;
        };

        /**
         * Converts this DeviceProps to JSON.
         * @function toJSON
         * @memberof proto.DeviceProps
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeviceProps.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * DevicePropsPlatformType enum.
         * @name proto.DeviceProps.DevicePropsPlatformType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} CHROME=1 CHROME value
         * @property {number} FIREFOX=2 FIREFOX value
         * @property {number} IE=3 IE value
         * @property {number} OPERA=4 OPERA value
         * @property {number} SAFARI=5 SAFARI value
         * @property {number} EDGE=6 EDGE value
         * @property {number} DESKTOP=7 DESKTOP value
         * @property {number} IPAD=8 IPAD value
         * @property {number} ANDROID_TABLET=9 ANDROID_TABLET value
         * @property {number} OHANA=10 OHANA value
         * @property {number} ALOHA=11 ALOHA value
         * @property {number} CATALINA=12 CATALINA value
         * @property {number} TCL_TV=13 TCL_TV value
         */
        DeviceProps.DevicePropsPlatformType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "CHROME"] = 1;
            values[valuesById[2] = "FIREFOX"] = 2;
            values[valuesById[3] = "IE"] = 3;
            values[valuesById[4] = "OPERA"] = 4;
            values[valuesById[5] = "SAFARI"] = 5;
            values[valuesById[6] = "EDGE"] = 6;
            values[valuesById[7] = "DESKTOP"] = 7;
            values[valuesById[8] = "IPAD"] = 8;
            values[valuesById[9] = "ANDROID_TABLET"] = 9;
            values[valuesById[10] = "OHANA"] = 10;
            values[valuesById[11] = "ALOHA"] = 11;
            values[valuesById[12] = "CATALINA"] = 12;
            values[valuesById[13] = "TCL_TV"] = 13;
            return values;
        })();

        return DeviceProps;
    })();

    proto.DeviceSentMessage = (function() {

        /**
         * Properties of a DeviceSentMessage.
         * @memberof proto
         * @interface IDeviceSentMessage
         * @property {string|null} [destinationJid] DeviceSentMessage destinationJid
         * @property {proto.IMessage|null} [message] DeviceSentMessage message
         * @property {string|null} [phash] DeviceSentMessage phash
         */

        /**
         * Constructs a new DeviceSentMessage.
         * @memberof proto
         * @classdesc Represents a DeviceSentMessage.
         * @implements IDeviceSentMessage
         * @constructor
         * @param {proto.IDeviceSentMessage=} [properties] Properties to set
         */
        function DeviceSentMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeviceSentMessage destinationJid.
         * @member {string} destinationJid
         * @memberof proto.DeviceSentMessage
         * @instance
         */
        DeviceSentMessage.prototype.destinationJid = "";

        /**
         * DeviceSentMessage message.
         * @member {proto.IMessage|null|undefined} message
         * @memberof proto.DeviceSentMessage
         * @instance
         */
        DeviceSentMessage.prototype.message = null;

        /**
         * DeviceSentMessage phash.
         * @member {string} phash
         * @memberof proto.DeviceSentMessage
         * @instance
         */
        DeviceSentMessage.prototype.phash = "";

        /**
         * Creates a new DeviceSentMessage instance using the specified properties.
         * @function create
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {proto.IDeviceSentMessage=} [properties] Properties to set
         * @returns {proto.DeviceSentMessage} DeviceSentMessage instance
         */
        DeviceSentMessage.create = function create(properties) {
            return new DeviceSentMessage(properties);
        };

        /**
         * Encodes the specified DeviceSentMessage message. Does not implicitly {@link proto.DeviceSentMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {proto.IDeviceSentMessage} message DeviceSentMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceSentMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.destinationJid != null && Object.hasOwnProperty.call(message, "destinationJid"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.destinationJid);
            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                $root.proto.Message.encode(message.message, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.phash != null && Object.hasOwnProperty.call(message, "phash"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.phash);
            return writer;
        };

        /**
         * Encodes the specified DeviceSentMessage message, length delimited. Does not implicitly {@link proto.DeviceSentMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {proto.IDeviceSentMessage} message DeviceSentMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceSentMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeviceSentMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeviceSentMessage} DeviceSentMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceSentMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeviceSentMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.destinationJid = reader.string();
                    break;
                case 2:
                    message.message = $root.proto.Message.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.phash = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeviceSentMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeviceSentMessage} DeviceSentMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceSentMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeviceSentMessage message.
         * @function verify
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeviceSentMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.destinationJid != null && message.hasOwnProperty("destinationJid"))
                if (!$util.isString(message.destinationJid))
                    return "destinationJid: string expected";
            if (message.message != null && message.hasOwnProperty("message")) {
                var error = $root.proto.Message.verify(message.message);
                if (error)
                    return "message." + error;
            }
            if (message.phash != null && message.hasOwnProperty("phash"))
                if (!$util.isString(message.phash))
                    return "phash: string expected";
            return null;
        };

        /**
         * Creates a DeviceSentMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeviceSentMessage} DeviceSentMessage
         */
        DeviceSentMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeviceSentMessage)
                return object;
            var message = new $root.proto.DeviceSentMessage();
            if (object.destinationJid != null)
                message.destinationJid = String(object.destinationJid);
            if (object.message != null) {
                if (typeof object.message !== "object")
                    throw TypeError(".proto.DeviceSentMessage.message: object expected");
                message.message = $root.proto.Message.fromObject(object.message);
            }
            if (object.phash != null)
                message.phash = String(object.phash);
            return message;
        };

        /**
         * Creates a plain object from a DeviceSentMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeviceSentMessage
         * @static
         * @param {proto.DeviceSentMessage} message DeviceSentMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeviceSentMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.destinationJid = "";
                object.message = null;
                object.phash = "";
            }
            if (message.destinationJid != null && message.hasOwnProperty("destinationJid"))
                object.destinationJid = message.destinationJid;
            if (message.message != null && message.hasOwnProperty("message"))
                object.message = $root.proto.Message.toObject(message.message, options);
            if (message.phash != null && message.hasOwnProperty("phash"))
                object.phash = message.phash;
            return object;
        };

        /**
         * Converts this DeviceSentMessage to JSON.
         * @function toJSON
         * @memberof proto.DeviceSentMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeviceSentMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeviceSentMessage;
    })();

    proto.DisappearingMode = (function() {

        /**
         * Properties of a DisappearingMode.
         * @memberof proto
         * @interface IDisappearingMode
         * @property {proto.DisappearingMode.DisappearingModeInitiator|null} [initiator] DisappearingMode initiator
         */

        /**
         * Constructs a new DisappearingMode.
         * @memberof proto
         * @classdesc Represents a DisappearingMode.
         * @implements IDisappearingMode
         * @constructor
         * @param {proto.IDisappearingMode=} [properties] Properties to set
         */
        function DisappearingMode(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DisappearingMode initiator.
         * @member {proto.DisappearingMode.DisappearingModeInitiator} initiator
         * @memberof proto.DisappearingMode
         * @instance
         */
        DisappearingMode.prototype.initiator = 0;

        /**
         * Creates a new DisappearingMode instance using the specified properties.
         * @function create
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.IDisappearingMode=} [properties] Properties to set
         * @returns {proto.DisappearingMode} DisappearingMode instance
         */
        DisappearingMode.create = function create(properties) {
            return new DisappearingMode(properties);
        };

        /**
         * Encodes the specified DisappearingMode message. Does not implicitly {@link proto.DisappearingMode.verify|verify} messages.
         * @function encode
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.IDisappearingMode} message DisappearingMode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DisappearingMode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.initiator != null && Object.hasOwnProperty.call(message, "initiator"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.initiator);
            return writer;
        };

        /**
         * Encodes the specified DisappearingMode message, length delimited. Does not implicitly {@link proto.DisappearingMode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.IDisappearingMode} message DisappearingMode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DisappearingMode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DisappearingMode message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DisappearingMode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DisappearingMode} DisappearingMode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DisappearingMode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DisappearingMode();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.initiator = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DisappearingMode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DisappearingMode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DisappearingMode} DisappearingMode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DisappearingMode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DisappearingMode message.
         * @function verify
         * @memberof proto.DisappearingMode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DisappearingMode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.initiator != null && message.hasOwnProperty("initiator"))
                switch (message.initiator) {
                default:
                    return "initiator: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            return null;
        };

        /**
         * Creates a DisappearingMode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DisappearingMode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DisappearingMode} DisappearingMode
         */
        DisappearingMode.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DisappearingMode)
                return object;
            var message = new $root.proto.DisappearingMode();
            switch (object.initiator) {
            case "CHANGED_IN_CHAT":
            case 0:
                message.initiator = 0;
                break;
            case "INITIATED_BY_ME":
            case 1:
                message.initiator = 1;
                break;
            case "INITIATED_BY_OTHER":
            case 2:
                message.initiator = 2;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a DisappearingMode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.DisappearingMode} message DisappearingMode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DisappearingMode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.initiator = options.enums === String ? "CHANGED_IN_CHAT" : 0;
            if (message.initiator != null && message.hasOwnProperty("initiator"))
                object.initiator = options.enums === String ? $root.proto.DisappearingMode.DisappearingModeInitiator[message.initiator] : message.initiator;
            return object;
        };

        /**
         * Converts this DisappearingMode to JSON.
         * @function toJSON
         * @memberof proto.DisappearingMode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DisappearingMode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * DisappearingModeInitiator enum.
         * @name proto.DisappearingMode.DisappearingModeInitiator
         * @enum {number}
         * @property {number} CHANGED_IN_CHAT=0 CHANGED_IN_CHAT value
         * @property {number} INITIATED_BY_ME=1 INITIATED_BY_ME value
         * @property {number} INITIATED_BY_OTHER=2 INITIATED_BY_OTHER value
         */
        DisappearingMode.DisappearingModeInitiator = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CHANGED_IN_CHAT"] = 0;
            values[valuesById[1] = "INITIATED_BY_ME"] = 1;
            values[valuesById[2] = "INITIATED_BY_OTHER"] = 2;
            return values;
        })();

        return DisappearingMode;
    })();

    proto.DocumentMessage = (function() {

        /**
         * Properties of a DocumentMessage.
         * @memberof proto
         * @interface IDocumentMessage
         * @property {string|null} [url] DocumentMessage url
         * @property {string|null} [mimetype] DocumentMessage mimetype
         * @property {string|null} [title] DocumentMessage title
         * @property {Uint8Array|null} [fileSha256] DocumentMessage fileSha256
         * @property {number|Long|null} [fileLength] DocumentMessage fileLength
         * @property {number|null} [pageCount] DocumentMessage pageCount
         * @property {Uint8Array|null} [mediaKey] DocumentMessage mediaKey
         * @property {string|null} [fileName] DocumentMessage fileName
         * @property {Uint8Array|null} [fileEncSha256] DocumentMessage fileEncSha256
         * @property {string|null} [directPath] DocumentMessage directPath
         * @property {number|Long|null} [mediaKeyTimestamp] DocumentMessage mediaKeyTimestamp
         * @property {boolean|null} [contactVcard] DocumentMessage contactVcard
         * @property {string|null} [thumbnailDirectPath] DocumentMessage thumbnailDirectPath
         * @property {Uint8Array|null} [thumbnailSha256] DocumentMessage thumbnailSha256
         * @property {Uint8Array|null} [thumbnailEncSha256] DocumentMessage thumbnailEncSha256
         * @property {Uint8Array|null} [jpegThumbnail] DocumentMessage jpegThumbnail
         * @property {proto.IContextInfo|null} [contextInfo] DocumentMessage contextInfo
         * @property {number|null} [thumbnailHeight] DocumentMessage thumbnailHeight
         * @property {number|null} [thumbnailWidth] DocumentMessage thumbnailWidth
         * @property {string|null} [caption] DocumentMessage caption
         */

        /**
         * Constructs a new DocumentMessage.
         * @memberof proto
         * @classdesc Represents a DocumentMessage.
         * @implements IDocumentMessage
         * @constructor
         * @param {proto.IDocumentMessage=} [properties] Properties to set
         */
        function DocumentMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DocumentMessage url.
         * @member {string} url
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.url = "";

        /**
         * DocumentMessage mimetype.
         * @member {string} mimetype
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.mimetype = "";

        /**
         * DocumentMessage title.
         * @member {string} title
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.title = "";

        /**
         * DocumentMessage fileSha256.
         * @member {Uint8Array} fileSha256
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.fileSha256 = $util.newBuffer([]);

        /**
         * DocumentMessage fileLength.
         * @member {number|Long} fileLength
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.fileLength = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * DocumentMessage pageCount.
         * @member {number} pageCount
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.pageCount = 0;

        /**
         * DocumentMessage mediaKey.
         * @member {Uint8Array} mediaKey
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.mediaKey = $util.newBuffer([]);

        /**
         * DocumentMessage fileName.
         * @member {string} fileName
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.fileName = "";

        /**
         * DocumentMessage fileEncSha256.
         * @member {Uint8Array} fileEncSha256
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.fileEncSha256 = $util.newBuffer([]);

        /**
         * DocumentMessage directPath.
         * @member {string} directPath
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.directPath = "";

        /**
         * DocumentMessage mediaKeyTimestamp.
         * @member {number|Long} mediaKeyTimestamp
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * DocumentMessage contactVcard.
         * @member {boolean} contactVcard
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.contactVcard = false;

        /**
         * DocumentMessage thumbnailDirectPath.
         * @member {string} thumbnailDirectPath
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.thumbnailDirectPath = "";

        /**
         * DocumentMessage thumbnailSha256.
         * @member {Uint8Array} thumbnailSha256
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.thumbnailSha256 = $util.newBuffer([]);

        /**
         * DocumentMessage thumbnailEncSha256.
         * @member {Uint8Array} thumbnailEncSha256
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.thumbnailEncSha256 = $util.newBuffer([]);

        /**
         * DocumentMessage jpegThumbnail.
         * @member {Uint8Array} jpegThumbnail
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.jpegThumbnail = $util.newBuffer([]);

        /**
         * DocumentMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.contextInfo = null;

        /**
         * DocumentMessage thumbnailHeight.
         * @member {number} thumbnailHeight
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.thumbnailHeight = 0;

        /**
         * DocumentMessage thumbnailWidth.
         * @member {number} thumbnailWidth
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.thumbnailWidth = 0;

        /**
         * DocumentMessage caption.
         * @member {string} caption
         * @memberof proto.DocumentMessage
         * @instance
         */
        DocumentMessage.prototype.caption = "";

        /**
         * Creates a new DocumentMessage instance using the specified properties.
         * @function create
         * @memberof proto.DocumentMessage
         * @static
         * @param {proto.IDocumentMessage=} [properties] Properties to set
         * @returns {proto.DocumentMessage} DocumentMessage instance
         */
        DocumentMessage.create = function create(properties) {
            return new DocumentMessage(properties);
        };

        /**
         * Encodes the specified DocumentMessage message. Does not implicitly {@link proto.DocumentMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.DocumentMessage
         * @static
         * @param {proto.IDocumentMessage} message DocumentMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.url);
            if (message.mimetype != null && Object.hasOwnProperty.call(message, "mimetype"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.mimetype);
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.title);
            if (message.fileSha256 != null && Object.hasOwnProperty.call(message, "fileSha256"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.fileSha256);
            if (message.fileLength != null && Object.hasOwnProperty.call(message, "fileLength"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint64(message.fileLength);
            if (message.pageCount != null && Object.hasOwnProperty.call(message, "pageCount"))
                writer.uint32(/* id 6, wireType 0 =*/48).uint32(message.pageCount);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 7, wireType 2 =*/58).bytes(message.mediaKey);
            if (message.fileName != null && Object.hasOwnProperty.call(message, "fileName"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.fileName);
            if (message.fileEncSha256 != null && Object.hasOwnProperty.call(message, "fileEncSha256"))
                writer.uint32(/* id 9, wireType 2 =*/74).bytes(message.fileEncSha256);
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 10, wireType 2 =*/82).string(message.directPath);
            if (message.mediaKeyTimestamp != null && Object.hasOwnProperty.call(message, "mediaKeyTimestamp"))
                writer.uint32(/* id 11, wireType 0 =*/88).int64(message.mediaKeyTimestamp);
            if (message.contactVcard != null && Object.hasOwnProperty.call(message, "contactVcard"))
                writer.uint32(/* id 12, wireType 0 =*/96).bool(message.contactVcard);
            if (message.thumbnailDirectPath != null && Object.hasOwnProperty.call(message, "thumbnailDirectPath"))
                writer.uint32(/* id 13, wireType 2 =*/106).string(message.thumbnailDirectPath);
            if (message.thumbnailSha256 != null && Object.hasOwnProperty.call(message, "thumbnailSha256"))
                writer.uint32(/* id 14, wireType 2 =*/114).bytes(message.thumbnailSha256);
            if (message.thumbnailEncSha256 != null && Object.hasOwnProperty.call(message, "thumbnailEncSha256"))
                writer.uint32(/* id 15, wireType 2 =*/122).bytes(message.thumbnailEncSha256);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 16, wireType 2 =*/130).bytes(message.jpegThumbnail);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.thumbnailHeight != null && Object.hasOwnProperty.call(message, "thumbnailHeight"))
                writer.uint32(/* id 18, wireType 0 =*/144).uint32(message.thumbnailHeight);
            if (message.thumbnailWidth != null && Object.hasOwnProperty.call(message, "thumbnailWidth"))
                writer.uint32(/* id 19, wireType 0 =*/152).uint32(message.thumbnailWidth);
            if (message.caption != null && Object.hasOwnProperty.call(message, "caption"))
                writer.uint32(/* id 20, wireType 2 =*/162).string(message.caption);
            return writer;
        };

        /**
         * Encodes the specified DocumentMessage message, length delimited. Does not implicitly {@link proto.DocumentMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DocumentMessage
         * @static
         * @param {proto.IDocumentMessage} message DocumentMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DocumentMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DocumentMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DocumentMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DocumentMessage} DocumentMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DocumentMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.url = reader.string();
                    break;
                case 2:
                    message.mimetype = reader.string();
                    break;
                case 3:
                    message.title = reader.string();
                    break;
                case 4:
                    message.fileSha256 = reader.bytes();
                    break;
                case 5:
                    message.fileLength = reader.uint64();
                    break;
                case 6:
                    message.pageCount = reader.uint32();
                    break;
                case 7:
                    message.mediaKey = reader.bytes();
                    break;
                case 8:
                    message.fileName = reader.string();
                    break;
                case 9:
                    message.fileEncSha256 = reader.bytes();
                    break;
                case 10:
                    message.directPath = reader.string();
                    break;
                case 11:
                    message.mediaKeyTimestamp = reader.int64();
                    break;
                case 12:
                    message.contactVcard = reader.bool();
                    break;
                case 13:
                    message.thumbnailDirectPath = reader.string();
                    break;
                case 14:
                    message.thumbnailSha256 = reader.bytes();
                    break;
                case 15:
                    message.thumbnailEncSha256 = reader.bytes();
                    break;
                case 16:
                    message.jpegThumbnail = reader.bytes();
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.thumbnailHeight = reader.uint32();
                    break;
                case 19:
                    message.thumbnailWidth = reader.uint32();
                    break;
                case 20:
                    message.caption = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DocumentMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DocumentMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DocumentMessage} DocumentMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DocumentMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DocumentMessage message.
         * @function verify
         * @memberof proto.DocumentMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DocumentMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.url != null && message.hasOwnProperty("url"))
                if (!$util.isString(message.url))
                    return "url: string expected";
            if (message.mimetype != null && message.hasOwnProperty("mimetype"))
                if (!$util.isString(message.mimetype))
                    return "mimetype: string expected";
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                if (!(message.fileSha256 && typeof message.fileSha256.length === "number" || $util.isString(message.fileSha256)))
                    return "fileSha256: buffer expected";
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (!$util.isInteger(message.fileLength) && !(message.fileLength && $util.isInteger(message.fileLength.low) && $util.isInteger(message.fileLength.high)))
                    return "fileLength: integer|Long expected";
            if (message.pageCount != null && message.hasOwnProperty("pageCount"))
                if (!$util.isInteger(message.pageCount))
                    return "pageCount: integer expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!(message.mediaKey && typeof message.mediaKey.length === "number" || $util.isString(message.mediaKey)))
                    return "mediaKey: buffer expected";
            if (message.fileName != null && message.hasOwnProperty("fileName"))
                if (!$util.isString(message.fileName))
                    return "fileName: string expected";
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                if (!(message.fileEncSha256 && typeof message.fileEncSha256.length === "number" || $util.isString(message.fileEncSha256)))
                    return "fileEncSha256: buffer expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (!$util.isInteger(message.mediaKeyTimestamp) && !(message.mediaKeyTimestamp && $util.isInteger(message.mediaKeyTimestamp.low) && $util.isInteger(message.mediaKeyTimestamp.high)))
                    return "mediaKeyTimestamp: integer|Long expected";
            if (message.contactVcard != null && message.hasOwnProperty("contactVcard"))
                if (typeof message.contactVcard !== "boolean")
                    return "contactVcard: boolean expected";
            if (message.thumbnailDirectPath != null && message.hasOwnProperty("thumbnailDirectPath"))
                if (!$util.isString(message.thumbnailDirectPath))
                    return "thumbnailDirectPath: string expected";
            if (message.thumbnailSha256 != null && message.hasOwnProperty("thumbnailSha256"))
                if (!(message.thumbnailSha256 && typeof message.thumbnailSha256.length === "number" || $util.isString(message.thumbnailSha256)))
                    return "thumbnailSha256: buffer expected";
            if (message.thumbnailEncSha256 != null && message.hasOwnProperty("thumbnailEncSha256"))
                if (!(message.thumbnailEncSha256 && typeof message.thumbnailEncSha256.length === "number" || $util.isString(message.thumbnailEncSha256)))
                    return "thumbnailEncSha256: buffer expected";
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                    return "jpegThumbnail: buffer expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.thumbnailHeight != null && message.hasOwnProperty("thumbnailHeight"))
                if (!$util.isInteger(message.thumbnailHeight))
                    return "thumbnailHeight: integer expected";
            if (message.thumbnailWidth != null && message.hasOwnProperty("thumbnailWidth"))
                if (!$util.isInteger(message.thumbnailWidth))
                    return "thumbnailWidth: integer expected";
            if (message.caption != null && message.hasOwnProperty("caption"))
                if (!$util.isString(message.caption))
                    return "caption: string expected";
            return null;
        };

        /**
         * Creates a DocumentMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DocumentMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DocumentMessage} DocumentMessage
         */
        DocumentMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DocumentMessage)
                return object;
            var message = new $root.proto.DocumentMessage();
            if (object.url != null)
                message.url = String(object.url);
            if (object.mimetype != null)
                message.mimetype = String(object.mimetype);
            if (object.title != null)
                message.title = String(object.title);
            if (object.fileSha256 != null)
                if (typeof object.fileSha256 === "string")
                    $util.base64.decode(object.fileSha256, message.fileSha256 = $util.newBuffer($util.base64.length(object.fileSha256)), 0);
                else if (object.fileSha256.length)
                    message.fileSha256 = object.fileSha256;
            if (object.fileLength != null)
                if ($util.Long)
                    (message.fileLength = $util.Long.fromValue(object.fileLength)).unsigned = true;
                else if (typeof object.fileLength === "string")
                    message.fileLength = parseInt(object.fileLength, 10);
                else if (typeof object.fileLength === "number")
                    message.fileLength = object.fileLength;
                else if (typeof object.fileLength === "object")
                    message.fileLength = new $util.LongBits(object.fileLength.low >>> 0, object.fileLength.high >>> 0).toNumber(true);
            if (object.pageCount != null)
                message.pageCount = object.pageCount >>> 0;
            if (object.mediaKey != null)
                if (typeof object.mediaKey === "string")
                    $util.base64.decode(object.mediaKey, message.mediaKey = $util.newBuffer($util.base64.length(object.mediaKey)), 0);
                else if (object.mediaKey.length)
                    message.mediaKey = object.mediaKey;
            if (object.fileName != null)
                message.fileName = String(object.fileName);
            if (object.fileEncSha256 != null)
                if (typeof object.fileEncSha256 === "string")
                    $util.base64.decode(object.fileEncSha256, message.fileEncSha256 = $util.newBuffer($util.base64.length(object.fileEncSha256)), 0);
                else if (object.fileEncSha256.length)
                    message.fileEncSha256 = object.fileEncSha256;
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.mediaKeyTimestamp != null)
                if ($util.Long)
                    (message.mediaKeyTimestamp = $util.Long.fromValue(object.mediaKeyTimestamp)).unsigned = false;
                else if (typeof object.mediaKeyTimestamp === "string")
                    message.mediaKeyTimestamp = parseInt(object.mediaKeyTimestamp, 10);
                else if (typeof object.mediaKeyTimestamp === "number")
                    message.mediaKeyTimestamp = object.mediaKeyTimestamp;
                else if (typeof object.mediaKeyTimestamp === "object")
                    message.mediaKeyTimestamp = new $util.LongBits(object.mediaKeyTimestamp.low >>> 0, object.mediaKeyTimestamp.high >>> 0).toNumber();
            if (object.contactVcard != null)
                message.contactVcard = Boolean(object.contactVcard);
            if (object.thumbnailDirectPath != null)
                message.thumbnailDirectPath = String(object.thumbnailDirectPath);
            if (object.thumbnailSha256 != null)
                if (typeof object.thumbnailSha256 === "string")
                    $util.base64.decode(object.thumbnailSha256, message.thumbnailSha256 = $util.newBuffer($util.base64.length(object.thumbnailSha256)), 0);
                else if (object.thumbnailSha256.length)
                    message.thumbnailSha256 = object.thumbnailSha256;
            if (object.thumbnailEncSha256 != null)
                if (typeof object.thumbnailEncSha256 === "string")
                    $util.base64.decode(object.thumbnailEncSha256, message.thumbnailEncSha256 = $util.newBuffer($util.base64.length(object.thumbnailEncSha256)), 0);
                else if (object.thumbnailEncSha256.length)
                    message.thumbnailEncSha256 = object.thumbnailEncSha256;
            if (object.jpegThumbnail != null)
                if (typeof object.jpegThumbnail === "string")
                    $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                else if (object.jpegThumbnail.length)
                    message.jpegThumbnail = object.jpegThumbnail;
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.DocumentMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.thumbnailHeight != null)
                message.thumbnailHeight = object.thumbnailHeight >>> 0;
            if (object.thumbnailWidth != null)
                message.thumbnailWidth = object.thumbnailWidth >>> 0;
            if (object.caption != null)
                message.caption = String(object.caption);
            return message;
        };

        /**
         * Creates a plain object from a DocumentMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DocumentMessage
         * @static
         * @param {proto.DocumentMessage} message DocumentMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DocumentMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.url = "";
                object.mimetype = "";
                object.title = "";
                if (options.bytes === String)
                    object.fileSha256 = "";
                else {
                    object.fileSha256 = [];
                    if (options.bytes !== Array)
                        object.fileSha256 = $util.newBuffer(object.fileSha256);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fileLength = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fileLength = options.longs === String ? "0" : 0;
                object.pageCount = 0;
                if (options.bytes === String)
                    object.mediaKey = "";
                else {
                    object.mediaKey = [];
                    if (options.bytes !== Array)
                        object.mediaKey = $util.newBuffer(object.mediaKey);
                }
                object.fileName = "";
                if (options.bytes === String)
                    object.fileEncSha256 = "";
                else {
                    object.fileEncSha256 = [];
                    if (options.bytes !== Array)
                        object.fileEncSha256 = $util.newBuffer(object.fileEncSha256);
                }
                object.directPath = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.mediaKeyTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.mediaKeyTimestamp = options.longs === String ? "0" : 0;
                object.contactVcard = false;
                object.thumbnailDirectPath = "";
                if (options.bytes === String)
                    object.thumbnailSha256 = "";
                else {
                    object.thumbnailSha256 = [];
                    if (options.bytes !== Array)
                        object.thumbnailSha256 = $util.newBuffer(object.thumbnailSha256);
                }
                if (options.bytes === String)
                    object.thumbnailEncSha256 = "";
                else {
                    object.thumbnailEncSha256 = [];
                    if (options.bytes !== Array)
                        object.thumbnailEncSha256 = $util.newBuffer(object.thumbnailEncSha256);
                }
                if (options.bytes === String)
                    object.jpegThumbnail = "";
                else {
                    object.jpegThumbnail = [];
                    if (options.bytes !== Array)
                        object.jpegThumbnail = $util.newBuffer(object.jpegThumbnail);
                }
                object.contextInfo = null;
                object.thumbnailHeight = 0;
                object.thumbnailWidth = 0;
                object.caption = "";
            }
            if (message.url != null && message.hasOwnProperty("url"))
                object.url = message.url;
            if (message.mimetype != null && message.hasOwnProperty("mimetype"))
                object.mimetype = message.mimetype;
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                object.fileSha256 = options.bytes === String ? $util.base64.encode(message.fileSha256, 0, message.fileSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileSha256) : message.fileSha256;
            if (message.fileLength != null && message.hasOwnProperty("fileLength"))
                if (typeof message.fileLength === "number")
                    object.fileLength = options.longs === String ? String(message.fileLength) : message.fileLength;
                else
                    object.fileLength = options.longs === String ? $util.Long.prototype.toString.call(message.fileLength) : options.longs === Number ? new $util.LongBits(message.fileLength.low >>> 0, message.fileLength.high >>> 0).toNumber(true) : message.fileLength;
            if (message.pageCount != null && message.hasOwnProperty("pageCount"))
                object.pageCount = message.pageCount;
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = options.bytes === String ? $util.base64.encode(message.mediaKey, 0, message.mediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.mediaKey) : message.mediaKey;
            if (message.fileName != null && message.hasOwnProperty("fileName"))
                object.fileName = message.fileName;
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                object.fileEncSha256 = options.bytes === String ? $util.base64.encode(message.fileEncSha256, 0, message.fileEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileEncSha256) : message.fileEncSha256;
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (typeof message.mediaKeyTimestamp === "number")
                    object.mediaKeyTimestamp = options.longs === String ? String(message.mediaKeyTimestamp) : message.mediaKeyTimestamp;
                else
                    object.mediaKeyTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.mediaKeyTimestamp) : options.longs === Number ? new $util.LongBits(message.mediaKeyTimestamp.low >>> 0, message.mediaKeyTimestamp.high >>> 0).toNumber() : message.mediaKeyTimestamp;
            if (message.contactVcard != null && message.hasOwnProperty("contactVcard"))
                object.contactVcard = message.contactVcard;
            if (message.thumbnailDirectPath != null && message.hasOwnProperty("thumbnailDirectPath"))
                object.thumbnailDirectPath = message.thumbnailDirectPath;
            if (message.thumbnailSha256 != null && message.hasOwnProperty("thumbnailSha256"))
                object.thumbnailSha256 = options.bytes === String ? $util.base64.encode(message.thumbnailSha256, 0, message.thumbnailSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnailSha256) : message.thumbnailSha256;
            if (message.thumbnailEncSha256 != null && message.hasOwnProperty("thumbnailEncSha256"))
                object.thumbnailEncSha256 = options.bytes === String ? $util.base64.encode(message.thumbnailEncSha256, 0, message.thumbnailEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnailEncSha256) : message.thumbnailEncSha256;
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.thumbnailHeight != null && message.hasOwnProperty("thumbnailHeight"))
                object.thumbnailHeight = message.thumbnailHeight;
            if (message.thumbnailWidth != null && message.hasOwnProperty("thumbnailWidth"))
                object.thumbnailWidth = message.thumbnailWidth;
            if (message.caption != null && message.hasOwnProperty("caption"))
                object.caption = message.caption;
            return object;
        };

        /**
         * Converts this DocumentMessage to JSON.
         * @function toJSON
         * @memberof proto.DocumentMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DocumentMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DocumentMessage;
    })();

    proto.EphemeralSetting = (function() {

        /**
         * Properties of an EphemeralSetting.
         * @memberof proto
         * @interface IEphemeralSetting
         * @property {number|null} [duration] EphemeralSetting duration
         * @property {number|Long|null} [timestamp] EphemeralSetting timestamp
         */

        /**
         * Constructs a new EphemeralSetting.
         * @memberof proto
         * @classdesc Represents an EphemeralSetting.
         * @implements IEphemeralSetting
         * @constructor
         * @param {proto.IEphemeralSetting=} [properties] Properties to set
         */
        function EphemeralSetting(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * EphemeralSetting duration.
         * @member {number} duration
         * @memberof proto.EphemeralSetting
         * @instance
         */
        EphemeralSetting.prototype.duration = 0;

        /**
         * EphemeralSetting timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.EphemeralSetting
         * @instance
         */
        EphemeralSetting.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new EphemeralSetting instance using the specified properties.
         * @function create
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.IEphemeralSetting=} [properties] Properties to set
         * @returns {proto.EphemeralSetting} EphemeralSetting instance
         */
        EphemeralSetting.create = function create(properties) {
            return new EphemeralSetting(properties);
        };

        /**
         * Encodes the specified EphemeralSetting message. Does not implicitly {@link proto.EphemeralSetting.verify|verify} messages.
         * @function encode
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.IEphemeralSetting} message EphemeralSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        EphemeralSetting.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.duration != null && Object.hasOwnProperty.call(message, "duration"))
                writer.uint32(/* id 1, wireType 5 =*/13).sfixed32(message.duration);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 1 =*/17).sfixed64(message.timestamp);
            return writer;
        };

        /**
         * Encodes the specified EphemeralSetting message, length delimited. Does not implicitly {@link proto.EphemeralSetting.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.IEphemeralSetting} message EphemeralSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        EphemeralSetting.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an EphemeralSetting message from the specified reader or buffer.
         * @function decode
         * @memberof proto.EphemeralSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.EphemeralSetting} EphemeralSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        EphemeralSetting.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.EphemeralSetting();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.duration = reader.sfixed32();
                    break;
                case 2:
                    message.timestamp = reader.sfixed64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an EphemeralSetting message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.EphemeralSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.EphemeralSetting} EphemeralSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        EphemeralSetting.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an EphemeralSetting message.
         * @function verify
         * @memberof proto.EphemeralSetting
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        EphemeralSetting.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.duration != null && message.hasOwnProperty("duration"))
                if (!$util.isInteger(message.duration))
                    return "duration: integer expected";
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates an EphemeralSetting message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.EphemeralSetting
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.EphemeralSetting} EphemeralSetting
         */
        EphemeralSetting.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.EphemeralSetting)
                return object;
            var message = new $root.proto.EphemeralSetting();
            if (object.duration != null)
                message.duration = object.duration | 0;
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from an EphemeralSetting message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.EphemeralSetting} message EphemeralSetting
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        EphemeralSetting.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.duration = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
            }
            if (message.duration != null && message.hasOwnProperty("duration"))
                object.duration = message.duration;
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber() : message.timestamp;
            return object;
        };

        /**
         * Converts this EphemeralSetting to JSON.
         * @function toJSON
         * @memberof proto.EphemeralSetting
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        EphemeralSetting.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return EphemeralSetting;
    })();

    proto.ExitCode = (function() {

        /**
         * Properties of an ExitCode.
         * @memberof proto
         * @interface IExitCode
         * @property {number|Long|null} [code] ExitCode code
         * @property {string|null} [text] ExitCode text
         */

        /**
         * Constructs a new ExitCode.
         * @memberof proto
         * @classdesc Represents an ExitCode.
         * @implements IExitCode
         * @constructor
         * @param {proto.IExitCode=} [properties] Properties to set
         */
        function ExitCode(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExitCode code.
         * @member {number|Long} code
         * @memberof proto.ExitCode
         * @instance
         */
        ExitCode.prototype.code = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ExitCode text.
         * @member {string} text
         * @memberof proto.ExitCode
         * @instance
         */
        ExitCode.prototype.text = "";

        /**
         * Creates a new ExitCode instance using the specified properties.
         * @function create
         * @memberof proto.ExitCode
         * @static
         * @param {proto.IExitCode=} [properties] Properties to set
         * @returns {proto.ExitCode} ExitCode instance
         */
        ExitCode.create = function create(properties) {
            return new ExitCode(properties);
        };

        /**
         * Encodes the specified ExitCode message. Does not implicitly {@link proto.ExitCode.verify|verify} messages.
         * @function encode
         * @memberof proto.ExitCode
         * @static
         * @param {proto.IExitCode} message ExitCode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExitCode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.code != null && Object.hasOwnProperty.call(message, "code"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.code);
            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.text);
            return writer;
        };

        /**
         * Encodes the specified ExitCode message, length delimited. Does not implicitly {@link proto.ExitCode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ExitCode
         * @static
         * @param {proto.IExitCode} message ExitCode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExitCode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExitCode message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ExitCode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ExitCode} ExitCode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExitCode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ExitCode();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.code = reader.uint64();
                    break;
                case 2:
                    message.text = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ExitCode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ExitCode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ExitCode} ExitCode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExitCode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExitCode message.
         * @function verify
         * @memberof proto.ExitCode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExitCode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.code != null && message.hasOwnProperty("code"))
                if (!$util.isInteger(message.code) && !(message.code && $util.isInteger(message.code.low) && $util.isInteger(message.code.high)))
                    return "code: integer|Long expected";
            if (message.text != null && message.hasOwnProperty("text"))
                if (!$util.isString(message.text))
                    return "text: string expected";
            return null;
        };

        /**
         * Creates an ExitCode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ExitCode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ExitCode} ExitCode
         */
        ExitCode.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ExitCode)
                return object;
            var message = new $root.proto.ExitCode();
            if (object.code != null)
                if ($util.Long)
                    (message.code = $util.Long.fromValue(object.code)).unsigned = true;
                else if (typeof object.code === "string")
                    message.code = parseInt(object.code, 10);
                else if (typeof object.code === "number")
                    message.code = object.code;
                else if (typeof object.code === "object")
                    message.code = new $util.LongBits(object.code.low >>> 0, object.code.high >>> 0).toNumber(true);
            if (object.text != null)
                message.text = String(object.text);
            return message;
        };

        /**
         * Creates a plain object from an ExitCode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ExitCode
         * @static
         * @param {proto.ExitCode} message ExitCode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExitCode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.code = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.code = options.longs === String ? "0" : 0;
                object.text = "";
            }
            if (message.code != null && message.hasOwnProperty("code"))
                if (typeof message.code === "number")
                    object.code = options.longs === String ? String(message.code) : message.code;
                else
                    object.code = options.longs === String ? $util.Long.prototype.toString.call(message.code) : options.longs === Number ? new $util.LongBits(message.code.low >>> 0, message.code.high >>> 0).toNumber(true) : message.code;
            if (message.text != null && message.hasOwnProperty("text"))
                object.text = message.text;
            return object;
        };

        /**
         * Converts this ExitCode to JSON.
         * @function toJSON
         * @memberof proto.ExitCode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExitCode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ExitCode;
    })();

    proto.ExtendedTextMessage = (function() {

        /**
         * Properties of an ExtendedTextMessage.
         * @memberof proto
         * @interface IExtendedTextMessage
         * @property {string|null} [text] ExtendedTextMessage text
         * @property {string|null} [matchedText] ExtendedTextMessage matchedText
         * @property {string|null} [canonicalUrl] ExtendedTextMessage canonicalUrl
         * @property {string|null} [description] ExtendedTextMessage description
         * @property {string|null} [title] ExtendedTextMessage title
         * @property {number|null} [textArgb] ExtendedTextMessage textArgb
         * @property {number|null} [backgroundArgb] ExtendedTextMessage backgroundArgb
         * @property {proto.ExtendedTextMessage.ExtendedTextMessageFontType|null} [font] ExtendedTextMessage font
         * @property {proto.ExtendedTextMessage.ExtendedTextMessagePreviewType|null} [previewType] ExtendedTextMessage previewType
         * @property {Uint8Array|null} [jpegThumbnail] ExtendedTextMessage jpegThumbnail
         * @property {proto.IContextInfo|null} [contextInfo] ExtendedTextMessage contextInfo
         * @property {boolean|null} [doNotPlayInline] ExtendedTextMessage doNotPlayInline
         * @property {string|null} [thumbnailDirectPath] ExtendedTextMessage thumbnailDirectPath
         * @property {Uint8Array|null} [thumbnailSha256] ExtendedTextMessage thumbnailSha256
         * @property {Uint8Array|null} [thumbnailEncSha256] ExtendedTextMessage thumbnailEncSha256
         * @property {Uint8Array|null} [mediaKey] ExtendedTextMessage mediaKey
         * @property {number|Long|null} [mediaKeyTimestamp] ExtendedTextMessage mediaKeyTimestamp
         * @property {number|null} [thumbnailHeight] ExtendedTextMessage thumbnailHeight
         * @property {number|null} [thumbnailWidth] ExtendedTextMessage thumbnailWidth
         * @property {proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType|null} [inviteLinkGroupType] ExtendedTextMessage inviteLinkGroupType
         * @property {string|null} [inviteLinkParentGroupSubjectV2] ExtendedTextMessage inviteLinkParentGroupSubjectV2
         * @property {Uint8Array|null} [inviteLinkParentGroupThumbnailV2] ExtendedTextMessage inviteLinkParentGroupThumbnailV2
         * @property {proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType|null} [inviteLinkGroupTypeV2] ExtendedTextMessage inviteLinkGroupTypeV2
         */

        /**
         * Constructs a new ExtendedTextMessage.
         * @memberof proto
         * @classdesc Represents an ExtendedTextMessage.
         * @implements IExtendedTextMessage
         * @constructor
         * @param {proto.IExtendedTextMessage=} [properties] Properties to set
         */
        function ExtendedTextMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExtendedTextMessage text.
         * @member {string} text
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.text = "";

        /**
         * ExtendedTextMessage matchedText.
         * @member {string} matchedText
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.matchedText = "";

        /**
         * ExtendedTextMessage canonicalUrl.
         * @member {string} canonicalUrl
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.canonicalUrl = "";

        /**
         * ExtendedTextMessage description.
         * @member {string} description
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.description = "";

        /**
         * ExtendedTextMessage title.
         * @member {string} title
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.title = "";

        /**
         * ExtendedTextMessage textArgb.
         * @member {number} textArgb
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.textArgb = 0;

        /**
         * ExtendedTextMessage backgroundArgb.
         * @member {number} backgroundArgb
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.backgroundArgb = 0;

        /**
         * ExtendedTextMessage font.
         * @member {proto.ExtendedTextMessage.ExtendedTextMessageFontType} font
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.font = 0;

        /**
         * ExtendedTextMessage previewType.
         * @member {proto.ExtendedTextMessage.ExtendedTextMessagePreviewType} previewType
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.previewType = 0;

        /**
         * ExtendedTextMessage jpegThumbnail.
         * @member {Uint8Array} jpegThumbnail
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.jpegThumbnail = $util.newBuffer([]);

        /**
         * ExtendedTextMessage contextInfo.
         * @member {proto.IContextInfo|null|undefined} contextInfo
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.contextInfo = null;

        /**
         * ExtendedTextMessage doNotPlayInline.
         * @member {boolean} doNotPlayInline
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.doNotPlayInline = false;

        /**
         * ExtendedTextMessage thumbnailDirectPath.
         * @member {string} thumbnailDirectPath
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.thumbnailDirectPath = "";

        /**
         * ExtendedTextMessage thumbnailSha256.
         * @member {Uint8Array} thumbnailSha256
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.thumbnailSha256 = $util.newBuffer([]);

        /**
         * ExtendedTextMessage thumbnailEncSha256.
         * @member {Uint8Array} thumbnailEncSha256
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.thumbnailEncSha256 = $util.newBuffer([]);

        /**
         * ExtendedTextMessage mediaKey.
         * @member {Uint8Array} mediaKey
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.mediaKey = $util.newBuffer([]);

        /**
         * ExtendedTextMessage mediaKeyTimestamp.
         * @member {number|Long} mediaKeyTimestamp
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * ExtendedTextMessage thumbnailHeight.
         * @member {number} thumbnailHeight
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.thumbnailHeight = 0;

        /**
         * ExtendedTextMessage thumbnailWidth.
         * @member {number} thumbnailWidth
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.thumbnailWidth = 0;

        /**
         * ExtendedTextMessage inviteLinkGroupType.
         * @member {proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType} inviteLinkGroupType
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.inviteLinkGroupType = 0;

        /**
         * ExtendedTextMessage inviteLinkParentGroupSubjectV2.
         * @member {string} inviteLinkParentGroupSubjectV2
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.inviteLinkParentGroupSubjectV2 = "";

        /**
         * ExtendedTextMessage inviteLinkParentGroupThumbnailV2.
         * @member {Uint8Array} inviteLinkParentGroupThumbnailV2
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.inviteLinkParentGroupThumbnailV2 = $util.newBuffer([]);

        /**
         * ExtendedTextMessage inviteLinkGroupTypeV2.
         * @member {proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType} inviteLinkGroupTypeV2
         * @memberof proto.ExtendedTextMessage
         * @instance
         */
        ExtendedTextMessage.prototype.inviteLinkGroupTypeV2 = 0;

        /**
         * Creates a new ExtendedTextMessage instance using the specified properties.
         * @function create
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {proto.IExtendedTextMessage=} [properties] Properties to set
         * @returns {proto.ExtendedTextMessage} ExtendedTextMessage instance
         */
        ExtendedTextMessage.create = function create(properties) {
            return new ExtendedTextMessage(properties);
        };

        /**
         * Encodes the specified ExtendedTextMessage message. Does not implicitly {@link proto.ExtendedTextMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {proto.IExtendedTextMessage} message ExtendedTextMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExtendedTextMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.text);
            if (message.matchedText != null && Object.hasOwnProperty.call(message, "matchedText"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.matchedText);
            if (message.canonicalUrl != null && Object.hasOwnProperty.call(message, "canonicalUrl"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.canonicalUrl);
            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.description);
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.title);
            if (message.textArgb != null && Object.hasOwnProperty.call(message, "textArgb"))
                writer.uint32(/* id 7, wireType 5 =*/61).fixed32(message.textArgb);
            if (message.backgroundArgb != null && Object.hasOwnProperty.call(message, "backgroundArgb"))
                writer.uint32(/* id 8, wireType 5 =*/69).fixed32(message.backgroundArgb);
            if (message.font != null && Object.hasOwnProperty.call(message, "font"))
                writer.uint32(/* id 9, wireType 0 =*/72).int32(message.font);
            if (message.previewType != null && Object.hasOwnProperty.call(message, "previewType"))
                writer.uint32(/* id 10, wireType 0 =*/80).int32(message.previewType);
            if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                writer.uint32(/* id 16, wireType 2 =*/130).bytes(message.jpegThumbnail);
            if (message.contextInfo != null && Object.hasOwnProperty.call(message, "contextInfo"))
                $root.proto.ContextInfo.encode(message.contextInfo, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.doNotPlayInline != null && Object.hasOwnProperty.call(message, "doNotPlayInline"))
                writer.uint32(/* id 18, wireType 0 =*/144).bool(message.doNotPlayInline);
            if (message.thumbnailDirectPath != null && Object.hasOwnProperty.call(message, "thumbnailDirectPath"))
                writer.uint32(/* id 19, wireType 2 =*/154).string(message.thumbnailDirectPath);
            if (message.thumbnailSha256 != null && Object.hasOwnProperty.call(message, "thumbnailSha256"))
                writer.uint32(/* id 20, wireType 2 =*/162).bytes(message.thumbnailSha256);
            if (message.thumbnailEncSha256 != null && Object.hasOwnProperty.call(message, "thumbnailEncSha256"))
                writer.uint32(/* id 21, wireType 2 =*/170).bytes(message.thumbnailEncSha256);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 22, wireType 2 =*/178).bytes(message.mediaKey);
            if (message.mediaKeyTimestamp != null && Object.hasOwnProperty.call(message, "mediaKeyTimestamp"))
                writer.uint32(/* id 23, wireType 0 =*/184).int64(message.mediaKeyTimestamp);
            if (message.thumbnailHeight != null && Object.hasOwnProperty.call(message, "thumbnailHeight"))
                writer.uint32(/* id 24, wireType 0 =*/192).uint32(message.thumbnailHeight);
            if (message.thumbnailWidth != null && Object.hasOwnProperty.call(message, "thumbnailWidth"))
                writer.uint32(/* id 25, wireType 0 =*/200).uint32(message.thumbnailWidth);
            if (message.inviteLinkGroupType != null && Object.hasOwnProperty.call(message, "inviteLinkGroupType"))
                writer.uint32(/* id 26, wireType 0 =*/208).int32(message.inviteLinkGroupType);
            if (message.inviteLinkParentGroupSubjectV2 != null && Object.hasOwnProperty.call(message, "inviteLinkParentGroupSubjectV2"))
                writer.uint32(/* id 27, wireType 2 =*/218).string(message.inviteLinkParentGroupSubjectV2);
            if (message.inviteLinkParentGroupThumbnailV2 != null && Object.hasOwnProperty.call(message, "inviteLinkParentGroupThumbnailV2"))
                writer.uint32(/* id 28, wireType 2 =*/226).bytes(message.inviteLinkParentGroupThumbnailV2);
            if (message.inviteLinkGroupTypeV2 != null && Object.hasOwnProperty.call(message, "inviteLinkGroupTypeV2"))
                writer.uint32(/* id 29, wireType 0 =*/232).int32(message.inviteLinkGroupTypeV2);
            return writer;
        };

        /**
         * Encodes the specified ExtendedTextMessage message, length delimited. Does not implicitly {@link proto.ExtendedTextMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {proto.IExtendedTextMessage} message ExtendedTextMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExtendedTextMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExtendedTextMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ExtendedTextMessage} ExtendedTextMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExtendedTextMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ExtendedTextMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.text = reader.string();
                    break;
                case 2:
                    message.matchedText = reader.string();
                    break;
                case 4:
                    message.canonicalUrl = reader.string();
                    break;
                case 5:
                    message.description = reader.string();
                    break;
                case 6:
                    message.title = reader.string();
                    break;
                case 7:
                    message.textArgb = reader.fixed32();
                    break;
                case 8:
                    message.backgroundArgb = reader.fixed32();
                    break;
                case 9:
                    message.font = reader.int32();
                    break;
                case 10:
                    message.previewType = reader.int32();
                    break;
                case 16:
                    message.jpegThumbnail = reader.bytes();
                    break;
                case 17:
                    message.contextInfo = $root.proto.ContextInfo.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.doNotPlayInline = reader.bool();
                    break;
                case 19:
                    message.thumbnailDirectPath = reader.string();
                    break;
                case 20:
                    message.thumbnailSha256 = reader.bytes();
                    break;
                case 21:
                    message.thumbnailEncSha256 = reader.bytes();
                    break;
                case 22:
                    message.mediaKey = reader.bytes();
                    break;
                case 23:
                    message.mediaKeyTimestamp = reader.int64();
                    break;
                case 24:
                    message.thumbnailHeight = reader.uint32();
                    break;
                case 25:
                    message.thumbnailWidth = reader.uint32();
                    break;
                case 26:
                    message.inviteLinkGroupType = reader.int32();
                    break;
                case 27:
                    message.inviteLinkParentGroupSubjectV2 = reader.string();
                    break;
                case 28:
                    message.inviteLinkParentGroupThumbnailV2 = reader.bytes();
                    break;
                case 29:
                    message.inviteLinkGroupTypeV2 = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ExtendedTextMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ExtendedTextMessage} ExtendedTextMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExtendedTextMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExtendedTextMessage message.
         * @function verify
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExtendedTextMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.text != null && message.hasOwnProperty("text"))
                if (!$util.isString(message.text))
                    return "text: string expected";
            if (message.matchedText != null && message.hasOwnProperty("matchedText"))
                if (!$util.isString(message.matchedText))
                    return "matchedText: string expected";
            if (message.canonicalUrl != null && message.hasOwnProperty("canonicalUrl"))
                if (!$util.isString(message.canonicalUrl))
                    return "canonicalUrl: string expected";
            if (message.description != null && message.hasOwnProperty("description"))
                if (!$util.isString(message.description))
                    return "description: string expected";
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.textArgb != null && message.hasOwnProperty("textArgb"))
                if (!$util.isInteger(message.textArgb))
                    return "textArgb: integer expected";
            if (message.backgroundArgb != null && message.hasOwnProperty("backgroundArgb"))
                if (!$util.isInteger(message.backgroundArgb))
                    return "backgroundArgb: integer expected";
            if (message.font != null && message.hasOwnProperty("font"))
                switch (message.font) {
                default:
                    return "font: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                    break;
                }
            if (message.previewType != null && message.hasOwnProperty("previewType"))
                switch (message.previewType) {
                default:
                    return "previewType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                    return "jpegThumbnail: buffer expected";
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo")) {
                var error = $root.proto.ContextInfo.verify(message.contextInfo);
                if (error)
                    return "contextInfo." + error;
            }
            if (message.doNotPlayInline != null && message.hasOwnProperty("doNotPlayInline"))
                if (typeof message.doNotPlayInline !== "boolean")
                    return "doNotPlayInline: boolean expected";
            if (message.thumbnailDirectPath != null && message.hasOwnProperty("thumbnailDirectPath"))
                if (!$util.isString(message.thumbnailDirectPath))
                    return "thumbnailDirectPath: string expected";
            if (message.thumbnailSha256 != null && message.hasOwnProperty("thumbnailSha256"))
                if (!(message.thumbnailSha256 && typeof message.thumbnailSha256.length === "number" || $util.isString(message.thumbnailSha256)))
                    return "thumbnailSha256: buffer expected";
            if (message.thumbnailEncSha256 != null && message.hasOwnProperty("thumbnailEncSha256"))
                if (!(message.thumbnailEncSha256 && typeof message.thumbnailEncSha256.length === "number" || $util.isString(message.thumbnailEncSha256)))
                    return "thumbnailEncSha256: buffer expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!(message.mediaKey && typeof message.mediaKey.length === "number" || $util.isString(message.mediaKey)))
                    return "mediaKey: buffer expected";
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (!$util.isInteger(message.mediaKeyTimestamp) && !(message.mediaKeyTimestamp && $util.isInteger(message.mediaKeyTimestamp.low) && $util.isInteger(message.mediaKeyTimestamp.high)))
                    return "mediaKeyTimestamp: integer|Long expected";
            if (message.thumbnailHeight != null && message.hasOwnProperty("thumbnailHeight"))
                if (!$util.isInteger(message.thumbnailHeight))
                    return "thumbnailHeight: integer expected";
            if (message.thumbnailWidth != null && message.hasOwnProperty("thumbnailWidth"))
                if (!$util.isInteger(message.thumbnailWidth))
                    return "thumbnailWidth: integer expected";
            if (message.inviteLinkGroupType != null && message.hasOwnProperty("inviteLinkGroupType"))
                switch (message.inviteLinkGroupType) {
                default:
                    return "inviteLinkGroupType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.inviteLinkParentGroupSubjectV2 != null && message.hasOwnProperty("inviteLinkParentGroupSubjectV2"))
                if (!$util.isString(message.inviteLinkParentGroupSubjectV2))
                    return "inviteLinkParentGroupSubjectV2: string expected";
            if (message.inviteLinkParentGroupThumbnailV2 != null && message.hasOwnProperty("inviteLinkParentGroupThumbnailV2"))
                if (!(message.inviteLinkParentGroupThumbnailV2 && typeof message.inviteLinkParentGroupThumbnailV2.length === "number" || $util.isString(message.inviteLinkParentGroupThumbnailV2)))
                    return "inviteLinkParentGroupThumbnailV2: buffer expected";
            if (message.inviteLinkGroupTypeV2 != null && message.hasOwnProperty("inviteLinkGroupTypeV2"))
                switch (message.inviteLinkGroupTypeV2) {
                default:
                    return "inviteLinkGroupTypeV2: enum value expected";
                case 0:
                case 1:
                    break;
                }
            return null;
        };

        /**
         * Creates an ExtendedTextMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ExtendedTextMessage} ExtendedTextMessage
         */
        ExtendedTextMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ExtendedTextMessage)
                return object;
            var message = new $root.proto.ExtendedTextMessage();
            if (object.text != null)
                message.text = String(object.text);
            if (object.matchedText != null)
                message.matchedText = String(object.matchedText);
            if (object.canonicalUrl != null)
                message.canonicalUrl = String(object.canonicalUrl);
            if (object.description != null)
                message.description = String(object.description);
            if (object.title != null)
                message.title = String(object.title);
            if (object.textArgb != null)
                message.textArgb = object.textArgb >>> 0;
            if (object.backgroundArgb != null)
                message.backgroundArgb = object.backgroundArgb >>> 0;
            switch (object.font) {
            case "SANS_SERIF":
            case 0:
                message.font = 0;
                break;
            case "SERIF":
            case 1:
                message.font = 1;
                break;
            case "NORICAN_REGULAR":
            case 2:
                message.font = 2;
                break;
            case "BRYNDAN_WRITE":
            case 3:
                message.font = 3;
                break;
            case "BEBASNEUE_REGULAR":
            case 4:
                message.font = 4;
                break;
            case "OSWALD_HEAVY":
            case 5:
                message.font = 5;
                break;
            }
            switch (object.previewType) {
            case "NONE":
            case 0:
                message.previewType = 0;
                break;
            case "VIDEO":
            case 1:
                message.previewType = 1;
                break;
            }
            if (object.jpegThumbnail != null)
                if (typeof object.jpegThumbnail === "string")
                    $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                else if (object.jpegThumbnail.length)
                    message.jpegThumbnail = object.jpegThumbnail;
            if (object.contextInfo != null) {
                if (typeof object.contextInfo !== "object")
                    throw TypeError(".proto.ExtendedTextMessage.contextInfo: object expected");
                message.contextInfo = $root.proto.ContextInfo.fromObject(object.contextInfo);
            }
            if (object.doNotPlayInline != null)
                message.doNotPlayInline = Boolean(object.doNotPlayInline);
            if (object.thumbnailDirectPath != null)
                message.thumbnailDirectPath = String(object.thumbnailDirectPath);
            if (object.thumbnailSha256 != null)
                if (typeof object.thumbnailSha256 === "string")
                    $util.base64.decode(object.thumbnailSha256, message.thumbnailSha256 = $util.newBuffer($util.base64.length(object.thumbnailSha256)), 0);
                else if (object.thumbnailSha256.length)
                    message.thumbnailSha256 = object.thumbnailSha256;
            if (object.thumbnailEncSha256 != null)
                if (typeof object.thumbnailEncSha256 === "string")
                    $util.base64.decode(object.thumbnailEncSha256, message.thumbnailEncSha256 = $util.newBuffer($util.base64.length(object.thumbnailEncSha256)), 0);
                else if (object.thumbnailEncSha256.length)
                    message.thumbnailEncSha256 = object.thumbnailEncSha256;
            if (object.mediaKey != null)
                if (typeof object.mediaKey === "string")
                    $util.base64.decode(object.mediaKey, message.mediaKey = $util.newBuffer($util.base64.length(object.mediaKey)), 0);
                else if (object.mediaKey.length)
                    message.mediaKey = object.mediaKey;
            if (object.mediaKeyTimestamp != null)
                if ($util.Long)
                    (message.mediaKeyTimestamp = $util.Long.fromValue(object.mediaKeyTimestamp)).unsigned = false;
                else if (typeof object.mediaKeyTimestamp === "string")
                    message.mediaKeyTimestamp = parseInt(object.mediaKeyTimestamp, 10);
                else if (typeof object.mediaKeyTimestamp === "number")
                    message.mediaKeyTimestamp = object.mediaKeyTimestamp;
                else if (typeof object.mediaKeyTimestamp === "object")
                    message.mediaKeyTimestamp = new $util.LongBits(object.mediaKeyTimestamp.low >>> 0, object.mediaKeyTimestamp.high >>> 0).toNumber();
            if (object.thumbnailHeight != null)
                message.thumbnailHeight = object.thumbnailHeight >>> 0;
            if (object.thumbnailWidth != null)
                message.thumbnailWidth = object.thumbnailWidth >>> 0;
            switch (object.inviteLinkGroupType) {
            case "DEFAULT":
            case 0:
                message.inviteLinkGroupType = 0;
                break;
            case "PARENT":
            case 1:
                message.inviteLinkGroupType = 1;
                break;
            }
            if (object.inviteLinkParentGroupSubjectV2 != null)
                message.inviteLinkParentGroupSubjectV2 = String(object.inviteLinkParentGroupSubjectV2);
            if (object.inviteLinkParentGroupThumbnailV2 != null)
                if (typeof object.inviteLinkParentGroupThumbnailV2 === "string")
                    $util.base64.decode(object.inviteLinkParentGroupThumbnailV2, message.inviteLinkParentGroupThumbnailV2 = $util.newBuffer($util.base64.length(object.inviteLinkParentGroupThumbnailV2)), 0);
                else if (object.inviteLinkParentGroupThumbnailV2.length)
                    message.inviteLinkParentGroupThumbnailV2 = object.inviteLinkParentGroupThumbnailV2;
            switch (object.inviteLinkGroupTypeV2) {
            case "DEFAULT":
            case 0:
                message.inviteLinkGroupTypeV2 = 0;
                break;
            case "PARENT":
            case 1:
                message.inviteLinkGroupTypeV2 = 1;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from an ExtendedTextMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ExtendedTextMessage
         * @static
         * @param {proto.ExtendedTextMessage} message ExtendedTextMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExtendedTextMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.text = "";
                object.matchedText = "";
                object.canonicalUrl = "";
                object.description = "";
                object.title = "";
                object.textArgb = 0;
                object.backgroundArgb = 0;
                object.font = options.enums === String ? "SANS_SERIF" : 0;
                object.previewType = options.enums === String ? "NONE" : 0;
                if (options.bytes === String)
                    object.jpegThumbnail = "";
                else {
                    object.jpegThumbnail = [];
                    if (options.bytes !== Array)
                        object.jpegThumbnail = $util.newBuffer(object.jpegThumbnail);
                }
                object.contextInfo = null;
                object.doNotPlayInline = false;
                object.thumbnailDirectPath = "";
                if (options.bytes === String)
                    object.thumbnailSha256 = "";
                else {
                    object.thumbnailSha256 = [];
                    if (options.bytes !== Array)
                        object.thumbnailSha256 = $util.newBuffer(object.thumbnailSha256);
                }
                if (options.bytes === String)
                    object.thumbnailEncSha256 = "";
                else {
                    object.thumbnailEncSha256 = [];
                    if (options.bytes !== Array)
                        object.thumbnailEncSha256 = $util.newBuffer(object.thumbnailEncSha256);
                }
                if (options.bytes === String)
                    object.mediaKey = "";
                else {
                    object.mediaKey = [];
                    if (options.bytes !== Array)
                        object.mediaKey = $util.newBuffer(object.mediaKey);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.mediaKeyTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.mediaKeyTimestamp = options.longs === String ? "0" : 0;
                object.thumbnailHeight = 0;
                object.thumbnailWidth = 0;
                object.inviteLinkGroupType = options.enums === String ? "DEFAULT" : 0;
                object.inviteLinkParentGroupSubjectV2 = "";
                if (options.bytes === String)
                    object.inviteLinkParentGroupThumbnailV2 = "";
                else {
                    object.inviteLinkParentGroupThumbnailV2 = [];
                    if (options.bytes !== Array)
                        object.inviteLinkParentGroupThumbnailV2 = $util.newBuffer(object.inviteLinkParentGroupThumbnailV2);
                }
                object.inviteLinkGroupTypeV2 = options.enums === String ? "DEFAULT" : 0;
            }
            if (message.text != null && message.hasOwnProperty("text"))
                object.text = message.text;
            if (message.matchedText != null && message.hasOwnProperty("matchedText"))
                object.matchedText = message.matchedText;
            if (message.canonicalUrl != null && message.hasOwnProperty("canonicalUrl"))
                object.canonicalUrl = message.canonicalUrl;
            if (message.description != null && message.hasOwnProperty("description"))
                object.description = message.description;
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.textArgb != null && message.hasOwnProperty("textArgb"))
                object.textArgb = message.textArgb;
            if (message.backgroundArgb != null && message.hasOwnProperty("backgroundArgb"))
                object.backgroundArgb = message.backgroundArgb;
            if (message.font != null && message.hasOwnProperty("font"))
                object.font = options.enums === String ? $root.proto.ExtendedTextMessage.ExtendedTextMessageFontType[message.font] : message.font;
            if (message.previewType != null && message.hasOwnProperty("previewType"))
                object.previewType = options.enums === String ? $root.proto.ExtendedTextMessage.ExtendedTextMessagePreviewType[message.previewType] : message.previewType;
            if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
            if (message.contextInfo != null && message.hasOwnProperty("contextInfo"))
                object.contextInfo = $root.proto.ContextInfo.toObject(message.contextInfo, options);
            if (message.doNotPlayInline != null && message.hasOwnProperty("doNotPlayInline"))
                object.doNotPlayInline = message.doNotPlayInline;
            if (message.thumbnailDirectPath != null && message.hasOwnProperty("thumbnailDirectPath"))
                object.thumbnailDirectPath = message.thumbnailDirectPath;
            if (message.thumbnailSha256 != null && message.hasOwnProperty("thumbnailSha256"))
                object.thumbnailSha256 = options.bytes === String ? $util.base64.encode(message.thumbnailSha256, 0, message.thumbnailSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnailSha256) : message.thumbnailSha256;
            if (message.thumbnailEncSha256 != null && message.hasOwnProperty("thumbnailEncSha256"))
                object.thumbnailEncSha256 = options.bytes === String ? $util.base64.encode(message.thumbnailEncSha256, 0, message.thumbnailEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnailEncSha256) : message.thumbnailEncSha256;
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = options.bytes === String ? $util.base64.encode(message.mediaKey, 0, message.mediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.mediaKey) : message.mediaKey;
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (typeof message.mediaKeyTimestamp === "number")
                    object.mediaKeyTimestamp = options.longs === String ? String(message.mediaKeyTimestamp) : message.mediaKeyTimestamp;
                else
                    object.mediaKeyTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.mediaKeyTimestamp) : options.longs === Number ? new $util.LongBits(message.mediaKeyTimestamp.low >>> 0, message.mediaKeyTimestamp.high >>> 0).toNumber() : message.mediaKeyTimestamp;
            if (message.thumbnailHeight != null && message.hasOwnProperty("thumbnailHeight"))
                object.thumbnailHeight = message.thumbnailHeight;
            if (message.thumbnailWidth != null && message.hasOwnProperty("thumbnailWidth"))
                object.thumbnailWidth = message.thumbnailWidth;
            if (message.inviteLinkGroupType != null && message.hasOwnProperty("inviteLinkGroupType"))
                object.inviteLinkGroupType = options.enums === String ? $root.proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType[message.inviteLinkGroupType] : message.inviteLinkGroupType;
            if (message.inviteLinkParentGroupSubjectV2 != null && message.hasOwnProperty("inviteLinkParentGroupSubjectV2"))
                object.inviteLinkParentGroupSubjectV2 = message.inviteLinkParentGroupSubjectV2;
            if (message.inviteLinkParentGroupThumbnailV2 != null && message.hasOwnProperty("inviteLinkParentGroupThumbnailV2"))
                object.inviteLinkParentGroupThumbnailV2 = options.bytes === String ? $util.base64.encode(message.inviteLinkParentGroupThumbnailV2, 0, message.inviteLinkParentGroupThumbnailV2.length) : options.bytes === Array ? Array.prototype.slice.call(message.inviteLinkParentGroupThumbnailV2) : message.inviteLinkParentGroupThumbnailV2;
            if (message.inviteLinkGroupTypeV2 != null && message.hasOwnProperty("inviteLinkGroupTypeV2"))
                object.inviteLinkGroupTypeV2 = options.enums === String ? $root.proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType[message.inviteLinkGroupTypeV2] : message.inviteLinkGroupTypeV2;
            return object;
        };

        /**
         * Converts this ExtendedTextMessage to JSON.
         * @function toJSON
         * @memberof proto.ExtendedTextMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExtendedTextMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ExtendedTextMessageFontType enum.
         * @name proto.ExtendedTextMessage.ExtendedTextMessageFontType
         * @enum {number}
         * @property {number} SANS_SERIF=0 SANS_SERIF value
         * @property {number} SERIF=1 SERIF value
         * @property {number} NORICAN_REGULAR=2 NORICAN_REGULAR value
         * @property {number} BRYNDAN_WRITE=3 BRYNDAN_WRITE value
         * @property {number} BEBASNEUE_REGULAR=4 BEBASNEUE_REGULAR value
         * @property {number} OSWALD_HEAVY=5 OSWALD_HEAVY value
         */
        ExtendedTextMessage.ExtendedTextMessageFontType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SANS_SERIF"] = 0;
            values[valuesById[1] = "SERIF"] = 1;
            values[valuesById[2] = "NORICAN_REGULAR"] = 2;
            values[valuesById[3] = "BRYNDAN_WRITE"] = 3;
            values[valuesById[4] = "BEBASNEUE_REGULAR"] = 4;
            values[valuesById[5] = "OSWALD_HEAVY"] = 5;
            return values;
        })();

        /**
         * ExtendedTextMessagePreviewType enum.
         * @name proto.ExtendedTextMessage.ExtendedTextMessagePreviewType
         * @enum {number}
         * @property {number} NONE=0 NONE value
         * @property {number} VIDEO=1 VIDEO value
         */
        ExtendedTextMessage.ExtendedTextMessagePreviewType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "VIDEO"] = 1;
            return values;
        })();

        /**
         * ExtendedTextMessageInviteLinkGroupType enum.
         * @name proto.ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType
         * @enum {number}
         * @property {number} DEFAULT=0 DEFAULT value
         * @property {number} PARENT=1 PARENT value
         */
        ExtendedTextMessage.ExtendedTextMessageInviteLinkGroupType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "DEFAULT"] = 0;
            values[valuesById[1] = "PARENT"] = 1;
            return values;
        })();

        return ExtendedTextMessage;
    })();

    proto.ExternalAdReplyInfo = (function() {

        /**
         * Properties of an ExternalAdReplyInfo.
         * @memberof proto
         * @interface IExternalAdReplyInfo
         * @property {string|null} [title] ExternalAdReplyInfo title
         * @property {string|null} [body] ExternalAdReplyInfo body
         * @property {proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType|null} [mediaType] ExternalAdReplyInfo mediaType
         * @property {string|null} [thumbnailUrl] ExternalAdReplyInfo thumbnailUrl
         * @property {string|null} [mediaUrl] ExternalAdReplyInfo mediaUrl
         * @property {Uint8Array|null} [thumbnail] ExternalAdReplyInfo thumbnail
         * @property {string|null} [sourceType] ExternalAdReplyInfo sourceType
         * @property {string|null} [sourceId] ExternalAdReplyInfo sourceId
         * @property {string|null} [sourceUrl] ExternalAdReplyInfo sourceUrl
         * @property {boolean|null} [containsAutoReply] ExternalAdReplyInfo containsAutoReply
         * @property {boolean|null} [renderLargerThumbnail] ExternalAdReplyInfo renderLargerThumbnail
         * @property {boolean|null} [showAdAttribution] ExternalAdReplyInfo showAdAttribution
         */

        /**
         * Constructs a new ExternalAdReplyInfo.
         * @memberof proto
         * @classdesc Represents an ExternalAdReplyInfo.
         * @implements IExternalAdReplyInfo
         * @constructor
         * @param {proto.IExternalAdReplyInfo=} [properties] Properties to set
         */
        function ExternalAdReplyInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExternalAdReplyInfo title.
         * @member {string} title
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.title = "";

        /**
         * ExternalAdReplyInfo body.
         * @member {string} body
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.body = "";

        /**
         * ExternalAdReplyInfo mediaType.
         * @member {proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType} mediaType
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.mediaType = 0;

        /**
         * ExternalAdReplyInfo thumbnailUrl.
         * @member {string} thumbnailUrl
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.thumbnailUrl = "";

        /**
         * ExternalAdReplyInfo mediaUrl.
         * @member {string} mediaUrl
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.mediaUrl = "";

        /**
         * ExternalAdReplyInfo thumbnail.
         * @member {Uint8Array} thumbnail
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.thumbnail = $util.newBuffer([]);

        /**
         * ExternalAdReplyInfo sourceType.
         * @member {string} sourceType
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.sourceType = "";

        /**
         * ExternalAdReplyInfo sourceId.
         * @member {string} sourceId
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.sourceId = "";

        /**
         * ExternalAdReplyInfo sourceUrl.
         * @member {string} sourceUrl
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.sourceUrl = "";

        /**
         * ExternalAdReplyInfo containsAutoReply.
         * @member {boolean} containsAutoReply
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.containsAutoReply = false;

        /**
         * ExternalAdReplyInfo renderLargerThumbnail.
         * @member {boolean} renderLargerThumbnail
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.renderLargerThumbnail = false;

        /**
         * ExternalAdReplyInfo showAdAttribution.
         * @member {boolean} showAdAttribution
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         */
        ExternalAdReplyInfo.prototype.showAdAttribution = false;

        /**
         * Creates a new ExternalAdReplyInfo instance using the specified properties.
         * @function create
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.IExternalAdReplyInfo=} [properties] Properties to set
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo instance
         */
        ExternalAdReplyInfo.create = function create(properties) {
            return new ExternalAdReplyInfo(properties);
        };

        /**
         * Encodes the specified ExternalAdReplyInfo message. Does not implicitly {@link proto.ExternalAdReplyInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.IExternalAdReplyInfo} message ExternalAdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalAdReplyInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.title);
            if (message.body != null && Object.hasOwnProperty.call(message, "body"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.body);
            if (message.mediaType != null && Object.hasOwnProperty.call(message, "mediaType"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.mediaType);
            if (message.thumbnailUrl != null && Object.hasOwnProperty.call(message, "thumbnailUrl"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.thumbnailUrl);
            if (message.mediaUrl != null && Object.hasOwnProperty.call(message, "mediaUrl"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.mediaUrl);
            if (message.thumbnail != null && Object.hasOwnProperty.call(message, "thumbnail"))
                writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.thumbnail);
            if (message.sourceType != null && Object.hasOwnProperty.call(message, "sourceType"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.sourceType);
            if (message.sourceId != null && Object.hasOwnProperty.call(message, "sourceId"))
                writer.uint32(/* id 8, wireType 2 =*/66).string(message.sourceId);
            if (message.sourceUrl != null && Object.hasOwnProperty.call(message, "sourceUrl"))
                writer.uint32(/* id 9, wireType 2 =*/74).string(message.sourceUrl);
            if (message.containsAutoReply != null && Object.hasOwnProperty.call(message, "containsAutoReply"))
                writer.uint32(/* id 10, wireType 0 =*/80).bool(message.containsAutoReply);
            if (message.renderLargerThumbnail != null && Object.hasOwnProperty.call(message, "renderLargerThumbnail"))
                writer.uint32(/* id 11, wireType 0 =*/88).bool(message.renderLargerThumbnail);
            if (message.showAdAttribution != null && Object.hasOwnProperty.call(message, "showAdAttribution"))
                writer.uint32(/* id 12, wireType 0 =*/96).bool(message.showAdAttribution);
            return writer;
        };

        /**
         * Encodes the specified ExternalAdReplyInfo message, length delimited. Does not implicitly {@link proto.ExternalAdReplyInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.IExternalAdReplyInfo} message ExternalAdReplyInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalAdReplyInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExternalAdReplyInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalAdReplyInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ExternalAdReplyInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.title = reader.string();
                    break;
                case 2:
                    message.body = reader.string();
                    break;
                case 3:
                    message.mediaType = reader.int32();
                    break;
                case 4:
                    message.thumbnailUrl = reader.string();
                    break;
                case 5:
                    message.mediaUrl = reader.string();
                    break;
                case 6:
                    message.thumbnail = reader.bytes();
                    break;
                case 7:
                    message.sourceType = reader.string();
                    break;
                case 8:
                    message.sourceId = reader.string();
                    break;
                case 9:
                    message.sourceUrl = reader.string();
                    break;
                case 10:
                    message.containsAutoReply = reader.bool();
                    break;
                case 11:
                    message.renderLargerThumbnail = reader.bool();
                    break;
                case 12:
                    message.showAdAttribution = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ExternalAdReplyInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalAdReplyInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExternalAdReplyInfo message.
         * @function verify
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExternalAdReplyInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.title != null && message.hasOwnProperty("title"))
                if (!$util.isString(message.title))
                    return "title: string expected";
            if (message.body != null && message.hasOwnProperty("body"))
                if (!$util.isString(message.body))
                    return "body: string expected";
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                switch (message.mediaType) {
                default:
                    return "mediaType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.thumbnailUrl != null && message.hasOwnProperty("thumbnailUrl"))
                if (!$util.isString(message.thumbnailUrl))
                    return "thumbnailUrl: string expected";
            if (message.mediaUrl != null && message.hasOwnProperty("mediaUrl"))
                if (!$util.isString(message.mediaUrl))
                    return "mediaUrl: string expected";
            if (message.thumbnail != null && message.hasOwnProperty("thumbnail"))
                if (!(message.thumbnail && typeof message.thumbnail.length === "number" || $util.isString(message.thumbnail)))
                    return "thumbnail: buffer expected";
            if (message.sourceType != null && message.hasOwnProperty("sourceType"))
                if (!$util.isString(message.sourceType))
                    return "sourceType: string expected";
            if (message.sourceId != null && message.hasOwnProperty("sourceId"))
                if (!$util.isString(message.sourceId))
                    return "sourceId: string expected";
            if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl"))
                if (!$util.isString(message.sourceUrl))
                    return "sourceUrl: string expected";
            if (message.containsAutoReply != null && message.hasOwnProperty("containsAutoReply"))
                if (typeof message.containsAutoReply !== "boolean")
                    return "containsAutoReply: boolean expected";
            if (message.renderLargerThumbnail != null && message.hasOwnProperty("renderLargerThumbnail"))
                if (typeof message.renderLargerThumbnail !== "boolean")
                    return "renderLargerThumbnail: boolean expected";
            if (message.showAdAttribution != null && message.hasOwnProperty("showAdAttribution"))
                if (typeof message.showAdAttribution !== "boolean")
                    return "showAdAttribution: boolean expected";
            return null;
        };

        /**
         * Creates an ExternalAdReplyInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ExternalAdReplyInfo} ExternalAdReplyInfo
         */
        ExternalAdReplyInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ExternalAdReplyInfo)
                return object;
            var message = new $root.proto.ExternalAdReplyInfo();
            if (object.title != null)
                message.title = String(object.title);
            if (object.body != null)
                message.body = String(object.body);
            switch (object.mediaType) {
            case "NONE":
            case 0:
                message.mediaType = 0;
                break;
            case "IMAGE":
            case 1:
                message.mediaType = 1;
                break;
            case "VIDEO":
            case 2:
                message.mediaType = 2;
                break;
            }
            if (object.thumbnailUrl != null)
                message.thumbnailUrl = String(object.thumbnailUrl);
            if (object.mediaUrl != null)
                message.mediaUrl = String(object.mediaUrl);
            if (object.thumbnail != null)
                if (typeof object.thumbnail === "string")
                    $util.base64.decode(object.thumbnail, message.thumbnail = $util.newBuffer($util.base64.length(object.thumbnail)), 0);
                else if (object.thumbnail.length)
                    message.thumbnail = object.thumbnail;
            if (object.sourceType != null)
                message.sourceType = String(object.sourceType);
            if (object.sourceId != null)
                message.sourceId = String(object.sourceId);
            if (object.sourceUrl != null)
                message.sourceUrl = String(object.sourceUrl);
            if (object.containsAutoReply != null)
                message.containsAutoReply = Boolean(object.containsAutoReply);
            if (object.renderLargerThumbnail != null)
                message.renderLargerThumbnail = Boolean(object.renderLargerThumbnail);
            if (object.showAdAttribution != null)
                message.showAdAttribution = Boolean(object.showAdAttribution);
            return message;
        };

        /**
         * Creates a plain object from an ExternalAdReplyInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ExternalAdReplyInfo
         * @static
         * @param {proto.ExternalAdReplyInfo} message ExternalAdReplyInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExternalAdReplyInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.title = "";
                object.body = "";
                object.mediaType = options.enums === String ? "NONE" : 0;
                object.thumbnailUrl = "";
                object.mediaUrl = "";
                if (options.bytes === String)
                    object.thumbnail = "";
                else {
                    object.thumbnail = [];
                    if (options.bytes !== Array)
                        object.thumbnail = $util.newBuffer(object.thumbnail);
                }
                object.sourceType = "";
                object.sourceId = "";
                object.sourceUrl = "";
                object.containsAutoReply = false;
                object.renderLargerThumbnail = false;
                object.showAdAttribution = false;
            }
            if (message.title != null && message.hasOwnProperty("title"))
                object.title = message.title;
            if (message.body != null && message.hasOwnProperty("body"))
                object.body = message.body;
            if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                object.mediaType = options.enums === String ? $root.proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType[message.mediaType] : message.mediaType;
            if (message.thumbnailUrl != null && message.hasOwnProperty("thumbnailUrl"))
                object.thumbnailUrl = message.thumbnailUrl;
            if (message.mediaUrl != null && message.hasOwnProperty("mediaUrl"))
                object.mediaUrl = message.mediaUrl;
            if (message.thumbnail != null && message.hasOwnProperty("thumbnail"))
                object.thumbnail = options.bytes === String ? $util.base64.encode(message.thumbnail, 0, message.thumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnail) : message.thumbnail;
            if (message.sourceType != null && message.hasOwnProperty("sourceType"))
                object.sourceType = message.sourceType;
            if (message.sourceId != null && message.hasOwnProperty("sourceId"))
                object.sourceId = message.sourceId;
            if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl"))
                object.sourceUrl = message.sourceUrl;
            if (message.containsAutoReply != null && message.hasOwnProperty("containsAutoReply"))
                object.containsAutoReply = message.containsAutoReply;
            if (message.renderLargerThumbnail != null && message.hasOwnProperty("renderLargerThumbnail"))
                object.renderLargerThumbnail = message.renderLargerThumbnail;
            if (message.showAdAttribution != null && message.hasOwnProperty("showAdAttribution"))
                object.showAdAttribution = message.showAdAttribution;
            return object;
        };

        /**
         * Converts this ExternalAdReplyInfo to JSON.
         * @function toJSON
         * @memberof proto.ExternalAdReplyInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExternalAdReplyInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ExternalAdReplyInfoMediaType enum.
         * @name proto.ExternalAdReplyInfo.ExternalAdReplyInfoMediaType
         * @enum {number}
         * @property {number} NONE=0 NONE value
         * @property {number} IMAGE=1 IMAGE value
         * @property {number} VIDEO=2 VIDEO value
         */
        ExternalAdReplyInfo.ExternalAdReplyInfoMediaType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "NONE"] = 0;
            values[valuesById[1] = "IMAGE"] = 1;
            values[valuesById[2] = "VIDEO"] = 2;
            return values;
        })();

        return ExternalAdReplyInfo;
    })();

    proto.ExternalBlobReference = (function() {

        /**
         * Properties of an ExternalBlobReference.
         * @memberof proto
         * @interface IExternalBlobReference
         * @property {Uint8Array|null} [mediaKey] ExternalBlobReference mediaKey
         * @property {string|null} [directPath] ExternalBlobReference directPath
         * @property {string|null} [handle] ExternalBlobReference handle
         * @property {number|Long|null} [fileSizeBytes] ExternalBlobReference fileSizeBytes
         * @property {Uint8Array|null} [fileSha256] ExternalBlobReference fileSha256
         * @property {Uint8Array|null} [fileEncSha256] ExternalBlobReference fileEncSha256
         */

        /**
         * Constructs a new ExternalBlobReference.
         * @memberof proto
         * @classdesc Represents an ExternalBlobReference.
         * @implements IExternalBlobReference
         * @constructor
         * @param {proto.IExternalBlobReference=} [properties] Properties to set
         */
        function ExternalBlobReference(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExternalBlobReference mediaKey.
         * @member {Uint8Array} mediaKey
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.mediaKey = $util.newBuffer([]);

        /**
         * ExternalBlobReference directPath.
         * @member {string} directPath
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.directPath = "";

        /**
         * ExternalBlobReference handle.
         * @member {string} handle
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.handle = "";

        /**
         * ExternalBlobReference fileSizeBytes.
         * @member {number|Long} fileSizeBytes
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.fileSizeBytes = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ExternalBlobReference fileSha256.
         * @member {Uint8Array} fileSha256
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.fileSha256 = $util.newBuffer([]);

        /**
         * ExternalBlobReference fileEncSha256.
         * @member {Uint8Array} fileEncSha256
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.fileEncSha256 = $util.newBuffer([]);

        /**
         * Creates a new ExternalBlobReference instance using the specified properties.
         * @function create
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.IExternalBlobReference=} [properties] Properties to set
         * @returns {proto.ExternalBlobReference} ExternalBlobReference instance
         */
        ExternalBlobReference.create = function create(properties) {
            return new ExternalBlobReference(properties);
        };

        /**
         * Encodes the specified ExternalBlobReference message. Does not implicitly {@link proto.ExternalBlobReference.verify|verify} messages.
         * @function encode
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.IExternalBlobReference} message ExternalBlobReference message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalBlobReference.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.mediaKey);
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.directPath);
            if (message.handle != null && Object.hasOwnProperty.call(message, "handle"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.handle);
            if (message.fileSizeBytes != null && Object.hasOwnProperty.call(message, "fileSizeBytes"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint64(message.fileSizeBytes);
            if (message.fileSha256 != null && Object.hasOwnProperty.call(message, "fileSha256"))
                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.fileSha256);
            if (message.fileEncSha256 != null && Object.hasOwnProperty.call(message, "fileEncSha256"))
                writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.fileEncSha256);
            return writer;
        };

        /**
         * Encodes the specified ExternalBlobReference message, length delimited. Does not implicitly {@link proto.ExternalBlobReference.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.IExternalBlobReference} message ExternalBlobReference message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalBlobReference.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExternalBlobReference message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ExternalBlobReference} ExternalBlobReference
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalBlobReference.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ExternalBlobReference();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.mediaKey = reader.bytes();
                    break;
                case 2:
                    message.directPath = reader.string();
                    break;
                case 3:
                    message.handle = reader.string();
                    break;
                case 4:
                    message.fileSizeBytes = reader.uint64();
                    break;
                case 5:
                    message.fileSha256 = reader.bytes();
                    break;
                case 6:
                    message.fileEncSha256 = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ExternalBlobReference message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ExternalBlobReference} ExternalBlobReference
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalBlobReference.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExternalBlobReference message.
         * @function verify
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExternalBlobReference.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!(message.mediaKey && typeof message.mediaKey.length === "number" || $util.isString(message.mediaKey)))
                    return "mediaKey: buffer expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.handle != null && message.hasOwnProperty("handle"))
                if (!$util.isString(message.handle))
                    return "handle: string expected";
            if (message.fileSizeBytes != null && message.hasOwnProperty("fileSizeBytes"))
                if (!$util.isInteger(message.fileSizeBytes) && !(message.fileSizeBytes && $util.isInteger(message.fileSizeBytes.low) && $util.isInteger(message.fileSizeBytes.high)))
                    return "fileSizeBytes: integer|Long expected";
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                if (!(message.fileSha256 && typeof message.fileSha256.length === "number" || $util.isString(message.fileSha256)))
                    return "fileSha256: buffer expected";
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                if (!(message.fileEncSha256 && typeof message.fileEncSha256.length === "number" || $util.isString(message.fileEncSha256)))
                    return "fileEncSha256: buffer expected";
            return null;
        };

        /**
         * Creates an ExternalBlobReference message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ExternalBlobReference} ExternalBlobReference
         */
        ExternalBlobReference.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ExternalBlobReference)
                return object;
            var message = new $root.proto.ExternalBlobReference();
            if (object.mediaKey != null)
                if (typeof object.mediaKey === "string")
                    $util.base64.decode(object.mediaKey, message.mediaKey = $util.newBuffer($util.base64.length(object.mediaKey)), 0);
                else if (object.mediaKey.length)
                    message.mediaKey = object.mediaKey;
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.handle != null)
                message.handle = String(object.handle);
            if (object.fileSizeBytes != null)
                if ($util.Long)
                    (message.fileSizeBytes = $util.Long.fromValue(object.fileSizeBytes)).unsigned = true;
                else if (typeof object.fileSizeBytes === "string")
                    message.fileSizeBytes = parseInt(object.fileSizeBytes, 10);
                else if (typeof object.fileSizeBytes === "number")
                    message.fileSizeBytes = object.fileSizeBytes;
                else if (typeof object.fileSizeBytes === "object")
                    message.fileSizeBytes = new $util.LongBits(object.fileSizeBytes.low >>> 0, object.fileSizeBytes.high >>> 0).toNumber(true);
            if (object.fileSha256 != null)
                if (typeof object.fileSha256 === "string")
                    $util.base64.decode(object.fileSha256, message.fileSha256 = $util.newBuffer($util.base64.length(object.fileSha256)), 0);
                else if (object.fileSha256.length)
                    message.fileSha256 = object.fileSha256;
            if (object.fileEncSha256 != null)
                if (typeof object.fileEncSha256 === "string")
                    $util.base64.decode(object.fileEncSha256, message.fileEncSha256 = $util.newBuffer($util.base64.length(object.fileEncSha256)), 0);
                else if (object.fileEncSha256.length)
                    message.fileEncSha256 = object.fileEncSha256;
            return message;
        };

        /**
         * Creates a plain object from an ExternalBlobReference message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.ExternalBlobReference} message ExternalBlobReference
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExternalBlobReference.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.mediaKey = "";
                else {
                    object.mediaKey = [];
                    if (options.bytes !== Array)
                        object.mediaKey = $util.newBuffer(object.mediaKey);
                }
                object.directPath = "";
                object.handle = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fileSizeBytes = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fileSizeBytes = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.fileSha256 = "";
                else {
                    object.fileSha256 = [];
                    if (options.bytes !== Array)
                        object.fileSha256 = $util.newBuffer(object.fileSha256);
                }
                if (options.bytes === String)
                    object.fileEncSha256 = "";
                else {
                    object.fileEncSha256 = [];
                    if (options.bytes !== Array)
                        object.fileEncSha256 = $util.newBuffer(object.fileEncSha256);
                }
            }
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = options.bytes === String ? $util.base64.encode(message.mediaKey, 0, message.mediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.mediaKey) : message.mediaKey;
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.handle != null && message.hasOwnProperty("handle"))
                object.handle = message.handle;
            if (message.fileSizeBytes != null && message.hasOwnProperty("fileSizeBytes"))
                if (typeof message.fileSizeBytes === "number")
                    object.fileSizeBytes = options.longs === String ? String(message.fileSizeBytes) : message.fileSizeBytes;
                else
                    object.fileSizeBytes = options.longs === String ? $util.Long.prototype.toString.call(message.fileSizeBytes) : options.longs === Number ? new $util.LongBits(message.fileSizeBytes.low >>> 0, message.fileSizeBytes.high >>> 0).toNumber(true) : message.fileSizeBytes;
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                object.fileSha256 = options.bytes === String ? $util.base64.encode(message.fileSha256, 0, message.fileSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileSha256) : message.fileSha256;
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                object.fileEncSha256 = options.bytes === String ? $util.base64.encode(message.fileEncSha256, 0, message.fileEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileEncSha256) : message.fileEncSha256;
            return object;
        };

        /**
         * Converts this ExternalBlobReference to JSON.
         * @function toJSON
         * @memberof proto.ExternalBlobReference
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExternalBlobReference.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ExternalBlobReference;
    })();

    proto.FavoriteStickerAction = (function() {

        /**
         * Properties of a FavoriteStickerAction.
         * @memberof proto
         * @interface IFavoriteStickerAction
         * @property {string|null} [directPath] FavoriteStickerAction directPath
         * @property {string|null} [lastUploadTimestamp] FavoriteStickerAction lastUploadTimestamp
         * @property {string|null} [handle] FavoriteStickerAction handle
         * @property {string|null} [encFilehash] FavoriteStickerAction encFilehash
         * @property {string|null} [stickerHashWithoutMeta] FavoriteStickerAction stickerHashWithoutMeta
         * @property {string|null} [mediaKey] FavoriteStickerAction mediaKey
         * @property {number|Long|null} [mediaKeyTimestamp] FavoriteStickerAction mediaKeyTimestamp
         * @property {boolean|null} [isFavorite] FavoriteStickerAction isFavorite
         */

        /**
         * Constructs a new FavoriteStickerAction.
         * @memberof proto
         * @classdesc Represents a FavoriteStickerAction.
         * @implements IFavoriteStickerAction
         * @constructor
         * @param {proto.IFavoriteStickerAction=} [properties] Properties to set
         */
        function FavoriteStickerAction(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FavoriteStickerAction directPath.
         * @member {string} directPath
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.directPath = "";

        /**
         * FavoriteStickerAction lastUploadTimestamp.
         * @member {string} lastUploadTimestamp
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.lastUploadTimestamp = "";

        /**
         * FavoriteStickerAction handle.
         * @member {string} handle
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.handle = "";

        /**
         * FavoriteStickerAction encFilehash.
         * @member {string} encFilehash
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.encFilehash = "";

        /**
         * FavoriteStickerAction stickerHashWithoutMeta.
         * @member {string} stickerHashWithoutMeta
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.stickerHashWithoutMeta = "";

        /**
         * FavoriteStickerAction mediaKey.
         * @member {string} mediaKey
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.mediaKey = "";

        /**
         * FavoriteStickerAction mediaKeyTimestamp.
         * @member {number|Long} mediaKeyTimestamp
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.mediaKeyTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * FavoriteStickerAction isFavorite.
         * @member {boolean} isFavorite
         * @memberof proto.FavoriteStickerAction
         * @instance
         */
        FavoriteStickerAction.prototype.isFavorite = false;

        /**
         * Creates a new FavoriteStickerAction instance using the specified properties.
         * @function create
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {proto.IFavoriteStickerAction=} [properties] Properties to set
         * @returns {proto.FavoriteStickerAction} FavoriteStickerAction instance
         */
        FavoriteStickerAction.create = function create(properties) {
            return new FavoriteStickerAction(properties);
        };

        /**
         * Encodes the specified FavoriteStickerAction message. Does not implicitly {@link proto.FavoriteStickerAction.verify|verify} messages.
         * @function encode
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {proto.IFavoriteStickerAction} message FavoriteStickerAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FavoriteStickerAction.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.directPath);
            if (message.lastUploadTimestamp != null && Object.hasOwnProperty.call(message, "lastUploadTimestamp"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.lastUploadTimestamp);
            if (message.handle != null && Object.hasOwnProperty.call(message, "handle"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.handle);
            if (message.encFilehash != null && Object.hasOwnProperty.call(message, "encFilehash"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.encFilehash);
            if (message.stickerHashWithoutMeta != null && Object.hasOwnProperty.call(message, "stickerHashWithoutMeta"))
                writer.uint32(/* id 5, wireType 2 =*/42).string(message.stickerHashWithoutMeta);
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 6, wireType 2 =*/50).string(message.mediaKey);
            if (message.mediaKeyTimestamp != null && Object.hasOwnProperty.call(message, "mediaKeyTimestamp"))
                writer.uint32(/* id 7, wireType 0 =*/56).int64(message.mediaKeyTimestamp);
            if (message.isFavorite != null && Object.hasOwnProperty.call(message, "isFavorite"))
                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.isFavorite);
            return writer;
        };

        /**
         * Encodes the specified FavoriteStickerAction message, length delimited. Does not implicitly {@link proto.FavoriteStickerAction.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {proto.IFavoriteStickerAction} message FavoriteStickerAction message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FavoriteStickerAction.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FavoriteStickerAction message from the specified reader or buffer.
         * @function decode
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.FavoriteStickerAction} FavoriteStickerAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FavoriteStickerAction.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.FavoriteStickerAction();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.directPath = reader.string();
                    break;
                case 2:
                    message.lastUploadTimestamp = reader.string();
                    break;
                case 3:
                    message.handle = reader.string();
                    break;
                case 4:
                    message.encFilehash = reader.string();
                    break;
                case 5:
                    message.stickerHashWithoutMeta = reader.string();
                    break;
                case 6:
                    message.mediaKey = reader.string();
                    break;
                case 7:
                    message.mediaKeyTimestamp = reader.int64();
                    break;
                case 8:
                    message.isFavorite = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FavoriteStickerAction message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.FavoriteStickerAction} FavoriteStickerAction
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FavoriteStickerAction.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FavoriteStickerAction message.
         * @function verify
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FavoriteStickerAction.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.lastUploadTimestamp != null && message.hasOwnProperty("lastUploadTimestamp"))
                if (!$util.isString(message.lastUploadTimestamp))
                    return "lastUploadTimestamp: string expected";
            if (message.handle != null && message.hasOwnProperty("handle"))
                if (!$util.isString(message.handle))
                    return "handle: string expected";
            if (message.encFilehash != null && message.hasOwnProperty("encFilehash"))
                if (!$util.isString(message.encFilehash))
                    return "encFilehash: string expected";
            if (message.stickerHashWithoutMeta != null && message.hasOwnProperty("stickerHashWithoutMeta"))
                if (!$util.isString(message.stickerHashWithoutMeta))
                    return "stickerHashWithoutMeta: string expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!$util.isString(message.mediaKey))
                    return "mediaKey: string expected";
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (!$util.isInteger(message.mediaKeyTimestamp) && !(message.mediaKeyTimestamp && $util.isInteger(message.mediaKeyTimestamp.low) && $util.isInteger(message.mediaKeyTimestamp.high)))
                    return "mediaKeyTimestamp: integer|Long expected";
            if (message.isFavorite != null && message.hasOwnProperty("isFavorite"))
                if (typeof message.isFavorite !== "boolean")
                    return "isFavorite: boolean expected";
            return null;
        };

        /**
         * Creates a FavoriteStickerAction message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.FavoriteStickerAction} FavoriteStickerAction
         */
        FavoriteStickerAction.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.FavoriteStickerAction)
                return object;
            var message = new $root.proto.FavoriteStickerAction();
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.lastUploadTimestamp != null)
                message.lastUploadTimestamp = String(object.lastUploadTimestamp);
            if (object.handle != null)
                message.handle = String(object.handle);
            if (object.encFilehash != null)
                message.encFilehash = String(object.encFilehash);
            if (object.stickerHashWithoutMeta != null)
                message.stickerHashWithoutMeta = String(object.stickerHashWithoutMeta);
            if (object.mediaKey != null)
                message.mediaKey = String(object.mediaKey);
            if (object.mediaKeyTimestamp != null)
                if ($util.Long)
                    (message.mediaKeyTimestamp = $util.Long.fromValue(object.mediaKeyTimestamp)).unsigned = false;
                else if (typeof object.mediaKeyTimestamp === "string")
                    message.mediaKeyTimestamp = parseInt(object.mediaKeyTimestamp, 10);
                else if (typeof object.mediaKeyTimestamp === "number")
                    message.mediaKeyTimestamp = object.mediaKeyTimestamp;
                else if (typeof object.mediaKeyTimestamp === "object")
                    message.mediaKeyTimestamp = new $util.LongBits(object.mediaKeyTimestamp.low >>> 0, object.mediaKeyTimestamp.high >>> 0).toNumber();
            if (object.isFavorite != null)
                message.isFavorite = Boolean(object.isFavorite);
            return message;
        };

        /**
         * Creates a plain object from a FavoriteStickerAction message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.FavoriteStickerAction
         * @static
         * @param {proto.FavoriteStickerAction} message FavoriteStickerAction
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FavoriteStickerAction.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.directPath = "";
                object.lastUploadTimestamp = "";
                object.handle = "";
                object.encFilehash = "";
                object.stickerHashWithoutMeta = "";
                object.mediaKey = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.mediaKeyTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.mediaKeyTimestamp = options.longs === String ? "0" : 0;
                object.isFavorite = false;
            }
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.lastUploadTimestamp != null && message.hasOwnProperty("lastUploadTimestamp"))
                object.lastUploadTimestamp = message.lastUploadTimestamp;
            if (message.handle != null && message.hasOwnProperty("handle"))
                object.handle = message.handle;
            if (message.encFilehash != null && message.hasOwnProperty("encFilehash"))
                object.encFilehash = message.encFilehash;
            if (message.stickerHashWithoutMeta != null && message.hasOwnProperty("stickerHashWithoutMeta"))
                object.stickerHashWithoutMeta = message.stickerHashWithoutMeta;
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = message.mediaKey;
            if (message.mediaKeyTimestamp != null && message.hasOwnProperty("mediaKeyTimestamp"))
                if (typeof message.mediaKeyTimestamp === "number")
                    object.mediaKeyTimestamp = options.longs === String ? String(message.mediaKeyTimestamp) : message.mediaKeyTimestamp;
                else
                    object.mediaKeyTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.mediaKeyTimestamp) : options.longs === Number ? new $util.LongBits(message.mediaKeyTimestamp.low >>> 0, message.mediaKeyTimestamp.high >>> 0).toNumber() : message.mediaKeyTimestamp;
            if (message.isFavorite != null && message.hasOwnProperty("isFavorite"))
                object.isFavorite = message.isFavorite;
            return object;
        };

        /**
         * Converts this FavoriteStickerAction to JSON.
         * @function toJSON
         * @memberof proto.FavoriteStickerAction
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FavoriteStickerAction.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FavoriteStickerAction;
    })();

    proto.Footer = (function() {

        /**
         * Properties of a Footer.
         * @memberof proto
         * @interface IFooter
         * @property {string|null} [text] Footer text
         */

        /**
         * Constructs a new Footer.
         * @memberof proto
         * @classdesc Represents a Footer.
         * @implements IFooter
         * @constructor
         * @param {proto.IFooter=} [properties] Properties to set
         */
        function Footer(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Footer text.
         * @member {string} text
         * @memberof proto.Footer
         * @instance
         */
        Footer.prototype.text = "";

        /**
         * Creates a new Footer instance using the specified properties.
         * @function create
         * @memberof proto.Footer
         * @static
         * @param {proto.IFooter=} [properties] Properties to set
         * @returns {proto.Footer} Footer instance
         */
        Footer.create = function create(properties) {
            return new Footer(properties);
        };

        /**
         * Encodes the specified Footer message. Does not implicitly {@link proto.Footer.verify|verify} messages.
         * @function encode
         * @memberof proto.Footer
         * @static
         * @param {proto.IFooter} message Footer message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Footer.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.text);
            return writer;
        };

        /**
         * Encodes the specified Footer message, length delimited. Does not implicitly {@link proto.Footer.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Footer
         * @static
         * @param {proto.IFooter} message Footer message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Footer.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Footer message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Footer
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Footer} Footer
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Footer.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Footer();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.text = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Footer message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Footer
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Footer} Footer
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Footer.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Footer message.
         * @function verify
         * @memberof proto.Footer
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Footer.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.text != null && message.hasOwnProperty("text"))
                if (!$util.isString(message.text))
                    return "text: string expected";
            return null;
        };

        /**
         * Creates a Footer message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Footer
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Footer} Footer
         */
        Footer.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Footer)
                return object;
            var message = new $root.proto.Footer();
            if (object.text != null)
                message.text = String(object.text);
            return message;
        };

        /**
         * Creates a plain object from a Footer message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Footer
         * @static
         * @param {proto.Footer} message Footer
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Footer.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.text = "";
            if (message.text != null && message.hasOwnProperty("text"))
                object.text = message.text;
            return object;
        };

        /**
         * Converts this Footer to JSON.
         * @function toJSON
         * @memberof proto.Footer
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Footer.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Footer;
    })();

    proto.FourRowTemplate = (function() {

        /**
         * Properties of a FourRowTemplate.
         * @memberof proto
         * @interface IFourRowTemplate
         * @property {proto.IHighlyStructuredMessage|null} [content] FourRowTemplate content
         * @property {proto.IHighlyStructuredMessage|null} [footer] FourRowTemplate footer
         * @property {Array.<proto.ITemplateButton>|null} [buttons] FourRowTemplate buttons
         * @property {proto.IDocumentMessage|null} [documentMessage] FourRowTemplate documentMessage
         * @property {proto.IHighlyStructuredMessage|null} [highlyStructuredMessage] FourRowTemplate highlyStructuredMessage
         * @property {proto.IImageMessage|null} [imageMessage] FourRowTemplate imageMessage
         * @property {proto.IVideoMessage|null} [videoMessage] FourRowTemplate videoMessage
         * @property {proto.ILocationMessage|null} [locationMessage] FourRowTemplate locationMessage
         */

        /**
         * Constructs a new FourRowTemplate.
         * @memberof proto
         * @classdesc Represents a FourRowTemplate.
         * @implements IFourRowTemplate
         * @constructor
         * @param {proto.IFourRowTemplate=} [properties] Properties to set
         */
        function FourRowTemplate(properties) {
            this.buttons = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FourRowTemplate content.
         * @member {proto.IHighlyStructuredMessage|null|undefined} content
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.content = null;

        /**
         * FourRowTemplate footer.
         * @member {proto.IHighlyStructuredMessage|null|undefined} footer
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.footer = null;

        /**
         * FourRowTemplate buttons.
         * @member {Array.<proto.ITemplateButton>} buttons
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.buttons = $util.emptyArray;

        /**
         * FourRowTemplate documentMessage.
         * @member {proto.IDocumentMessage|null|undefined} documentMessage
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.documentMessage = null;

        /**
         * FourRowTemplate highlyStructuredMessage.
         * @member {proto.IHighlyStructuredMessage|null|undefined} highlyStructuredMessage
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.highlyStructuredMessage = null;

        /**
         * FourRowTemplate imageMessage.
         * @member {proto.IImageMessage|null|undefined} imageMessage
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.imageMessage = null;

        /**
         * FourRowTemplate videoMessage.
         * @member {proto.IVideoMessage|null|undefined} videoMessage
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.videoMessage = null;

        /**
         * FourRowTemplate locationMessage.
         * @member {proto.ILocationMessage|null|undefined} locationMessage
         * @memberof proto.FourRowTemplate
         * @instance
         */
        FourRowTemplate.prototype.locationMessage = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * FourRowTemplate title.
         * @member {"documentMessage"|"highlyStructuredMessage"|"imageMessage"|"videoMessage"|"locationMessage"|undefined} title
         * @memberof proto.FourRowTemplate
         * @instance
         */
        Object.defineProperty(FourRowTemplate.prototype, "title", {
            get: $util.oneOfGetter($oneOfFields = ["documentMessage", "highlyStructuredMessage", "imageMessage", "videoMessage", "locationMessage"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new FourRowTemplate instance using the specified properties.
         * @function create
         * @memberof proto.FourRowTemplate
         * @static
         * @param {proto.IFourRowTemplate=} [properties] Properties to set
         * @returns {proto.FourRowTemplate} FourRowTemplate instance
         */
        FourRowTemplate.create = function create(properties) {
            return new FourRowTemplate(properties);
        };

        /**
         * Encodes the specified FourRowTemplate message. Does not implicitly {@link proto.FourRowTemplate.verify|verify} messages.
         * @function encode
         * @memberof proto.FourRowTemplate
         * @static
         * @param {proto.IFourRowTemplate} message FourRowTemplate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FourRowTemplate.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.documentMessage != null && Object.hasOwnProperty.call(message, "documentMessage"))
                $root.proto.DocumentMessage.encode(message.documentMessage, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.highlyStructuredMessage != null && Object.hasOwnProperty.call(message, "highlyStructuredMessage"))
                $root.proto.HighlyStructuredMessage.encode(message.highlyStructuredMessage, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.imageMessage != null && Object.hasOwnProperty.call(message, "imageMessage"))
                $root.proto.ImageMessage.encode(message.imageMessage, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.videoMessage != null && Object.hasOwnProperty.call(message, "videoMessage"))
                $root.proto.VideoMessage.encode(message.videoMessage, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.locationMessage != null && Object.hasOwnProperty.call(message, "locationMessage"))
                $root.proto.LocationMessage.encode(message.locationMessage, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.content != null && Object.hasOwnProperty.call(message, "content"))
                $root.proto.HighlyStructuredMessage.encode(message.content, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.footer != null && Object.hasOwnProperty.call(message, "footer"))
                $root.proto.HighlyStructuredMessage.encode(message.footer, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.buttons != null && message.buttons.length)
                for (var i = 0; i < message.buttons.length; ++i)
                    $root.proto.TemplateButton.encode(message.buttons[i], writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified FourRowTemplate message, length delimited. Does not implicitly {@link proto.FourRowTemplate.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.FourRowTemplate
         * @static
         * @param {proto.IFourRowTemplate} message FourRowTemplate message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FourRowTemplate.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FourRowTemplate message from the specified reader or buffer.
         * @function decode
         * @memberof proto.FourRowTemplate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.FourRowTemplate} FourRowTemplate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FourRowTemplate.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.FourRowTemplate();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 6:
                    message.content = $root.proto.HighlyStructuredMessage.decode(reader, reader.uint32());
                    break;
                case 7:
                    message.footer = $root.proto.HighlyStructuredMessage.decode(reader, reader.uint32());
                    break;
                case 8:
                    if (!(message.buttons && message.buttons.length))
                        message.buttons = [];
                    message.buttons.push($root.proto.TemplateButton.decode(reader, reader.uint32()));
                    break;
                case 1:
                    message.documentMessage = $root.proto.DocumentMessage.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.highlyStructuredMessage = $root.proto.HighlyStructuredMessage.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.imageMessage = $root.proto.ImageMessage.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.videoMessage = $root.proto.VideoMessage.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.locationMessage = $root.proto.LocationMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FourRowTemplate message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.FourRowTemplate
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.FourRowTemplate} FourRowTemplate
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FourRowTemplate.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FourRowTemplate message.
         * @function verify
         * @memberof proto.FourRowTemplate
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FourRowTemplate.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.content != null && message.hasOwnProperty("content")) {
                var error = $root.proto.HighlyStructuredMessage.verify(message.content);
                if (error)
                    return "content." + error;
            }
            if (message.footer != null && message.hasOwnProperty("footer")) {
                var error = $root.proto.HighlyStructuredMessage.verify(message.footer);
                if (error)
                    return "footer." + error;
            }
            if (message.buttons != null && message.hasOwnProperty("buttons")) {
                if (!Array.isArray(message.buttons))
                    return "buttons: array expected";
                for (var i = 0; i < message.buttons.length; ++i) {
                    var error = $root.proto.TemplateButton.verify(message.buttons[i]);
                    if (error)
                        return "buttons." + error;
                }
            }
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                properties.title = 1;
                {
                    var error = $root.proto.DocumentMessage.verify(message.documentMessage);
                    if (error)
                        return "documentMessage." + error;
                }
            }
            if (message.highlyStructuredMessage != null && message.hasOwnProperty("highlyStructuredMessage")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                {
                    var error = $root.proto.HighlyStructuredMessage.verify(message.highlyStructuredMessage);
                    if (error)
                        return "highlyStructuredMessage." + error;
                }
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                {
                    var error = $root.proto.ImageMessage.verify(message.imageMessage);
                    if (error)
                        return "imageMessage." + error;
                }
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                {
                    var error = $root.proto.VideoMessage.verify(message.videoMessage);
                    if (error)
                        return "videoMessage." + error;
                }
            }
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage")) {
                if (properties.title === 1)
                    return "title: multiple values";
                properties.title = 1;
                {
                    var error = $root.proto.LocationMessage.verify(message.locationMessage);
                    if (error)
                        return "locationMessage." + error;
                }
            }
            return null;
        };

        /**
         * Creates a FourRowTemplate message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.FourRowTemplate
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.FourRowTemplate} FourRowTemplate
         */
        FourRowTemplate.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.FourRowTemplate)
                return object;
            var message = new $root.proto.FourRowTemplate();
            if (object.content != null) {
                if (typeof object.content !== "object")
                    throw TypeError(".proto.FourRowTemplate.content: object expected");
                message.content = $root.proto.HighlyStructuredMessage.fromObject(object.content);
            }
            if (object.footer != null) {
                if (typeof object.footer !== "object")
                    throw TypeError(".proto.FourRowTemplate.footer: object expected");
                message.footer = $root.proto.HighlyStructuredMessage.fromObject(object.footer);
            }
            if (object.buttons) {
                if (!Array.isArray(object.buttons))
                    throw TypeError(".proto.FourRowTemplate.buttons: array expected");
                message.buttons = [];
                for (var i = 0; i < object.buttons.length; ++i) {
                    if (typeof object.buttons[i] !== "object")
                        throw TypeError(".proto.FourRowTemplate.buttons: object expected");
                    message.buttons[i] = $root.proto.TemplateButton.fromObject(object.buttons[i]);
                }
            }
            if (object.documentMessage != null) {
                if (typeof object.documentMessage !== "object")
                    throw TypeError(".proto.FourRowTemplate.documentMessage: object expected");
                message.documentMessage = $root.proto.DocumentMessage.fromObject(object.documentMessage);
            }
            if (object.highlyStructuredMessage != null) {
                if (typeof object.highlyStructuredMessage !== "object")
                    throw TypeError(".proto.FourRowTemplate.highlyStructuredMessage: object expected");
                message.highlyStructuredMessage = $root.proto.HighlyStructuredMessage.fromObject(object.highlyStructuredMessage);
            }
            if (object.imageMessage != null) {
                if (typeof object.imageMessage !== "object")
                    throw TypeError(".proto.FourRowTemplate.imageMessage: object expected");
                message.imageMessage = $root.proto.ImageMessage.fromObject(object.imageMessage);
            }
            if (object.videoMessage != null) {
                if (typeof object.videoMessage !== "object")
                    throw TypeError(".proto.FourRowTemplate.videoMessage: object expected");
                message.videoMessage = $root.proto.VideoMessage.fromObject(object.videoMessage);
            }
            if (object.locationMessage != null) {
                if (typeof object.locationMessage !== "object")
                    throw TypeError(".proto.FourRowTemplate.locationMessage: object expected");
                message.locationMessage = $root.proto.LocationMessage.fromObject(object.locationMessage);
            }
            return message;
        };

        /**
         * Creates a plain object from a FourRowTemplate message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.FourRowTemplate
         * @static
         * @param {proto.FourRowTemplate} message FourRowTemplate
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FourRowTemplate.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.buttons = [];
            if (options.defaults) {
                object.content = null;
                object.footer = null;
            }
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                object.documentMessage = $root.proto.DocumentMessage.toObject(message.documentMessage, options);
                if (options.oneofs)
                    object.title = "documentMessage";
            }
            if (message.highlyStructuredMessage != null && message.hasOwnProperty("highlyStructuredMessage")) {
                object.highlyStructuredMessage = $root.proto.HighlyStructuredMessage.toObject(message.highlyStructuredMessage, options);
                if (options.oneofs)
                    object.title = "highlyStructuredMessage";
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                object.imageMessage = $root.proto.ImageMessage.toObject(message.imageMessage, options);
                if (options.oneofs)
                    object.title = "imageMessage";
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                object.videoMessage = $root.proto.VideoMessage.toObject(message.videoMessage, options);
                if (options.oneofs)
                    object.title = "videoMessage";
            }
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage")) {
                object.locationMessage = $root.proto.LocationMessage.toObject(message.locationMessage, options);
                if (options.oneofs)
                    object.title = "locationMessage";
            }
            if (message.content != null && message.hasOwnProperty("content"))
                object.content = $root.proto.HighlyStructuredMessage.toObject(message.content, options);
            if (message.footer != null && message.hasOwnProperty("footer"))
                object.footer = $root.proto.HighlyStructuredMessage.toObject(message.footer, options);
            if (message.buttons && message.buttons.length) {
                object.buttons = [];
                for (var j = 0; j < message.buttons.length; ++j)
                    object.buttons[j] = $root.proto.TemplateButton.toObject(message.buttons[j], options);
            }
            return object;
        };

        /**
         * Converts this FourRowTemplate to JSON.
         * @function toJSON
         * @memberof proto.FourRowTemplate
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FourRowTemplate.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FourRowTemplate;
    })();

    proto.FutureProofMessage = (function() {

        /**
         * Properties of a FutureProofMessage.
         * @memberof proto
         * @interface IFutureProofMessage
         * @property {proto.IMessage|null} [message] FutureProofMessage message
         */

        /**
         * Constructs a new FutureProofMessage.
         * @memberof proto
         * @classdesc Represents a FutureProofMessage.
         * @implements IFutureProofMessage
         * @constructor
         * @param {proto.IFutureProofMessage=} [properties] Properties to set
         */
        function FutureProofMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * FutureProofMessage message.
         * @member {proto.IMessage|null|undefined} message
         * @memberof proto.FutureProofMessage
         * @instance
         */
        FutureProofMessage.prototype.message = null;

        /**
         * Creates a new FutureProofMessage instance using the specified properties.
         * @function create
         * @memberof proto.FutureProofMessage
         * @static
         * @param {proto.IFutureProofMessage=} [properties] Properties to set
         * @returns {proto.FutureProofMessage} FutureProofMessage instance
         */
        FutureProofMessage.create = function create(properties) {
            return new FutureProofMessage(properties);
        };

        /**
         * Encodes the specified FutureProofMessage message. Does not implicitly {@link proto.FutureProofMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.FutureProofMessage
         * @static
         * @param {proto.IFutureProofMessage} message FutureProofMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FutureProofMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                $root.proto.Message.encode(message.message, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified FutureProofMessage message, length delimited. Does not implicitly {@link proto.FutureProofMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.FutureProofMessage
         * @static
         * @param {proto.IFutureProofMessage} message FutureProofMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        FutureProofMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a FutureProofMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.FutureProofMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.FutureProofMessage} FutureProofMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FutureProofMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.FutureProofMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.message = $root.proto.Message.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a FutureProofMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.FutureProofMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.FutureProofMessage} FutureProofMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        FutureProofMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a FutureProofMessage message.
         * @function verify
         * @memberof proto.FutureProofMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        FutureProofMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.message != null && message.hasOwnProperty("message")) {
                var error = $root.proto.Message.verify(message.message);
                if (error)
                    return "message." + error;
            }
            return null;
        };

        /**
         * Creates a FutureProofMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.FutureProofMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.FutureProofMessage} FutureProofMessage
         */
        FutureProofMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.FutureProofMessage)
                return object;
            var message = new $root.proto.FutureProofMessage();
            if (object.message != null) {
                if (typeof object.message !== "object")
                    throw TypeError(".proto.FutureProofMessage.message: object expected");
                message.message = $root.proto.Message.fromObject(object.message);
            }
            return message;
        };

        /**
         * Creates a plain object from a FutureProofMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.FutureProofMessage
         * @static
         * @param {proto.FutureProofMessage} message FutureProofMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        FutureProofMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.message = null;
            if (message.message != null && message.hasOwnProperty("message"))
                object.message = $root.proto.Message.toObject(message.message, options);
            return object;
        };

        /**
         * Converts this FutureProofMessage to JSON.
         * @function toJSON
         * @memberof proto.FutureProofMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        FutureProofMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return FutureProofMessage;
    })();

    proto.GlobalSettings = (function() {

        /**
         * Properties of a GlobalSettings.
         * @memberof proto
         * @interface IGlobalSettings
         * @property {proto.IWallpaperSettings|null} [lightThemeWallpaper] GlobalSettings lightThemeWallpaper
         * @property {proto.MediaVisibility|null} [mediaVisibility] GlobalSettings mediaVisibility
         * @property {proto.IWallpaperSettings|null} [darkThemeWallpaper] GlobalSettings darkThemeWallpaper
         * @property {proto.IAutoDownloadSettings|null} [autoDownloadWiFi] GlobalSettings autoDownloadWiFi
         * @property {proto.IAutoDownloadSettings|null} [autoDownloadCellular] GlobalSettings autoDownloadCellular
         * @property {proto.IAutoDownloadSettings|null} [autoDownloadRoaming] GlobalSettings autoDownloadRoaming
         * @property {boolean|null} [showIndividualNotificationsPreview] GlobalSettings showIndividualNotificationsPreview
         * @property {boolean|null} [showGroupNotificationsPreview] GlobalSettings showGroupNotificationsPreview
         * @property {number|null} [disappearingModeDuration] GlobalSettings disappearingModeDuration
         * @property {number|Long|null} [disappearingModeTimestamp] GlobalSettings disappearingModeTimestamp
         */

        /**
         * Constructs a new GlobalSettings.
         * @memberof proto
         * @classdesc Represents a GlobalSettings.
         * @implements IGlobalSettings
         * @constructor
         * @param {proto.IGlobalSettings=} [properties] Properties to set
         */
        function GlobalSettings(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * GlobalSettings lightThemeWallpaper.
         * @member {proto.IWallpaperSettings|null|undefined} lightThemeWallpaper
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.lightThemeWallpaper = null;

        /**
         * GlobalSettings mediaVisibility.
         * @member {proto.MediaVisibility} mediaVisibility
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.mediaVisibility = 0;

        /**
         * GlobalSettings darkThemeWallpaper.
         * @member {proto.IWallpaperSettings|null|undefined} darkThemeWallpaper
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.darkThemeWallpaper = null;

        /**
         * GlobalSettings autoDownloadWiFi.
         * @member {proto.IAutoDownloadSettings|null|undefined} autoDownloadWiFi
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.autoDownloadWiFi = null;

        /**
         * GlobalSettings autoDownloadCellular.
         * @member {proto.IAutoDownloadSettings|null|undefined} autoDownloadCellular
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.autoDownloadCellular = null;

        /**
         * GlobalSettings autoDownloadRoaming.
         * @member {proto.IAutoDownloadSettings|null|undefined} autoDownloadRoaming
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.autoDownloadRoaming = null;

        /**
         * GlobalSettings showIndividualNotificationsPreview.
         * @member {boolean} showIndividualNotificationsPreview
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.showIndividualNotificationsPreview = false;

        /**
         * GlobalSettings showGroupNotificationsPreview.
         * @member {boolean} showGroupNotificationsPreview
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.showGroupNotificationsPreview = false;

        /**
         * GlobalSettings disappearingModeDuration.
         * @member {number} disappearingModeDuration
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.disappearingModeDuration = 0;

        /**
         * GlobalSettings disappearingModeTimestamp.
         * @member {number|Long} disappearingModeTimestamp
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.disappearingModeTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new GlobalSettings instance using the specified properties.
         * @function create
         * @memberof proto.GlobalSettings
         * @static
         * @param {proto.IGlobalSettings=} [properties] Properties to set
         * @returns {proto.GlobalSettings} GlobalSettings instance
         */
        GlobalSettings.create = function create(properties) {
            return new GlobalSettings(properties);
        };

        /**
         * Encodes the specified GlobalSettings message. Does not implicitly {@link proto.GlobalSettings.verify|verify} messages.
         * @function encode
         * @memberof proto.GlobalSettings
         * @static
         * @param {proto.IGlobalSettings} message GlobalSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GlobalSettings.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.lightThemeWallpaper != null && Object.hasOwnProperty.call(message, "lightThemeWallpaper"))
                $root.proto.WallpaperSettings.encode(message.lightThemeWallpaper, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.mediaVisibility != null && Object.hasOwnProperty.call(message, "mediaVisibility"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.mediaVisibility);
            if (message.darkThemeWallpaper != null && Object.hasOwnProperty.call(message, "darkThemeWallpaper"))
                $root.proto.WallpaperSettings.encode(message.darkThemeWallpaper, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.autoDownloadWiFi != null && Object.hasOwnProperty.call(message, "autoDownloadWiFi"))
                $root.proto.AutoDownloadSettings.encode(message.autoDownloadWiFi, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.autoDownloadCellular != null && Object.hasOwnProperty.call(message, "autoDownloadCellular"))
                $root.proto.AutoDownloadSettings.encode(message.autoDownloadCellular, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.autoDownloadRoaming != null && Object.hasOwnProperty.call(message, "autoDownloadRoaming"))
                $root.proto.AutoDownloadSettings.encode(message.autoDownloadRoaming, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.showIndividualNotificationsPreview != null && Object.hasOwnProperty.call(message, "showIndividualNotificationsPreview"))
                writer.uint32(/* id 7, wireType 0 =*/56).bool(message.showIndividualNotificationsPreview);
            if (message.showGroupNotificationsPreview != null && Object.hasOwnProperty.call(message, "showGroupNotificationsPreview"))
                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.showGroupNotificationsPreview);
            if (message.disappearingModeDuration != null && Object.hasOwnProperty.call(message, "disappearingModeDuration"))
                writer.uint32(/* id 9, wireType 0 =*/72).int32(message.disappearingModeDuration);
            if (message.disappearingModeTimestamp != null && Object.hasOwnProperty.call(message, "disappearingModeTimestamp"))
                writer.uint32(/* id 10, wireType 0 =*/80).int64(message.disappearingModeTimestamp);
            return writer;
        };

        /**
         * Encodes the specified GlobalSettings message, length delimited. Does not implicitly {@link proto.GlobalSettings.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.GlobalSettings
         * @static
         * @param {proto.IGlobalSettings} message GlobalSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GlobalSettings.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ld