'use strict';

var Transform = require('stream').Transform;
var Util = require('util');

function Encoder(schema) {
  this._schema = schema;
  Transform.call(this, {objectMode: true});
}

Util.inherits(Encoder, Transform);

Encoder.prototype._transform = function(chunk, encoding, callback) {
  // Encode the chunk using the schema
  var message = this._schema.encode(chunk);

  // Create a buffer containing the message length
  var length = new Buffer(4);
  length.writeUInt32BE(message.length, 0);
 
  // Prepend the length to the message
  var buffer = Buffer.concat([length, message]);
  this.push(buffer);

  return callback();
};

module.exports = Encoder;
