'use strict';

var Decoder = require('../').Decoder;
var ProtoBuf = require('protocol-buffers/require');
var Tap = require('tap');

var messages = ProtoBuf(__dirname + '/message.proto');
var decoder = new Decoder(messages.Message);

Tap.test('non-buffer', function(t) {
  decoder.once('error', function(err) {
    t.equals(err.message, 'chunk must be a buffer');
    t.end();
  });

  decoder.write({
    name: 'Hello',
    value: 'world'
  });
});

Tap.test('single chunk', function(t) {
  var message = {
    name: 'Hello',
    value: 'world'
  };
  var buffer = messages.Message.encode(message);
  var length = new Buffer(4);
  length.writeUInt32BE(buffer.length, 0);

  decoder.once('data', function(data) {
    t.same(data, message);
    t.end();
  });

  decoder.write(Buffer.concat([length, buffer]));
});

Tap.test('multiple chunks', function(t) {
  var message = {
    name: 'Hello',
    value: 'world'
  };
  var buffer = messages.Message.encode(message);
  var length = new Buffer(4);
  length.writeUInt32BE(buffer.length, 0);

  decoder.once('data', function(data) {
    t.same(data, message);
    t.end();
  });

  decoder.write(Buffer.concat([length, buffer.slice(0, 5)]));
  decoder.write(buffer.slice(5));
});

Tap.test('multiple messages', function(t) {
  var message = {
    name: 'Hello',
    value: 'world'
  };
  var buffer = messages.Message.encode(message);
  var length = new Buffer(4);
  length.writeUInt32BE(buffer.length, 0);

  decoder.once('data', function(data) {
    t.same(data, message);
    decoder.once('data', function(data) {
      t.same(data, message);
      t.end();
    });
  });

  decoder.write(Buffer.concat([length, buffer, length, buffer]));
});
