'use strict';

var ProtoBuf = require('protocol-buffers/require');
var Stream = require('../');
var Tap = require('tap');

var messages = ProtoBuf(__dirname + '/message.proto');
var stream = Stream(messages.Message);

Tap.test('encoder to decoder', function(t) {
  var message = {
    name: 'Hello',
    value: 'world'
  };

  stream.encoder.pipe(stream.decoder).once('data', function(data) {
    t.same(data, message);
    t.end();
  });

  stream.encoder.write(message);
});
